# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.entities_model_entity_group import EntitiesModelEntityGroup
from atriumsports.datacore.openapi.models.fixture_entities_model_conference import FixtureEntitiesModelConference
from atriumsports.datacore.openapi.models.fixture_entities_model_division import FixtureEntitiesModelDivision
from atriumsports.datacore.openapi.models.fixture_entities_model_entity import FixtureEntitiesModelEntity
from atriumsports.datacore.openapi.models.fixture_persons_model_person import FixturePersonsModelPerson
from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.season_roster_model_organization import SeasonRosterModelOrganization


class SeasonRosterModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[SeasonRosterModelOrganization] = None
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    entity: Optional[FixtureEntitiesModelEntity] = None
    entity_group_id: Optional[StrictStr] = Field(
        None, alias="entityGroupId", description="The entity group that this entity belongs to"
    )
    entity_group: Optional[EntitiesModelEntityGroup] = Field(None, alias="entityGroup")
    division_id: Optional[StrictStr] = Field(
        None, alias="divisionId", description="The unique identifier of the division"
    )
    division: Optional[FixtureEntitiesModelDivision] = None
    conference_id: Optional[StrictStr] = Field(
        None, alias="conferenceId", description="The unique identifier of the conference"
    )
    conference: Optional[FixtureEntitiesModelConference] = None
    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The unique identifier of the person")
    person: Optional[FixturePersonsModelPerson] = None
    bib: Optional[constr(strict=True, max_length=100)] = Field(None, description="The number displayed on the jersey")
    position: Optional[constr(strict=True, max_length=100)] = Field(None, description="Playing position")
    status: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        description="Participation status >- `ACTIVE` Active >- `INJURED` Injured >- `OTHER_NOT_PARTICIPATING` Other Non-Participation >- `OUT` Out >- `SUSPENDED` Suspended ",
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "seasonId",
        "season",
        "organizationId",
        "organization",
        "entityId",
        "entity",
        "entityGroupId",
        "entityGroup",
        "divisionId",
        "division",
        "conferenceId",
        "conference",
        "personId",
        "person",
        "bib",
        "position",
        "status",
        "externalId",
        "updated",
        "added",
    ]

    @validator("status")
    def status_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("ACTIVE", "INJURED", "OUT", "SUSPENDED", "OTHER_NOT_PARTICIPATING"):
            raise ValueError(
                "must validate the enum values ('ACTIVE', 'INJURED', 'OUT', 'SUSPENDED', 'OTHER_NOT_PARTICIPATING')"
            )
        return v

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonRosterModel:
        """Create an instance of SeasonRosterModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entity_group
        if self.entity_group:
            _dict["entityGroup"] = self.entity_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of division
        if self.division:
            _dict["division"] = self.division.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conference
        if self.conference:
            _dict["conference"] = self.conference.to_dict()
        # override the default output from pydantic by calling `to_dict()` of person
        if self.person:
            _dict["person"] = self.person.to_dict()
        # set to None if entity_group_id (nullable) is None
        if self.entity_group_id is None:
            _dict["entityGroupId"] = None

        # set to None if division_id (nullable) is None
        if self.division_id is None:
            _dict["divisionId"] = None

        # set to None if conference_id (nullable) is None
        if self.conference_id is None:
            _dict["conferenceId"] = None

        # set to None if bib (nullable) is None
        if self.bib is None:
            _dict["bib"] = None

        # set to None if position (nullable) is None
        if self.position is None:
            _dict["position"] = None

        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonRosterModel:
        """Create an instance of SeasonRosterModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SeasonRosterModel.parse_obj(obj)

        _obj = SeasonRosterModel.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": SeasonRosterModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "entity_id": obj.get("entityId"),
                "entity": FixtureEntitiesModelEntity.from_dict(obj.get("entity"))
                if obj.get("entity") is not None
                else None,
                "entity_group_id": obj.get("entityGroupId"),
                "entity_group": EntitiesModelEntityGroup.from_dict(obj.get("entityGroup"))
                if obj.get("entityGroup") is not None
                else None,
                "division_id": obj.get("divisionId"),
                "division": FixtureEntitiesModelDivision.from_dict(obj.get("division"))
                if obj.get("division") is not None
                else None,
                "conference_id": obj.get("conferenceId"),
                "conference": FixtureEntitiesModelConference.from_dict(obj.get("conference"))
                if obj.get("conference") is not None
                else None,
                "person_id": obj.get("personId"),
                "person": FixturePersonsModelPerson.from_dict(obj.get("person"))
                if obj.get("person") is not None
                else None,
                "bib": obj.get("bib"),
                "position": obj.get("position"),
                "status": obj.get("status"),
                "external_id": obj.get("externalId"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
