# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date
from inspect import getfullargspec
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conint, constr, validator

from atriumsports.datacore.openapi.models.social_media import SocialMedia


class SeasonPutBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The unique identifier of the competition"
    )
    leader_criteria_id: Optional[StrictStr] = Field(
        None, alias="leaderCriteriaId", description="The unique identifier of the leader criteria"
    )
    international_reference: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="internationalReference",
        description="The international reference for this season given by the sport governing body",
    )
    event_type: Optional[constr(strict=True, max_length=30)] = Field(
        "FIXTURE",
        alias="eventType",
        description="Primary Type of Fixtures >- `FIXTURE` Fixture >- `PRACTICE` Practice ",
    )
    season_type: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="seasonType",
        description="The type of fixtures added to this season >- `ONE_OFF` One off >- `SEASON` Season >- `TOURNAMENT` Tournament ",
    )
    year: Optional[conint(strict=True)] = Field(None, description="Year of the season")
    grade: Optional[constr(strict=True, max_length=50)] = Field(
        None, description="The playing grade of the fixtures in this season"
    )
    status: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="Status >- `ACTIVE` Active >- `INACTIVE` Inactive >- `PENDING` Pending "
    )
    include_in_statistics: Optional[StrictBool] = Field(
        True, alias="includeInStatistics", description="Include this season in calculated statistics?"
    )
    live_video_available: Optional[StrictBool] = Field(
        None,
        alias="liveVideoAvailable",
        description="If no 'liveVideoAvailable' flag passed to a new fixture this value is used",
    )
    live_data_available: Optional[StrictBool] = Field(
        None,
        alias="liveDataAvailable",
        description="If no 'liveDataAvailable' flag passed to a new fixture this value is used",
    )
    duration_full: Optional[StrictInt] = Field(
        None, alias="durationFull", description="If no 'durationFull' is passed to a new fixture this value is used"
    )
    name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLocal",
        description="The name of the season in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the season in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    name_short_local: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="nameShortLocal",
        description="The abbreviated name of the season in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_short_latin: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="nameShortLatin",
        description="The abbreviated name of the season in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    start_date: Optional[date] = Field(None, alias="startDate", description="Season start date")
    end_date: Optional[date] = Field(None, alias="endDate", description="Season end date")
    gender: Optional[constr(strict=True, max_length=20)] = Field(
        None,
        description="The gender of the participants in the season >- `FEMALE` Female >- `MALE` Male >- `MIXED` Mixed >- `UNKNOWN` Unknown ",
    )
    age_group: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="ageGroup",
        description="The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth ",
    )
    standard: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        description="The playing standard of the season >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship ",
    )
    representation: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        description="What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person >- `REGION` Region >- `STATE` State ",
    )
    standing_configuration_id: Optional[StrictStr] = Field(
        None, alias="standingConfigurationId", description="The unique identifier of the ~standingConfiguration~"
    )
    lock_standings: Optional[StrictBool] = Field(
        None, alias="lockStandings", description="Is the standings generation locked ?"
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    social: Optional[SocialMedia] = None
    configuration: Optional[Dict[str, Any]] = Field(None, description="Season Configuration settings")
    profile_id: Optional[StrictStr] = Field(
        None, alias="profileId", description="The profile that this season belongs to"
    )
    video_production: Optional[constr(strict=True, max_length=50)] = Field(
        "NONE",
        alias="videoProduction",
        description="Data synchronization strategy with video production systems >- `AUTOMATED` Automated >- `MANUAL` Manual >- `NONE` None ",
    )
    __properties = [
        "competitionId",
        "leaderCriteriaId",
        "internationalReference",
        "eventType",
        "seasonType",
        "year",
        "grade",
        "status",
        "includeInStatistics",
        "liveVideoAvailable",
        "liveDataAvailable",
        "durationFull",
        "nameLocal",
        "nameLatin",
        "nameShortLocal",
        "nameShortLatin",
        "startDate",
        "endDate",
        "gender",
        "ageGroup",
        "standard",
        "representation",
        "standingConfigurationId",
        "lockStandings",
        "externalId",
        "social",
        "configuration",
        "profileId",
        "videoProduction",
    ]

    @validator("event_type")
    def event_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("FIXTURE", "PRACTICE"):
            raise ValueError("must validate the enum values ('FIXTURE', 'PRACTICE')")
        return v

    @validator("season_type")
    def season_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("SEASON", "TOURNAMENT", "ONE_OFF"):
            raise ValueError("must validate the enum values ('SEASON', 'TOURNAMENT', 'ONE_OFF')")
        return v

    @validator("status")
    def status_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("ACTIVE", "INACTIVE", "PENDING"):
            raise ValueError("must validate the enum values ('ACTIVE', 'INACTIVE', 'PENDING')")
        return v

    @validator("gender")
    def gender_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("FEMALE", "MALE", "MIXED", "UNKNOWN"):
            raise ValueError("must validate the enum values ('FEMALE', 'MALE', 'MIXED', 'UNKNOWN')")
        return v

    @validator("age_group")
    def age_group_validate_enum(cls, v):
        if v is None:
            return v

        if v not in (
            "JUNIOR",
            "YOUTH",
            "UNDER_15",
            "UNDER_16",
            "UNDER_17",
            "UNDER_18",
            "UNDER_19",
            "UNDER_20",
            "UNDER_21",
            "UNDER_22",
            "UNDER_23",
            "SENIOR",
            "MASTERS",
        ):
            raise ValueError(
                "must validate the enum values ('JUNIOR', 'YOUTH', 'UNDER_15', 'UNDER_16', 'UNDER_17', 'UNDER_18', 'UNDER_19', 'UNDER_20', 'UNDER_21', 'UNDER_22', 'UNDER_23', 'SENIOR', 'MASTERS')"
            )
        return v

    @validator("standard")
    def standard_validate_enum(cls, v):
        if v is None:
            return v

        if v not in (
            "ELITE",
            "FRIENDLY",
            "GRASS_ROOT",
            "INTERNATIONAL",
            "NONCONTINENTAL_CHAMPIONSHIP",
            "OLYMPIC",
            "REGION",
            "TIER2",
            "TIER3",
            "WORLD_CHAMPIONSHIP",
            "ZONE_CHAMPIONSHIP",
        ):
            raise ValueError(
                "must validate the enum values ('ELITE', 'FRIENDLY', 'GRASS_ROOT', 'INTERNATIONAL', 'NONCONTINENTAL_CHAMPIONSHIP', 'OLYMPIC', 'REGION', 'TIER2', 'TIER3', 'WORLD_CHAMPIONSHIP', 'ZONE_CHAMPIONSHIP')"
            )
        return v

    @validator("representation")
    def representation_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("CLUB", "STATE", "REGION", "COUNTRY", "PERSON"):
            raise ValueError("must validate the enum values ('CLUB', 'STATE', 'REGION', 'COUNTRY', 'PERSON')")
        return v

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    @validator("video_production")
    def video_production_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("NONE", "AUTOMATED", "MANUAL"):
            raise ValueError("must validate the enum values ('NONE', 'AUTOMATED', 'MANUAL')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonPutBody:
        """Create an instance of SeasonPutBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of social
        if self.social:
            _dict["social"] = self.social.to_dict()
        # set to None if leader_criteria_id (nullable) is None
        if self.leader_criteria_id is None:
            _dict["leaderCriteriaId"] = None

        # set to None if international_reference (nullable) is None
        if self.international_reference is None:
            _dict["internationalReference"] = None

        # set to None if grade (nullable) is None
        if self.grade is None:
            _dict["grade"] = None

        # set to None if duration_full (nullable) is None
        if self.duration_full is None:
            _dict["durationFull"] = None

        # set to None if name_latin (nullable) is None
        if self.name_latin is None:
            _dict["nameLatin"] = None

        # set to None if name_short_local (nullable) is None
        if self.name_short_local is None:
            _dict["nameShortLocal"] = None

        # set to None if name_short_latin (nullable) is None
        if self.name_short_latin is None:
            _dict["nameShortLatin"] = None

        # set to None if end_date (nullable) is None
        if self.end_date is None:
            _dict["endDate"] = None

        # set to None if standing_configuration_id (nullable) is None
        if self.standing_configuration_id is None:
            _dict["standingConfigurationId"] = None

        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        # set to None if social (nullable) is None
        if self.social is None:
            _dict["social"] = None

        # set to None if configuration (nullable) is None
        if self.configuration is None:
            _dict["configuration"] = None

        # set to None if profile_id (nullable) is None
        if self.profile_id is None:
            _dict["profileId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonPutBody:
        """Create an instance of SeasonPutBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SeasonPutBody.parse_obj(obj)

        _obj = SeasonPutBody.parse_obj(
            {
                "competition_id": obj.get("competitionId"),
                "leader_criteria_id": obj.get("leaderCriteriaId"),
                "international_reference": obj.get("internationalReference"),
                "event_type": obj.get("eventType") if obj.get("eventType") is not None else "FIXTURE",
                "season_type": obj.get("seasonType"),
                "year": obj.get("year"),
                "grade": obj.get("grade"),
                "status": obj.get("status"),
                "include_in_statistics": obj.get("includeInStatistics")
                if obj.get("includeInStatistics") is not None
                else True,
                "live_video_available": obj.get("liveVideoAvailable"),
                "live_data_available": obj.get("liveDataAvailable"),
                "duration_full": obj.get("durationFull"),
                "name_local": obj.get("nameLocal"),
                "name_latin": obj.get("nameLatin"),
                "name_short_local": obj.get("nameShortLocal"),
                "name_short_latin": obj.get("nameShortLatin"),
                "start_date": obj.get("startDate"),
                "end_date": obj.get("endDate"),
                "gender": obj.get("gender"),
                "age_group": obj.get("ageGroup"),
                "standard": obj.get("standard"),
                "representation": obj.get("representation"),
                "standing_configuration_id": obj.get("standingConfigurationId"),
                "lock_standings": obj.get("lockStandings"),
                "external_id": obj.get("externalId"),
                "social": SocialMedia.from_dict(obj.get("social")) if obj.get("social") is not None else None,
                "configuration": obj.get("configuration"),
                "profile_id": obj.get("profileId"),
                "video_production": obj.get("videoProduction") if obj.get("videoProduction") is not None else "NONE",
            }
        )
        return _obj
