# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.season_fixture_stages_pools_list_model_stage import (
    SeasonFixtureStagesPoolsListModelStage,
)
from atriumsports.datacore.openapi.models.season_pools_model_organization import SeasonPoolsModelOrganization


class SeasonPoolsModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[SeasonPoolsModelOrganization] = None
    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    pool_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="poolCode", description="A unique code for the pool. (Unique for season)"
    )
    stage_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="stageCode", description="A unique code for the stage. (Unique for season)"
    )
    stage: Optional[SeasonFixtureStagesPoolsListModelStage] = None
    name_local: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="nameLocal",
        description="The name of the pool in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    abbreviation_local: Optional[constr(strict=True, max_length=10)] = Field(
        None,
        alias="abbreviationLocal",
        description="An abbreviation/short name in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_latin: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="nameLatin",
        description="The name of the pool in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    abbreviation_latin: Optional[constr(strict=True, max_length=10)] = Field(
        None,
        alias="abbreviationLatin",
        description="An abbreviation/short name in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    pool_order: Optional[StrictInt] = Field(
        None, alias="poolOrder", description="User defined sort order of the ~pool~"
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "organizationId",
        "organization",
        "seasonId",
        "season",
        "poolCode",
        "stageCode",
        "stage",
        "nameLocal",
        "abbreviationLocal",
        "nameLatin",
        "abbreviationLatin",
        "poolOrder",
        "externalId",
        "updated",
        "added",
    ]

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonPoolsModel:
        """Create an instance of SeasonPoolsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stage
        if self.stage:
            _dict["stage"] = self.stage.to_dict()
        # set to None if stage_code (nullable) is None
        if self.stage_code is None:
            _dict["stageCode"] = None

        # set to None if name_local (nullable) is None
        if self.name_local is None:
            _dict["nameLocal"] = None

        # set to None if abbreviation_local (nullable) is None
        if self.abbreviation_local is None:
            _dict["abbreviationLocal"] = None

        # set to None if name_latin (nullable) is None
        if self.name_latin is None:
            _dict["nameLatin"] = None

        # set to None if abbreviation_latin (nullable) is None
        if self.abbreviation_latin is None:
            _dict["abbreviationLatin"] = None

        # set to None if pool_order (nullable) is None
        if self.pool_order is None:
            _dict["poolOrder"] = None

        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonPoolsModel:
        """Create an instance of SeasonPoolsModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SeasonPoolsModel.parse_obj(obj)

        _obj = SeasonPoolsModel.parse_obj(
            {
                "organization_id": obj.get("organizationId"),
                "organization": SeasonPoolsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "pool_code": obj.get("poolCode"),
                "stage_code": obj.get("stageCode"),
                "stage": SeasonFixtureStagesPoolsListModelStage.from_dict(obj.get("stage"))
                if obj.get("stage") is not None
                else None,
                "name_local": obj.get("nameLocal"),
                "abbreviation_local": obj.get("abbreviationLocal"),
                "name_latin": obj.get("nameLatin"),
                "abbreviation_latin": obj.get("abbreviationLatin"),
                "pool_order": obj.get("poolOrder"),
                "external_id": obj.get("externalId"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
