# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator


class SeasonEntityBaseStatisticsPostBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    season_id: StrictStr = Field(..., alias="seasonId", description="The unique identifier of the season")
    entity_id: StrictStr = Field(..., alias="entityId", description="The unique identifier of the entity")
    fixture_type: constr(strict=True, max_length=50) = Field(
        ...,
        alias="fixtureType",
        description="Type of fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular ",
    )
    competitor_type: constr(strict=True, max_length=50) = Field(
        ...,
        alias="competitorType",
        description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person ",
    )
    statistics: Optional[Dict[str, Any]] = None
    __properties = ["seasonId", "entityId", "fixtureType", "competitorType", "statistics"]

    @validator("fixture_type")
    def fixture_type_validate_enum(cls, v):
        if v not in ("ALL_STAR", "PRESEASON", "REGULAR", "FINAL", "PLAYOFF", "FRIENDLY", "DEMONSTRATION"):
            raise ValueError(
                "must validate the enum values ('ALL_STAR', 'PRESEASON', 'REGULAR', 'FINAL', 'PLAYOFF', 'FRIENDLY', 'DEMONSTRATION')"
            )
        return v

    @validator("competitor_type")
    def competitor_type_validate_enum(cls, v):
        if v not in ("PERSON", "ENTITY"):
            raise ValueError("must validate the enum values ('PERSON', 'ENTITY')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonEntityBaseStatisticsPostBody:
        """Create an instance of SeasonEntityBaseStatisticsPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonEntityBaseStatisticsPostBody:
        """Create an instance of SeasonEntityBaseStatisticsPostBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SeasonEntityBaseStatisticsPostBody.parse_obj(obj)

        _obj = SeasonEntityBaseStatisticsPostBody.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "entity_id": obj.get("entityId"),
                "fixture_type": obj.get("fixtureType"),
                "competitor_type": obj.get("competitorType"),
                "statistics": obj.get("statistics"),
            }
        )
        return _obj
