# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from inspect import getfullargspec
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.fixture_entities_model_entity import FixtureEntitiesModelEntity
from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.season_entity_base_statistics_model_organization import (
    SeasonEntityBaseStatisticsModelOrganization,
)


class SeasonEntityBaseStatisticsModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    entity: Optional[FixtureEntitiesModelEntity] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[SeasonEntityBaseStatisticsModelOrganization] = None
    fixture_type: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="fixtureType",
        description="Type of fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular ",
    )
    competitor_type: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="competitorType",
        description="The type of competitors in this fixture >- `ENTITY` Entity >- `PERSON` Person ",
    )
    statistics: Optional[Dict[str, Any]] = None
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "seasonId",
        "season",
        "entityId",
        "entity",
        "organizationId",
        "organization",
        "fixtureType",
        "competitorType",
        "statistics",
        "updated",
        "added",
    ]

    @validator("fixture_type")
    def fixture_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("ALL_STAR", "PRESEASON", "REGULAR", "FINAL", "PLAYOFF", "FRIENDLY", "DEMONSTRATION"):
            raise ValueError(
                "must validate the enum values ('ALL_STAR', 'PRESEASON', 'REGULAR', 'FINAL', 'PLAYOFF', 'FRIENDLY', 'DEMONSTRATION')"
            )
        return v

    @validator("competitor_type")
    def competitor_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("PERSON", "ENTITY"):
            raise ValueError("must validate the enum values ('PERSON', 'ENTITY')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonEntityBaseStatisticsModel:
        """Create an instance of SeasonEntityBaseStatisticsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonEntityBaseStatisticsModel:
        """Create an instance of SeasonEntityBaseStatisticsModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SeasonEntityBaseStatisticsModel.parse_obj(obj)

        _obj = SeasonEntityBaseStatisticsModel.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "entity_id": obj.get("entityId"),
                "entity": FixtureEntitiesModelEntity.from_dict(obj.get("entity"))
                if obj.get("entity") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": SeasonEntityBaseStatisticsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "fixture_type": obj.get("fixtureType"),
                "competitor_type": obj.get("competitorType"),
                "statistics": obj.get("statistics"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
