# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.social_media import SocialMedia


class LeaguePostBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    league_id: Optional[StrictStr] = Field(None, alias="leagueId", description="The unique identifier of the league")
    abbreviation_local: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="abbreviationLocal",
        description="An abbreviation/short name in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_local: constr(strict=True, max_length=150) = Field(
        ...,
        alias="nameLocal",
        description="The name of the league in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    abbreviation_latin: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="abbreviationLatin",
        description="An abbreviation/short name in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the league in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    country_code: Optional[constr(strict=True, max_length=3, min_length=3)] = Field(
        None,
        alias="countryCode",
        description="Country code of the league. We recommend you use ISO-3166-1:alpha3 (upper case) values where available.",
    )
    region_type: StrictStr = Field(
        ...,
        alias="regionType",
        description="How geographically relevant is this league >- `INTERNATIONAL` Multiple countries >- `INTERSTATE` Cross state >- `LOCAL` Local area >- `NATIONAL` One country >- `STATE` One state ",
    )
    social: Optional[SocialMedia] = None
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = [
        "leagueId",
        "abbreviationLocal",
        "nameLocal",
        "abbreviationLatin",
        "nameLatin",
        "countryCode",
        "regionType",
        "social",
        "externalId",
    ]

    @validator("region_type")
    def region_type_validate_enum(cls, v):
        if v not in ("LOCAL", "STATE", "INTERSTATE", "NATIONAL", "INTERNATIONAL"):
            raise ValueError(
                "must validate the enum values ('LOCAL', 'STATE', 'INTERSTATE', 'NATIONAL', 'INTERNATIONAL')"
            )
        return v

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LeaguePostBody:
        """Create an instance of LeaguePostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of social
        if self.social:
            _dict["social"] = self.social.to_dict()
        # set to None if abbreviation_local (nullable) is None
        if self.abbreviation_local is None:
            _dict["abbreviationLocal"] = None

        # set to None if abbreviation_latin (nullable) is None
        if self.abbreviation_latin is None:
            _dict["abbreviationLatin"] = None

        # set to None if name_latin (nullable) is None
        if self.name_latin is None:
            _dict["nameLatin"] = None

        # set to None if country_code (nullable) is None
        if self.country_code is None:
            _dict["countryCode"] = None

        # set to None if social (nullable) is None
        if self.social is None:
            _dict["social"] = None

        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LeaguePostBody:
        """Create an instance of LeaguePostBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return LeaguePostBody.parse_obj(obj)

        _obj = LeaguePostBody.parse_obj(
            {
                "league_id": obj.get("leagueId"),
                "abbreviation_local": obj.get("abbreviationLocal"),
                "name_local": obj.get("nameLocal"),
                "abbreviation_latin": obj.get("abbreviationLatin"),
                "name_latin": obj.get("nameLatin"),
                "country_code": obj.get("countryCode"),
                "region_type": obj.get("regionType"),
                "social": SocialMedia.from_dict(obj.get("social")) if obj.get("social") is not None else None,
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
