# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictFloat, StrictStr, validator


class LeaderQualifierPostBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    qualifier_id: Optional[StrictStr] = Field(
        None, alias="qualifierId", description="The unique identifier of the leader qualifier"
    )
    leader_criteria_id: StrictStr = Field(
        ..., alias="leaderCriteriaId", description="The unique identifier of the ~LeaderCriteria~"
    )
    statistic_field: StrictStr = Field(
        ..., alias="statisticField", description="The statistic field that this qualifier is for."
    )
    comparison_field: StrictStr = Field(
        ..., alias="comparisonField", description="The statistic field to compare against."
    )
    comparison_type: StrictStr = Field(
        ...,
        alias="comparisonType",
        description="Comparison type for the qualifier >- `EQUAL` Equal >- `GREATER_THAN` Greater than >- `GREATER_THAN_EQUAL` Greater than or equal >- `LESS_THAN` Less than >- `LESS_THAN_EQUAL` Less than or equal ",
    )
    comparison_value: StrictFloat = Field(
        ..., alias="comparisonValue", description="Comparison value for the qualifier"
    )
    __properties = [
        "qualifierId",
        "leaderCriteriaId",
        "statisticField",
        "comparisonField",
        "comparisonType",
        "comparisonValue",
    ]

    @validator("comparison_type")
    def comparison_type_validate_enum(cls, v):
        if v not in ("GREATER_THAN", "LESS_THAN", "EQUAL", "GREATER_THAN_EQUAL", "LESS_THAN_EQUAL"):
            raise ValueError(
                "must validate the enum values ('GREATER_THAN', 'LESS_THAN', 'EQUAL', 'GREATER_THAN_EQUAL', 'LESS_THAN_EQUAL')"
            )
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LeaderQualifierPostBody:
        """Create an instance of LeaderQualifierPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LeaderQualifierPostBody:
        """Create an instance of LeaderQualifierPostBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return LeaderQualifierPostBody.parse_obj(obj)

        _obj = LeaderQualifierPostBody.parse_obj(
            {
                "qualifier_id": obj.get("qualifierId"),
                "leader_criteria_id": obj.get("leaderCriteriaId"),
                "statistic_field": obj.get("statisticField"),
                "comparison_field": obj.get("comparisonField"),
                "comparison_type": obj.get("comparisonType"),
                "comparison_value": obj.get("comparisonValue"),
            }
        )
        return _obj
