# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr

from atriumsports.datacore.openapi.models.leader_criteria_model_organization import LeaderCriteriaModelOrganization


class LeaderCriteriaModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[LeaderCriteriaModelOrganization] = None
    leader_criteria_id: Optional[StrictStr] = Field(
        None, alias="leaderCriteriaId", description="The unique identifier of the leader criteria"
    )
    name: Optional[StrictStr] = Field(None, description="The name of the criteria")
    __properties = ["added", "organizationId", "organization", "leaderCriteriaId", "name"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LeaderCriteriaModel:
        """Create an instance of LeaderCriteriaModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "added",
                "organization_id",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LeaderCriteriaModel:
        """Create an instance of LeaderCriteriaModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return LeaderCriteriaModel.parse_obj(obj)

        _obj = LeaderCriteriaModel.parse_obj(
            {
                "added": obj.get("added"),
                "organization_id": obj.get("organizationId"),
                "organization": LeaderCriteriaModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "leader_criteria_id": obj.get("leaderCriteriaId"),
                "name": obj.get("name"),
            }
        )
        return _obj
