# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.fixture_progressions_model_fixture import FixtureProgressionsModelFixture
from atriumsports.datacore.openapi.models.fixture_progressions_model_organization import (
    FixtureProgressionsModelOrganization,
)
from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason


class FixtureProgressionsModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="Source fixtureId")
    fixture: Optional[FixtureProgressionsModelFixture] = None
    to_fixture_id: Optional[StrictStr] = Field(None, alias="toFixtureId", description="Destination fixtureId")
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[FixtureProgressionsModelOrganization] = None
    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    placing: Optional[StrictInt] = Field(None, description="Place after source fixture completion")
    is_home: Optional[StrictBool] = Field(
        None, alias="isHome", description="Will this competitor be the 'home' entity in the target fixture?"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = [
        "fixtureId",
        "fixture",
        "toFixtureId",
        "organizationId",
        "organization",
        "seasonId",
        "season",
        "placing",
        "isHome",
        "updated",
        "added",
        "externalId",
    ]

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixtureProgressionsModel:
        """Create an instance of FixtureProgressionsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of fixture
        if self.fixture:
            _dict["fixture"] = self.fixture.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixtureProgressionsModel:
        """Create an instance of FixtureProgressionsModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return FixtureProgressionsModel.parse_obj(obj)

        _obj = FixtureProgressionsModel.parse_obj(
            {
                "fixture_id": obj.get("fixtureId"),
                "fixture": FixtureProgressionsModelFixture.from_dict(obj.get("fixture"))
                if obj.get("fixture") is not None
                else None,
                "to_fixture_id": obj.get("toFixtureId"),
                "organization_id": obj.get("organizationId"),
                "organization": FixtureProgressionsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "placing": obj.get("placing"),
                "is_home": obj.get("isHome"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
