# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, constr


class FixturePbpPostBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="The unique identifier of the fixture")
    period_id: Optional[StrictInt] = Field(None, alias="periodId", description="The identifier for the period")
    section: Optional[constr(strict=True, max_length=100)] = Field(
        None, description="The section of the period (sub-period)"
    )
    events: Optional[Dict[str, Any]] = Field(None, description="Event details")
    __properties = ["fixtureId", "periodId", "section", "events"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixturePbpPostBody:
        """Create an instance of FixturePbpPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if events (nullable) is None
        if self.events is None:
            _dict["events"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixturePbpPostBody:
        """Create an instance of FixturePbpPostBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return FixturePbpPostBody.parse_obj(obj)

        _obj = FixturePbpPostBody.parse_obj(
            {
                "fixture_id": obj.get("fixtureId"),
                "period_id": obj.get("periodId"),
                "section": obj.get("section"),
                "events": obj.get("events"),
            }
        )
        return _obj
