# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictStr, validator


class FixtureParticipant(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    person_id: StrictStr = Field(..., alias="personId", description="The uuid of the person")
    entity_group_id: Optional[StrictStr] = Field(
        None, alias="entityGroupId", description="The uuid of the entity group"
    )
    is_home: Optional[StrictBool] = Field(None, alias="isHome", description="Is participant the home person ?")
    draw: Optional[StrictBool] = Field(None, description="Result for this participant was a draw ?")
    result_status: Optional[StrictStr] = Field(None, alias="resultStatus", description="Result status")
    result_place: Optional[StrictFloat] = Field(None, alias="resultPlace", description="Result placing (1=Won, 2=Lost)")
    starting_number: Optional[StrictFloat] = Field(None, alias="startingNumber", description="Starting number")
    score: Optional[StrictStr] = Field(None, description="Score for participant in fixture")
    secondary_score: Optional[StrictStr] = Field(None, alias="secondaryScore", description="Secondary score")
    is_neutral_venue: Optional[StrictBool] = Field(
        None, alias="isNeutralVenue", description="Participant is playing at a neutral venue ?"
    )
    external_id: Optional[StrictStr] = Field(None, alias="externalId", description="externalId")
    __properties = [
        "personId",
        "entityGroupId",
        "isHome",
        "draw",
        "resultStatus",
        "resultPlace",
        "startingNumber",
        "score",
        "secondaryScore",
        "isNeutralVenue",
        "externalId",
    ]

    @validator("result_status")
    def result_status_validate_enum(cls, v):
        if v is None:
            return v

        if v not in (
            "SCHEDULED",
            "IN_PROGRESS",
            "CONFIRMED",
            "DISQUALIFIED",
            "FORFEITED",
            "WON_BY_FORFEIT",
            "DID_NOT_FINISH",
            "WITHDRAWN",
            "DID_NOT_START",
        ):
            raise ValueError(
                "must validate the enum values ('SCHEDULED', 'IN_PROGRESS', 'CONFIRMED', 'DISQUALIFIED', 'FORFEITED', 'WON_BY_FORFEIT', 'DID_NOT_FINISH', 'WITHDRAWN', 'DID_NOT_START')"
            )
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FixtureParticipant:
        """Create an instance of FixtureParticipant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if result_place (nullable) is None
        if self.result_place is None:
            _dict["resultPlace"] = None

        # set to None if starting_number (nullable) is None
        if self.starting_number is None:
            _dict["startingNumber"] = None

        # set to None if score (nullable) is None
        if self.score is None:
            _dict["score"] = None

        # set to None if secondary_score (nullable) is None
        if self.secondary_score is None:
            _dict["secondaryScore"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FixtureParticipant:
        """Create an instance of FixtureParticipant from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return FixtureParticipant.parse_obj(obj)

        _obj = FixtureParticipant.parse_obj(
            {
                "person_id": obj.get("personId"),
                "entity_group_id": obj.get("entityGroupId"),
                "is_home": obj.get("isHome"),
                "draw": obj.get("draw"),
                "result_status": obj.get("resultStatus"),
                "result_place": obj.get("resultPlace"),
                "starting_number": obj.get("startingNumber"),
                "score": obj.get("score"),
                "secondary_score": obj.get("secondaryScore"),
                "is_neutral_venue": obj.get("isNeutralVenue"),
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
