# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, constr


class EntityPostBodyAdditionalNames(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    name_short_local: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="nameShortLocal",
        description="The short name of the entity in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_place_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="namePlaceLocal",
        description="The name of the place associated with the entity in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_short_latin: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="nameShortLatin",
        description="The short name of the entity using [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    name_place_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="namePlaceLatin",
        description="The name of the place associated with the entity using [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    __properties = ["nameShortLocal", "namePlaceLocal", "nameShortLatin", "namePlaceLatin"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EntityPostBodyAdditionalNames:
        """Create an instance of EntityPostBodyAdditionalNames from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if name_short_local (nullable) is None
        if self.name_short_local is None:
            _dict["nameShortLocal"] = None

        # set to None if name_place_local (nullable) is None
        if self.name_place_local is None:
            _dict["namePlaceLocal"] = None

        # set to None if name_short_latin (nullable) is None
        if self.name_short_latin is None:
            _dict["nameShortLatin"] = None

        # set to None if name_place_latin (nullable) is None
        if self.name_place_latin is None:
            _dict["namePlaceLatin"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EntityPostBodyAdditionalNames:
        """Create an instance of EntityPostBodyAdditionalNames from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EntityPostBodyAdditionalNames.parse_obj(obj)

        _obj = EntityPostBodyAdditionalNames.parse_obj(
            {
                "name_short_local": obj.get("nameShortLocal"),
                "name_place_local": obj.get("namePlaceLocal"),
                "name_short_latin": obj.get("nameShortLatin"),
                "name_place_latin": obj.get("namePlaceLatin"),
            }
        )
        return _obj
