# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, constr


class EntityGroupPostBodyColors(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    primary: Optional[constr(strict=True, max_length=6, min_length=6)] = Field(
        None,
        description="Primary color of the entity group.  Colors are a hexadecimal string `RRGGBB` with `RR`(red), `GG`(green) and `BB`(blue) representing the components of the colour. ",
    )
    secondary: Optional[constr(strict=True, max_length=6, min_length=6)] = Field(
        None,
        description="Secondary color of the entity group.  Colors are a hexadecimal string `RRGGBB` with `RR`(red), `GG`(green) and `BB`(blue) representing the components of the colour. ",
    )
    tertiary: Optional[constr(strict=True, max_length=6, min_length=6)] = Field(
        None,
        description="Tertiary color of the entity group.  Colors are a hexadecimal string `RRGGBB` with `RR`(red), `GG`(green) and `BB`(blue) representing the components of the colour. ",
    )
    __properties = ["primary", "secondary", "tertiary"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EntityGroupPostBodyColors:
        """Create an instance of EntityGroupPostBodyColors from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if primary (nullable) is None
        if self.primary is None:
            _dict["primary"] = None

        # set to None if secondary (nullable) is None
        if self.secondary is None:
            _dict["secondary"] = None

        # set to None if tertiary (nullable) is None
        if self.tertiary is None:
            _dict["tertiary"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EntityGroupPostBodyColors:
        """Create an instance of EntityGroupPostBodyColors from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EntityGroupPostBodyColors.parse_obj(obj)

        _obj = EntityGroupPostBodyColors.parse_obj(
            {"primary": obj.get("primary"), "secondary": obj.get("secondary"), "tertiary": obj.get("tertiary")}
        )
        return _obj
