# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictFloat, StrictStr, constr


class EntityGroupAddress(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    address1: Optional[StrictStr] = Field(None, description="First line of the address")
    address2: Optional[StrictStr] = Field(None, description="Second line of the address")
    address3: Optional[StrictStr] = Field(None, description="Third line of the address")
    city: Optional[StrictStr] = Field(None, description="The city/suburb of the address")
    state: Optional[StrictStr] = Field(None, description="The state of the address")
    postal_code: Optional[StrictStr] = Field(None, alias="postalCode", description="The postal code for the address")
    country_code: Optional[constr(strict=True, max_length=3, min_length=3)] = Field(
        None,
        alias="countryCode",
        description="ISO Country code of the address.  We recommend you use ISO-3166-1:alpha3 (upper case) values where available.",
    )
    longitude: Optional[StrictFloat] = None
    latitude: Optional[StrictFloat] = None
    __properties = [
        "address1",
        "address2",
        "address3",
        "city",
        "state",
        "postalCode",
        "countryCode",
        "longitude",
        "latitude",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EntityGroupAddress:
        """Create an instance of EntityGroupAddress from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if address1 (nullable) is None
        if self.address1 is None:
            _dict["address1"] = None

        # set to None if address2 (nullable) is None
        if self.address2 is None:
            _dict["address2"] = None

        # set to None if address3 (nullable) is None
        if self.address3 is None:
            _dict["address3"] = None

        # set to None if city (nullable) is None
        if self.city is None:
            _dict["city"] = None

        # set to None if state (nullable) is None
        if self.state is None:
            _dict["state"] = None

        # set to None if postal_code (nullable) is None
        if self.postal_code is None:
            _dict["postalCode"] = None

        # set to None if country_code (nullable) is None
        if self.country_code is None:
            _dict["countryCode"] = None

        # set to None if longitude (nullable) is None
        if self.longitude is None:
            _dict["longitude"] = None

        # set to None if latitude (nullable) is None
        if self.latitude is None:
            _dict["latitude"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EntityGroupAddress:
        """Create an instance of EntityGroupAddress from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EntityGroupAddress.parse_obj(obj)

        _obj = EntityGroupAddress.parse_obj(
            {
                "address1": obj.get("address1"),
                "address2": obj.get("address2"),
                "address3": obj.get("address3"),
                "city": obj.get("city"),
                "state": obj.get("state"),
                "postal_code": obj.get("postalCode"),
                "country_code": obj.get("countryCode"),
                "longitude": obj.get("longitude"),
                "latitude": obj.get("latitude"),
            }
        )
        return _obj
