# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictFloat


class EntityAdditionalDetails(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    founded: Optional[StrictFloat] = Field(None, description="Year Founded")
    squad_value: Optional[StrictFloat] = Field(None, alias="squadValue", description="Value of Squad")
    __properties = ["founded", "squadValue"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EntityAdditionalDetails:
        """Create an instance of EntityAdditionalDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if founded (nullable) is None
        if self.founded is None:
            _dict["founded"] = None

        # set to None if squad_value (nullable) is None
        if self.squad_value is None:
            _dict["squadValue"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EntityAdditionalDetails:
        """Create an instance of EntityAdditionalDetails from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EntityAdditionalDetails.parse_obj(obj)

        _obj = EntityAdditionalDetails.parse_obj({"founded": obj.get("founded"), "squad_value": obj.get("squadValue")})
        return _obj
