# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr


class ContactDetails(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    fax: Optional[StrictStr] = Field(None, description="Fax number")
    phone: Optional[StrictStr] = Field(None, description="Primary phone number")
    phone_secondary: Optional[StrictStr] = Field(None, alias="phoneSecondary", description="Secondary phone number")
    email: Optional[StrictStr] = Field(None, description="Primary email address")
    __properties = ["fax", "phone", "phoneSecondary", "email"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ContactDetails:
        """Create an instance of ContactDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if fax (nullable) is None
        if self.fax is None:
            _dict["fax"] = None

        # set to None if phone (nullable) is None
        if self.phone is None:
            _dict["phone"] = None

        # set to None if phone_secondary (nullable) is None
        if self.phone_secondary is None:
            _dict["phoneSecondary"] = None

        # set to None if email (nullable) is None
        if self.email is None:
            _dict["email"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ContactDetails:
        """Create an instance of ContactDetails from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ContactDetails.parse_obj(obj)

        _obj = ContactDetails.parse_obj(
            {
                "fax": obj.get("fax"),
                "phone": obj.get("phone"),
                "phone_secondary": obj.get("phoneSecondary"),
                "email": obj.get("email"),
            }
        )
        return _obj
