# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.competition_historical_name import CompetitionHistoricalName
from atriumsports.datacore.openapi.models.competitions_season_status_model_league import (
    CompetitionsSeasonStatusModelLeague,
)
from atriumsports.datacore.openapi.models.competitions_season_status_model_organization import (
    CompetitionsSeasonStatusModelOrganization,
)
from atriumsports.datacore.openapi.models.images_model import ImagesModel
from atriumsports.datacore.openapi.models.social_media import SocialMedia


class CompetitionsSeasonStatusModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The unique identifier of the competition"
    )
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[CompetitionsSeasonStatusModelOrganization] = None
    league_id: Optional[StrictStr] = Field(None, alias="leagueId", description="The unique identifier of the league")
    league: Optional[CompetitionsSeasonStatusModelLeague] = None
    international_reference: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="internationalReference",
        description="The international reference for this competition season status given by the sport governing body",
    )
    abbreviation_local: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="abbreviationLocal",
        description="An abbreviation/short name in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLocal",
        description="The name of the competition season status in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    event_type: Optional[constr(strict=True, max_length=30)] = Field(
        "FIXTURE",
        alias="eventType",
        description="Primary Type of Fixtures >- `FIXTURE` Fixture >- `PRACTICE` Practice ",
    )
    abbreviation_latin: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="abbreviationLatin",
        description="An abbreviation/short name in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the competition season status in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    social: Optional[SocialMedia] = None
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    historical_names: Optional[List[CompetitionHistoricalName]] = Field(
        None, alias="historicalNames", description="Array of competition historical names"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    age_group: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="ageGroup",
        description="The age group of the competition >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth ",
    )
    images: Optional[List[ImagesModel]] = None
    __properties = [
        "competitionId",
        "organizationId",
        "organization",
        "leagueId",
        "league",
        "internationalReference",
        "abbreviationLocal",
        "nameLocal",
        "eventType",
        "abbreviationLatin",
        "nameLatin",
        "social",
        "externalId",
        "historicalNames",
        "updated",
        "added",
        "ageGroup",
        "images",
    ]

    @validator("event_type")
    def event_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("FIXTURE", "PRACTICE"):
            raise ValueError("must validate the enum values ('FIXTURE', 'PRACTICE')")
        return v

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    @validator("age_group")
    def age_group_validate_enum(cls, v):
        if v is None:
            return v

        if v not in (
            "JUNIOR",
            "YOUTH",
            "UNDER_15",
            "UNDER_16",
            "UNDER_17",
            "UNDER_18",
            "UNDER_19",
            "UNDER_20",
            "UNDER_21",
            "UNDER_22",
            "UNDER_23",
            "SENIOR",
            "MASTERS",
        ):
            raise ValueError(
                "must validate the enum values ('JUNIOR', 'YOUTH', 'UNDER_15', 'UNDER_16', 'UNDER_17', 'UNDER_18', 'UNDER_19', 'UNDER_20', 'UNDER_21', 'UNDER_22', 'UNDER_23', 'SENIOR', 'MASTERS')"
            )
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompetitionsSeasonStatusModel:
        """Create an instance of CompetitionsSeasonStatusModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of league
        if self.league:
            _dict["league"] = self.league.to_dict()
        # override the default output from pydantic by calling `to_dict()` of social
        if self.social:
            _dict["social"] = self.social.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in historical_names (list)
        _items = []
        if self.historical_names:
            for _item in self.historical_names:
                if _item:
                    _items.append(_item.to_dict())
            _dict["historicalNames"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item in self.images:
                if _item:
                    _items.append(_item.to_dict())
            _dict["images"] = _items
        # set to None if international_reference (nullable) is None
        if self.international_reference is None:
            _dict["internationalReference"] = None

        # set to None if abbreviation_local (nullable) is None
        if self.abbreviation_local is None:
            _dict["abbreviationLocal"] = None

        # set to None if abbreviation_latin (nullable) is None
        if self.abbreviation_latin is None:
            _dict["abbreviationLatin"] = None

        # set to None if name_latin (nullable) is None
        if self.name_latin is None:
            _dict["nameLatin"] = None

        # set to None if social (nullable) is None
        if self.social is None:
            _dict["social"] = None

        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        # set to None if historical_names (nullable) is None
        if self.historical_names is None:
            _dict["historicalNames"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CompetitionsSeasonStatusModel:
        """Create an instance of CompetitionsSeasonStatusModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CompetitionsSeasonStatusModel.parse_obj(obj)

        _obj = CompetitionsSeasonStatusModel.parse_obj(
            {
                "competition_id": obj.get("competitionId"),
                "organization_id": obj.get("organizationId"),
                "organization": CompetitionsSeasonStatusModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "league_id": obj.get("leagueId"),
                "league": CompetitionsSeasonStatusModelLeague.from_dict(obj.get("league"))
                if obj.get("league") is not None
                else None,
                "international_reference": obj.get("internationalReference"),
                "abbreviation_local": obj.get("abbreviationLocal"),
                "name_local": obj.get("nameLocal"),
                "event_type": obj.get("eventType") if obj.get("eventType") is not None else "FIXTURE",
                "abbreviation_latin": obj.get("abbreviationLatin"),
                "name_latin": obj.get("nameLatin"),
                "social": SocialMedia.from_dict(obj.get("social")) if obj.get("social") is not None else None,
                "external_id": obj.get("externalId"),
                "historical_names": [CompetitionHistoricalName.from_dict(_item) for _item in obj.get("historicalNames")]
                if obj.get("historicalNames") is not None
                else None,
                "updated": obj.get("updated"),
                "added": obj.get("added"),
                "age_group": obj.get("ageGroup"),
                "images": [ImagesModel.from_dict(_item) for _item in obj.get("images")]
                if obj.get("images") is not None
                else None,
            }
        )
        return _obj
