# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictStr

from atriumsports.datacore.openapi.models.competition_person_statistics_model_organization import (
    CompetitionPersonStatisticsModelOrganization,
)
from atriumsports.datacore.openapi.models.fixture_persons_model_person import FixturePersonsModelPerson
from atriumsports.datacore.openapi.models.seasons_model_competition import SeasonsModelCompetition


class CompetitionPersonStatisticsModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The unique identifier of the person")
    person: Optional[FixturePersonsModelPerson] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[CompetitionPersonStatisticsModelOrganization] = None
    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The unique identifier of the competition"
    )
    competition: Optional[SeasonsModelCompetition] = None
    statistics: Optional[Dict[str, Any]] = None
    __properties = [
        "personId",
        "person",
        "organizationId",
        "organization",
        "competitionId",
        "competition",
        "statistics",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompetitionPersonStatisticsModel:
        """Create an instance of CompetitionPersonStatisticsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of person
        if self.person:
            _dict["person"] = self.person.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of competition
        if self.competition:
            _dict["competition"] = self.competition.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CompetitionPersonStatisticsModel:
        """Create an instance of CompetitionPersonStatisticsModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CompetitionPersonStatisticsModel.parse_obj(obj)

        _obj = CompetitionPersonStatisticsModel.parse_obj(
            {
                "person_id": obj.get("personId"),
                "person": FixturePersonsModelPerson.from_dict(obj.get("person"))
                if obj.get("person") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": CompetitionPersonStatisticsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "competition_id": obj.get("competitionId"),
                "competition": SeasonsModelCompetition.from_dict(obj.get("competition"))
                if obj.get("competition") is not None
                else None,
                "statistics": obj.get("statistics"),
            }
        )
        return _obj
