# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictStr

from atriumsports.datacore.openapi.models.competition_entity_statistics_model_organization import (
    CompetitionEntityStatisticsModelOrganization,
)
from atriumsports.datacore.openapi.models.fixture_entities_model_entity import FixtureEntitiesModelEntity
from atriumsports.datacore.openapi.models.seasons_model_competition import SeasonsModelCompetition


class CompetitionEntityStatisticsModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    entity: Optional[FixtureEntitiesModelEntity] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[CompetitionEntityStatisticsModelOrganization] = None
    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The unique identifier of the competition"
    )
    competition: Optional[SeasonsModelCompetition] = None
    statistics: Optional[Dict[str, Any]] = None
    __properties = [
        "entityId",
        "entity",
        "organizationId",
        "organization",
        "competitionId",
        "competition",
        "statistics",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompetitionEntityStatisticsModel:
        """Create an instance of CompetitionEntityStatisticsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of competition
        if self.competition:
            _dict["competition"] = self.competition.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CompetitionEntityStatisticsModel:
        """Create an instance of CompetitionEntityStatisticsModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CompetitionEntityStatisticsModel.parse_obj(obj)

        _obj = CompetitionEntityStatisticsModel.parse_obj(
            {
                "entity_id": obj.get("entityId"),
                "entity": FixtureEntitiesModelEntity.from_dict(obj.get("entity"))
                if obj.get("entity") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": CompetitionEntityStatisticsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "competition_id": obj.get("competitionId"),
                "competition": SeasonsModelCompetition.from_dict(obj.get("competition"))
                if obj.get("competition") is not None
                else None,
                "statistics": obj.get("statistics"),
            }
        )
        return _obj
