# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import logging
import re  # noqa: F401
from datetime import datetime
from typing import Optional

from pydantic import Field, StrictBool, StrictInt, StrictStr, ValidationError, conint, constr, validate_arguments
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.season_standings_stages_pools_list_response import (
    SeasonStandingsStagesPoolsListResponse,
)
from atriumsports.datacore.openapi.models.standing_post_body import StandingPostBody
from atriumsports.datacore.openapi.models.standing_put_body import StandingPutBody
from atriumsports.datacore.openapi.models.standings_response import StandingsResponse
from atriumsports.datacore.openapi.models.success_response import SuccessResponse

logger = logging.getLogger("openapi")


class StandingsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def season_standings_stages_pools_list(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonStandingsStagesPoolsListResponse:  # noqa: E501
        """Get a list of ~stages~ and ~pools~ used by standings in the season  # noqa: E501

        Return a list of ~stages~ and ~pools~ used by standings for a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_standings_stages_pools_list(organization_id, season_id, sport, external, fields, fixture_type, hide_null, include, limit, offset, stage_code, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonStandingsStagesPoolsListResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_standings_stages_pools_list_with_http_info(
                organization_id,
                season_id,
                sport,
                external,
                fields,
                fixture_type,
                hide_null,
                include,
                limit,
                offset,
                stage_code,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StandingsApi->season_standings_stages_pools_list: %s\n" % e)
            raise

    @validate_arguments
    def season_standings_stages_pools_list_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Get a list of ~stages~ and ~pools~ used by standings in the season  # noqa: E501

        Return a list of ~stages~ and ~pools~ used by standings for a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_standings_stages_pools_list_with_http_info(organization_id, season_id, sport, external, fields, fixture_type, hide_null, include, limit, offset, stage_code, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonStandingsStagesPoolsListResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "external",
            "fields",
            "fixture_type",
            "hide_null",
            "include",
            "limit",
            "offset",
            "stage_code",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method season_standings_stages_pools_list" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonStandingsStagesPoolsListResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/standings/stages/pools",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def standing_all_delete(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Delete all the standings for a season  # noqa: E501

        Delete all a specific seasons standing records  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_all_delete(organization_id, season_id, sport, external, fields, force_delete, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.standing_all_delete_with_http_info(
                organization_id, season_id, sport, external, fields, force_delete, hide_null, include, tbf, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StandingsApi->standing_all_delete: %s\n" % e)
            raise

    @validate_arguments
    def standing_all_delete_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Delete all the standings for a season  # noqa: E501

        Delete all a specific seasons standing records  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_all_delete_with_http_info(organization_id, season_id, sport, external, fields, force_delete, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method standing_all_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/standings",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def standing_build(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Build a standing  # noqa: E501

        Build a standing  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_build(organization_id, season_id, sport, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.standing_build_with_http_info(
                organization_id, season_id, sport, external, fields, hide_null, include, tbf, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StandingsApi->standing_build: %s\n" % e)
            raise

    @validate_arguments
    def standing_build_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Build a standing  # noqa: E501

        Build a standing  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_build_with_http_info(organization_id, season_id, sport, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["organization_id", "season_id", "sport", "external", "fields", "hide_null", "include", "tbf"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method standing_build" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/standings/build",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def standing_build_live(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Build a standing using live data  # noqa: E501

        Build a standing using live data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_build_live(organization_id, season_id, sport, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.standing_build_live_with_http_info(
                organization_id, season_id, sport, external, fields, hide_null, include, tbf, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StandingsApi->standing_build_live: %s\n" % e)
            raise

    @validate_arguments
    def standing_build_live_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Build a standing using live data  # noqa: E501

        Build a standing using live data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_build_live_with_http_info(organization_id, season_id, sport, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["organization_id", "season_id", "sport", "external", "fields", "hide_null", "include", "tbf"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method standing_build_live" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/standings/build/live",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def standing_delete(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        standing_id: Annotated[StrictStr, Field(..., description="The unique identifier of the standing record")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> StandingsResponse:  # noqa: E501
        """Delete a standing  # noqa: E501

        Delete a specific standing  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_delete(organization_id, sport, standing_id, external, fields, force_delete, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param standing_id: The unique identifier of the standing record (required)
        :type standing_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StandingsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.standing_delete_with_http_info(
                organization_id, sport, standing_id, external, fields, force_delete, hide_null, include, tbf, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StandingsApi->standing_delete: %s\n" % e)
            raise

    @validate_arguments
    def standing_delete_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        standing_id: Annotated[StrictStr, Field(..., description="The unique identifier of the standing record")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        force_delete: Annotated[
            Optional[StrictBool],
            Field(
                description="Force a delete command to run and delete child records as well if there are existing records depending on the record."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Delete a standing  # noqa: E501

        Delete a specific standing  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_delete_with_http_info(organization_id, sport, standing_id, external, fields, force_delete, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param standing_id: The unique identifier of the standing record (required)
        :type standing_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param force_delete: Force a delete command to run and delete child records as well if there are existing records depending on the record.
        :type force_delete: bool
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StandingsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "sport",
            "standing_id",
            "external",
            "fields",
            "force_delete",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method standing_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]
        if _params["standing_id"]:
            _path_params["standingId"] = _params["standing_id"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("force_delete") is not None:  # noqa: E501
            _query_params.append(("forceDelete", _params["force_delete"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "StandingsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/standings/{standingId}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def standing_detail(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        standing_id: Annotated[StrictStr, Field(..., description="The unique identifier of the standing record")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> StandingsResponse:  # noqa: E501
        """Get a standing  # noqa: E501

        Return detailed information about a specific standing  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_detail(organization_id, sport, standing_id, external, fields, hide_null, include, limit, offset, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param standing_id: The unique identifier of the standing record (required)
        :type standing_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StandingsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.standing_detail_with_http_info(
                organization_id, sport, standing_id, external, fields, hide_null, include, limit, offset, tbf, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StandingsApi->standing_detail: %s\n" % e)
            raise

    @validate_arguments
    def standing_detail_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        standing_id: Annotated[StrictStr, Field(..., description="The unique identifier of the standing record")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Get a standing  # noqa: E501

        Return detailed information about a specific standing  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_detail_with_http_info(organization_id, sport, standing_id, external, fields, hide_null, include, limit, offset, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param standing_id: The unique identifier of the standing record (required)
        :type standing_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StandingsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "sport",
            "standing_id",
            "external",
            "fields",
            "hide_null",
            "include",
            "limit",
            "offset",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method standing_detail" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]
        if _params["standing_id"]:
            _path_params["standingId"] = _params["standing_id"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "StandingsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/standings/{standingId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def standing_insert(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        standing_post_body: StandingPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> StandingsResponse:  # noqa: E501
        """Create a standing  # noqa: E501

        Insert a new standing  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_insert(organization_id, season_id, sport, standing_post_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param standing_post_body: (required)
        :type standing_post_body: StandingPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StandingsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.standing_insert_with_http_info(
                organization_id,
                season_id,
                sport,
                standing_post_body,
                external,
                fields,
                hide_null,
                include,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StandingsApi->standing_insert: %s\n" % e)
            raise

    @validate_arguments
    def standing_insert_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        standing_post_body: StandingPostBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Create a standing  # noqa: E501

        Insert a new standing  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_insert_with_http_info(organization_id, season_id, sport, standing_post_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param standing_post_body: (required)
        :type standing_post_body: StandingPostBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StandingsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "standing_post_body",
            "external",
            "fields",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method standing_insert" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["standing_post_body"]:
            _body_params = _params["standing_post_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "StandingsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/standings",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def standing_list(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        conference_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the division")
        ] = None,
        division_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the division")] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        grouping_base: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Base grouping of standings row >- `OVERALL` Overall >- `ROUND` Round "),
        ] = None,
        grouping_conference_division: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Conference/Division grouping of standings row >- `CONFERENCE` Conference >- `DIVISION` Division >- `OVERALL` Overall "
            ),
        ] = None,
        grouping_stage_pool: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Stage/Pool grouping of standings row >- `OVERALL` Overall >- `STAGE` Stage >- `STAGEPOOL` Stage/Pool "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        in_progress: Annotated[
            Optional[StrictBool], Field(description="Is the competitor in a current fixture?")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        latest: Annotated[Optional[StrictBool], Field(description="Is this the latest standing record ?")] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        live: Annotated[Optional[StrictBool], Field(description="Live competitor standings?")] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        standing_configuration_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the configuration")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ) -> StandingsResponse:  # noqa: E501
        """Get a list of standings  # noqa: E501

        Return a list of available standings for a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_list(organization_id, season_id, sport, added, conference_id, division_id, entity_id, external, fields, fixture_type, grouping_base, grouping_conference_division, grouping_stage_pool, hide_null, in_progress, include, latest, limit, live, offset, pool_code, round_code, round_number, sort_by, stage_code, standing_configuration_id, tbf, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param conference_id: The unique identifier of the division
        :type conference_id: str
        :param division_id: The unique identifier of the division
        :type division_id: str
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param grouping_base: Base grouping of standings row >- `OVERALL` Overall >- `ROUND` Round
        :type grouping_base: str
        :param grouping_conference_division: Conference/Division grouping of standings row >- `CONFERENCE` Conference >- `DIVISION` Division >- `OVERALL` Overall
        :type grouping_conference_division: str
        :param grouping_stage_pool: Stage/Pool grouping of standings row >- `OVERALL` Overall >- `STAGE` Stage >- `STAGEPOOL` Stage/Pool
        :type grouping_stage_pool: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param in_progress: Is the competitor in a current fixture?
        :type in_progress: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param latest: Is this the latest standing record ?
        :type latest: bool
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param live: Live competitor standings?
        :type live: bool
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param sort_by: Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order.
        :type sort_by: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param standing_configuration_id: The unique identifier of the configuration
        :type standing_configuration_id: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StandingsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.standing_list_with_http_info(
                organization_id,
                season_id,
                sport,
                added,
                conference_id,
                division_id,
                entity_id,
                external,
                fields,
                fixture_type,
                grouping_base,
                grouping_conference_division,
                grouping_stage_pool,
                hide_null,
                in_progress,
                include,
                latest,
                limit,
                live,
                offset,
                pool_code,
                round_code,
                round_number,
                sort_by,
                stage_code,
                standing_configuration_id,
                tbf,
                updated,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StandingsApi->standing_list: %s\n" % e)
            raise

    @validate_arguments
    def standing_list_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        added: Annotated[
            Optional[datetime], Field(description="Record was added after this date/time. In UTC.")
        ] = None,
        conference_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the division")
        ] = None,
        division_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the division")] = None,
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        grouping_base: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Base grouping of standings row >- `OVERALL` Overall >- `ROUND` Round "),
        ] = None,
        grouping_conference_division: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Conference/Division grouping of standings row >- `CONFERENCE` Conference >- `DIVISION` Division >- `OVERALL` Overall "
            ),
        ] = None,
        grouping_stage_pool: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Stage/Pool grouping of standings row >- `OVERALL` Overall >- `STAGE` Stage >- `STAGEPOOL` Stage/Pool "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        in_progress: Annotated[
            Optional[StrictBool], Field(description="Is the competitor in a current fixture?")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        latest: Annotated[Optional[StrictBool], Field(description="Is this the latest standing record ?")] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        live: Annotated[Optional[StrictBool], Field(description="Live competitor standings?")] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        sort_by: Annotated[
            Optional[StrictStr],
            Field(
                description="Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order."
            ),
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        standing_configuration_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the configuration")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        updated: Annotated[
            Optional[datetime], Field(description="Record was modified after this date/time. In UTC.")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Get a list of standings  # noqa: E501

        Return a list of available standings for a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_list_with_http_info(organization_id, season_id, sport, added, conference_id, division_id, entity_id, external, fields, fixture_type, grouping_base, grouping_conference_division, grouping_stage_pool, hide_null, in_progress, include, latest, limit, live, offset, pool_code, round_code, round_number, sort_by, stage_code, standing_configuration_id, tbf, updated, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param added: Record was added after this date/time. In UTC.
        :type added: datetime
        :param conference_id: The unique identifier of the division
        :type conference_id: str
        :param division_id: The unique identifier of the division
        :type division_id: str
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param grouping_base: Base grouping of standings row >- `OVERALL` Overall >- `ROUND` Round
        :type grouping_base: str
        :param grouping_conference_division: Conference/Division grouping of standings row >- `CONFERENCE` Conference >- `DIVISION` Division >- `OVERALL` Overall
        :type grouping_conference_division: str
        :param grouping_stage_pool: Stage/Pool grouping of standings row >- `OVERALL` Overall >- `STAGE` Stage >- `STAGEPOOL` Stage/Pool
        :type grouping_stage_pool: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param in_progress: Is the competitor in a current fixture?
        :type in_progress: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param latest: Is this the latest standing record ?
        :type latest: bool
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param live: Live competitor standings?
        :type live: bool
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param sort_by: Comma-delimited list of one or more fields to sort by, each field can have '-' as prefix to sort in descending order, and '+' (or no prefix) to sort in ascending order.
        :type sort_by: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param standing_configuration_id: The unique identifier of the configuration
        :type standing_configuration_id: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param updated: Record was modified after this date/time. In UTC.
        :type updated: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StandingsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "added",
            "conference_id",
            "division_id",
            "entity_id",
            "external",
            "fields",
            "fixture_type",
            "grouping_base",
            "grouping_conference_division",
            "grouping_stage_pool",
            "hide_null",
            "in_progress",
            "include",
            "latest",
            "limit",
            "live",
            "offset",
            "pool_code",
            "round_code",
            "round_number",
            "sort_by",
            "stage_code",
            "standing_configuration_id",
            "tbf",
            "updated",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method standing_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("added") is not None:  # noqa: E501
            _query_params.append(("added", _params["added"]))
        if _params.get("conference_id") is not None:  # noqa: E501
            _query_params.append(("conferenceId", _params["conference_id"]))
        if _params.get("division_id") is not None:  # noqa: E501
            _query_params.append(("divisionId", _params["division_id"]))
        if _params.get("entity_id") is not None:  # noqa: E501
            _query_params.append(("entityId", _params["entity_id"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"]))
        if _params.get("grouping_base") is not None:  # noqa: E501
            _query_params.append(("groupingBase", _params["grouping_base"]))
        if _params.get("grouping_conference_division") is not None:  # noqa: E501
            _query_params.append(("groupingConferenceDivision", _params["grouping_conference_division"]))
        if _params.get("grouping_stage_pool") is not None:  # noqa: E501
            _query_params.append(("groupingStagePool", _params["grouping_stage_pool"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("in_progress") is not None:  # noqa: E501
            _query_params.append(("inProgress", _params["in_progress"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("latest") is not None:  # noqa: E501
            _query_params.append(("latest", _params["latest"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("live") is not None:  # noqa: E501
            _query_params.append(("live", _params["live"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("pool_code") is not None:  # noqa: E501
            _query_params.append(("poolCode", _params["pool_code"]))
        if _params.get("round_code") is not None:  # noqa: E501
            _query_params.append(("roundCode", _params["round_code"]))
        if _params.get("round_number") is not None:  # noqa: E501
            _query_params.append(("roundNumber", _params["round_number"]))
        if _params.get("sort_by") is not None:  # noqa: E501
            _query_params.append(("sortBy", _params["sort_by"]))
        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))
        if _params.get("standing_configuration_id") is not None:  # noqa: E501
            _query_params.append(("standingConfigurationId", _params["standing_configuration_id"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("updated") is not None:  # noqa: E501
            _query_params.append(("updated", _params["updated"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "StandingsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/standings",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def standing_update(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        standing_id: Annotated[StrictStr, Field(..., description="The unique identifier of the standing record")],
        standing_put_body: StandingPutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> StandingsResponse:  # noqa: E501
        """Update a standing  # noqa: E501

        Change the information of a specific standing  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_update(organization_id, sport, standing_id, standing_put_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param standing_id: The unique identifier of the standing record (required)
        :type standing_id: str
        :param standing_put_body: (required)
        :type standing_put_body: StandingPutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StandingsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.standing_update_with_http_info(
                organization_id,
                sport,
                standing_id,
                standing_put_body,
                external,
                fields,
                hide_null,
                include,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling StandingsApi->standing_update: %s\n" % e)
            raise

    @validate_arguments
    def standing_update_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        standing_id: Annotated[StrictStr, Field(..., description="The unique identifier of the standing record")],
        standing_put_body: StandingPutBody,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Update a standing  # noqa: E501

        Change the information of a specific standing  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.standing_update_with_http_info(organization_id, sport, standing_id, standing_put_body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param standing_id: The unique identifier of the standing record (required)
        :type standing_id: str
        :param standing_put_body: (required)
        :type standing_put_body: StandingPutBody
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StandingsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "sport",
            "standing_id",
            "standing_put_body",
            "external",
            "fields",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method standing_update" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]
        if _params["standing_id"]:
            _path_params["standingId"] = _params["standing_id"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["standing_put_body"]:
            _body_params = _params["standing_put_body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "StandingsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/standings/{standingId}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
