# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import logging
import re  # noqa: F401
from datetime import datetime
from typing import Optional

from pydantic import Field, StrictBool, StrictInt, StrictStr, ValidationError, conint, constr, validate_arguments
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.season_entity_statistics_response import SeasonEntityStatisticsResponse
from atriumsports.datacore.openapi.models.season_person_statistics_periods_response import (
    SeasonPersonStatisticsPeriodsResponse,
)
from atriumsports.datacore.openapi.models.season_person_statistics_response import SeasonPersonStatisticsResponse
from atriumsports.datacore.openapi.models.season_person_total_statistics_response import (
    SeasonPersonTotalStatisticsResponse,
)

logger = logging.getLogger("openapi")


class SeasonStatisticsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def pss_list(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        person_id: Annotated[StrictStr, Field(..., description="The unique identifier of the person")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        age_group: Annotated[
            Optional[StrictStr],
            Field(
                description="The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth "
            ),
        ] = None,
        competition_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the competition")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        representation: Annotated[
            Optional[StrictStr],
            Field(
                description="What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person "
            ),
        ] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        season_type: Annotated[
            Optional[StrictStr],
            Field(
                description="The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament "
            ),
        ] = None,
        standard: Annotated[
            Optional[StrictStr],
            Field(
                description="The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship "
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonPersonStatisticsResponse:  # noqa: E501
        """Person season statistics  # noqa: E501

        Return a list of person statistics for all seasons  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.pss_list(organization_id, person_id, sport, age_group, competition_id, external, fields, fixture_type, hide_null, include, limit, offset, representation, season_id, season_type, standard, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param person_id: The unique identifier of the person (required)
        :type person_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param age_group: The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth
        :type age_group: str
        :param competition_id: The unique identifier of the competition
        :type competition_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param representation: What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person
        :type representation: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param season_type: The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament
        :type season_type: str
        :param standard: The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship
        :type standard: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonPersonStatisticsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.pss_list_with_http_info(
                organization_id,
                person_id,
                sport,
                age_group,
                competition_id,
                external,
                fields,
                fixture_type,
                hide_null,
                include,
                limit,
                offset,
                representation,
                season_id,
                season_type,
                standard,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling SeasonStatisticsApi->pss_list: %s\n" % e)
            raise

    @validate_arguments
    def pss_list_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        person_id: Annotated[StrictStr, Field(..., description="The unique identifier of the person")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        age_group: Annotated[
            Optional[StrictStr],
            Field(
                description="The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth "
            ),
        ] = None,
        competition_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the competition")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        representation: Annotated[
            Optional[StrictStr],
            Field(
                description="What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person "
            ),
        ] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        season_type: Annotated[
            Optional[StrictStr],
            Field(
                description="The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament "
            ),
        ] = None,
        standard: Annotated[
            Optional[StrictStr],
            Field(
                description="The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship "
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Person season statistics  # noqa: E501

        Return a list of person statistics for all seasons  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.pss_list_with_http_info(organization_id, person_id, sport, age_group, competition_id, external, fields, fixture_type, hide_null, include, limit, offset, representation, season_id, season_type, standard, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param person_id: The unique identifier of the person (required)
        :type person_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param age_group: The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth
        :type age_group: str
        :param competition_id: The unique identifier of the competition
        :type competition_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param representation: What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person
        :type representation: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param season_type: The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament
        :type season_type: str
        :param standard: The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship
        :type standard: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonPersonStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "person_id",
            "sport",
            "age_group",
            "competition_id",
            "external",
            "fields",
            "fixture_type",
            "hide_null",
            "include",
            "limit",
            "offset",
            "representation",
            "season_id",
            "season_type",
            "standard",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method pss_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["person_id"]:
            _path_params["personId"] = _params["person_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("age_group") is not None:  # noqa: E501
            _query_params.append(("ageGroup", _params["age_group"]))
        if _params.get("competition_id") is not None:  # noqa: E501
            _query_params.append(("competitionId", _params["competition_id"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("representation") is not None:  # noqa: E501
            _query_params.append(("representation", _params["representation"]))
        if _params.get("season_id") is not None:  # noqa: E501
            _query_params.append(("seasonId", _params["season_id"]))
        if _params.get("season_type") is not None:  # noqa: E501
            _query_params.append(("seasonType", _params["season_type"]))
        if _params.get("standard") is not None:  # noqa: E501
            _query_params.append(("standard", _params["standard"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonPersonStatisticsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/statistics/for/person/{personId}/in/seasons",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def psts_list(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        person_id: Annotated[StrictStr, Field(..., description="The unique identifier of the person")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        age_group: Annotated[
            Optional[StrictStr],
            Field(
                description="The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth "
            ),
        ] = None,
        competition_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the competition")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        representation: Annotated[
            Optional[StrictStr],
            Field(
                description="What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person "
            ),
        ] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        season_type: Annotated[
            Optional[StrictStr],
            Field(
                description="The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament "
            ),
        ] = None,
        standard: Annotated[
            Optional[StrictStr],
            Field(
                description="The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship "
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SeasonPersonTotalStatisticsResponse:  # noqa: E501
        """Person season statistics - combined teams  # noqa: E501

             Return a list of person statistic totals for a season.     If a person plays for multiple entities in a season then their statistics are normally     separated out by entity.     For this call the statistics are combined - and hence entity data is not available.       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.psts_list(organization_id, person_id, sport, age_group, competition_id, external, fields, fixture_type, hide_null, include, limit, offset, representation, season_id, season_type, standard, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param person_id: The unique identifier of the person (required)
        :type person_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param age_group: The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth
        :type age_group: str
        :param competition_id: The unique identifier of the competition
        :type competition_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param representation: What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person
        :type representation: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param season_type: The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament
        :type season_type: str
        :param standard: The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship
        :type standard: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonPersonTotalStatisticsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.psts_list_with_http_info(
                organization_id,
                person_id,
                sport,
                age_group,
                competition_id,
                external,
                fields,
                fixture_type,
                hide_null,
                include,
                limit,
                offset,
                representation,
                season_id,
                season_type,
                standard,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling SeasonStatisticsApi->psts_list: %s\n" % e)
            raise

    @validate_arguments
    def psts_list_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        person_id: Annotated[StrictStr, Field(..., description="The unique identifier of the person")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        age_group: Annotated[
            Optional[StrictStr],
            Field(
                description="The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth "
            ),
        ] = None,
        competition_id: Annotated[
            Optional[StrictStr], Field(description="The unique identifier of the competition")
        ] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        representation: Annotated[
            Optional[StrictStr],
            Field(
                description="What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person "
            ),
        ] = None,
        season_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the season")] = None,
        season_type: Annotated[
            Optional[StrictStr],
            Field(
                description="The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament "
            ),
        ] = None,
        standard: Annotated[
            Optional[StrictStr],
            Field(
                description="The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship "
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Person season statistics - combined teams  # noqa: E501

             Return a list of person statistic totals for a season.     If a person plays for multiple entities in a season then their statistics are normally     separated out by entity.     For this call the statistics are combined - and hence entity data is not available.       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.psts_list_with_http_info(organization_id, person_id, sport, age_group, competition_id, external, fields, fixture_type, hide_null, include, limit, offset, representation, season_id, season_type, standard, tbf, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param person_id: The unique identifier of the person (required)
        :type person_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param age_group: The age group of the season >- `JUNIOR` Junior >- `MASTERS` Masters >- `SENIOR` Senior >- `UNDER_15` Under 15 >- `UNDER_16` Under 16 >- `UNDER_17` Under 17 >- `UNDER_18` Under 18 >- `UNDER_19` Under 19 >- `UNDER_20` Under 20 >- `UNDER_21` Under 21 >- `UNDER_22` Under 22 >- `UNDER_23` Under 23 >- `YOUTH` Youth
        :type age_group: str
        :param competition_id: The unique identifier of the competition
        :type competition_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param representation: What level are the competitors representing >- `CLUB` Club >- `COUNTRY` Country >- `PERSON` Person
        :type representation: str
        :param season_id: The unique identifier of the season
        :type season_id: str
        :param season_type: The type of matches added to this season >- `ONE_OFF` One off match >- `SEASON` Season >- `TOURNAMENT` Tournament
        :type season_type: str
        :param standard: The playing standard of the season or entity >- `ELITE` Professional/elite organisation >- `FRIENDLY` International Friendly >- `GRASS_ROOT` Normal >- `INTERNATIONAL` International >- `NONCONTINENTAL_CHAMPIONSHIP` Non-continental Championship >- `OLYMPIC` Olympics >- `REGION` Regional >- `TIER2` lesser standard than elite >- `TIER3` lesser standard than tier 2 >- `WORLD_CHAMPIONSHIP` World Championship >- `ZONE_CHAMPIONSHIP` International Zone Championship
        :type standard: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonPersonTotalStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "person_id",
            "sport",
            "age_group",
            "competition_id",
            "external",
            "fields",
            "fixture_type",
            "hide_null",
            "include",
            "limit",
            "offset",
            "representation",
            "season_id",
            "season_type",
            "standard",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method psts_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["person_id"]:
            _path_params["personId"] = _params["person_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("age_group") is not None:  # noqa: E501
            _query_params.append(("ageGroup", _params["age_group"]))
        if _params.get("competition_id") is not None:  # noqa: E501
            _query_params.append(("competitionId", _params["competition_id"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("representation") is not None:  # noqa: E501
            _query_params.append(("representation", _params["representation"]))
        if _params.get("season_id") is not None:  # noqa: E501
            _query_params.append(("seasonId", _params["season_id"]))
        if _params.get("season_type") is not None:  # noqa: E501
            _query_params.append(("seasonType", _params["season_type"]))
        if _params.get("standard") is not None:  # noqa: E501
            _query_params.append(("standard", _params["standard"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonPersonTotalStatisticsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/statistics/for/person/{personId}/in/seasons/combined",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def ses_list(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ) -> SeasonEntityStatisticsResponse:  # noqa: E501
        """Entity statistics  # noqa: E501

        Return a list of entity statistic totals for a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ses_list(organization_id, season_id, sport, entity_id, external, fields, fixture_type, from_time_utc, hide_null, home_away, include, limit, offset, pool_code, round_code, round_number, stage_code, tbf, to_time_utc, win_loss, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonEntityStatisticsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.ses_list_with_http_info(
                organization_id,
                season_id,
                sport,
                entity_id,
                external,
                fields,
                fixture_type,
                from_time_utc,
                hide_null,
                home_away,
                include,
                limit,
                offset,
                pool_code,
                round_code,
                round_number,
                stage_code,
                tbf,
                to_time_utc,
                win_loss,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling SeasonStatisticsApi->ses_list: %s\n" % e)
            raise

    @validate_arguments
    def ses_list_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Entity statistics  # noqa: E501

        Return a list of entity statistic totals for a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ses_list_with_http_info(organization_id, season_id, sport, entity_id, external, fields, fixture_type, from_time_utc, hide_null, home_away, include, limit, offset, pool_code, round_code, round_number, stage_code, tbf, to_time_utc, win_loss, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonEntityStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "entity_id",
            "external",
            "fields",
            "fixture_type",
            "from_time_utc",
            "hide_null",
            "home_away",
            "include",
            "limit",
            "offset",
            "pool_code",
            "round_code",
            "round_number",
            "stage_code",
            "tbf",
            "to_time_utc",
            "win_loss",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method ses_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("entity_id") is not None:  # noqa: E501
            _query_params.append(("entityId", _params["entity_id"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"]))
        if _params.get("from_time_utc") is not None:  # noqa: E501
            _query_params.append(("fromTimeUTC", _params["from_time_utc"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("home_away") is not None:  # noqa: E501
            _query_params.append(("homeAway", _params["home_away"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("pool_code") is not None:  # noqa: E501
            _query_params.append(("poolCode", _params["pool_code"]))
        if _params.get("round_code") is not None:  # noqa: E501
            _query_params.append(("roundCode", _params["round_code"]))
        if _params.get("round_number") is not None:  # noqa: E501
            _query_params.append(("roundNumber", _params["round_number"]))
        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("to_time_utc") is not None:  # noqa: E501
            _query_params.append(("toTimeUTC", _params["to_time_utc"]))
        if _params.get("win_loss") is not None:  # noqa: E501
            _query_params.append(("winLoss", _params["win_loss"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonEntityStatisticsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/statistics/for/entity/in/seasons/{seasonId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def ses_listperiods(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        period_id: Annotated[Optional[StrictInt], Field(description="The identifier for the period")] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        section: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The section of the period (sub-period)")
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ) -> SeasonEntityStatisticsResponse:  # noqa: E501
        """Entity statistics by period  # noqa: E501

        Return a list of entity statistics for a season filterable by period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ses_listperiods(organization_id, season_id, sport, entity_id, external, fields, fixture_type, from_time_utc, hide_null, home_away, include, limit, offset, period_id, pool_code, round_code, round_number, section, stage_code, tbf, to_time_utc, win_loss, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param period_id: The identifier for the period
        :type period_id: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param section: The section of the period (sub-period)
        :type section: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonEntityStatisticsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.ses_listperiods_with_http_info(
                organization_id,
                season_id,
                sport,
                entity_id,
                external,
                fields,
                fixture_type,
                from_time_utc,
                hide_null,
                home_away,
                include,
                limit,
                offset,
                period_id,
                pool_code,
                round_code,
                round_number,
                section,
                stage_code,
                tbf,
                to_time_utc,
                win_loss,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling SeasonStatisticsApi->ses_listperiods: %s\n" % e)
            raise

    @validate_arguments
    def ses_listperiods_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        period_id: Annotated[Optional[StrictInt], Field(description="The identifier for the period")] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        section: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The section of the period (sub-period)")
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Entity statistics by period  # noqa: E501

        Return a list of entity statistics for a season filterable by period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ses_listperiods_with_http_info(organization_id, season_id, sport, entity_id, external, fields, fixture_type, from_time_utc, hide_null, home_away, include, limit, offset, period_id, pool_code, round_code, round_number, section, stage_code, tbf, to_time_utc, win_loss, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param period_id: The identifier for the period
        :type period_id: int
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param section: The section of the period (sub-period)
        :type section: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonEntityStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "entity_id",
            "external",
            "fields",
            "fixture_type",
            "from_time_utc",
            "hide_null",
            "home_away",
            "include",
            "limit",
            "offset",
            "period_id",
            "pool_code",
            "round_code",
            "round_number",
            "section",
            "stage_code",
            "tbf",
            "to_time_utc",
            "win_loss",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method ses_listperiods" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("entity_id") is not None:  # noqa: E501
            _query_params.append(("entityId", _params["entity_id"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"]))
        if _params.get("from_time_utc") is not None:  # noqa: E501
            _query_params.append(("fromTimeUTC", _params["from_time_utc"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("home_away") is not None:  # noqa: E501
            _query_params.append(("homeAway", _params["home_away"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("period_id") is not None:  # noqa: E501
            _query_params.append(("periodId", _params["period_id"]))
        if _params.get("pool_code") is not None:  # noqa: E501
            _query_params.append(("poolCode", _params["pool_code"]))
        if _params.get("round_code") is not None:  # noqa: E501
            _query_params.append(("roundCode", _params["round_code"]))
        if _params.get("round_number") is not None:  # noqa: E501
            _query_params.append(("roundNumber", _params["round_number"]))
        if _params.get("section") is not None:  # noqa: E501
            _query_params.append(("section", _params["section"]))
        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("to_time_utc") is not None:  # noqa: E501
            _query_params.append(("toTimeUTC", _params["to_time_utc"]))
        if _params.get("win_loss") is not None:  # noqa: E501
            _query_params.append(("winLoss", _params["win_loss"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonEntityStatisticsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/statistics/for/entity/in/seasons/{seasonId}/periods",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def sps_list(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        is_player: Annotated[Optional[StrictBool], Field(description="Is the person a player?")] = None,
        is_team_official: Annotated[Optional[StrictBool], Field(description="Is the person a entity official?")] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        starter: Annotated[Optional[StrictBool], Field(description="Is the person a starter in the fixture ?")] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ) -> SeasonPersonStatisticsResponse:  # noqa: E501
        """Season person statistics  # noqa: E501

        Return a list of person statistic totals for a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sps_list(organization_id, season_id, sport, entity_id, external, fields, fixture_type, from_time_utc, hide_null, home_away, include, is_player, is_team_official, limit, offset, person_id, pool_code, round_code, round_number, stage_code, starter, tbf, to_time_utc, win_loss, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param is_player: Is the person a player?
        :type is_player: bool
        :param is_team_official: Is the person a entity official?
        :type is_team_official: bool
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param starter: Is the person a starter in the fixture ?
        :type starter: bool
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonPersonStatisticsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.sps_list_with_http_info(
                organization_id,
                season_id,
                sport,
                entity_id,
                external,
                fields,
                fixture_type,
                from_time_utc,
                hide_null,
                home_away,
                include,
                is_player,
                is_team_official,
                limit,
                offset,
                person_id,
                pool_code,
                round_code,
                round_number,
                stage_code,
                starter,
                tbf,
                to_time_utc,
                win_loss,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling SeasonStatisticsApi->sps_list: %s\n" % e)
            raise

    @validate_arguments
    def sps_list_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        is_player: Annotated[Optional[StrictBool], Field(description="Is the person a player?")] = None,
        is_team_official: Annotated[Optional[StrictBool], Field(description="Is the person a entity official?")] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        starter: Annotated[Optional[StrictBool], Field(description="Is the person a starter in the fixture ?")] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Season person statistics  # noqa: E501

        Return a list of person statistic totals for a season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sps_list_with_http_info(organization_id, season_id, sport, entity_id, external, fields, fixture_type, from_time_utc, hide_null, home_away, include, is_player, is_team_official, limit, offset, person_id, pool_code, round_code, round_number, stage_code, starter, tbf, to_time_utc, win_loss, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param is_player: Is the person a player?
        :type is_player: bool
        :param is_team_official: Is the person a entity official?
        :type is_team_official: bool
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param starter: Is the person a starter in the fixture ?
        :type starter: bool
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonPersonStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "entity_id",
            "external",
            "fields",
            "fixture_type",
            "from_time_utc",
            "hide_null",
            "home_away",
            "include",
            "is_player",
            "is_team_official",
            "limit",
            "offset",
            "person_id",
            "pool_code",
            "round_code",
            "round_number",
            "stage_code",
            "starter",
            "tbf",
            "to_time_utc",
            "win_loss",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method sps_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("entity_id") is not None:  # noqa: E501
            _query_params.append(("entityId", _params["entity_id"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"]))
        if _params.get("from_time_utc") is not None:  # noqa: E501
            _query_params.append(("fromTimeUTC", _params["from_time_utc"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("home_away") is not None:  # noqa: E501
            _query_params.append(("homeAway", _params["home_away"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("is_player") is not None:  # noqa: E501
            _query_params.append(("isPlayer", _params["is_player"]))
        if _params.get("is_team_official") is not None:  # noqa: E501
            _query_params.append(("isTeamOfficial", _params["is_team_official"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("person_id") is not None:  # noqa: E501
            _query_params.append(("personId", _params["person_id"]))
        if _params.get("pool_code") is not None:  # noqa: E501
            _query_params.append(("poolCode", _params["pool_code"]))
        if _params.get("round_code") is not None:  # noqa: E501
            _query_params.append(("roundCode", _params["round_code"]))
        if _params.get("round_number") is not None:  # noqa: E501
            _query_params.append(("roundNumber", _params["round_number"]))
        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))
        if _params.get("starter") is not None:  # noqa: E501
            _query_params.append(("starter", _params["starter"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("to_time_utc") is not None:  # noqa: E501
            _query_params.append(("toTimeUTC", _params["to_time_utc"]))
        if _params.get("win_loss") is not None:  # noqa: E501
            _query_params.append(("winLoss", _params["win_loss"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonPersonStatisticsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/statistics/for/person/in/seasons/{seasonId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def spsp_listperiods(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        is_player: Annotated[Optional[StrictBool], Field(description="Is the person a player?")] = None,
        is_team_official: Annotated[Optional[StrictBool], Field(description="Is the person a entity official?")] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        period_id: Annotated[Optional[StrictInt], Field(description="The identifier for the period")] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        section: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The section of the period (sub-period)")
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        starter: Annotated[Optional[StrictBool], Field(description="Is the person a starter in the fixture ?")] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ) -> SeasonPersonStatisticsPeriodsResponse:  # noqa: E501
        """Person season statistics by period  # noqa: E501

        Return a list of person statistics for a season broken down and filterable by period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.spsp_listperiods(organization_id, season_id, sport, entity_id, external, fields, fixture_type, from_time_local, from_time_utc, hide_null, home_away, include, is_player, is_team_official, limit, offset, period_id, person_id, pool_code, round_code, round_number, section, stage_code, starter, tbf, to_time_local, to_time_utc, win_loss, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param is_player: Is the person a player?
        :type is_player: bool
        :param is_team_official: Is the person a entity official?
        :type is_team_official: bool
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param period_id: The identifier for the period
        :type period_id: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param section: The section of the period (sub-period)
        :type section: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param starter: Is the person a starter in the fixture ?
        :type starter: bool
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonPersonStatisticsPeriodsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.spsp_listperiods_with_http_info(
                organization_id,
                season_id,
                sport,
                entity_id,
                external,
                fields,
                fixture_type,
                from_time_local,
                from_time_utc,
                hide_null,
                home_away,
                include,
                is_player,
                is_team_official,
                limit,
                offset,
                period_id,
                person_id,
                pool_code,
                round_code,
                round_number,
                section,
                stage_code,
                starter,
                tbf,
                to_time_local,
                to_time_utc,
                win_loss,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling SeasonStatisticsApi->spsp_listperiods: %s\n" % e)
            raise

    @validate_arguments
    def spsp_listperiods_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        is_player: Annotated[Optional[StrictBool], Field(description="Is the person a player?")] = None,
        is_team_official: Annotated[Optional[StrictBool], Field(description="Is the person a entity official?")] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        period_id: Annotated[Optional[StrictInt], Field(description="The identifier for the period")] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        section: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The section of the period (sub-period)")
        ] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        starter: Annotated[Optional[StrictBool], Field(description="Is the person a starter in the fixture ?")] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Person season statistics by period  # noqa: E501

        Return a list of person statistics for a season broken down and filterable by period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.spsp_listperiods_with_http_info(organization_id, season_id, sport, entity_id, external, fields, fixture_type, from_time_local, from_time_utc, hide_null, home_away, include, is_player, is_team_official, limit, offset, period_id, person_id, pool_code, round_code, round_number, section, stage_code, starter, tbf, to_time_local, to_time_utc, win_loss, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param is_player: Is the person a player?
        :type is_player: bool
        :param is_team_official: Is the person a entity official?
        :type is_team_official: bool
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param period_id: The identifier for the period
        :type period_id: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param section: The section of the period (sub-period)
        :type section: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param starter: Is the person a starter in the fixture ?
        :type starter: bool
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonPersonStatisticsPeriodsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "entity_id",
            "external",
            "fields",
            "fixture_type",
            "from_time_local",
            "from_time_utc",
            "hide_null",
            "home_away",
            "include",
            "is_player",
            "is_team_official",
            "limit",
            "offset",
            "period_id",
            "person_id",
            "pool_code",
            "round_code",
            "round_number",
            "section",
            "stage_code",
            "starter",
            "tbf",
            "to_time_local",
            "to_time_utc",
            "win_loss",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method spsp_listperiods" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("entity_id") is not None:  # noqa: E501
            _query_params.append(("entityId", _params["entity_id"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"]))
        if _params.get("from_time_local") is not None:  # noqa: E501
            _query_params.append(("fromTimeLocal", _params["from_time_local"]))
        if _params.get("from_time_utc") is not None:  # noqa: E501
            _query_params.append(("fromTimeUTC", _params["from_time_utc"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("home_away") is not None:  # noqa: E501
            _query_params.append(("homeAway", _params["home_away"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("is_player") is not None:  # noqa: E501
            _query_params.append(("isPlayer", _params["is_player"]))
        if _params.get("is_team_official") is not None:  # noqa: E501
            _query_params.append(("isTeamOfficial", _params["is_team_official"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("period_id") is not None:  # noqa: E501
            _query_params.append(("periodId", _params["period_id"]))
        if _params.get("person_id") is not None:  # noqa: E501
            _query_params.append(("personId", _params["person_id"]))
        if _params.get("pool_code") is not None:  # noqa: E501
            _query_params.append(("poolCode", _params["pool_code"]))
        if _params.get("round_code") is not None:  # noqa: E501
            _query_params.append(("roundCode", _params["round_code"]))
        if _params.get("round_number") is not None:  # noqa: E501
            _query_params.append(("roundNumber", _params["round_number"]))
        if _params.get("section") is not None:  # noqa: E501
            _query_params.append(("section", _params["section"]))
        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))
        if _params.get("starter") is not None:  # noqa: E501
            _query_params.append(("starter", _params["starter"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("to_time_local") is not None:  # noqa: E501
            _query_params.append(("toTimeLocal", _params["to_time_local"]))
        if _params.get("to_time_utc") is not None:  # noqa: E501
            _query_params.append(("toTimeUTC", _params["to_time_utc"]))
        if _params.get("win_loss") is not None:  # noqa: E501
            _query_params.append(("winLoss", _params["win_loss"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonPersonStatisticsPeriodsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/statistics/for/person/in/seasons/{seasonId}/periods",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def spts_list(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        is_player: Annotated[Optional[StrictBool], Field(description="Is the person a player?")] = None,
        is_team_official: Annotated[Optional[StrictBool], Field(description="Is the person a entity official?")] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        starter: Annotated[Optional[StrictBool], Field(description="Is the person a starter in the fixture ?")] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ) -> SeasonPersonTotalStatisticsResponse:  # noqa: E501
        """Person season statistics - combined teams  # noqa: E501

             Return a list of person statistic totals for a person over multiple seasons.     If a person plays for multiple entities in a season then their statistics are normally separated     out by entity. For this call the statistics are combined - and hence entity data is not available.       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.spts_list(organization_id, season_id, sport, entity_id, external, fields, fixture_type, from_time_local, from_time_utc, hide_null, home_away, include, is_player, is_team_official, limit, offset, person_id, pool_code, round_code, round_number, stage_code, starter, tbf, to_time_local, to_time_utc, win_loss, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param is_player: Is the person a player?
        :type is_player: bool
        :param is_team_official: Is the person a entity official?
        :type is_team_official: bool
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param starter: Is the person a starter in the fixture ?
        :type starter: bool
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SeasonPersonTotalStatisticsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.spts_list_with_http_info(
                organization_id,
                season_id,
                sport,
                entity_id,
                external,
                fields,
                fixture_type,
                from_time_local,
                from_time_utc,
                hide_null,
                home_away,
                include,
                is_player,
                is_team_official,
                limit,
                offset,
                person_id,
                pool_code,
                round_code,
                round_number,
                stage_code,
                starter,
                tbf,
                to_time_local,
                to_time_utc,
                win_loss,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling SeasonStatisticsApi->spts_list: %s\n" % e)
            raise

    @validate_arguments
    def spts_list_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        from_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) >= this value")
        ] = None,
        from_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) >= this value")
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        is_player: Annotated[Optional[StrictBool], Field(description="Is the person a player?")] = None,
        is_team_official: Annotated[Optional[StrictBool], Field(description="Is the person a entity official?")] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        person_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the person")] = None,
        pool_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The pool identifier within a season")
        ] = None,
        round_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The round identifier within a season")
        ] = None,
        round_number: Annotated[Optional[constr(strict=True, max_length=30)], Field(description="Round number")] = None,
        stage_code: Annotated[
            Optional[constr(strict=True, max_length=30)], Field(description="The stage identifier within a season")
        ] = None,
        starter: Annotated[Optional[StrictBool], Field(description="Is the person a starter in the fixture ?")] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        to_time_local: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in local time) <= this value")
        ] = None,
        to_time_utc: Annotated[
            Optional[datetime], Field(description="Where fixture start time (in UTC) <= this value")
        ] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Person season statistics - combined teams  # noqa: E501

             Return a list of person statistic totals for a person over multiple seasons.     If a person plays for multiple entities in a season then their statistics are normally separated     out by entity. For this call the statistics are combined - and hence entity data is not available.       # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.spts_list_with_http_info(organization_id, season_id, sport, entity_id, external, fields, fixture_type, from_time_local, from_time_utc, hide_null, home_away, include, is_player, is_team_official, limit, offset, person_id, pool_code, round_code, round_number, stage_code, starter, tbf, to_time_local, to_time_utc, win_loss, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param from_time_local: Where fixture start time (in local time) >= this value
        :type from_time_local: datetime
        :param from_time_utc: Where fixture start time (in UTC) >= this value
        :type from_time_utc: datetime
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param is_player: Is the person a player?
        :type is_player: bool
        :param is_team_official: Is the person a entity official?
        :type is_team_official: bool
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param person_id: The unique identifier of the person
        :type person_id: str
        :param pool_code: The pool identifier within a season
        :type pool_code: str
        :param round_code: The round identifier within a season
        :type round_code: str
        :param round_number: Round number
        :type round_number: str
        :param stage_code: The stage identifier within a season
        :type stage_code: str
        :param starter: Is the person a starter in the fixture ?
        :type starter: bool
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param to_time_local: Where fixture start time (in local time) <= this value
        :type to_time_local: datetime
        :param to_time_utc: Where fixture start time (in UTC) <= this value
        :type to_time_utc: datetime
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SeasonPersonTotalStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "organization_id",
            "season_id",
            "sport",
            "entity_id",
            "external",
            "fields",
            "fixture_type",
            "from_time_local",
            "from_time_utc",
            "hide_null",
            "home_away",
            "include",
            "is_player",
            "is_team_official",
            "limit",
            "offset",
            "person_id",
            "pool_code",
            "round_code",
            "round_number",
            "stage_code",
            "starter",
            "tbf",
            "to_time_local",
            "to_time_utc",
            "win_loss",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method spts_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("entity_id") is not None:  # noqa: E501
            _query_params.append(("entityId", _params["entity_id"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"]))
        if _params.get("from_time_local") is not None:  # noqa: E501
            _query_params.append(("fromTimeLocal", _params["from_time_local"]))
        if _params.get("from_time_utc") is not None:  # noqa: E501
            _query_params.append(("fromTimeUTC", _params["from_time_utc"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("home_away") is not None:  # noqa: E501
            _query_params.append(("homeAway", _params["home_away"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("is_player") is not None:  # noqa: E501
            _query_params.append(("isPlayer", _params["is_player"]))
        if _params.get("is_team_official") is not None:  # noqa: E501
            _query_params.append(("isTeamOfficial", _params["is_team_official"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("person_id") is not None:  # noqa: E501
            _query_params.append(("personId", _params["person_id"]))
        if _params.get("pool_code") is not None:  # noqa: E501
            _query_params.append(("poolCode", _params["pool_code"]))
        if _params.get("round_code") is not None:  # noqa: E501
            _query_params.append(("roundCode", _params["round_code"]))
        if _params.get("round_number") is not None:  # noqa: E501
            _query_params.append(("roundNumber", _params["round_number"]))
        if _params.get("stage_code") is not None:  # noqa: E501
            _query_params.append(("stageCode", _params["stage_code"]))
        if _params.get("starter") is not None:  # noqa: E501
            _query_params.append(("starter", _params["starter"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("to_time_local") is not None:  # noqa: E501
            _query_params.append(("toTimeLocal", _params["to_time_local"]))
        if _params.get("to_time_utc") is not None:  # noqa: E501
            _query_params.append(("toTimeUTC", _params["to_time_utc"]))
        if _params.get("win_loss") is not None:  # noqa: E501
            _query_params.append(("winLoss", _params["win_loss"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SeasonPersonTotalStatisticsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/statistics/for/person/in/seasons/{seasonId}/combined",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
