# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import logging
import re  # noqa: F401
from typing import Dict

from pydantic import Field, StrictStr, ValidationError, constr, validate_arguments
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.blank_model_response import BlankModelResponse

logger = logging.getLogger("openapi")


class PartnerAPIsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def partners_delete(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        partner: Annotated[StrictStr, Field(..., description="Partner for partner integrations")],
        pathsubpath: Annotated[StrictStr, Field(..., description="Subpath for partner integrations")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Dict[str, StrictStr],
        **kwargs
    ) -> BlankModelResponse:  # noqa: E501
        """Call a partner API DELETE service  # noqa: E501

        For detail check the documentation for the specific partner type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.partners_delete(organization_id, partner, pathsubpath, sport, body, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param partner: Partner for partner integrations (required)
        :type partner: str
        :param pathsubpath: Subpath for partner integrations (required)
        :type pathsubpath: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BlankModelResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.partners_delete_with_http_info(
                organization_id, partner, pathsubpath, sport, body, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling PartnerAPIsApi->partners_delete: %s\n" % e)
            raise

    @validate_arguments
    def partners_delete_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        partner: Annotated[StrictStr, Field(..., description="Partner for partner integrations")],
        pathsubpath: Annotated[StrictStr, Field(..., description="Subpath for partner integrations")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Dict[str, StrictStr],
        **kwargs
    ):  # noqa: E501
        """Call a partner API DELETE service  # noqa: E501

        For detail check the documentation for the specific partner type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.partners_delete_with_http_info(organization_id, partner, pathsubpath, sport, body, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param partner: Partner for partner integrations (required)
        :type partner: str
        :param pathsubpath: Subpath for partner integrations (required)
        :type pathsubpath: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BlankModelResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["organization_id", "partner", "pathsubpath", "sport", "body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method partners_delete" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["partner"]:
            _path_params["partner"] = _params["partner"]
        if _params["pathsubpath"]:
            _path_params["path:subpath"] = _params["pathsubpath"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["body"]:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "BlankModelResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/partners/{partner}/{path:subpath}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def partners_get(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        partner: Annotated[StrictStr, Field(..., description="Partner for partner integrations")],
        pathsubpath: Annotated[StrictStr, Field(..., description="Subpath for partner integrations")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Dict[str, StrictStr],
        **kwargs
    ) -> BlankModelResponse:  # noqa: E501
        """Call a partner API GET service  # noqa: E501

        For detail check the documentation for the specific partner type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.partners_get(organization_id, partner, pathsubpath, sport, body, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param partner: Partner for partner integrations (required)
        :type partner: str
        :param pathsubpath: Subpath for partner integrations (required)
        :type pathsubpath: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BlankModelResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.partners_get_with_http_info(
                organization_id, partner, pathsubpath, sport, body, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling PartnerAPIsApi->partners_get: %s\n" % e)
            raise

    @validate_arguments
    def partners_get_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        partner: Annotated[StrictStr, Field(..., description="Partner for partner integrations")],
        pathsubpath: Annotated[StrictStr, Field(..., description="Subpath for partner integrations")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Dict[str, StrictStr],
        **kwargs
    ):  # noqa: E501
        """Call a partner API GET service  # noqa: E501

        For detail check the documentation for the specific partner type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.partners_get_with_http_info(organization_id, partner, pathsubpath, sport, body, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param partner: Partner for partner integrations (required)
        :type partner: str
        :param pathsubpath: Subpath for partner integrations (required)
        :type pathsubpath: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BlankModelResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["organization_id", "partner", "pathsubpath", "sport", "body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method partners_get" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["partner"]:
            _path_params["partner"] = _params["partner"]
        if _params["pathsubpath"]:
            _path_params["path:subpath"] = _params["pathsubpath"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["body"]:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "BlankModelResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/partners/{partner}/{path:subpath}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def partners_post(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        partner: Annotated[StrictStr, Field(..., description="Partner for partner integrations")],
        pathsubpath: Annotated[StrictStr, Field(..., description="Subpath for partner integrations")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Dict[str, StrictStr],
        **kwargs
    ) -> BlankModelResponse:  # noqa: E501
        """Call a partner API POST service  # noqa: E501

        For detail check the documentation for the specific partner type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.partners_post(organization_id, partner, pathsubpath, sport, body, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param partner: Partner for partner integrations (required)
        :type partner: str
        :param pathsubpath: Subpath for partner integrations (required)
        :type pathsubpath: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BlankModelResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.partners_post_with_http_info(
                organization_id, partner, pathsubpath, sport, body, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling PartnerAPIsApi->partners_post: %s\n" % e)
            raise

    @validate_arguments
    def partners_post_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        partner: Annotated[StrictStr, Field(..., description="Partner for partner integrations")],
        pathsubpath: Annotated[StrictStr, Field(..., description="Subpath for partner integrations")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Dict[str, StrictStr],
        **kwargs
    ):  # noqa: E501
        """Call a partner API POST service  # noqa: E501

        For detail check the documentation for the specific partner type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.partners_post_with_http_info(organization_id, partner, pathsubpath, sport, body, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param partner: Partner for partner integrations (required)
        :type partner: str
        :param pathsubpath: Subpath for partner integrations (required)
        :type pathsubpath: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BlankModelResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["organization_id", "partner", "pathsubpath", "sport", "body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method partners_post" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["partner"]:
            _path_params["partner"] = _params["partner"]
        if _params["pathsubpath"]:
            _path_params["path:subpath"] = _params["pathsubpath"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["body"]:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "BlankModelResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/partners/{partner}/{path:subpath}",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def partners_put(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        partner: Annotated[StrictStr, Field(..., description="Partner for partner integrations")],
        pathsubpath: Annotated[StrictStr, Field(..., description="Subpath for partner integrations")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Dict[str, StrictStr],
        **kwargs
    ) -> BlankModelResponse:  # noqa: E501
        """Call a partner API PUT service  # noqa: E501

        For detail check the documentation for the specific partner type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.partners_put(organization_id, partner, pathsubpath, sport, body, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param partner: Partner for partner integrations (required)
        :type partner: str
        :param pathsubpath: Subpath for partner integrations (required)
        :type pathsubpath: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BlankModelResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.partners_put_with_http_info(
                organization_id, partner, pathsubpath, sport, body, **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling PartnerAPIsApi->partners_put: %s\n" % e)
            raise

    @validate_arguments
    def partners_put_with_http_info(
        self,
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        partner: Annotated[StrictStr, Field(..., description="Partner for partner integrations")],
        pathsubpath: Annotated[StrictStr, Field(..., description="Subpath for partner integrations")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        body: Dict[str, StrictStr],
        **kwargs
    ):  # noqa: E501
        """Call a partner API PUT service  # noqa: E501

        For detail check the documentation for the specific partner type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.partners_put_with_http_info(organization_id, partner, pathsubpath, sport, body, async_req=True)
        >>> result = thread.get()

        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param partner: Partner for partner integrations (required)
        :type partner: str
        :param pathsubpath: Subpath for partner integrations (required)
        :type pathsubpath: str
        :param sport: Sport name (required)
        :type sport: str
        :param body: (required)
        :type body: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BlankModelResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["organization_id", "partner", "pathsubpath", "sport", "body"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method partners_put" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["partner"]:
            _path_params["partner"] = _params["partner"]
        if _params["pathsubpath"]:
            _path_params["path:subpath"] = _params["pathsubpath"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["body"]:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "BlankModelResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/partners/{partner}/{path:subpath}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
