# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import logging
import re  # noqa: F401
from typing import Dict, Optional

from pydantic import Field, StrictBool, StrictStr, ValidationError, constr, validate_arguments
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.success_response import SuccessResponse

logger = logging.getLogger("openapi")


class MergeRecordsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def entity_merge(
        self,
        from_entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'from' record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        to_entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'to' record")],
        body: Dict[str, StrictStr],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Merge two entity records  # noqa: E501

        Merge the records of two entities  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.entity_merge(from_entity_id, organization_id, sport, to_entity_id, body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param from_entity_id: The unique identifier of the 'from' record (required)
        :type from_entity_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param to_entity_id: The unique identifier of the 'to' record (required)
        :type to_entity_id: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.entity_merge_with_http_info(
                from_entity_id,
                organization_id,
                sport,
                to_entity_id,
                body,
                external,
                fields,
                hide_null,
                include,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling MergeRecordsApi->entity_merge: %s\n" % e)
            raise

    @validate_arguments
    def entity_merge_with_http_info(
        self,
        from_entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'from' record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        to_entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'to' record")],
        body: Dict[str, StrictStr],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Merge two entity records  # noqa: E501

        Merge the records of two entities  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.entity_merge_with_http_info(from_entity_id, organization_id, sport, to_entity_id, body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param from_entity_id: The unique identifier of the 'from' record (required)
        :type from_entity_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param to_entity_id: The unique identifier of the 'to' record (required)
        :type to_entity_id: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "from_entity_id",
            "organization_id",
            "sport",
            "to_entity_id",
            "body",
            "external",
            "fields",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method entity_merge" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["from_entity_id"]:
            _path_params["fromEntityId"] = _params["from_entity_id"]
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]
        if _params["to_entity_id"]:
            _path_params["toEntityId"] = _params["to_entity_id"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["body"]:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/entities/merge/from/{fromEntityId}/to/{toEntityId}",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def entity_swap(
        self,
        from_entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'from' record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        to_entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'to' record")],
        body: Dict[str, StrictStr],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """For a given season, swap two entity records  # noqa: E501

        For a given season, swap the records of two entities  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.entity_swap(from_entity_id, organization_id, season_id, sport, to_entity_id, body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param from_entity_id: The unique identifier of the 'from' record (required)
        :type from_entity_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param to_entity_id: The unique identifier of the 'to' record (required)
        :type to_entity_id: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.entity_swap_with_http_info(
                from_entity_id,
                organization_id,
                season_id,
                sport,
                to_entity_id,
                body,
                external,
                fields,
                hide_null,
                include,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling MergeRecordsApi->entity_swap: %s\n" % e)
            raise

    @validate_arguments
    def entity_swap_with_http_info(
        self,
        from_entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'from' record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        to_entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'to' record")],
        body: Dict[str, StrictStr],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """For a given season, swap two entity records  # noqa: E501

        For a given season, swap the records of two entities  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.entity_swap_with_http_info(from_entity_id, organization_id, season_id, sport, to_entity_id, body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param from_entity_id: The unique identifier of the 'from' record (required)
        :type from_entity_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param to_entity_id: The unique identifier of the 'to' record (required)
        :type to_entity_id: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "from_entity_id",
            "organization_id",
            "season_id",
            "sport",
            "to_entity_id",
            "body",
            "external",
            "fields",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method entity_swap" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["from_entity_id"]:
            _path_params["fromEntityId"] = _params["from_entity_id"]
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]
        if _params["to_entity_id"]:
            _path_params["toEntityId"] = _params["to_entity_id"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["body"]:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/entities/swap/from/{fromEntityId}/to/{toEntityId}",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def person_merge(
        self,
        from_person_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'from' record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        to_person_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'to' record")],
        body: Dict[str, StrictStr],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Merge two person records  # noqa: E501

        Merge the records of two persons  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_merge(from_person_id, organization_id, sport, to_person_id, body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param from_person_id: The unique identifier of the 'from' record (required)
        :type from_person_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param to_person_id: The unique identifier of the 'to' record (required)
        :type to_person_id: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.person_merge_with_http_info(
                from_person_id,
                organization_id,
                sport,
                to_person_id,
                body,
                external,
                fields,
                hide_null,
                include,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling MergeRecordsApi->person_merge: %s\n" % e)
            raise

    @validate_arguments
    def person_merge_with_http_info(
        self,
        from_person_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'from' record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        to_person_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'to' record")],
        body: Dict[str, StrictStr],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Merge two person records  # noqa: E501

        Merge the records of two persons  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_merge_with_http_info(from_person_id, organization_id, sport, to_person_id, body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param from_person_id: The unique identifier of the 'from' record (required)
        :type from_person_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param to_person_id: The unique identifier of the 'to' record (required)
        :type to_person_id: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "from_person_id",
            "organization_id",
            "sport",
            "to_person_id",
            "body",
            "external",
            "fields",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method person_merge" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["from_person_id"]:
            _path_params["fromPersonId"] = _params["from_person_id"]
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]
        if _params["to_person_id"]:
            _path_params["toPersonId"] = _params["to_person_id"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["body"]:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/persons/merge/from/{fromPersonId}/to/{toPersonId}",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def person_swap(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        from_person_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'from' record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        to_person_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'to' record")],
        body: Dict[str, StrictStr],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """For a given fixture, swap two person records  # noqa: E501

        For a given fixture, swap the records of two persons  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_swap(fixture_id, from_person_id, organization_id, sport, to_person_id, body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param from_person_id: The unique identifier of the 'from' record (required)
        :type from_person_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param to_person_id: The unique identifier of the 'to' record (required)
        :type to_person_id: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.person_swap_with_http_info(
                fixture_id,
                from_person_id,
                organization_id,
                sport,
                to_person_id,
                body,
                external,
                fields,
                hide_null,
                include,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling MergeRecordsApi->person_swap: %s\n" % e)
            raise

    @validate_arguments
    def person_swap_with_http_info(
        self,
        fixture_id: Annotated[StrictStr, Field(..., description="The unique identifier of the fixture")],
        from_person_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'from' record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        to_person_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'to' record")],
        body: Dict[str, StrictStr],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """For a given fixture, swap two person records  # noqa: E501

        For a given fixture, swap the records of two persons  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.person_swap_with_http_info(fixture_id, from_person_id, organization_id, sport, to_person_id, body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param fixture_id: The unique identifier of the fixture (required)
        :type fixture_id: str
        :param from_person_id: The unique identifier of the 'from' record (required)
        :type from_person_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param to_person_id: The unique identifier of the 'to' record (required)
        :type to_person_id: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "fixture_id",
            "from_person_id",
            "organization_id",
            "sport",
            "to_person_id",
            "body",
            "external",
            "fields",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method person_swap" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["fixture_id"]:
            _path_params["fixtureId"] = _params["fixture_id"]
        if _params["from_person_id"]:
            _path_params["fromPersonId"] = _params["from_person_id"]
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]
        if _params["to_person_id"]:
            _path_params["toPersonId"] = _params["to_person_id"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["body"]:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/fixtures/{fixtureId}/persons/swap/from/{fromPersonId}/to/{toPersonId}",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def season_move(
        self,
        from_competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'from' record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        to_competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'to' record")],
        body: Dict[str, StrictStr],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ) -> SuccessResponse:  # noqa: E501
        """Move a season to a different competition  # noqa: E501

        Move a season under a different competition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_move(from_competition_id, organization_id, season_id, sport, to_competition_id, body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param from_competition_id: The unique identifier of the 'from' record (required)
        :type from_competition_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param to_competition_id: The unique identifier of the 'to' record (required)
        :type to_competition_id: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.season_move_with_http_info(
                from_competition_id,
                organization_id,
                season_id,
                sport,
                to_competition_id,
                body,
                external,
                fields,
                hide_null,
                include,
                tbf,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling MergeRecordsApi->season_move: %s\n" % e)
            raise

    @validate_arguments
    def season_move_with_http_info(
        self,
        from_competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'from' record")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        season_id: Annotated[StrictStr, Field(..., description="The unique identifier of the season")],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        to_competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the 'to' record")],
        body: Dict[str, StrictStr],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        **kwargs
    ):  # noqa: E501
        """Move a season to a different competition  # noqa: E501

        Move a season under a different competition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.season_move_with_http_info(from_competition_id, organization_id, season_id, sport, to_competition_id, body, external, fields, hide_null, include, tbf, async_req=True)
        >>> result = thread.get()

        :param from_competition_id: The unique identifier of the 'from' record (required)
        :type from_competition_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param season_id: The unique identifier of the season (required)
        :type season_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param to_competition_id: The unique identifier of the 'to' record (required)
        :type to_competition_id: str
        :param body: (required)
        :type body: object
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "from_competition_id",
            "organization_id",
            "season_id",
            "sport",
            "to_competition_id",
            "body",
            "external",
            "fields",
            "hide_null",
            "include",
            "tbf",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method season_move" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["from_competition_id"]:
            _path_params["fromCompetitionId"] = _params["from_competition_id"]
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["season_id"]:
            _path_params["seasonId"] = _params["season_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]
        if _params["to_competition_id"]:
            _path_params["toCompetitionId"] = _params["to_competition_id"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["body"]:
            _body_params = _params["body"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type", self.api_client.select_header_content_type(["application/json"])
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "SuccessResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/seasons/{seasonId}/move/from/competitions/{fromCompetitionId}/to/competitions/{toCompetitionId}",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
