# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import logging
import re  # noqa: F401
from typing import Optional

from pydantic import Field, StrictBool, StrictInt, StrictStr, ValidationError, conint, constr, validate_arguments
from typing_extensions import Annotated

from atriumsports.datacore.openapi.api_client import ApiClient
from atriumsports.datacore.openapi.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from atriumsports.datacore.openapi.models.competition_entity_statistics_response import (
    CompetitionEntityStatisticsResponse,
)

logger = logging.getLogger("openapi")


class CompetitionStatisticsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def ces_list(
        self,
        competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the competition")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ) -> CompetitionEntityStatisticsResponse:  # noqa: E501
        """Entity statistics for a competition  # noqa: E501

        Return a list of entity statistic totals for a competition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ces_list(competition_id, organization_id, sport, entity_id, external, fields, fixture_type, hide_null, home_away, include, limit, offset, tbf, win_loss, async_req=True)
        >>> result = thread.get()

        :param competition_id: The unique identifier of the competition (required)
        :type competition_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CompetitionEntityStatisticsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.ces_list_with_http_info(
                competition_id,
                organization_id,
                sport,
                entity_id,
                external,
                fields,
                fixture_type,
                hide_null,
                home_away,
                include,
                limit,
                offset,
                tbf,
                win_loss,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling CompetitionStatisticsApi->ces_list: %s\n" % e)
            raise

    @validate_arguments
    def ces_list_with_http_info(
        self,
        competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the competition")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        entity_id: Annotated[Optional[StrictStr], Field(description="The unique identifier of the entity")] = None,
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Entity statistics for a competition  # noqa: E501

        Return a list of entity statistic totals for a competition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ces_list_with_http_info(competition_id, organization_id, sport, entity_id, external, fields, fixture_type, hide_null, home_away, include, limit, offset, tbf, win_loss, async_req=True)
        >>> result = thread.get()

        :param competition_id: The unique identifier of the competition (required)
        :type competition_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param entity_id: The unique identifier of the entity
        :type entity_id: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CompetitionEntityStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "competition_id",
            "organization_id",
            "sport",
            "entity_id",
            "external",
            "fields",
            "fixture_type",
            "hide_null",
            "home_away",
            "include",
            "limit",
            "offset",
            "tbf",
            "win_loss",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method ces_list" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["competition_id"]:
            _path_params["competitionId"] = _params["competition_id"]
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("entity_id") is not None:  # noqa: E501
            _query_params.append(("entityId", _params["entity_id"]))
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("home_away") is not None:  # noqa: E501
            _query_params.append(("homeAway", _params["home_away"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("win_loss") is not None:  # noqa: E501
            _query_params.append(("winLoss", _params["win_loss"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "CompetitionEntityStatisticsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/statistics/for/entity/in/competitions/{competitionId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def ces_listentity(
        self,
        competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the competition")],
        entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the entity")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        section: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The section of the period (sub-period)")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ) -> CompetitionEntityStatisticsResponse:  # noqa: E501
        """Statistics for an entity in a competition  # noqa: E501

        Return the statistic totals for a specific entity in a competition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ces_listentity(competition_id, entity_id, organization_id, sport, external, fields, fixture_type, hide_null, home_away, include, limit, offset, section, tbf, win_loss, async_req=True)
        >>> result = thread.get()

        :param competition_id: The unique identifier of the competition (required)
        :type competition_id: str
        :param entity_id: The unique identifier of the entity (required)
        :type entity_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param section: The section of the period (sub-period)
        :type section: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CompetitionEntityStatisticsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.ces_listentity_with_http_info(
                competition_id,
                entity_id,
                organization_id,
                sport,
                external,
                fields,
                fixture_type,
                hide_null,
                home_away,
                include,
                limit,
                offset,
                section,
                tbf,
                win_loss,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling CompetitionStatisticsApi->ces_listentity: %s\n" % e)
            raise

    @validate_arguments
    def ces_listentity_with_http_info(
        self,
        competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the competition")],
        entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the entity")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        section: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The section of the period (sub-period)")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Statistics for an entity in a competition  # noqa: E501

        Return the statistic totals for a specific entity in a competition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ces_listentity_with_http_info(competition_id, entity_id, organization_id, sport, external, fields, fixture_type, hide_null, home_away, include, limit, offset, section, tbf, win_loss, async_req=True)
        >>> result = thread.get()

        :param competition_id: The unique identifier of the competition (required)
        :type competition_id: str
        :param entity_id: The unique identifier of the entity (required)
        :type entity_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param section: The section of the period (sub-period)
        :type section: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CompetitionEntityStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "competition_id",
            "entity_id",
            "organization_id",
            "sport",
            "external",
            "fields",
            "fixture_type",
            "hide_null",
            "home_away",
            "include",
            "limit",
            "offset",
            "section",
            "tbf",
            "win_loss",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method ces_listentity" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["competition_id"]:
            _path_params["competitionId"] = _params["competition_id"]
        if _params["entity_id"]:
            _path_params["entityId"] = _params["entity_id"]
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("home_away") is not None:  # noqa: E501
            _query_params.append(("homeAway", _params["home_away"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("section") is not None:  # noqa: E501
            _query_params.append(("section", _params["section"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("win_loss") is not None:  # noqa: E501
            _query_params.append(("winLoss", _params["win_loss"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "CompetitionEntityStatisticsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/statistics/for/entity/in/competitions/{competitionId}/entities/{entityId}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def ces_listentity_periods(
        self,
        competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the competition")],
        entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the entity")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        period_id: Annotated[Optional[StrictInt], Field(description="The identifier for the period")] = None,
        section: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The section of the period (sub-period)")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ) -> CompetitionEntityStatisticsResponse:  # noqa: E501
        """Statistics for an entity in a competition  # noqa: E501

        Return the statistics for a specific entity in a competition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ces_listentity_periods(competition_id, entity_id, organization_id, sport, external, fields, fixture_type, hide_null, home_away, include, limit, offset, period_id, section, tbf, win_loss, async_req=True)
        >>> result = thread.get()

        :param competition_id: The unique identifier of the competition (required)
        :type competition_id: str
        :param entity_id: The unique identifier of the entity (required)
        :type entity_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param period_id: The identifier for the period
        :type period_id: int
        :param section: The section of the period (sub-period)
        :type section: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CompetitionEntityStatisticsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.ces_listentity_periods_with_http_info(
                competition_id,
                entity_id,
                organization_id,
                sport,
                external,
                fields,
                fixture_type,
                hide_null,
                home_away,
                include,
                limit,
                offset,
                period_id,
                section,
                tbf,
                win_loss,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling CompetitionStatisticsApi->ces_listentity_periods: %s\n" % e)
            raise

    @validate_arguments
    def ces_listentity_periods_with_http_info(
        self,
        competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the competition")],
        entity_id: Annotated[StrictStr, Field(..., description="The unique identifier of the entity")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        period_id: Annotated[Optional[StrictInt], Field(description="The identifier for the period")] = None,
        section: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The section of the period (sub-period)")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Statistics for an entity in a competition  # noqa: E501

        Return the statistics for a specific entity in a competition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ces_listentity_periods_with_http_info(competition_id, entity_id, organization_id, sport, external, fields, fixture_type, hide_null, home_away, include, limit, offset, period_id, section, tbf, win_loss, async_req=True)
        >>> result = thread.get()

        :param competition_id: The unique identifier of the competition (required)
        :type competition_id: str
        :param entity_id: The unique identifier of the entity (required)
        :type entity_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param period_id: The identifier for the period
        :type period_id: int
        :param section: The section of the period (sub-period)
        :type section: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CompetitionEntityStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "competition_id",
            "entity_id",
            "organization_id",
            "sport",
            "external",
            "fields",
            "fixture_type",
            "hide_null",
            "home_away",
            "include",
            "limit",
            "offset",
            "period_id",
            "section",
            "tbf",
            "win_loss",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method ces_listentity_periods" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["competition_id"]:
            _path_params["competitionId"] = _params["competition_id"]
        if _params["entity_id"]:
            _path_params["entityId"] = _params["entity_id"]
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("home_away") is not None:  # noqa: E501
            _query_params.append(("homeAway", _params["home_away"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("period_id") is not None:  # noqa: E501
            _query_params.append(("periodId", _params["period_id"]))
        if _params.get("section") is not None:  # noqa: E501
            _query_params.append(("section", _params["section"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("win_loss") is not None:  # noqa: E501
            _query_params.append(("winLoss", _params["win_loss"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "CompetitionEntityStatisticsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/statistics/for/entity/in/competitions/{competitionId}/entities/{entityId}/periods",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def ces_listperiods(
        self,
        competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the competition")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        period_id: Annotated[Optional[StrictInt], Field(description="The identifier for the period")] = None,
        section: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The section of the period (sub-period)")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ) -> CompetitionEntityStatisticsResponse:  # noqa: E501
        """Entity statistics for a competition by period  # noqa: E501

        Return a list of entity statistics for a competition filterable by period. This still displays aggregated/summed data, and should return the same values as the non by-period call, this one can be further filtered by period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ces_listperiods(competition_id, organization_id, sport, external, fields, fixture_type, hide_null, home_away, include, limit, offset, period_id, section, tbf, win_loss, async_req=True)
        >>> result = thread.get()

        :param competition_id: The unique identifier of the competition (required)
        :type competition_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param period_id: The identifier for the period
        :type period_id: int
        :param section: The section of the period (sub-period)
        :type section: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CompetitionEntityStatisticsResponse
        """
        kwargs["_return_http_data_only"] = True
        try:
            return self.ces_listperiods_with_http_info(
                competition_id,
                organization_id,
                sport,
                external,
                fields,
                fixture_type,
                hide_null,
                home_away,
                include,
                limit,
                offset,
                period_id,
                section,
                tbf,
                win_loss,
                **kwargs
            )  # noqa: E501
        except Exception as e:
            logger.error("Exception when calling CompetitionStatisticsApi->ces_listperiods: %s\n" % e)
            raise

    @validate_arguments
    def ces_listperiods_with_http_info(
        self,
        competition_id: Annotated[StrictStr, Field(..., description="The unique identifier of the competition")],
        organization_id: Annotated[
            constr(strict=True, max_length=5, min_length=5),
            Field(..., description="The unique identifier of the organization"),
        ],
        sport: Annotated[StrictStr, Field(..., description="Sport name")],
        external: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information."
            ),
        ] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information."
            ),
        ] = None,
        fixture_type: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(
                description="Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular "
            ),
        ] = None,
        hide_null: Annotated[
            Optional[StrictBool], Field(description="Don't display data fields with null values or empty structures")
        ] = None,
        home_away: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="Where the result was >- `AWAY` Away >- `HOME` Home "),
        ] = None,
        include: Annotated[
            Optional[StrictStr],
            Field(
                description="A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=1000, ge=1)],
            Field(
                description="The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information."
            ),
        ] = None,
        period_id: Annotated[Optional[StrictInt], Field(description="The identifier for the period")] = None,
        section: Annotated[
            Optional[constr(strict=True, max_length=100)], Field(description="The section of the period (sub-period)")
        ] = None,
        tbf: Annotated[Optional[StrictBool], Field(description="Feature flag for TBF")] = None,
        win_loss: Annotated[
            Optional[constr(strict=True, max_length=50)],
            Field(description="What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win "),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Entity statistics for a competition by period  # noqa: E501

        Return a list of entity statistics for a competition filterable by period. This still displays aggregated/summed data, and should return the same values as the non by-period call, this one can be further filtered by period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ces_listperiods_with_http_info(competition_id, organization_id, sport, external, fields, fixture_type, hide_null, home_away, include, limit, offset, period_id, section, tbf, win_loss, async_req=True)
        >>> result = thread.get()

        :param competition_id: The unique identifier of the competition (required)
        :type competition_id: str
        :param organization_id: The unique identifier of the organization (required)
        :type organization_id: str
        :param sport: Sport name (required)
        :type sport: str
        :param external: A comma separated list of fields that will instead be interpreted as an externalId. See [External Ids](#section/Introduction/External-Ids) for more information.
        :type external: str
        :param fields: A comma separated list of fields to display.  The response will only display these fields. See [Partial Response](#section/Partial-Response) section for more information.
        :type fields: str
        :param fixture_type: Type of Fixture >- `ALL_STAR` All Star >- `DEMONSTRATION` Demonstration >- `FINAL` Final >- `FRIENDLY` Friendly >- `PLAYOFF` Playoff >- `PRESEASON` Pre Season >- `REGULAR` Regular
        :type fixture_type: str
        :param hide_null: Don't display data fields with null values or empty structures
        :type hide_null: bool
        :param home_away: Where the result was >- `AWAY` Away >- `HOME` Home
        :type home_away: str
        :param include: A comma separated list of resource types to include. See [Resource Inclusion](#section/Introduction/Resource-Inclusion) for more information.
        :type include: str
        :param limit: The maximum number of records to return. See [Pagination](#section/Introduction/Pagination) for more information.
        :type limit: int
        :param offset: The offset of the records. See [Pagination](#section/Introduction/Pagination) for more information.
        :type offset: int
        :param period_id: The identifier for the period
        :type period_id: int
        :param section: The section of the period (sub-period)
        :type section: str
        :param tbf: Feature flag for TBF
        :type tbf: bool
        :param win_loss: What the result was >- `DRAW` Draw >- `LOSS` Loss >- `WIN` Win
        :type win_loss: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CompetitionEntityStatisticsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "competition_id",
            "organization_id",
            "sport",
            "external",
            "fields",
            "fixture_type",
            "hide_null",
            "home_away",
            "include",
            "limit",
            "offset",
            "period_id",
            "section",
            "tbf",
            "win_loss",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method ces_listperiods" % _key)
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["competition_id"]:
            _path_params["competitionId"] = _params["competition_id"]
        if _params["organization_id"]:
            _path_params["organizationId"] = _params["organization_id"]
        if _params["sport"]:
            _path_params["sport"] = _params["sport"]

        # process the query parameters
        _query_params = []
        if _params.get("external") is not None:  # noqa: E501
            _query_params.append(("external", _params["external"]))
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fixture_type") is not None:  # noqa: E501
            _query_params.append(("fixtureType", _params["fixture_type"]))
        if _params.get("hide_null") is not None:  # noqa: E501
            _query_params.append(("hideNull", _params["hide_null"]))
        if _params.get("home_away") is not None:  # noqa: E501
            _query_params.append(("homeAway", _params["home_away"]))
        if _params.get("include") is not None:  # noqa: E501
            _query_params.append(("include", _params["include"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("period_id") is not None:  # noqa: E501
            _query_params.append(("periodId", _params["period_id"]))
        if _params.get("section") is not None:  # noqa: E501
            _query_params.append(("section", _params["section"]))
        if _params.get("tbf") is not None:  # noqa: E501
            _query_params.append(("tbf", _params["tbf"]))
        if _params.get("win_loss") is not None:  # noqa: E501
            _query_params.append(("winLoss", _params["win_loss"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(["application/json"])  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2"]  # noqa: E501

        _response_types_map = {
            "200": "CompetitionEntityStatisticsResponse",
        }

        return self.api_client.call_api(
            "/{sport}/o/{organizationId}/statistics/for/entity/in/competitions/{competitionId}/periods",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
