#include "main.hpp"
#if (U_ICU_VERSION_MAJOR_NUM >= 51)
#include <unicode/udisplaycontext.h>
#endif // (U_ICU_VERSION_MAJOR_NUM >= 51)

void init_udisplaycontext(py::module &m) {
#if (U_ICU_VERSION_MAJOR_NUM >= 51)
  py::enum_<UDisplayContext>(m, "UDisplayContext", py::arithmetic())
      .value("UDISPCTX_STANDARD_NAMES", UDISPCTX_STANDARD_NAMES)
      .value("UDISPCTX_DIALECT_NAMES", UDISPCTX_DIALECT_NAMES)
      .value("UDISPCTX_CAPITALIZATION_NONE", UDISPCTX_CAPITALIZATION_NONE)
      .value("UDISPCTX_CAPITALIZATION_FOR_MIDDLE_OF_SENTENCE", UDISPCTX_CAPITALIZATION_FOR_MIDDLE_OF_SENTENCE)
      .value("UDISPCTX_CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE", UDISPCTX_CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE)
      .value("UDISPCTX_CAPITALIZATION_FOR_UI_LIST_OR_MENU", UDISPCTX_CAPITALIZATION_FOR_UI_LIST_OR_MENU)
      .value("UDISPCTX_CAPITALIZATION_FOR_STANDALONE", UDISPCTX_CAPITALIZATION_FOR_STANDALONE)
#if (U_ICU_VERSION_MAJOR_NUM >= 54)
      .value("UDISPCTX_LENGTH_FULL", UDISPCTX_LENGTH_FULL)
      .value("UDISPCTX_LENGTH_SHORT", UDISPCTX_LENGTH_SHORT)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 54)

#if (U_ICU_VERSION_MAJOR_NUM >= 58)
      .value("UDISPCTX_SUBSTITUTE", UDISPCTX_SUBSTITUTE)
      .value("UDISPCTX_NO_SUBSTITUTE", UDISPCTX_NO_SUBSTITUTE)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 58)
      .export_values();

  py::enum_<UDisplayContextType>(m, "UDisplayContextType", py::arithmetic())
      .value("UDISPCTX_TYPE_DIALECT_HANDLING", UDISPCTX_TYPE_DIALECT_HANDLING)
      .value("UDISPCTX_TYPE_CAPITALIZATION", UDISPCTX_TYPE_CAPITALIZATION)
#if (U_ICU_VERSION_MAJOR_NUM >= 54)
      .value("UDISPCTX_TYPE_DISPLAY_LENGTH", UDISPCTX_TYPE_DISPLAY_LENGTH)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 54)

#if (U_ICU_VERSION_MAJOR_NUM >= 58)
      .value("UDISPCTX_TYPE_SUBSTITUTE_HANDLING", UDISPCTX_TYPE_SUBSTITUTE_HANDLING)
#endif // (U_ICU_VERSION_MAJOR_NUM >= 58)
      .export_values();

#endif // (U_ICU_VERSION_MAJOR_NUM >= 51)
}
