# Presentation of THORONDOR, a program for data analysis and treatment in NEXAFS

Authors : Simonne and Martini

#### The Program is meant to be imported as a python package, if you download it, please save the THORONDOR folder in ...\Anaconda3\Lib\site-packages
The installation command can be found here : https://pypi.org/project/THORONDOR/

To keep the package up to date, please use the following command : `pip install THORONDOR -U`

There are two main classes at the core of THORONDOR:

### The class Dataset
A new instance of the Dataset class will be initialized for each Dataset saved in the data folder. This object is then saved in the list "ClassList", attribute of the second class "GUI".
For each Dataset, all the different dataframes that will be created as well as specific information e.g. the edge jump E0 can be found as attributes of this class. Certain attributes are instanced directly with the class, such as:
* Name of Dataset
* Path of original dataset
* Timestamp

At the end of the data reduction, each Dataset should have at least three different data sets as attributes, saved as `pandas.DataFrame()`:
* Renamed data : Original data
* Shifted data : If one shifts the energy 
* Reduced data : If one applies some background reduction or normalization method 

A Logbook entry might also be associated, under `Dataset.LogbookEntry`, this is done via the GUI, the logbook should be in the common excel formats.

It is possible to add commentaries for each Dataset by using the `Dataset.Comment()` and to specify some additional information with the function `Dataset.AdditionalInfo()`.

Each Dataset can be retrieved by using the function `Dataset.unpickle()` with the path of the saved Class as an argument. This is the recommended way to share the data, since it comes with all the metadata linked to the data collection and analysis.

### The class GUI
This  class is a Graphical User Interface (GUI) that is meant to be used to process nulerous XAS datasets, that focus on similar energy range and absorption edge.
There are two ways of initializing the procedure in a jupyter notebook:
* `GUI = THORONDOR.GUI()`; one will have to write the name of the data folder in which all his raw datasets are saved in a common data format (*.txt*, *.dat*, *.csv*, *.xlsx*).
* `GUI = THORONDOR.GUI.GetClassList(DataFolder = "<yourdatafolder>")` ; if one has already worked on a folder and wishes to retrieve his work.

This class makes extensive use of the ipywidgets and is thus meant to be used with a jupyter notebook. Additional informations concerning the use of the GUI functions are provided in the "ReadMe" tab of the GUI. One may also access method information through the python `help` built-in function.

All the different attributes of this class can also be exported in a single hdf5 file using the pandas `.to_hdf5` methods. They should then be accessed using the `read_hdf` methods.

The necessary Python packages are : numpy, pandas, matplotlib, glob, errno, os, shutil, ipywidgets, IPython, scipy, datetime, importlib, pickle, lmfit, encee and inspect.

### Citation and additional details

THORONDOR: software for fast treatment and analysis of low-energy XAS dat. Simonne, D.H., Martini, A., Signorile, M., Piovano, A., Braglia, L., Torelli, P., Borfecchia, E. & Ricchiardi, G. (2020). J. Synchrotron Rad. 27, https://doi.org/10.1107/S1600577520011388.

### FlowChart

![FlowChart](https://user-images.githubusercontent.com/51970962/81314649-aae0cd00-9089-11ea-9300-4c2e8ce47dc1.PNG)

### Tutorial

![Diapositive1](https://user-images.githubusercontent.com/51970962/80913188-01c16c00-8d43-11ea-812a-8f688d6b8707.PNG)
![Diapositive2](https://user-images.githubusercontent.com/51970962/94428605-3d951c00-0191-11eb-9408-37ab35815d4c.PNG)
![Diapositive3](https://user-images.githubusercontent.com/51970962/94428722-84831180-0191-11eb-90e9-8383007b2f88.PNG)
![Diapositive4](https://user-images.githubusercontent.com/51970962/94428762-9795e180-0191-11eb-8d67-281aafa1013c.PNG)
![Diapositive5](https://user-images.githubusercontent.com/51970962/94428767-995fa500-0191-11eb-9fae-009631541f86.PNG)
![Diapositive6](https://user-images.githubusercontent.com/51970962/94428771-9a90d200-0191-11eb-8abf-1ae81f3e6f0e.PNG)
![Diapositive7](https://user-images.githubusercontent.com/51970962/94428776-9c5a9580-0191-11eb-83d9-558293965496.PNG)
![Diapositive8](https://user-images.githubusercontent.com/51970962/94428779-9d8bc280-0191-11eb-9bce-795954b26a9a.PNG)
![Diapositive9](https://user-images.githubusercontent.com/51970962/94428784-9e245900-0191-11eb-9507-1e67195f581f.PNG)
![Diapositive10](https://user-images.githubusercontent.com/51970962/94428793-a11f4980-0191-11eb-91ff-b1701d80bb20.PNG)

### Please follow the following architecture when using the software


![Architecture1](https://user-images.githubusercontent.com/51970962/92746823-e36c1c80-f383-11ea-8850-79a7ab35b114.PNG)
![Architecture2](https://user-images.githubusercontent.com/51970962/92746753-d4856a00-f383-11ea-9b1c-6c05cc00423d.PNG)


### For users on Jupyter Lab, please follow this thread : https://stackoverflow.com/questions/49542417/how-to-get-ipywidgets-working-in-jupyter-lab