# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/CLI.ipynb.

# %% auto 0
__all__ = ['new', 'prepare', 'preview']

# %% ../nbs/CLI.ipynb 1
from typing import *
from pathlib import Path

import typer

import nbdev_mkdocs
import nbdev_mkdocs.mkdocs

# %% ../nbs/CLI.ipynb 3
_app = typer.Typer(help="")


@_app.command(
    help="Creates files in **mkdocs** subdirectory needed for other **nbdev_mkdocs** subcommands",
)
def new(root_path: str = typer.Option(".", help="")):
    """CLI command for creating files for nbdev_mkdocs command"""
    try:
        nbdev_mkdocs.mkdocs.new(root_path=root_path)
    except Exception as e:
        typer.secho("Unexpected internal error :/", err=True, fg=typer.colors.RED)
        raise typer.Exit(1)


@_app.command(
    help="Prepares files in **mkdocs/docs** and then runs **mkdocs build** command on them ",
)
def prepare(root_path: str = typer.Option(".", help="")):
    """CLI command for creating files for nbdev_mkdocs command"""
    try:
        nbdev_mkdocs.mkdocs.prepare(root_path=root_path)
    except Exception as e:
        typer.secho("Unexpected internal error :/", err=True, fg=typer.colors.RED)
        raise typer.Exit(1)


@_app.command(
    help="Prepares files in **mkdocs/docs** and then runs **mkdocs serve** command on them ",
)
def preview(
    root_path: str = typer.Option(
        ".", help="path under which mkdocs directory will be created"
    ),
    port: int = typer.Option(4000, help="port to use"),
):
    """CLI command for creating files for nbdev_mkdocs command"""
    try:
        nbdev_mkdocs.mkdocs.preview(root_path=root_path, port=port)
    except Exception as e:
        typer.secho("Unexpected internal error :/", err=True, fg=typer.colors.RED)
        raise typer.Exit(1)
