# denver
Denver API for Python

This API is specifically designed for python developers who want to use
advanced utilities but without coding much. The API requires you to
have minimum Python 3.6

## **Warning**
Do not use it for now until version 3.0.0 is out. major changes which break compatibility are in
progress, documentation is also in progress. Major changes are here to comply with PEP8.

## tools
this is a new package built into denver and now you can use every module inside it as a command line
tool. You can type the following command `python denverapi.tools` to get a list of available tools.

## colored text (denver.colored_text)
Colored console output have been a problem since long but here at denver API, we provide
cross-platform colored console output in almost any console. we also provide emulated
print and input function with extra keyword arguments for coloring and customizing. the
default print and input function of you code can be switched out to these one by

```python
from denverapi import colored_text

print = colored_text.print
input = colored_text.input

# You can do the same with input
print("Hello", "World in colored", "text", fore="green", back="white", style="bright")
print("Hello", "World in simple", "environment")
```

## Installation
The package can be installed by
```commandline
pip install denver-api
```
and upgraded by
```commandline
pip install --upgrade denver-api
```

## Documentation
Documentation for denver can be found out at [this page](https://xcodz-dot.github.io/denver) (*currently in progress
and may not be visible for some time*).
Also Documentation can be generated
by the following command
```commandline
pip install pdoc3
```
or if you already have then you can upgrade it by following command
```commandline
pip install --upgrade pdoc3
```
After installation cd to root of this repository and run this command
 `pdoc denverapi -o docs --html --config show_source_code=False --template-dir pdoc`.
This will generate documentation and save it under the folder `docs`.

## Community
This is a community driven project and accepts pull requests
of any kind (read [CONTRIBUTING.md](https://github.com/xcodz-dot/denver/blob/master/.github/CONTRIBUTING.md)), 
Thanks to all the contributors. Contributions are appreciated 

## Fixed Bugs
### 3.0.0b (the upcoming stable release)
* `denverapi.tools.cpic_editor` cell height to width ratio is 25:10 now for better compatibility with terminal
* `denverapi.pyelib` error in load library
### 2.5.2, 2.5.3, 2.5.4
* `denverapi.autopyb` fixes
### 2.5.1
* `denverapi.autopyb` minimum version fix
### 2.4.1
* `denverapi.bdtpfserv.post` function is now fixes to work without pausing and making troubles
* `denverapi.tools.bdtpserver` tool fixed for the post argument
* `denverapi.tools.cpic_editor` tool fixes which produced file system errors on linux
### 2.1.0
* `denverapi.pysetup.find_package_data` function is now fixed, so it can include files at root level of a module

## What's New
### 3.0.0b (the upcoming stable release)
* added `denverapi.tools.cryptify` to encrypt files and decrypt files
* added `encryption` to encrypt and decrypt data
* removed `cpic` due to complexity and incompatibility with existing modules.
* removed the documentation (that was a lot of work, now use the python documentation generated by pdoc3) 
* better cli for `denverapi.autopyb`
* added support for Python 3.6
* added new command line utilities.
* added `denverapi.tools.cpicview` to view cpic type images from commandline.
* added `entrypoints` to all tools as scripts.
* added `pyelib` which makes libraries from caching functions, so they do not compile every time they run.
* added ability to `denverapi.autopyb.commands.pip` to be able to detect dependencies and do not run pip for no reason
* added ability to `denverapi.tools.cpic_editor` to save cpic images to file.
### 2.5.0
* autopyb is added as a new auto building manager
### 2.4.1
* Thread control
* Split up the pygame into a separate section (denverapi is sometimes required without pygame)
### 2.2.0
* new indev tools
* renamed to a new project
### 2.1.0
* `denver.tools` package is now added as a standard interface to many modules (Many tools are still work in progress)
