# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ServiceConfig']


class ServiceConfig(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apis: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiArgs']]]]] = None,
                 authentication: Optional[pulumi.Input[pulumi.InputType['AuthenticationArgs']]] = None,
                 backend: Optional[pulumi.Input[pulumi.InputType['BackendArgs']]] = None,
                 billing: Optional[pulumi.Input[pulumi.InputType['BillingArgs']]] = None,
                 config_id: Optional[pulumi.Input[str]] = None,
                 config_version: Optional[pulumi.Input[int]] = None,
                 context: Optional[pulumi.Input[pulumi.InputType['ContextArgs']]] = None,
                 control: Optional[pulumi.Input[pulumi.InputType['ControlArgs']]] = None,
                 custom_error: Optional[pulumi.Input[pulumi.InputType['CustomErrorArgs']]] = None,
                 documentation: Optional[pulumi.Input[pulumi.InputType['DocumentationArgs']]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointArgs']]]]] = None,
                 enums: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnumArgs']]]]] = None,
                 http: Optional[pulumi.Input[pulumi.InputType['HttpArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input[pulumi.InputType['LoggingArgs']]] = None,
                 logs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogDescriptorArgs']]]]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricDescriptorArgs']]]]] = None,
                 monitored_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceDescriptorArgs']]]]] = None,
                 monitoring: Optional[pulumi.Input[pulumi.InputType['MonitoringArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 producer_project_id: Optional[pulumi.Input[str]] = None,
                 quota: Optional[pulumi.Input[pulumi.InputType['QuotaArgs']]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 source_info: Optional[pulumi.Input[pulumi.InputType['SourceInfoArgs']]] = None,
                 system_parameters: Optional[pulumi.Input[pulumi.InputType['SystemParametersArgs']]] = None,
                 system_types: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeArgs']]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 types: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeArgs']]]]] = None,
                 usage: Optional[pulumi.Input[pulumi.InputType['UsageArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a new service configuration (version) for a managed service. This method only stores the service configuration. To roll out the service configuration to backend systems please call CreateServiceRollout. Only the 100 most recent service configurations and ones referenced by existing rollouts are kept for each service. The rest will be deleted eventually.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApiArgs']]]] apis: A list of API interfaces exported by this service. Only the `name` field of the google.protobuf.Api needs to be provided by the configuration author, as the remaining fields will be derived from the IDL during the normalization process. It is an error to specify an API interface here which cannot be resolved against the associated IDL files.
        :param pulumi.Input[pulumi.InputType['AuthenticationArgs']] authentication: Auth configuration.
        :param pulumi.Input[pulumi.InputType['BackendArgs']] backend: API backend configuration.
        :param pulumi.Input[pulumi.InputType['BillingArgs']] billing: Billing configuration.
        :param pulumi.Input[int] config_version: Obsolete. Do not use. This field has no semantic meaning. The service config compiler always sets this field to `3`.
        :param pulumi.Input[pulumi.InputType['ContextArgs']] context: Context configuration.
        :param pulumi.Input[pulumi.InputType['ControlArgs']] control: Configuration for the service control plane.
        :param pulumi.Input[pulumi.InputType['CustomErrorArgs']] custom_error: Custom error configuration.
        :param pulumi.Input[pulumi.InputType['DocumentationArgs']] documentation: Additional API documentation.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointArgs']]]] endpoints: Configuration for network endpoints. If this is empty, then an endpoint with the same name as the service is automatically generated to service all defined APIs.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnumArgs']]]] enums: A list of all enum types included in this API service. Enums referenced directly or indirectly by the `apis` are automatically included. Enums which are not referenced but shall be included should be listed here by name. Example: enums: - name: google.someapi.v1.SomeEnum
        :param pulumi.Input[pulumi.InputType['HttpArgs']] http: HTTP configuration.
        :param pulumi.Input[str] id: A unique ID for a specific instance of this message, typically assigned by the client for tracking purpose. Must be no longer than 63 characters and only lower case letters, digits, '.', '_' and '-' are allowed. If empty, the server may choose to generate one instead.
        :param pulumi.Input[pulumi.InputType['LoggingArgs']] logging: Logging configuration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LogDescriptorArgs']]]] logs: Defines the logs used by this service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricDescriptorArgs']]]] metrics: Defines the metrics used by this service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceDescriptorArgs']]]] monitored_resources: Defines the monitored resources used by this service. This is required by the Service.monitoring and Service.logging configurations.
        :param pulumi.Input[pulumi.InputType['MonitoringArgs']] monitoring: Monitoring configuration.
        :param pulumi.Input[str] name: The service name, which is a DNS-like logical identifier for the service, such as `calendar.googleapis.com`. The service name typically goes through DNS verification to make sure the owner of the service also owns the DNS name.
        :param pulumi.Input[str] producer_project_id: The Google project that owns this service.
        :param pulumi.Input[pulumi.InputType['QuotaArgs']] quota: Quota configuration.
        :param pulumi.Input[pulumi.InputType['SourceInfoArgs']] source_info: The source information for this configuration if available.
        :param pulumi.Input[pulumi.InputType['SystemParametersArgs']] system_parameters: System parameter configuration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeArgs']]]] system_types: A list of all proto message types included in this API service. It serves similar purpose as [google.api.Service.types], except that these types are not needed by user-defined APIs. Therefore, they will not show up in the generated discovery doc. This field should only be used to define system APIs in ESF.
        :param pulumi.Input[str] title: The product title for this service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TypeArgs']]]] types: A list of all proto message types included in this API service. Types referenced directly or indirectly by the `apis` are automatically included. Messages which are not referenced but shall be included, such as types used by the `google.protobuf.Any` type, should be listed here by name. Example: types: - name: google.protobuf.Int32
        :param pulumi.Input[pulumi.InputType['UsageArgs']] usage: Configuration controlling usage of this service.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['apis'] = apis
            __props__['authentication'] = authentication
            __props__['backend'] = backend
            __props__['billing'] = billing
            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__['config_id'] = config_id
            __props__['config_version'] = config_version
            __props__['context'] = context
            __props__['control'] = control
            __props__['custom_error'] = custom_error
            __props__['documentation'] = documentation
            __props__['endpoints'] = endpoints
            __props__['enums'] = enums
            __props__['http'] = http
            __props__['id'] = id
            __props__['logging'] = logging
            __props__['logs'] = logs
            __props__['metrics'] = metrics
            __props__['monitored_resources'] = monitored_resources
            __props__['monitoring'] = monitoring
            __props__['name'] = name
            __props__['producer_project_id'] = producer_project_id
            __props__['quota'] = quota
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__['service_name'] = service_name
            __props__['source_info'] = source_info
            __props__['system_parameters'] = system_parameters
            __props__['system_types'] = system_types
            __props__['title'] = title
            __props__['types'] = types
            __props__['usage'] = usage
        super(ServiceConfig, __self__).__init__(
            'gcp-native:servicemanagement/v1:ServiceConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ServiceConfig':
        """
        Get an existing ServiceConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["apis"] = None
        __props__["authentication"] = None
        __props__["backend"] = None
        __props__["billing"] = None
        __props__["config_version"] = None
        __props__["context"] = None
        __props__["control"] = None
        __props__["custom_error"] = None
        __props__["documentation"] = None
        __props__["endpoints"] = None
        __props__["enums"] = None
        __props__["http"] = None
        __props__["logging"] = None
        __props__["logs"] = None
        __props__["metrics"] = None
        __props__["monitored_resources"] = None
        __props__["monitoring"] = None
        __props__["name"] = None
        __props__["producer_project_id"] = None
        __props__["quota"] = None
        __props__["source_info"] = None
        __props__["system_parameters"] = None
        __props__["system_types"] = None
        __props__["title"] = None
        __props__["types"] = None
        __props__["usage"] = None
        return ServiceConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def apis(self) -> pulumi.Output[Sequence['outputs.ApiResponse']]:
        """
        A list of API interfaces exported by this service. Only the `name` field of the google.protobuf.Api needs to be provided by the configuration author, as the remaining fields will be derived from the IDL during the normalization process. It is an error to specify an API interface here which cannot be resolved against the associated IDL files.
        """
        return pulumi.get(self, "apis")

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Output['outputs.AuthenticationResponse']:
        """
        Auth configuration.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output['outputs.BackendResponse']:
        """
        API backend configuration.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter
    def billing(self) -> pulumi.Output['outputs.BillingResponse']:
        """
        Billing configuration.
        """
        return pulumi.get(self, "billing")

    @property
    @pulumi.getter(name="configVersion")
    def config_version(self) -> pulumi.Output[int]:
        """
        Obsolete. Do not use. This field has no semantic meaning. The service config compiler always sets this field to `3`.
        """
        return pulumi.get(self, "config_version")

    @property
    @pulumi.getter
    def context(self) -> pulumi.Output['outputs.ContextResponse']:
        """
        Context configuration.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter
    def control(self) -> pulumi.Output['outputs.ControlResponse']:
        """
        Configuration for the service control plane.
        """
        return pulumi.get(self, "control")

    @property
    @pulumi.getter(name="customError")
    def custom_error(self) -> pulumi.Output['outputs.CustomErrorResponse']:
        """
        Custom error configuration.
        """
        return pulumi.get(self, "custom_error")

    @property
    @pulumi.getter
    def documentation(self) -> pulumi.Output['outputs.DocumentationResponse']:
        """
        Additional API documentation.
        """
        return pulumi.get(self, "documentation")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.EndpointResponse']]:
        """
        Configuration for network endpoints. If this is empty, then an endpoint with the same name as the service is automatically generated to service all defined APIs.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def enums(self) -> pulumi.Output[Sequence['outputs.EnumResponse']]:
        """
        A list of all enum types included in this API service. Enums referenced directly or indirectly by the `apis` are automatically included. Enums which are not referenced but shall be included should be listed here by name. Example: enums: - name: google.someapi.v1.SomeEnum
        """
        return pulumi.get(self, "enums")

    @property
    @pulumi.getter
    def http(self) -> pulumi.Output['outputs.HttpResponse']:
        """
        HTTP configuration.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def logging(self) -> pulumi.Output['outputs.LoggingResponse']:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter
    def logs(self) -> pulumi.Output[Sequence['outputs.LogDescriptorResponse']]:
        """
        Defines the logs used by this service.
        """
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[Sequence['outputs.MetricDescriptorResponse']]:
        """
        Defines the metrics used by this service.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="monitoredResources")
    def monitored_resources(self) -> pulumi.Output[Sequence['outputs.MonitoredResourceDescriptorResponse']]:
        """
        Defines the monitored resources used by this service. This is required by the Service.monitoring and Service.logging configurations.
        """
        return pulumi.get(self, "monitored_resources")

    @property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output['outputs.MonitoringResponse']:
        """
        Monitoring configuration.
        """
        return pulumi.get(self, "monitoring")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The service name, which is a DNS-like logical identifier for the service, such as `calendar.googleapis.com`. The service name typically goes through DNS verification to make sure the owner of the service also owns the DNS name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="producerProjectId")
    def producer_project_id(self) -> pulumi.Output[str]:
        """
        The Google project that owns this service.
        """
        return pulumi.get(self, "producer_project_id")

    @property
    @pulumi.getter
    def quota(self) -> pulumi.Output['outputs.QuotaResponse']:
        """
        Quota configuration.
        """
        return pulumi.get(self, "quota")

    @property
    @pulumi.getter(name="sourceInfo")
    def source_info(self) -> pulumi.Output['outputs.SourceInfoResponse']:
        """
        The source information for this configuration if available.
        """
        return pulumi.get(self, "source_info")

    @property
    @pulumi.getter(name="systemParameters")
    def system_parameters(self) -> pulumi.Output['outputs.SystemParametersResponse']:
        """
        System parameter configuration.
        """
        return pulumi.get(self, "system_parameters")

    @property
    @pulumi.getter(name="systemTypes")
    def system_types(self) -> pulumi.Output[Sequence['outputs.TypeResponse']]:
        """
        A list of all proto message types included in this API service. It serves similar purpose as [google.api.Service.types], except that these types are not needed by user-defined APIs. Therefore, they will not show up in the generated discovery doc. This field should only be used to define system APIs in ESF.
        """
        return pulumi.get(self, "system_types")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        The product title for this service.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def types(self) -> pulumi.Output[Sequence['outputs.TypeResponse']]:
        """
        A list of all proto message types included in this API service. Types referenced directly or indirectly by the `apis` are automatically included. Messages which are not referenced but shall be included, such as types used by the `google.protobuf.Any` type, should be listed here by name. Example: types: - name: google.protobuf.Int32
        """
        return pulumi.get(self, "types")

    @property
    @pulumi.getter
    def usage(self) -> pulumi.Output['outputs.UsageResponse']:
        """
        Configuration controlling usage of this service.
        """
        return pulumi.get(self, "usage")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

