# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = ['Brand']


class Brand(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_title: Optional[pulumi.Input[str]] = None,
                 brands_id: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 support_email: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Constructs a new OAuth brand for the project if one does not exist. The created brand is "internal only", meaning that OAuth clients created under it only accept requests from users who belong to the same G Suite organization as the project. The brand is created in an un-reviewed status. NOTE: The "internal only" status can be manually changed in the Google Cloud console. Requires that a brand does not already exist for the project, and that the specified support email is owned by the caller.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_title: Application name displayed on OAuth consent screen.
        :param pulumi.Input[str] support_email: Support email displayed on the OAuth consent screen.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['application_title'] = application_title
            if brands_id is None and not opts.urn:
                raise TypeError("Missing required property 'brands_id'")
            __props__['brands_id'] = brands_id
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__['projects_id'] = projects_id
            __props__['support_email'] = support_email
            __props__['name'] = None
            __props__['org_internal_only'] = None
        super(Brand, __self__).__init__(
            'gcp-native:iap/v1:Brand',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Brand':
        """
        Get an existing Brand resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["application_title"] = None
        __props__["name"] = None
        __props__["org_internal_only"] = None
        __props__["support_email"] = None
        return Brand(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationTitle")
    def application_title(self) -> pulumi.Output[str]:
        """
        Application name displayed on OAuth consent screen.
        """
        return pulumi.get(self, "application_title")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Identifier of the brand. NOTE: GCP project number achieves the same brand identification purpose as only one brand per project can be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgInternalOnly")
    def org_internal_only(self) -> pulumi.Output[bool]:
        """
        Whether the brand is only intended for usage inside the G Suite organization only.
        """
        return pulumi.get(self, "org_internal_only")

    @property
    @pulumi.getter(name="supportEmail")
    def support_email(self) -> pulumi.Output[str]:
        """
        Support email displayed on the OAuth consent screen.
        """
        return pulumi.get(self, "support_email")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

