# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'CertDnsChallengeArgs',
    'CertHttpChallengeArgs',
    'DomainProvisioningArgs',
    'DomainRedirectArgs',
]

@pulumi.input_type
class CertDnsChallengeArgs:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        Represents a DNS certificate challenge.
        :param pulumi.Input[str] domain_name: The domain name upon which the DNS challenge must be satisfied.
        :param pulumi.Input[str] token: The value that must be present as a TXT record on the domain name to satisfy the challenge.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name upon which the DNS challenge must be satisfied.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The value that must be present as a TXT record on the domain name to satisfy the challenge.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class CertHttpChallengeArgs:
    def __init__(__self__, *,
                 path: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        Represents an HTTP certificate challenge.
        :param pulumi.Input[str] path: The URL path on which to serve the specified token to satisfy the certificate challenge.
        :param pulumi.Input[str] token: The token to serve at the specified URL path to satisfy the certificate challenge.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The URL path on which to serve the specified token to satisfy the certificate challenge.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The token to serve at the specified URL path to satisfy the certificate challenge.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class DomainProvisioningArgs:
    def __init__(__self__, *,
                 cert_challenge_discovered_txt: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cert_challenge_dns: Optional[pulumi.Input['CertDnsChallengeArgs']] = None,
                 cert_challenge_http: Optional[pulumi.Input['CertHttpChallengeArgs']] = None,
                 cert_status: Optional[pulumi.Input[str]] = None,
                 discovered_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_fetch_time: Optional[pulumi.Input[str]] = None,
                 dns_status: Optional[pulumi.Input[str]] = None,
                 expected_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The current certificate provisioning status information for a domain.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cert_challenge_discovered_txt: The TXT records (for the certificate challenge) that were found at the last DNS fetch.
        :param pulumi.Input['CertDnsChallengeArgs'] cert_challenge_dns: The DNS challenge for generating a certificate.
        :param pulumi.Input['CertHttpChallengeArgs'] cert_challenge_http: The HTTP challenge for generating a certificate.
        :param pulumi.Input[str] cert_status: The certificate provisioning status; updated when Firebase Hosting provisions an SSL certificate for the domain.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] discovered_ips: The IPs found at the last DNS fetch.
        :param pulumi.Input[str] dns_fetch_time: The time at which the last DNS fetch occurred.
        :param pulumi.Input[str] dns_status: The DNS record match status as of the last DNS fetch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expected_ips: The list of IPs to which the domain is expected to resolve.
        """
        if cert_challenge_discovered_txt is not None:
            pulumi.set(__self__, "cert_challenge_discovered_txt", cert_challenge_discovered_txt)
        if cert_challenge_dns is not None:
            pulumi.set(__self__, "cert_challenge_dns", cert_challenge_dns)
        if cert_challenge_http is not None:
            pulumi.set(__self__, "cert_challenge_http", cert_challenge_http)
        if cert_status is not None:
            pulumi.set(__self__, "cert_status", cert_status)
        if discovered_ips is not None:
            pulumi.set(__self__, "discovered_ips", discovered_ips)
        if dns_fetch_time is not None:
            pulumi.set(__self__, "dns_fetch_time", dns_fetch_time)
        if dns_status is not None:
            pulumi.set(__self__, "dns_status", dns_status)
        if expected_ips is not None:
            pulumi.set(__self__, "expected_ips", expected_ips)

    @property
    @pulumi.getter(name="certChallengeDiscoveredTxt")
    def cert_challenge_discovered_txt(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The TXT records (for the certificate challenge) that were found at the last DNS fetch.
        """
        return pulumi.get(self, "cert_challenge_discovered_txt")

    @cert_challenge_discovered_txt.setter
    def cert_challenge_discovered_txt(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cert_challenge_discovered_txt", value)

    @property
    @pulumi.getter(name="certChallengeDns")
    def cert_challenge_dns(self) -> Optional[pulumi.Input['CertDnsChallengeArgs']]:
        """
        The DNS challenge for generating a certificate.
        """
        return pulumi.get(self, "cert_challenge_dns")

    @cert_challenge_dns.setter
    def cert_challenge_dns(self, value: Optional[pulumi.Input['CertDnsChallengeArgs']]):
        pulumi.set(self, "cert_challenge_dns", value)

    @property
    @pulumi.getter(name="certChallengeHttp")
    def cert_challenge_http(self) -> Optional[pulumi.Input['CertHttpChallengeArgs']]:
        """
        The HTTP challenge for generating a certificate.
        """
        return pulumi.get(self, "cert_challenge_http")

    @cert_challenge_http.setter
    def cert_challenge_http(self, value: Optional[pulumi.Input['CertHttpChallengeArgs']]):
        pulumi.set(self, "cert_challenge_http", value)

    @property
    @pulumi.getter(name="certStatus")
    def cert_status(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate provisioning status; updated when Firebase Hosting provisions an SSL certificate for the domain.
        """
        return pulumi.get(self, "cert_status")

    @cert_status.setter
    def cert_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_status", value)

    @property
    @pulumi.getter(name="discoveredIps")
    def discovered_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IPs found at the last DNS fetch.
        """
        return pulumi.get(self, "discovered_ips")

    @discovered_ips.setter
    def discovered_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "discovered_ips", value)

    @property
    @pulumi.getter(name="dnsFetchTime")
    def dns_fetch_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the last DNS fetch occurred.
        """
        return pulumi.get(self, "dns_fetch_time")

    @dns_fetch_time.setter
    def dns_fetch_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_fetch_time", value)

    @property
    @pulumi.getter(name="dnsStatus")
    def dns_status(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS record match status as of the last DNS fetch.
        """
        return pulumi.get(self, "dns_status")

    @dns_status.setter
    def dns_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_status", value)

    @property
    @pulumi.getter(name="expectedIps")
    def expected_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of IPs to which the domain is expected to resolve.
        """
        return pulumi.get(self, "expected_ips")

    @expected_ips.setter
    def expected_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expected_ips", value)


@pulumi.input_type
class DomainRedirectArgs:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Defines the behavior of a domain-level redirect. Domain redirects preserve the path of the redirect but replace the requested domain with the one specified in the redirect configuration.
        :param pulumi.Input[str] domain_name: Required. The domain name to redirect to.
        :param pulumi.Input[str] type: Required. The redirect status code.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The domain name to redirect to.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The redirect status code.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


