# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ManagedZone']


class ManagedZone(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 dnssec_config: Optional[pulumi.Input[pulumi.InputType['ManagedZoneDnsSecConfigArgs']]] = None,
                 forwarding_config: Optional[pulumi.Input[pulumi.InputType['ManagedZoneForwardingConfigArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 managed_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_server_set: Optional[pulumi.Input[str]] = None,
                 name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 peering_config: Optional[pulumi.Input[pulumi.InputType['ManagedZonePeeringConfigArgs']]] = None,
                 private_visibility_config: Optional[pulumi.Input[pulumi.InputType['ManagedZonePrivateVisibilityConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reverse_lookup_config: Optional[pulumi.Input[pulumi.InputType['ManagedZoneReverseLookupConfigArgs']]] = None,
                 service_directory_config: Optional[pulumi.Input[pulumi.InputType['ManagedZoneServiceDirectoryConfigArgs']]] = None,
                 visibility: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a new ManagedZone.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creation_time: The time that this resource was created on the server. This is in RFC3339 text format. Output only.
        :param pulumi.Input[str] description: A mutable string of at most 1024 characters associated with this resource for the user's convenience. Has no effect on the managed zone's function.
        :param pulumi.Input[str] dns_name: The DNS name of this managed zone, for instance "example.com.".
        :param pulumi.Input[pulumi.InputType['ManagedZoneDnsSecConfigArgs']] dnssec_config: DNSSEC configuration.
        :param pulumi.Input[pulumi.InputType['ManagedZoneForwardingConfigArgs']] forwarding_config: The presence for this field indicates that outbound forwarding is enabled for this zone. The value of this field contains the set of destinations to forward to.
        :param pulumi.Input[str] id: Unique identifier for the resource; defined by the server (output only)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User labels.
        :param pulumi.Input[str] name: User assigned name for this resource. Must be unique within the project. The name must be 1-63 characters long, must begin with a letter, end with a letter or digit, and only contain lowercase letters, digits or dashes.
        :param pulumi.Input[str] name_server_set: Optionally specifies the NameServerSet for this ManagedZone. A NameServerSet is a set of DNS name servers that all host the same ManagedZones. Most users leave this field unset. If you need to use this field, contact your account team.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] name_servers: Delegate your managed_zone to these virtual name servers; defined by the server (output only)
        :param pulumi.Input[pulumi.InputType['ManagedZonePeeringConfigArgs']] peering_config: The presence of this field indicates that DNS Peering is enabled for this zone. The value of this field contains the network to peer with.
        :param pulumi.Input[pulumi.InputType['ManagedZonePrivateVisibilityConfigArgs']] private_visibility_config: For privately visible zones, the set of Virtual Private Cloud resources that the zone is visible from.
        :param pulumi.Input[pulumi.InputType['ManagedZoneReverseLookupConfigArgs']] reverse_lookup_config: The presence of this field indicates that this is a managed reverse lookup zone and Cloud DNS resolves reverse lookup queries using automatically configured records for VPC resources. This only applies to networks listed under private_visibility_config.
        :param pulumi.Input[pulumi.InputType['ManagedZoneServiceDirectoryConfigArgs']] service_directory_config: This field links to the associated service directory namespace. Do not set this field for public zones or forwarding zones.
        :param pulumi.Input[str] visibility: The zone's visibility: public zones are exposed to the Internet, while private zones are visible only to Virtual Private Cloud resources.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['creation_time'] = creation_time
            __props__['description'] = description
            __props__['dns_name'] = dns_name
            __props__['dnssec_config'] = dnssec_config
            __props__['forwarding_config'] = forwarding_config
            __props__['id'] = id
            __props__['kind'] = kind
            __props__['labels'] = labels
            if managed_zone is None and not opts.urn:
                raise TypeError("Missing required property 'managed_zone'")
            __props__['managed_zone'] = managed_zone
            __props__['name'] = name
            __props__['name_server_set'] = name_server_set
            __props__['name_servers'] = name_servers
            __props__['peering_config'] = peering_config
            __props__['private_visibility_config'] = private_visibility_config
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['reverse_lookup_config'] = reverse_lookup_config
            __props__['service_directory_config'] = service_directory_config
            __props__['visibility'] = visibility
        super(ManagedZone, __self__).__init__(
            'gcp-native:dns/v1:ManagedZone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ManagedZone':
        """
        Get an existing ManagedZone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["creation_time"] = None
        __props__["description"] = None
        __props__["dns_name"] = None
        __props__["dnssec_config"] = None
        __props__["forwarding_config"] = None
        __props__["kind"] = None
        __props__["labels"] = None
        __props__["name"] = None
        __props__["name_server_set"] = None
        __props__["name_servers"] = None
        __props__["peering_config"] = None
        __props__["private_visibility_config"] = None
        __props__["reverse_lookup_config"] = None
        __props__["service_directory_config"] = None
        __props__["visibility"] = None
        return ManagedZone(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The time that this resource was created on the server. This is in RFC3339 text format. Output only.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A mutable string of at most 1024 characters associated with this resource for the user's convenience. Has no effect on the managed zone's function.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        The DNS name of this managed zone, for instance "example.com.".
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="dnssecConfig")
    def dnssec_config(self) -> pulumi.Output['outputs.ManagedZoneDnsSecConfigResponse']:
        """
        DNSSEC configuration.
        """
        return pulumi.get(self, "dnssec_config")

    @property
    @pulumi.getter(name="forwardingConfig")
    def forwarding_config(self) -> pulumi.Output['outputs.ManagedZoneForwardingConfigResponse']:
        """
        The presence for this field indicates that outbound forwarding is enabled for this zone. The value of this field contains the set of destinations to forward to.
        """
        return pulumi.get(self, "forwarding_config")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        User labels.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        User assigned name for this resource. Must be unique within the project. The name must be 1-63 characters long, must begin with a letter, end with a letter or digit, and only contain lowercase letters, digits or dashes.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameServerSet")
    def name_server_set(self) -> pulumi.Output[str]:
        """
        Optionally specifies the NameServerSet for this ManagedZone. A NameServerSet is a set of DNS name servers that all host the same ManagedZones. Most users leave this field unset. If you need to use this field, contact your account team.
        """
        return pulumi.get(self, "name_server_set")

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        Delegate your managed_zone to these virtual name servers; defined by the server (output only)
        """
        return pulumi.get(self, "name_servers")

    @property
    @pulumi.getter(name="peeringConfig")
    def peering_config(self) -> pulumi.Output['outputs.ManagedZonePeeringConfigResponse']:
        """
        The presence of this field indicates that DNS Peering is enabled for this zone. The value of this field contains the network to peer with.
        """
        return pulumi.get(self, "peering_config")

    @property
    @pulumi.getter(name="privateVisibilityConfig")
    def private_visibility_config(self) -> pulumi.Output['outputs.ManagedZonePrivateVisibilityConfigResponse']:
        """
        For privately visible zones, the set of Virtual Private Cloud resources that the zone is visible from.
        """
        return pulumi.get(self, "private_visibility_config")

    @property
    @pulumi.getter(name="reverseLookupConfig")
    def reverse_lookup_config(self) -> pulumi.Output['outputs.ManagedZoneReverseLookupConfigResponse']:
        """
        The presence of this field indicates that this is a managed reverse lookup zone and Cloud DNS resolves reverse lookup queries using automatically configured records for VPC resources. This only applies to networks listed under private_visibility_config.
        """
        return pulumi.get(self, "reverse_lookup_config")

    @property
    @pulumi.getter(name="serviceDirectoryConfig")
    def service_directory_config(self) -> pulumi.Output['outputs.ManagedZoneServiceDirectoryConfigResponse']:
        """
        This field links to the associated service directory namespace. Do not set this field for public zones or forwarding zones.
        """
        return pulumi.get(self, "service_directory_config")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[str]:
        """
        The zone's visibility: public zones are exposed to the Internet, while private zones are visible only to Virtual Private Cloud resources.
        """
        return pulumi.get(self, "visibility")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

