# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ConversationProfile']


class ConversationProfile(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automated_agent_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2AutomatedAgentConfigArgs']]] = None,
                 conversation_profiles_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 human_agent_assistant_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2HumanAgentAssistantConfigArgs']]] = None,
                 human_agent_handoff_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2HumanAgentHandoffConfigArgs']]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 logging_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2LoggingConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_message_event_notification_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2NotificationConfigArgs']]] = None,
                 notification_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2NotificationConfigArgs']]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 stt_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2SpeechToTextConfigArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a conversation profile in the specified project. ConversationProfile.CreateTime and ConversationProfile.UpdateTime aren't populated in the response. You can retrieve them via GetConversationProfile API.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2AutomatedAgentConfigArgs']] automated_agent_config: Configuration for an automated agent to use with this profile.
        :param pulumi.Input[str] display_name: Required. Human readable name for this profile. Max length 1024 bytes.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2HumanAgentAssistantConfigArgs']] human_agent_assistant_config: Configuration for agent assistance to use with this profile.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2HumanAgentHandoffConfigArgs']] human_agent_handoff_config: Configuration for connecting to a live agent. Currently, this feature is not general available, please contact Google to get access.
        :param pulumi.Input[str] language_code: Language which represents the conversationProfile. If unspecified, the default language code en-us applies. Users need to create a ConversationProfile for each language they want to support.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2LoggingConfigArgs']] logging_config: Configuration for logging conversation lifecycle events.
        :param pulumi.Input[str] name: The unique identifier of this conversation profile. Format: `projects//locations//conversationProfiles/`.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2NotificationConfigArgs']] new_message_event_notification_config: Configuration for publishing new message events. Event will be sent in format of ConversationEvent
        :param pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2NotificationConfigArgs']] notification_config: Configuration for publishing conversation lifecycle events.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2SpeechToTextConfigArgs']] stt_config: Settings for speech transcription.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['automated_agent_config'] = automated_agent_config
            if conversation_profiles_id is None and not opts.urn:
                raise TypeError("Missing required property 'conversation_profiles_id'")
            __props__['conversation_profiles_id'] = conversation_profiles_id
            __props__['display_name'] = display_name
            __props__['human_agent_assistant_config'] = human_agent_assistant_config
            __props__['human_agent_handoff_config'] = human_agent_handoff_config
            __props__['language_code'] = language_code
            if locations_id is None and not opts.urn:
                raise TypeError("Missing required property 'locations_id'")
            __props__['locations_id'] = locations_id
            __props__['logging_config'] = logging_config
            __props__['name'] = name
            __props__['new_message_event_notification_config'] = new_message_event_notification_config
            __props__['notification_config'] = notification_config
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__['projects_id'] = projects_id
            __props__['stt_config'] = stt_config
            __props__['create_time'] = None
            __props__['update_time'] = None
        super(ConversationProfile, __self__).__init__(
            'gcp-native:dialogflow/v2:ConversationProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ConversationProfile':
        """
        Get an existing ConversationProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["automated_agent_config"] = None
        __props__["create_time"] = None
        __props__["display_name"] = None
        __props__["human_agent_assistant_config"] = None
        __props__["human_agent_handoff_config"] = None
        __props__["language_code"] = None
        __props__["logging_config"] = None
        __props__["name"] = None
        __props__["new_message_event_notification_config"] = None
        __props__["notification_config"] = None
        __props__["stt_config"] = None
        __props__["update_time"] = None
        return ConversationProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="automatedAgentConfig")
    def automated_agent_config(self) -> pulumi.Output['outputs.GoogleCloudDialogflowV2AutomatedAgentConfigResponse']:
        """
        Configuration for an automated agent to use with this profile.
        """
        return pulumi.get(self, "automated_agent_config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Create time of the conversation profile.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Required. Human readable name for this profile. Max length 1024 bytes.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="humanAgentAssistantConfig")
    def human_agent_assistant_config(self) -> pulumi.Output['outputs.GoogleCloudDialogflowV2HumanAgentAssistantConfigResponse']:
        """
        Configuration for agent assistance to use with this profile.
        """
        return pulumi.get(self, "human_agent_assistant_config")

    @property
    @pulumi.getter(name="humanAgentHandoffConfig")
    def human_agent_handoff_config(self) -> pulumi.Output['outputs.GoogleCloudDialogflowV2HumanAgentHandoffConfigResponse']:
        """
        Configuration for connecting to a live agent. Currently, this feature is not general available, please contact Google to get access.
        """
        return pulumi.get(self, "human_agent_handoff_config")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[str]:
        """
        Language which represents the conversationProfile. If unspecified, the default language code en-us applies. Users need to create a ConversationProfile for each language they want to support.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output['outputs.GoogleCloudDialogflowV2LoggingConfigResponse']:
        """
        Configuration for logging conversation lifecycle events.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique identifier of this conversation profile. Format: `projects//locations//conversationProfiles/`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newMessageEventNotificationConfig")
    def new_message_event_notification_config(self) -> pulumi.Output['outputs.GoogleCloudDialogflowV2NotificationConfigResponse']:
        """
        Configuration for publishing new message events. Event will be sent in format of ConversationEvent
        """
        return pulumi.get(self, "new_message_event_notification_config")

    @property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> pulumi.Output['outputs.GoogleCloudDialogflowV2NotificationConfigResponse']:
        """
        Configuration for publishing conversation lifecycle events.
        """
        return pulumi.get(self, "notification_config")

    @property
    @pulumi.getter(name="sttConfig")
    def stt_config(self) -> pulumi.Output['outputs.GoogleCloudDialogflowV2SpeechToTextConfigResponse']:
        """
        Settings for speech transcription.
        """
        return pulumi.get(self, "stt_config")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Update time of the conversation profile.
        """
        return pulumi.get(self, "update_time")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

