# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['DatasetAnnotatedDatasetFeedbackThreadFeedbackMessage']


class DatasetAnnotatedDatasetFeedbackThreadFeedbackMessage(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotated_datasets_id: Optional[pulumi.Input[str]] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 datasets_id: Optional[pulumi.Input[str]] = None,
                 feedback_messages_id: Optional[pulumi.Input[str]] = None,
                 feedback_threads_id: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operator_feedback_metadata: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatalabelingV1beta1OperatorFeedbackMetadataArgs']]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 requester_feedback_metadata: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDatalabelingV1beta1RequesterFeedbackMetadataArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a FeedbackMessage object.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] body: String content of the feedback. Maximum of 10000 characters.
        :param pulumi.Input[str] create_time: Create time.
        :param pulumi.Input[str] image: The image storing this feedback if the feedback is an image representing operator's comments.
        :param pulumi.Input[str] name: Name of the feedback message in a feedback thread. Format: 'project/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset_id}/feedbackThreads/{feedback_thread_id}/feedbackMessage/{feedback_message_id}'
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if annotated_datasets_id is None and not opts.urn:
                raise TypeError("Missing required property 'annotated_datasets_id'")
            __props__['annotated_datasets_id'] = annotated_datasets_id
            __props__['body'] = body
            __props__['create_time'] = create_time
            if datasets_id is None and not opts.urn:
                raise TypeError("Missing required property 'datasets_id'")
            __props__['datasets_id'] = datasets_id
            if feedback_messages_id is None and not opts.urn:
                raise TypeError("Missing required property 'feedback_messages_id'")
            __props__['feedback_messages_id'] = feedback_messages_id
            if feedback_threads_id is None and not opts.urn:
                raise TypeError("Missing required property 'feedback_threads_id'")
            __props__['feedback_threads_id'] = feedback_threads_id
            __props__['image'] = image
            __props__['name'] = name
            __props__['operator_feedback_metadata'] = operator_feedback_metadata
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__['projects_id'] = projects_id
            __props__['requester_feedback_metadata'] = requester_feedback_metadata
        super(DatasetAnnotatedDatasetFeedbackThreadFeedbackMessage, __self__).__init__(
            'gcp-native:datalabeling/v1beta1:DatasetAnnotatedDatasetFeedbackThreadFeedbackMessage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DatasetAnnotatedDatasetFeedbackThreadFeedbackMessage':
        """
        Get an existing DatasetAnnotatedDatasetFeedbackThreadFeedbackMessage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["body"] = None
        __props__["create_time"] = None
        __props__["image"] = None
        __props__["name"] = None
        __props__["operator_feedback_metadata"] = None
        __props__["requester_feedback_metadata"] = None
        return DatasetAnnotatedDatasetFeedbackThreadFeedbackMessage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def body(self) -> pulumi.Output[str]:
        """
        String content of the feedback. Maximum of 10000 characters.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Create time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def image(self) -> pulumi.Output[str]:
        """
        The image storing this feedback if the feedback is an image representing operator's comments.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the feedback message in a feedback thread. Format: 'project/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset_id}/feedbackThreads/{feedback_thread_id}/feedbackMessage/{feedback_message_id}'
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operatorFeedbackMetadata")
    def operator_feedback_metadata(self) -> pulumi.Output['outputs.GoogleCloudDatalabelingV1beta1OperatorFeedbackMetadataResponse']:
        return pulumi.get(self, "operator_feedback_metadata")

    @property
    @pulumi.getter(name="requesterFeedbackMetadata")
    def requester_feedback_metadata(self) -> pulumi.Output['outputs.GoogleCloudDatalabelingV1beta1RequesterFeedbackMetadataResponse']:
        return pulumi.get(self, "requester_feedback_metadata")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

