# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'ApiConfigHandlerArgs',
    'ApiEndpointHandlerArgs',
    'AutomaticScalingArgs',
    'BasicScalingArgs',
    'CertificateRawDataArgs',
    'CloudBuildOptionsArgs',
    'ContainerInfoArgs',
    'CpuUtilizationArgs',
    'DeploymentArgs',
    'DiskUtilizationArgs',
    'EndpointsApiServiceArgs',
    'EntrypointArgs',
    'ErrorHandlerArgs',
    'FeatureSettingsArgs',
    'HealthCheckArgs',
    'IdentityAwareProxyArgs',
    'LibraryArgs',
    'LivenessCheckArgs',
    'ManagedCertificateArgs',
    'ManualScalingArgs',
    'NetworkArgs',
    'NetworkUtilizationArgs',
    'ReadinessCheckArgs',
    'RequestUtilizationArgs',
    'ResourceRecordArgs',
    'ResourcesArgs',
    'ScriptHandlerArgs',
    'SslSettingsArgs',
    'StandardSchedulerSettingsArgs',
    'StaticFilesHandlerArgs',
    'UrlDispatchRuleArgs',
    'UrlMapArgs',
    'VolumeArgs',
    'VpcAccessConnectorArgs',
    'ZipInfoArgs',
]

@pulumi.input_type
class ApiConfigHandlerArgs:
    def __init__(__self__, *,
                 auth_fail_action: Optional[pulumi.Input[str]] = None,
                 login: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None,
                 security_level: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Google Cloud Endpoints (https://cloud.google.com/appengine/docs/python/endpoints/) configuration for API handlers.
        :param pulumi.Input[str] auth_fail_action: Action to take when users access resources that require authentication. Defaults to redirect.
        :param pulumi.Input[str] login: Level of login required to access this resource. Defaults to optional.
        :param pulumi.Input[str] script: Path to the script from the application root directory.
        :param pulumi.Input[str] security_level: Security (HTTPS) enforcement for this URL.
        :param pulumi.Input[str] url: URL to serve the endpoint at.
        """
        if auth_fail_action is not None:
            pulumi.set(__self__, "auth_fail_action", auth_fail_action)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if security_level is not None:
            pulumi.set(__self__, "security_level", security_level)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="authFailAction")
    def auth_fail_action(self) -> Optional[pulumi.Input[str]]:
        """
        Action to take when users access resources that require authentication. Defaults to redirect.
        """
        return pulumi.get(self, "auth_fail_action")

    @auth_fail_action.setter
    def auth_fail_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_fail_action", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[str]]:
        """
        Level of login required to access this resource. Defaults to optional.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the script from the application root directory.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="securityLevel")
    def security_level(self) -> Optional[pulumi.Input[str]]:
        """
        Security (HTTPS) enforcement for this URL.
        """
        return pulumi.get(self, "security_level")

    @security_level.setter
    def security_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_level", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        URL to serve the endpoint at.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class ApiEndpointHandlerArgs:
    def __init__(__self__, *,
                 script_path: Optional[pulumi.Input[str]] = None):
        """
        Uses Google Cloud Endpoints to handle requests.
        :param pulumi.Input[str] script_path: Path to the script from the application root directory.
        """
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)

    @property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the script from the application root directory.
        """
        return pulumi.get(self, "script_path")

    @script_path.setter
    def script_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_path", value)


@pulumi.input_type
class AutomaticScalingArgs:
    def __init__(__self__, *,
                 cool_down_period: Optional[pulumi.Input[str]] = None,
                 cpu_utilization: Optional[pulumi.Input['CpuUtilizationArgs']] = None,
                 disk_utilization: Optional[pulumi.Input['DiskUtilizationArgs']] = None,
                 max_concurrent_requests: Optional[pulumi.Input[int]] = None,
                 max_idle_instances: Optional[pulumi.Input[int]] = None,
                 max_pending_latency: Optional[pulumi.Input[str]] = None,
                 max_total_instances: Optional[pulumi.Input[int]] = None,
                 min_idle_instances: Optional[pulumi.Input[int]] = None,
                 min_pending_latency: Optional[pulumi.Input[str]] = None,
                 min_total_instances: Optional[pulumi.Input[int]] = None,
                 network_utilization: Optional[pulumi.Input['NetworkUtilizationArgs']] = None,
                 request_utilization: Optional[pulumi.Input['RequestUtilizationArgs']] = None,
                 standard_scheduler_settings: Optional[pulumi.Input['StandardSchedulerSettingsArgs']] = None):
        """
        Automatic scaling is based on request rate, response latencies, and other application metrics.
        :param pulumi.Input[str] cool_down_period: The time period that the Autoscaler (https://cloud.google.com/compute/docs/autoscaler/) should wait before it starts collecting information from a new instance. This prevents the autoscaler from collecting information when the instance is initializing, during which the collected usage would not be reliable. Only applicable in the App Engine flexible environment.
        :param pulumi.Input['CpuUtilizationArgs'] cpu_utilization: Target scaling by CPU usage.
        :param pulumi.Input['DiskUtilizationArgs'] disk_utilization: Target scaling by disk usage.
        :param pulumi.Input[int] max_concurrent_requests: Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.Defaults to a runtime-specific value.
        :param pulumi.Input[int] max_idle_instances: Maximum number of idle instances that should be maintained for this version.
        :param pulumi.Input[str] max_pending_latency: Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
        :param pulumi.Input[int] max_total_instances: Maximum number of instances that should be started to handle requests for this version.
        :param pulumi.Input[int] min_idle_instances: Minimum number of idle instances that should be maintained for this version. Only applicable for the default version of a service.
        :param pulumi.Input[str] min_pending_latency: Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
        :param pulumi.Input[int] min_total_instances: Minimum number of running instances that should be maintained for this version.
        :param pulumi.Input['NetworkUtilizationArgs'] network_utilization: Target scaling by network usage.
        :param pulumi.Input['RequestUtilizationArgs'] request_utilization: Target scaling by request utilization.
        :param pulumi.Input['StandardSchedulerSettingsArgs'] standard_scheduler_settings: Scheduler settings for standard environment.
        """
        if cool_down_period is not None:
            pulumi.set(__self__, "cool_down_period", cool_down_period)
        if cpu_utilization is not None:
            pulumi.set(__self__, "cpu_utilization", cpu_utilization)
        if disk_utilization is not None:
            pulumi.set(__self__, "disk_utilization", disk_utilization)
        if max_concurrent_requests is not None:
            pulumi.set(__self__, "max_concurrent_requests", max_concurrent_requests)
        if max_idle_instances is not None:
            pulumi.set(__self__, "max_idle_instances", max_idle_instances)
        if max_pending_latency is not None:
            pulumi.set(__self__, "max_pending_latency", max_pending_latency)
        if max_total_instances is not None:
            pulumi.set(__self__, "max_total_instances", max_total_instances)
        if min_idle_instances is not None:
            pulumi.set(__self__, "min_idle_instances", min_idle_instances)
        if min_pending_latency is not None:
            pulumi.set(__self__, "min_pending_latency", min_pending_latency)
        if min_total_instances is not None:
            pulumi.set(__self__, "min_total_instances", min_total_instances)
        if network_utilization is not None:
            pulumi.set(__self__, "network_utilization", network_utilization)
        if request_utilization is not None:
            pulumi.set(__self__, "request_utilization", request_utilization)
        if standard_scheduler_settings is not None:
            pulumi.set(__self__, "standard_scheduler_settings", standard_scheduler_settings)

    @property
    @pulumi.getter(name="coolDownPeriod")
    def cool_down_period(self) -> Optional[pulumi.Input[str]]:
        """
        The time period that the Autoscaler (https://cloud.google.com/compute/docs/autoscaler/) should wait before it starts collecting information from a new instance. This prevents the autoscaler from collecting information when the instance is initializing, during which the collected usage would not be reliable. Only applicable in the App Engine flexible environment.
        """
        return pulumi.get(self, "cool_down_period")

    @cool_down_period.setter
    def cool_down_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cool_down_period", value)

    @property
    @pulumi.getter(name="cpuUtilization")
    def cpu_utilization(self) -> Optional[pulumi.Input['CpuUtilizationArgs']]:
        """
        Target scaling by CPU usage.
        """
        return pulumi.get(self, "cpu_utilization")

    @cpu_utilization.setter
    def cpu_utilization(self, value: Optional[pulumi.Input['CpuUtilizationArgs']]):
        pulumi.set(self, "cpu_utilization", value)

    @property
    @pulumi.getter(name="diskUtilization")
    def disk_utilization(self) -> Optional[pulumi.Input['DiskUtilizationArgs']]:
        """
        Target scaling by disk usage.
        """
        return pulumi.get(self, "disk_utilization")

    @disk_utilization.setter
    def disk_utilization(self, value: Optional[pulumi.Input['DiskUtilizationArgs']]):
        pulumi.set(self, "disk_utilization", value)

    @property
    @pulumi.getter(name="maxConcurrentRequests")
    def max_concurrent_requests(self) -> Optional[pulumi.Input[int]]:
        """
        Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.Defaults to a runtime-specific value.
        """
        return pulumi.get(self, "max_concurrent_requests")

    @max_concurrent_requests.setter
    def max_concurrent_requests(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_requests", value)

    @property
    @pulumi.getter(name="maxIdleInstances")
    def max_idle_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of idle instances that should be maintained for this version.
        """
        return pulumi.get(self, "max_idle_instances")

    @max_idle_instances.setter
    def max_idle_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_idle_instances", value)

    @property
    @pulumi.getter(name="maxPendingLatency")
    def max_pending_latency(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
        """
        return pulumi.get(self, "max_pending_latency")

    @max_pending_latency.setter
    def max_pending_latency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_pending_latency", value)

    @property
    @pulumi.getter(name="maxTotalInstances")
    def max_total_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of instances that should be started to handle requests for this version.
        """
        return pulumi.get(self, "max_total_instances")

    @max_total_instances.setter
    def max_total_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_total_instances", value)

    @property
    @pulumi.getter(name="minIdleInstances")
    def min_idle_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of idle instances that should be maintained for this version. Only applicable for the default version of a service.
        """
        return pulumi.get(self, "min_idle_instances")

    @min_idle_instances.setter
    def min_idle_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_idle_instances", value)

    @property
    @pulumi.getter(name="minPendingLatency")
    def min_pending_latency(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
        """
        return pulumi.get(self, "min_pending_latency")

    @min_pending_latency.setter
    def min_pending_latency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_pending_latency", value)

    @property
    @pulumi.getter(name="minTotalInstances")
    def min_total_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of running instances that should be maintained for this version.
        """
        return pulumi.get(self, "min_total_instances")

    @min_total_instances.setter
    def min_total_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_total_instances", value)

    @property
    @pulumi.getter(name="networkUtilization")
    def network_utilization(self) -> Optional[pulumi.Input['NetworkUtilizationArgs']]:
        """
        Target scaling by network usage.
        """
        return pulumi.get(self, "network_utilization")

    @network_utilization.setter
    def network_utilization(self, value: Optional[pulumi.Input['NetworkUtilizationArgs']]):
        pulumi.set(self, "network_utilization", value)

    @property
    @pulumi.getter(name="requestUtilization")
    def request_utilization(self) -> Optional[pulumi.Input['RequestUtilizationArgs']]:
        """
        Target scaling by request utilization.
        """
        return pulumi.get(self, "request_utilization")

    @request_utilization.setter
    def request_utilization(self, value: Optional[pulumi.Input['RequestUtilizationArgs']]):
        pulumi.set(self, "request_utilization", value)

    @property
    @pulumi.getter(name="standardSchedulerSettings")
    def standard_scheduler_settings(self) -> Optional[pulumi.Input['StandardSchedulerSettingsArgs']]:
        """
        Scheduler settings for standard environment.
        """
        return pulumi.get(self, "standard_scheduler_settings")

    @standard_scheduler_settings.setter
    def standard_scheduler_settings(self, value: Optional[pulumi.Input['StandardSchedulerSettingsArgs']]):
        pulumi.set(self, "standard_scheduler_settings", value)


@pulumi.input_type
class BasicScalingArgs:
    def __init__(__self__, *,
                 idle_timeout: Optional[pulumi.Input[str]] = None,
                 max_instances: Optional[pulumi.Input[int]] = None):
        """
        A service with basic scaling will create an instance when the application receives a request. The instance will be turned down when the app becomes idle. Basic scaling is ideal for work that is intermittent or driven by user activity.
        :param pulumi.Input[str] idle_timeout: Duration of time after the last request that an instance must wait before the instance is shut down.
        :param pulumi.Input[int] max_instances: Maximum number of instances to create for this version.
        """
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Duration of time after the last request that an instance must wait before the instance is shut down.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_timeout", value)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of instances to create for this version.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instances", value)


@pulumi.input_type
class CertificateRawDataArgs:
    def __init__(__self__, *,
                 private_key: Optional[pulumi.Input[str]] = None,
                 public_certificate: Optional[pulumi.Input[str]] = None):
        """
        An SSL certificate obtained from a certificate authority.
        :param pulumi.Input[str] private_key: Unencrypted PEM encoded RSA private key. This field is set once on certificate creation and then encrypted. The key size must be 2048 bits or fewer. Must include the header and footer. Example: -----BEGIN RSA PRIVATE KEY----- -----END RSA PRIVATE KEY----- @InputOnly
        :param pulumi.Input[str] public_certificate: PEM encoded x.509 public key certificate. This field is set once on certificate creation. Must include the header and footer. Example: -----BEGIN CERTIFICATE----- -----END CERTIFICATE----- 
        """
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_certificate is not None:
            pulumi.set(__self__, "public_certificate", public_certificate)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        Unencrypted PEM encoded RSA private key. This field is set once on certificate creation and then encrypted. The key size must be 2048 bits or fewer. Must include the header and footer. Example: -----BEGIN RSA PRIVATE KEY----- -----END RSA PRIVATE KEY----- @InputOnly
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        PEM encoded x.509 public key certificate. This field is set once on certificate creation. Must include the header and footer. Example: -----BEGIN CERTIFICATE----- -----END CERTIFICATE----- 
        """
        return pulumi.get(self, "public_certificate")

    @public_certificate.setter
    def public_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_certificate", value)


@pulumi.input_type
class CloudBuildOptionsArgs:
    def __init__(__self__, *,
                 app_yaml_path: Optional[pulumi.Input[str]] = None,
                 cloud_build_timeout: Optional[pulumi.Input[str]] = None):
        """
        Options for the build operations performed as a part of the version deployment. Only applicable for App Engine flexible environment when creating a version using source code directly.
        :param pulumi.Input[str] app_yaml_path: Path to the yaml file used in deployment, used to determine runtime configuration details.Required for flexible environment builds.See https://cloud.google.com/appengine/docs/standard/python/config/appref for more details.
        :param pulumi.Input[str] cloud_build_timeout: The Cloud Build timeout used as part of any dependent builds performed by version creation. Defaults to 10 minutes.
        """
        if app_yaml_path is not None:
            pulumi.set(__self__, "app_yaml_path", app_yaml_path)
        if cloud_build_timeout is not None:
            pulumi.set(__self__, "cloud_build_timeout", cloud_build_timeout)

    @property
    @pulumi.getter(name="appYamlPath")
    def app_yaml_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the yaml file used in deployment, used to determine runtime configuration details.Required for flexible environment builds.See https://cloud.google.com/appengine/docs/standard/python/config/appref for more details.
        """
        return pulumi.get(self, "app_yaml_path")

    @app_yaml_path.setter
    def app_yaml_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_yaml_path", value)

    @property
    @pulumi.getter(name="cloudBuildTimeout")
    def cloud_build_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Build timeout used as part of any dependent builds performed by version creation. Defaults to 10 minutes.
        """
        return pulumi.get(self, "cloud_build_timeout")

    @cloud_build_timeout.setter
    def cloud_build_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_build_timeout", value)


@pulumi.input_type
class ContainerInfoArgs:
    def __init__(__self__, *,
                 image: Optional[pulumi.Input[str]] = None):
        """
        Docker image that is used to create a container and start a VM instance for the version that you deploy. Only applicable for instances running in the App Engine flexible environment.
        :param pulumi.Input[str] image: URI to the hosted container image in Google Container Registry. The URI must be fully qualified and include a tag or digest. Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
        """
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        URI to the hosted container image in Google Container Registry. The URI must be fully qualified and include a tag or digest. Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)


@pulumi.input_type
class CpuUtilizationArgs:
    def __init__(__self__, *,
                 aggregation_window_length: Optional[pulumi.Input[str]] = None,
                 target_utilization: Optional[pulumi.Input[float]] = None):
        """
        Target scaling by CPU usage.
        :param pulumi.Input[str] aggregation_window_length: Period of time over which CPU utilization is calculated.
        :param pulumi.Input[float] target_utilization: Target CPU utilization ratio to maintain when scaling. Must be between 0 and 1.
        """
        if aggregation_window_length is not None:
            pulumi.set(__self__, "aggregation_window_length", aggregation_window_length)
        if target_utilization is not None:
            pulumi.set(__self__, "target_utilization", target_utilization)

    @property
    @pulumi.getter(name="aggregationWindowLength")
    def aggregation_window_length(self) -> Optional[pulumi.Input[str]]:
        """
        Period of time over which CPU utilization is calculated.
        """
        return pulumi.get(self, "aggregation_window_length")

    @aggregation_window_length.setter
    def aggregation_window_length(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aggregation_window_length", value)

    @property
    @pulumi.getter(name="targetUtilization")
    def target_utilization(self) -> Optional[pulumi.Input[float]]:
        """
        Target CPU utilization ratio to maintain when scaling. Must be between 0 and 1.
        """
        return pulumi.get(self, "target_utilization")

    @target_utilization.setter
    def target_utilization(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "target_utilization", value)


@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 cloud_build_options: Optional[pulumi.Input['CloudBuildOptionsArgs']] = None,
                 container: Optional[pulumi.Input['ContainerInfoArgs']] = None,
                 files: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zip: Optional[pulumi.Input['ZipInfoArgs']] = None):
        """
        Code and application artifacts used to deploy a version to App Engine.
        :param pulumi.Input['CloudBuildOptionsArgs'] cloud_build_options: Options for any Google Cloud Build builds created as a part of this deployment.These options will only be used if a new build is created, such as when deploying to the App Engine flexible environment using files or zip.
        :param pulumi.Input['ContainerInfoArgs'] container: The Docker image for the container that runs the version. Only applicable for instances running in the App Engine flexible environment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] files: Manifest of the files stored in Google Cloud Storage that are included as part of this version. All files must be readable using the credentials supplied with this call.
        :param pulumi.Input['ZipInfoArgs'] zip: The zip file for this deployment, if this is a zip deployment.
        """
        if cloud_build_options is not None:
            pulumi.set(__self__, "cloud_build_options", cloud_build_options)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if zip is not None:
            pulumi.set(__self__, "zip", zip)

    @property
    @pulumi.getter(name="cloudBuildOptions")
    def cloud_build_options(self) -> Optional[pulumi.Input['CloudBuildOptionsArgs']]:
        """
        Options for any Google Cloud Build builds created as a part of this deployment.These options will only be used if a new build is created, such as when deploying to the App Engine flexible environment using files or zip.
        """
        return pulumi.get(self, "cloud_build_options")

    @cloud_build_options.setter
    def cloud_build_options(self, value: Optional[pulumi.Input['CloudBuildOptionsArgs']]):
        pulumi.set(self, "cloud_build_options", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['ContainerInfoArgs']]:
        """
        The Docker image for the container that runs the version. Only applicable for instances running in the App Engine flexible environment.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['ContainerInfoArgs']]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Manifest of the files stored in Google Cloud Storage that are included as part of this version. All files must be readable using the credentials supplied with this call.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter
    def zip(self) -> Optional[pulumi.Input['ZipInfoArgs']]:
        """
        The zip file for this deployment, if this is a zip deployment.
        """
        return pulumi.get(self, "zip")

    @zip.setter
    def zip(self, value: Optional[pulumi.Input['ZipInfoArgs']]):
        pulumi.set(self, "zip", value)


@pulumi.input_type
class DiskUtilizationArgs:
    def __init__(__self__, *,
                 target_read_bytes_per_second: Optional[pulumi.Input[int]] = None,
                 target_read_ops_per_second: Optional[pulumi.Input[int]] = None,
                 target_write_bytes_per_second: Optional[pulumi.Input[int]] = None,
                 target_write_ops_per_second: Optional[pulumi.Input[int]] = None):
        """
        Target scaling by disk usage. Only applicable in the App Engine flexible environment.
        :param pulumi.Input[int] target_read_bytes_per_second: Target bytes read per second.
        :param pulumi.Input[int] target_read_ops_per_second: Target ops read per seconds.
        :param pulumi.Input[int] target_write_bytes_per_second: Target bytes written per second.
        :param pulumi.Input[int] target_write_ops_per_second: Target ops written per second.
        """
        if target_read_bytes_per_second is not None:
            pulumi.set(__self__, "target_read_bytes_per_second", target_read_bytes_per_second)
        if target_read_ops_per_second is not None:
            pulumi.set(__self__, "target_read_ops_per_second", target_read_ops_per_second)
        if target_write_bytes_per_second is not None:
            pulumi.set(__self__, "target_write_bytes_per_second", target_write_bytes_per_second)
        if target_write_ops_per_second is not None:
            pulumi.set(__self__, "target_write_ops_per_second", target_write_ops_per_second)

    @property
    @pulumi.getter(name="targetReadBytesPerSecond")
    def target_read_bytes_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        Target bytes read per second.
        """
        return pulumi.get(self, "target_read_bytes_per_second")

    @target_read_bytes_per_second.setter
    def target_read_bytes_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_read_bytes_per_second", value)

    @property
    @pulumi.getter(name="targetReadOpsPerSecond")
    def target_read_ops_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        Target ops read per seconds.
        """
        return pulumi.get(self, "target_read_ops_per_second")

    @target_read_ops_per_second.setter
    def target_read_ops_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_read_ops_per_second", value)

    @property
    @pulumi.getter(name="targetWriteBytesPerSecond")
    def target_write_bytes_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        Target bytes written per second.
        """
        return pulumi.get(self, "target_write_bytes_per_second")

    @target_write_bytes_per_second.setter
    def target_write_bytes_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_write_bytes_per_second", value)

    @property
    @pulumi.getter(name="targetWriteOpsPerSecond")
    def target_write_ops_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        Target ops written per second.
        """
        return pulumi.get(self, "target_write_ops_per_second")

    @target_write_ops_per_second.setter
    def target_write_ops_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_write_ops_per_second", value)


@pulumi.input_type
class EndpointsApiServiceArgs:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[str]] = None,
                 disable_trace_sampling: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rollout_strategy: Optional[pulumi.Input[str]] = None):
        """
        Cloud Endpoints (https://cloud.google.com/endpoints) configuration. The Endpoints API Service provides tooling for serving Open API and gRPC endpoints via an NGINX proxy. Only valid for App Engine Flexible environment deployments.The fields here refer to the name and configuration ID of a "service" resource in the Service Management API (https://cloud.google.com/service-management/overview).
        :param pulumi.Input[str] config_id: Endpoints service configuration ID as specified by the Service Management API. For example "2016-09-19r1".By default, the rollout strategy for Endpoints is RolloutStrategy.FIXED. This means that Endpoints starts up with a particular configuration ID. When a new configuration is rolled out, Endpoints must be given the new configuration ID. The config_id field is used to give the configuration ID and is required in this case.Endpoints also has a rollout strategy called RolloutStrategy.MANAGED. When using this, Endpoints fetches the latest configuration and does not need the configuration ID. In this case, config_id must be omitted.
        :param pulumi.Input[bool] disable_trace_sampling: Enable or disable trace sampling. By default, this is set to false for enabled.
        :param pulumi.Input[str] name: Endpoints service name which is the name of the "service" resource in the Service Management API. For example "myapi.endpoints.myproject.cloud.goog"
        :param pulumi.Input[str] rollout_strategy: Endpoints rollout strategy. If FIXED, config_id must be specified. If MANAGED, config_id must be omitted.
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if disable_trace_sampling is not None:
            pulumi.set(__self__, "disable_trace_sampling", disable_trace_sampling)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rollout_strategy is not None:
            pulumi.set(__self__, "rollout_strategy", rollout_strategy)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[str]]:
        """
        Endpoints service configuration ID as specified by the Service Management API. For example "2016-09-19r1".By default, the rollout strategy for Endpoints is RolloutStrategy.FIXED. This means that Endpoints starts up with a particular configuration ID. When a new configuration is rolled out, Endpoints must be given the new configuration ID. The config_id field is used to give the configuration ID and is required in this case.Endpoints also has a rollout strategy called RolloutStrategy.MANAGED. When using this, Endpoints fetches the latest configuration and does not need the configuration ID. In this case, config_id must be omitted.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter(name="disableTraceSampling")
    def disable_trace_sampling(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable trace sampling. By default, this is set to false for enabled.
        """
        return pulumi.get(self, "disable_trace_sampling")

    @disable_trace_sampling.setter
    def disable_trace_sampling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_trace_sampling", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Endpoints service name which is the name of the "service" resource in the Service Management API. For example "myapi.endpoints.myproject.cloud.goog"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rolloutStrategy")
    def rollout_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Endpoints rollout strategy. If FIXED, config_id must be specified. If MANAGED, config_id must be omitted.
        """
        return pulumi.get(self, "rollout_strategy")

    @rollout_strategy.setter
    def rollout_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rollout_strategy", value)


@pulumi.input_type
class EntrypointArgs:
    def __init__(__self__, *,
                 shell: Optional[pulumi.Input[str]] = None):
        """
        The entrypoint for the application.
        :param pulumi.Input[str] shell: The format should be a shell command that can be fed to bash -c.
        """
        if shell is not None:
            pulumi.set(__self__, "shell", shell)

    @property
    @pulumi.getter
    def shell(self) -> Optional[pulumi.Input[str]]:
        """
        The format should be a shell command that can be fed to bash -c.
        """
        return pulumi.get(self, "shell")

    @shell.setter
    def shell(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shell", value)


@pulumi.input_type
class ErrorHandlerArgs:
    def __init__(__self__, *,
                 error_code: Optional[pulumi.Input[str]] = None,
                 mime_type: Optional[pulumi.Input[str]] = None,
                 static_file: Optional[pulumi.Input[str]] = None):
        """
        Custom static error page to be served when an error occurs.
        :param pulumi.Input[str] error_code: Error condition this handler applies to.
        :param pulumi.Input[str] mime_type: MIME type of file. Defaults to text/html.
        :param pulumi.Input[str] static_file: Static file content to be served for this error.
        """
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if mime_type is not None:
            pulumi.set(__self__, "mime_type", mime_type)
        if static_file is not None:
            pulumi.set(__self__, "static_file", static_file)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[pulumi.Input[str]]:
        """
        Error condition this handler applies to.
        """
        return pulumi.get(self, "error_code")

    @error_code.setter
    def error_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_code", value)

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> Optional[pulumi.Input[str]]:
        """
        MIME type of file. Defaults to text/html.
        """
        return pulumi.get(self, "mime_type")

    @mime_type.setter
    def mime_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mime_type", value)

    @property
    @pulumi.getter(name="staticFile")
    def static_file(self) -> Optional[pulumi.Input[str]]:
        """
        Static file content to be served for this error.
        """
        return pulumi.get(self, "static_file")

    @static_file.setter
    def static_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "static_file", value)


@pulumi.input_type
class FeatureSettingsArgs:
    def __init__(__self__, *,
                 split_health_checks: Optional[pulumi.Input[bool]] = None,
                 use_container_optimized_os: Optional[pulumi.Input[bool]] = None):
        """
        The feature specific settings to be used in the application. These define behaviors that are user configurable.
        :param pulumi.Input[bool] split_health_checks: Boolean value indicating if split health checks should be used instead of the legacy health checks. At an app.yaml level, this means defaulting to 'readiness_check' and 'liveness_check' values instead of 'health_check' ones. Once the legacy 'health_check' behavior is deprecated, and this value is always true, this setting can be removed.
        :param pulumi.Input[bool] use_container_optimized_os: If true, use Container-Optimized OS (https://cloud.google.com/container-optimized-os/) base image for VMs, rather than a base Debian image.
        """
        if split_health_checks is not None:
            pulumi.set(__self__, "split_health_checks", split_health_checks)
        if use_container_optimized_os is not None:
            pulumi.set(__self__, "use_container_optimized_os", use_container_optimized_os)

    @property
    @pulumi.getter(name="splitHealthChecks")
    def split_health_checks(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value indicating if split health checks should be used instead of the legacy health checks. At an app.yaml level, this means defaulting to 'readiness_check' and 'liveness_check' values instead of 'health_check' ones. Once the legacy 'health_check' behavior is deprecated, and this value is always true, this setting can be removed.
        """
        return pulumi.get(self, "split_health_checks")

    @split_health_checks.setter
    def split_health_checks(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "split_health_checks", value)

    @property
    @pulumi.getter(name="useContainerOptimizedOs")
    def use_container_optimized_os(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, use Container-Optimized OS (https://cloud.google.com/container-optimized-os/) base image for VMs, rather than a base Debian image.
        """
        return pulumi.get(self, "use_container_optimized_os")

    @use_container_optimized_os.setter
    def use_container_optimized_os(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_container_optimized_os", value)


@pulumi.input_type
class HealthCheckArgs:
    def __init__(__self__, *,
                 check_interval: Optional[pulumi.Input[str]] = None,
                 disable_health_check: Optional[pulumi.Input[bool]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 restart_threshold: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None):
        """
        Health checking configuration for VM instances. Unhealthy instances are killed and replaced with new instances. Only applicable for instances in App Engine flexible environment.
        :param pulumi.Input[str] check_interval: Interval between health checks.
        :param pulumi.Input[bool] disable_health_check: Whether to explicitly disable health checks for this instance.
        :param pulumi.Input[int] healthy_threshold: Number of consecutive successful health checks required before receiving traffic.
        :param pulumi.Input[str] host: Host header to send when performing an HTTP health check. Example: "myapp.appspot.com"
        :param pulumi.Input[int] restart_threshold: Number of consecutive failed health checks required before an instance is restarted.
        :param pulumi.Input[str] timeout: Time before the health check is considered failed.
        :param pulumi.Input[int] unhealthy_threshold: Number of consecutive failed health checks required before removing traffic.
        """
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if disable_health_check is not None:
            pulumi.set(__self__, "disable_health_check", disable_health_check)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if restart_threshold is not None:
            pulumi.set(__self__, "restart_threshold", restart_threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Interval between health checks.
        """
        return pulumi.get(self, "check_interval")

    @check_interval.setter
    def check_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "check_interval", value)

    @property
    @pulumi.getter(name="disableHealthCheck")
    def disable_health_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to explicitly disable health checks for this instance.
        """
        return pulumi.get(self, "disable_health_check")

    @disable_health_check.setter
    def disable_health_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_health_check", value)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of consecutive successful health checks required before receiving traffic.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "healthy_threshold", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Host header to send when performing an HTTP health check. Example: "myapp.appspot.com"
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="restartThreshold")
    def restart_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of consecutive failed health checks required before an instance is restarted.
        """
        return pulumi.get(self, "restart_threshold")

    @restart_threshold.setter
    def restart_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "restart_threshold", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Time before the health check is considered failed.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of consecutive failed health checks required before removing traffic.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unhealthy_threshold", value)


@pulumi.input_type
class IdentityAwareProxyArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 oauth2_client_id: Optional[pulumi.Input[str]] = None,
                 oauth2_client_secret: Optional[pulumi.Input[str]] = None,
                 oauth2_client_secret_sha256: Optional[pulumi.Input[str]] = None):
        """
        Identity-Aware Proxy
        :param pulumi.Input[bool] enabled: Whether the serving infrastructure will authenticate and authorize all incoming requests.If true, the oauth2_client_id and oauth2_client_secret fields must be non-empty.
        :param pulumi.Input[str] oauth2_client_id: OAuth2 client ID to use for the authentication flow.
        :param pulumi.Input[str] oauth2_client_secret: OAuth2 client secret to use for the authentication flow.For security reasons, this value cannot be retrieved via the API. Instead, the SHA-256 hash of the value is returned in the oauth2_client_secret_sha256 field.@InputOnly
        :param pulumi.Input[str] oauth2_client_secret_sha256: Hex-encoded SHA-256 hash of the client secret.@OutputOnly
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if oauth2_client_id is not None:
            pulumi.set(__self__, "oauth2_client_id", oauth2_client_id)
        if oauth2_client_secret is not None:
            pulumi.set(__self__, "oauth2_client_secret", oauth2_client_secret)
        if oauth2_client_secret_sha256 is not None:
            pulumi.set(__self__, "oauth2_client_secret_sha256", oauth2_client_secret_sha256)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the serving infrastructure will authenticate and authorize all incoming requests.If true, the oauth2_client_id and oauth2_client_secret fields must be non-empty.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="oauth2ClientId")
    def oauth2_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        OAuth2 client ID to use for the authentication flow.
        """
        return pulumi.get(self, "oauth2_client_id")

    @oauth2_client_id.setter
    def oauth2_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_client_id", value)

    @property
    @pulumi.getter(name="oauth2ClientSecret")
    def oauth2_client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        OAuth2 client secret to use for the authentication flow.For security reasons, this value cannot be retrieved via the API. Instead, the SHA-256 hash of the value is returned in the oauth2_client_secret_sha256 field.@InputOnly
        """
        return pulumi.get(self, "oauth2_client_secret")

    @oauth2_client_secret.setter
    def oauth2_client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_client_secret", value)

    @property
    @pulumi.getter(name="oauth2ClientSecretSha256")
    def oauth2_client_secret_sha256(self) -> Optional[pulumi.Input[str]]:
        """
        Hex-encoded SHA-256 hash of the client secret.@OutputOnly
        """
        return pulumi.get(self, "oauth2_client_secret_sha256")

    @oauth2_client_secret_sha256.setter
    def oauth2_client_secret_sha256(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_client_secret_sha256", value)


@pulumi.input_type
class LibraryArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Third-party Python runtime library that is required by the application.
        :param pulumi.Input[str] name: Name of the library. Example: "django".
        :param pulumi.Input[str] version: Version of the library to select, or "latest".
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the library. Example: "django".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the library to select, or "latest".
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class LivenessCheckArgs:
    def __init__(__self__, *,
                 check_interval: Optional[pulumi.Input[str]] = None,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 initial_delay: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 success_threshold: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Health checking configuration for VM instances. Unhealthy instances are killed and replaced with new instances.
        :param pulumi.Input[str] check_interval: Interval between health checks.
        :param pulumi.Input[int] failure_threshold: Number of consecutive failed checks required before considering the VM unhealthy.
        :param pulumi.Input[str] host: Host header to send when performing a HTTP Liveness check. Example: "myapp.appspot.com"
        :param pulumi.Input[str] initial_delay: The initial delay before starting to execute the checks.
        :param pulumi.Input[str] path: The request path.
        :param pulumi.Input[int] success_threshold: Number of consecutive successful checks required before considering the VM healthy.
        :param pulumi.Input[str] timeout: Time before the check is considered failed.
        """
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Interval between health checks.
        """
        return pulumi.get(self, "check_interval")

    @check_interval.setter
    def check_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "check_interval", value)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of consecutive failed checks required before considering the VM unhealthy.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Host header to send when performing a HTTP Liveness check. Example: "myapp.appspot.com"
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[pulumi.Input[str]]:
        """
        The initial delay before starting to execute the checks.
        """
        return pulumi.get(self, "initial_delay")

    @initial_delay.setter
    def initial_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_delay", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The request path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of consecutive successful checks required before considering the VM healthy.
        """
        return pulumi.get(self, "success_threshold")

    @success_threshold.setter
    def success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_threshold", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Time before the check is considered failed.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class ManagedCertificateArgs:
    def __init__(__self__, *,
                 last_renewal_time: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        A certificate managed by App Engine.
        :param pulumi.Input[str] last_renewal_time: Time at which the certificate was last renewed. The renewal process is fully managed. Certificate renewal will automatically occur before the certificate expires. Renewal errors can be tracked via ManagementStatus.@OutputOnly
        :param pulumi.Input[str] status: Status of certificate management. Refers to the most recent certificate acquisition or renewal attempt.@OutputOnly
        """
        if last_renewal_time is not None:
            pulumi.set(__self__, "last_renewal_time", last_renewal_time)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="lastRenewalTime")
    def last_renewal_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which the certificate was last renewed. The renewal process is fully managed. Certificate renewal will automatically occur before the certificate expires. Renewal errors can be tracked via ManagementStatus.@OutputOnly
        """
        return pulumi.get(self, "last_renewal_time")

    @last_renewal_time.setter
    def last_renewal_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_renewal_time", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of certificate management. Refers to the most recent certificate acquisition or renewal attempt.@OutputOnly
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ManualScalingArgs:
    def __init__(__self__, *,
                 instances: Optional[pulumi.Input[int]] = None):
        """
        A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
        :param pulumi.Input[int] instances: Number of instances to assign to the service at the start. This number can later be altered by using the Modules API (https://cloud.google.com/appengine/docs/python/modules/functions) set_num_instances() function.
        """
        if instances is not None:
            pulumi.set(__self__, "instances", instances)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[int]]:
        """
        Number of instances to assign to the service at the start. This number can later be altered by using the Modules API (https://cloud.google.com/appengine/docs/python/modules/functions) set_num_instances() function.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instances", value)


@pulumi.input_type
class NetworkArgs:
    def __init__(__self__, *,
                 forwarded_ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_tag: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 session_affinity: Optional[pulumi.Input[bool]] = None,
                 subnetwork_name: Optional[pulumi.Input[str]] = None):
        """
        Extra network settings. Only applicable in the App Engine flexible environment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] forwarded_ports: List of ports, or port pairs, to forward from the virtual machine to the application container. Only applicable in the App Engine flexible environment.
        :param pulumi.Input[str] instance_tag: Tag to apply to the instance during creation. Only applicable in the App Engine flexible environment.
        :param pulumi.Input[str] name: Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.Defaults to default.
        :param pulumi.Input[bool] session_affinity: Enable session affinity. Only applicable in the App Engine flexible environment.
        :param pulumi.Input[str] subnetwork_name: Google Cloud Platform sub-network where the virtual machines are created. Specify the short name, not the resource path.If a subnetwork name is specified, a network name will also be required unless it is for the default network. If the network that the instance is being created in is a Legacy network, then the IP address is allocated from the IPv4Range. If the network that the instance is being created in is an auto Subnet Mode Network, then only network name should be specified (not the subnetwork_name) and the IP address is created from the IPCidrRange of the subnetwork that exists in that zone for that network. If the network that the instance is being created in is a custom Subnet Mode Network, then the subnetwork_name must be specified and the IP address is created from the IPCidrRange of the subnetwork.If specified, the subnetwork must exist in the same region as the App Engine flexible environment application.
        """
        if forwarded_ports is not None:
            pulumi.set(__self__, "forwarded_ports", forwarded_ports)
        if instance_tag is not None:
            pulumi.set(__self__, "instance_tag", instance_tag)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if subnetwork_name is not None:
            pulumi.set(__self__, "subnetwork_name", subnetwork_name)

    @property
    @pulumi.getter(name="forwardedPorts")
    def forwarded_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of ports, or port pairs, to forward from the virtual machine to the application container. Only applicable in the App Engine flexible environment.
        """
        return pulumi.get(self, "forwarded_ports")

    @forwarded_ports.setter
    def forwarded_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "forwarded_ports", value)

    @property
    @pulumi.getter(name="instanceTag")
    def instance_tag(self) -> Optional[pulumi.Input[str]]:
        """
        Tag to apply to the instance during creation. Only applicable in the App Engine flexible environment.
        """
        return pulumi.get(self, "instance_tag")

    @instance_tag.setter
    def instance_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_tag", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.Defaults to default.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable session affinity. Only applicable in the App Engine flexible environment.
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "session_affinity", value)

    @property
    @pulumi.getter(name="subnetworkName")
    def subnetwork_name(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Platform sub-network where the virtual machines are created. Specify the short name, not the resource path.If a subnetwork name is specified, a network name will also be required unless it is for the default network. If the network that the instance is being created in is a Legacy network, then the IP address is allocated from the IPv4Range. If the network that the instance is being created in is an auto Subnet Mode Network, then only network name should be specified (not the subnetwork_name) and the IP address is created from the IPCidrRange of the subnetwork that exists in that zone for that network. If the network that the instance is being created in is a custom Subnet Mode Network, then the subnetwork_name must be specified and the IP address is created from the IPCidrRange of the subnetwork.If specified, the subnetwork must exist in the same region as the App Engine flexible environment application.
        """
        return pulumi.get(self, "subnetwork_name")

    @subnetwork_name.setter
    def subnetwork_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork_name", value)


@pulumi.input_type
class NetworkUtilizationArgs:
    def __init__(__self__, *,
                 target_received_bytes_per_second: Optional[pulumi.Input[int]] = None,
                 target_received_packets_per_second: Optional[pulumi.Input[int]] = None,
                 target_sent_bytes_per_second: Optional[pulumi.Input[int]] = None,
                 target_sent_packets_per_second: Optional[pulumi.Input[int]] = None):
        """
        Target scaling by network usage. Only applicable in the App Engine flexible environment.
        :param pulumi.Input[int] target_received_bytes_per_second: Target bytes received per second.
        :param pulumi.Input[int] target_received_packets_per_second: Target packets received per second.
        :param pulumi.Input[int] target_sent_bytes_per_second: Target bytes sent per second.
        :param pulumi.Input[int] target_sent_packets_per_second: Target packets sent per second.
        """
        if target_received_bytes_per_second is not None:
            pulumi.set(__self__, "target_received_bytes_per_second", target_received_bytes_per_second)
        if target_received_packets_per_second is not None:
            pulumi.set(__self__, "target_received_packets_per_second", target_received_packets_per_second)
        if target_sent_bytes_per_second is not None:
            pulumi.set(__self__, "target_sent_bytes_per_second", target_sent_bytes_per_second)
        if target_sent_packets_per_second is not None:
            pulumi.set(__self__, "target_sent_packets_per_second", target_sent_packets_per_second)

    @property
    @pulumi.getter(name="targetReceivedBytesPerSecond")
    def target_received_bytes_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        Target bytes received per second.
        """
        return pulumi.get(self, "target_received_bytes_per_second")

    @target_received_bytes_per_second.setter
    def target_received_bytes_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_received_bytes_per_second", value)

    @property
    @pulumi.getter(name="targetReceivedPacketsPerSecond")
    def target_received_packets_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        Target packets received per second.
        """
        return pulumi.get(self, "target_received_packets_per_second")

    @target_received_packets_per_second.setter
    def target_received_packets_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_received_packets_per_second", value)

    @property
    @pulumi.getter(name="targetSentBytesPerSecond")
    def target_sent_bytes_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        Target bytes sent per second.
        """
        return pulumi.get(self, "target_sent_bytes_per_second")

    @target_sent_bytes_per_second.setter
    def target_sent_bytes_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_sent_bytes_per_second", value)

    @property
    @pulumi.getter(name="targetSentPacketsPerSecond")
    def target_sent_packets_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        Target packets sent per second.
        """
        return pulumi.get(self, "target_sent_packets_per_second")

    @target_sent_packets_per_second.setter
    def target_sent_packets_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_sent_packets_per_second", value)


@pulumi.input_type
class ReadinessCheckArgs:
    def __init__(__self__, *,
                 app_start_timeout: Optional[pulumi.Input[str]] = None,
                 check_interval: Optional[pulumi.Input[str]] = None,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 success_threshold: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Readiness checking configuration for VM instances. Unhealthy instances are removed from traffic rotation.
        :param pulumi.Input[str] app_start_timeout: A maximum time limit on application initialization, measured from moment the application successfully replies to a healthcheck until it is ready to serve traffic.
        :param pulumi.Input[str] check_interval: Interval between health checks.
        :param pulumi.Input[int] failure_threshold: Number of consecutive failed checks required before removing traffic.
        :param pulumi.Input[str] host: Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"
        :param pulumi.Input[str] path: The request path.
        :param pulumi.Input[int] success_threshold: Number of consecutive successful checks required before receiving traffic.
        :param pulumi.Input[str] timeout: Time before the check is considered failed.
        """
        if app_start_timeout is not None:
            pulumi.set(__self__, "app_start_timeout", app_start_timeout)
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="appStartTimeout")
    def app_start_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        A maximum time limit on application initialization, measured from moment the application successfully replies to a healthcheck until it is ready to serve traffic.
        """
        return pulumi.get(self, "app_start_timeout")

    @app_start_timeout.setter
    def app_start_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_start_timeout", value)

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Interval between health checks.
        """
        return pulumi.get(self, "check_interval")

    @check_interval.setter
    def check_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "check_interval", value)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of consecutive failed checks required before removing traffic.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The request path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of consecutive successful checks required before receiving traffic.
        """
        return pulumi.get(self, "success_threshold")

    @success_threshold.setter
    def success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_threshold", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Time before the check is considered failed.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class RequestUtilizationArgs:
    def __init__(__self__, *,
                 target_concurrent_requests: Optional[pulumi.Input[int]] = None,
                 target_request_count_per_second: Optional[pulumi.Input[int]] = None):
        """
        Target scaling by request utilization. Only applicable in the App Engine flexible environment.
        :param pulumi.Input[int] target_concurrent_requests: Target number of concurrent requests.
        :param pulumi.Input[int] target_request_count_per_second: Target requests per second.
        """
        if target_concurrent_requests is not None:
            pulumi.set(__self__, "target_concurrent_requests", target_concurrent_requests)
        if target_request_count_per_second is not None:
            pulumi.set(__self__, "target_request_count_per_second", target_request_count_per_second)

    @property
    @pulumi.getter(name="targetConcurrentRequests")
    def target_concurrent_requests(self) -> Optional[pulumi.Input[int]]:
        """
        Target number of concurrent requests.
        """
        return pulumi.get(self, "target_concurrent_requests")

    @target_concurrent_requests.setter
    def target_concurrent_requests(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_concurrent_requests", value)

    @property
    @pulumi.getter(name="targetRequestCountPerSecond")
    def target_request_count_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        Target requests per second.
        """
        return pulumi.get(self, "target_request_count_per_second")

    @target_request_count_per_second.setter
    def target_request_count_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_request_count_per_second", value)


@pulumi.input_type
class ResourceRecordArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 rrdata: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        A DNS resource record.
        :param pulumi.Input[str] name: Relative name of the object affected by this record. Only applicable for CNAME records. Example: 'www'.
        :param pulumi.Input[str] rrdata: Data for this record. Values vary by record type, as defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
        :param pulumi.Input[str] type: Resource record type. Example: AAAA.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rrdata is not None:
            pulumi.set(__self__, "rrdata", rrdata)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Relative name of the object affected by this record. Only applicable for CNAME records. Example: 'www'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rrdata(self) -> Optional[pulumi.Input[str]]:
        """
        Data for this record. Values vary by record type, as defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
        """
        return pulumi.get(self, "rrdata")

    @rrdata.setter
    def rrdata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rrdata", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource record type. Example: AAAA.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ResourcesArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[float]] = None,
                 disk_gb: Optional[pulumi.Input[float]] = None,
                 kms_key_reference: Optional[pulumi.Input[str]] = None,
                 memory_gb: Optional[pulumi.Input[float]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]] = None):
        """
        Machine resources for a version.
        :param pulumi.Input[float] cpu: Number of CPU cores needed.
        :param pulumi.Input[float] disk_gb: Disk size (GB) needed.
        :param pulumi.Input[str] kms_key_reference: The name of the encryption key that is stored in Google Cloud KMS. Only should be used by Cloud Composer to encrypt the vm disk
        :param pulumi.Input[float] memory_gb: Memory (GB) needed.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]] volumes: User specified volumes.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if disk_gb is not None:
            pulumi.set(__self__, "disk_gb", disk_gb)
        if kms_key_reference is not None:
            pulumi.set(__self__, "kms_key_reference", kms_key_reference)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        Number of CPU cores needed.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="diskGb")
    def disk_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Disk size (GB) needed.
        """
        return pulumi.get(self, "disk_gb")

    @disk_gb.setter
    def disk_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "disk_gb", value)

    @property
    @pulumi.getter(name="kmsKeyReference")
    def kms_key_reference(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the encryption key that is stored in Google Cloud KMS. Only should be used by Cloud Composer to encrypt the vm disk
        """
        return pulumi.get(self, "kms_key_reference")

    @kms_key_reference.setter
    def kms_key_reference(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_reference", value)

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Memory (GB) needed.
        """
        return pulumi.get(self, "memory_gb")

    @memory_gb.setter
    def memory_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_gb", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]:
        """
        User specified volumes.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class ScriptHandlerArgs:
    def __init__(__self__, *,
                 script_path: Optional[pulumi.Input[str]] = None):
        """
        Executes a script to handle the request that matches the URL pattern.
        :param pulumi.Input[str] script_path: Path to the script from the application root directory.
        """
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)

    @property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the script from the application root directory.
        """
        return pulumi.get(self, "script_path")

    @script_path.setter
    def script_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_path", value)


@pulumi.input_type
class SslSettingsArgs:
    def __init__(__self__, *,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 pending_managed_certificate_id: Optional[pulumi.Input[str]] = None,
                 ssl_management_type: Optional[pulumi.Input[str]] = None):
        """
        SSL configuration for a DomainMapping resource.
        :param pulumi.Input[str] certificate_id: ID of the AuthorizedCertificate resource configuring SSL for the application. Clearing this field will remove SSL support.By default, a managed certificate is automatically created for every domain mapping. To omit SSL support or to configure SSL manually, specify SslManagementType.MANUAL on a CREATE or UPDATE request. You must be authorized to administer the AuthorizedCertificate resource to manually map it to a DomainMapping resource. Example: 12345.
        :param pulumi.Input[str] pending_managed_certificate_id: ID of the managed AuthorizedCertificate resource currently being provisioned, if applicable. Until the new managed certificate has been successfully provisioned, the previous SSL state will be preserved. Once the provisioning process completes, the certificate_id field will reflect the new managed certificate and this field will be left empty. To remove SSL support while there is still a pending managed certificate, clear the certificate_id field with an UpdateDomainMappingRequest.@OutputOnly
        :param pulumi.Input[str] ssl_management_type: SSL management type for this domain. If AUTOMATIC, a managed certificate is automatically provisioned. If MANUAL, certificate_id must be manually specified in order to configure SSL for this domain.
        """
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if pending_managed_certificate_id is not None:
            pulumi.set(__self__, "pending_managed_certificate_id", pending_managed_certificate_id)
        if ssl_management_type is not None:
            pulumi.set(__self__, "ssl_management_type", ssl_management_type)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the AuthorizedCertificate resource configuring SSL for the application. Clearing this field will remove SSL support.By default, a managed certificate is automatically created for every domain mapping. To omit SSL support or to configure SSL manually, specify SslManagementType.MANUAL on a CREATE or UPDATE request. You must be authorized to administer the AuthorizedCertificate resource to manually map it to a DomainMapping resource. Example: 12345.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="pendingManagedCertificateId")
    def pending_managed_certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the managed AuthorizedCertificate resource currently being provisioned, if applicable. Until the new managed certificate has been successfully provisioned, the previous SSL state will be preserved. Once the provisioning process completes, the certificate_id field will reflect the new managed certificate and this field will be left empty. To remove SSL support while there is still a pending managed certificate, clear the certificate_id field with an UpdateDomainMappingRequest.@OutputOnly
        """
        return pulumi.get(self, "pending_managed_certificate_id")

    @pending_managed_certificate_id.setter
    def pending_managed_certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pending_managed_certificate_id", value)

    @property
    @pulumi.getter(name="sslManagementType")
    def ssl_management_type(self) -> Optional[pulumi.Input[str]]:
        """
        SSL management type for this domain. If AUTOMATIC, a managed certificate is automatically provisioned. If MANUAL, certificate_id must be manually specified in order to configure SSL for this domain.
        """
        return pulumi.get(self, "ssl_management_type")

    @ssl_management_type.setter
    def ssl_management_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_management_type", value)


@pulumi.input_type
class StandardSchedulerSettingsArgs:
    def __init__(__self__, *,
                 max_instances: Optional[pulumi.Input[int]] = None,
                 min_instances: Optional[pulumi.Input[int]] = None,
                 target_cpu_utilization: Optional[pulumi.Input[float]] = None,
                 target_throughput_utilization: Optional[pulumi.Input[float]] = None):
        """
        Scheduler settings for standard environment.
        :param pulumi.Input[int] max_instances: Maximum number of instances to run for this version. Set to zero to disable max_instances configuration.
        :param pulumi.Input[int] min_instances: Minimum number of instances to run for this version. Set to zero to disable min_instances configuration.
        :param pulumi.Input[float] target_cpu_utilization: Target CPU utilization ratio to maintain when scaling.
        :param pulumi.Input[float] target_throughput_utilization: Target throughput utilization ratio to maintain when scaling
        """
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if target_cpu_utilization is not None:
            pulumi.set(__self__, "target_cpu_utilization", target_cpu_utilization)
        if target_throughput_utilization is not None:
            pulumi.set(__self__, "target_throughput_utilization", target_throughput_utilization)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of instances to run for this version. Set to zero to disable max_instances configuration.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instances", value)

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of instances to run for this version. Set to zero to disable min_instances configuration.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instances", value)

    @property
    @pulumi.getter(name="targetCpuUtilization")
    def target_cpu_utilization(self) -> Optional[pulumi.Input[float]]:
        """
        Target CPU utilization ratio to maintain when scaling.
        """
        return pulumi.get(self, "target_cpu_utilization")

    @target_cpu_utilization.setter
    def target_cpu_utilization(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "target_cpu_utilization", value)

    @property
    @pulumi.getter(name="targetThroughputUtilization")
    def target_throughput_utilization(self) -> Optional[pulumi.Input[float]]:
        """
        Target throughput utilization ratio to maintain when scaling
        """
        return pulumi.get(self, "target_throughput_utilization")

    @target_throughput_utilization.setter
    def target_throughput_utilization(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "target_throughput_utilization", value)


@pulumi.input_type
class StaticFilesHandlerArgs:
    def __init__(__self__, *,
                 application_readable: Optional[pulumi.Input[bool]] = None,
                 expiration: Optional[pulumi.Input[str]] = None,
                 http_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 mime_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 require_matching_file: Optional[pulumi.Input[bool]] = None,
                 upload_path_regex: Optional[pulumi.Input[str]] = None):
        """
        Files served directly to the user for a given URL, such as images, CSS stylesheets, or JavaScript source files. Static file handlers describe which files in the application directory are static files, and which URLs serve them.
        :param pulumi.Input[bool] application_readable: Whether files should also be uploaded as code data. By default, files declared in static file handlers are uploaded as static data and are only served to end users; they cannot be read by the application. If enabled, uploads are charged against both your code and static data storage resource quotas.
        :param pulumi.Input[str] expiration: Time a static file served by this handler should be cached by web proxies and browsers.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] http_headers: HTTP headers to use for all responses from these URLs.
        :param pulumi.Input[str] mime_type: MIME type used to serve all files served by this handler.Defaults to file-specific MIME types, which are derived from each file's filename extension.
        :param pulumi.Input[str] path: Path to the static files matched by the URL pattern, from the application root directory. The path can refer to text matched in groupings in the URL pattern.
        :param pulumi.Input[bool] require_matching_file: Whether this handler should match the request if the file referenced by the handler does not exist.
        :param pulumi.Input[str] upload_path_regex: Regular expression that matches the file paths for all files that should be referenced by this handler.
        """
        if application_readable is not None:
            pulumi.set(__self__, "application_readable", application_readable)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if mime_type is not None:
            pulumi.set(__self__, "mime_type", mime_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if require_matching_file is not None:
            pulumi.set(__self__, "require_matching_file", require_matching_file)
        if upload_path_regex is not None:
            pulumi.set(__self__, "upload_path_regex", upload_path_regex)

    @property
    @pulumi.getter(name="applicationReadable")
    def application_readable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether files should also be uploaded as code data. By default, files declared in static file handlers are uploaded as static data and are only served to end users; they cannot be read by the application. If enabled, uploads are charged against both your code and static data storage resource quotas.
        """
        return pulumi.get(self, "application_readable")

    @application_readable.setter
    def application_readable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "application_readable", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[str]]:
        """
        Time a static file served by this handler should be cached by web proxies and browsers.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        HTTP headers to use for all responses from these URLs.
        """
        return pulumi.get(self, "http_headers")

    @http_headers.setter
    def http_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "http_headers", value)

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> Optional[pulumi.Input[str]]:
        """
        MIME type used to serve all files served by this handler.Defaults to file-specific MIME types, which are derived from each file's filename extension.
        """
        return pulumi.get(self, "mime_type")

    @mime_type.setter
    def mime_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mime_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the static files matched by the URL pattern, from the application root directory. The path can refer to text matched in groupings in the URL pattern.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="requireMatchingFile")
    def require_matching_file(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this handler should match the request if the file referenced by the handler does not exist.
        """
        return pulumi.get(self, "require_matching_file")

    @require_matching_file.setter
    def require_matching_file(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_matching_file", value)

    @property
    @pulumi.getter(name="uploadPathRegex")
    def upload_path_regex(self) -> Optional[pulumi.Input[str]]:
        """
        Regular expression that matches the file paths for all files that should be referenced by this handler.
        """
        return pulumi.get(self, "upload_path_regex")

    @upload_path_regex.setter
    def upload_path_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upload_path_regex", value)


@pulumi.input_type
class UrlDispatchRuleArgs:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Rules to match an HTTP request and dispatch that request to a service.
        :param pulumi.Input[str] domain: Domain name to match against. The wildcard "*" is supported if specified before a period: "*.".Defaults to matching all domains: "*".
        :param pulumi.Input[str] path: Pathname within the host. Must start with a "/". A single "*" can be included at the end of the path.The sum of the lengths of the domain and path may not exceed 100 characters.
        :param pulumi.Input[str] service: Resource ID of a service in this application that should serve the matched request. The service must already exist. Example: default.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        Domain name to match against. The wildcard "*" is supported if specified before a period: "*.".Defaults to matching all domains: "*".
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Pathname within the host. Must start with a "/". A single "*" can be included at the end of the path.The sum of the lengths of the domain and path may not exceed 100 characters.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID of a service in this application that should serve the matched request. The service must already exist. Example: default.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class UrlMapArgs:
    def __init__(__self__, *,
                 api_endpoint: Optional[pulumi.Input['ApiEndpointHandlerArgs']] = None,
                 auth_fail_action: Optional[pulumi.Input[str]] = None,
                 login: Optional[pulumi.Input[str]] = None,
                 redirect_http_response_code: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input['ScriptHandlerArgs']] = None,
                 security_level: Optional[pulumi.Input[str]] = None,
                 static_files: Optional[pulumi.Input['StaticFilesHandlerArgs']] = None,
                 url_regex: Optional[pulumi.Input[str]] = None):
        """
        URL pattern and description of how the URL should be handled. App Engine can handle URLs by executing application code or by serving static files uploaded with the version, such as images, CSS, or JavaScript.
        :param pulumi.Input['ApiEndpointHandlerArgs'] api_endpoint: Uses API Endpoints to handle requests.
        :param pulumi.Input[str] auth_fail_action: Action to take when users access resources that require authentication. Defaults to redirect.
        :param pulumi.Input[str] login: Level of login required to access this resource. Not supported for Node.js in the App Engine standard environment.
        :param pulumi.Input[str] redirect_http_response_code: 30x code to use when performing redirects for the secure field. Defaults to 302.
        :param pulumi.Input['ScriptHandlerArgs'] script: Executes a script to handle the requests that match this URL pattern. Only the auto value is supported for Node.js in the App Engine standard environment, for example "script": "auto".
        :param pulumi.Input[str] security_level: Security (HTTPS) enforcement for this URL.
        :param pulumi.Input['StaticFilesHandlerArgs'] static_files: Returns the contents of a file, such as an image, as the response.
        :param pulumi.Input[str] url_regex: URL prefix. Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings. All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
        """
        if api_endpoint is not None:
            pulumi.set(__self__, "api_endpoint", api_endpoint)
        if auth_fail_action is not None:
            pulumi.set(__self__, "auth_fail_action", auth_fail_action)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if redirect_http_response_code is not None:
            pulumi.set(__self__, "redirect_http_response_code", redirect_http_response_code)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if security_level is not None:
            pulumi.set(__self__, "security_level", security_level)
        if static_files is not None:
            pulumi.set(__self__, "static_files", static_files)
        if url_regex is not None:
            pulumi.set(__self__, "url_regex", url_regex)

    @property
    @pulumi.getter(name="apiEndpoint")
    def api_endpoint(self) -> Optional[pulumi.Input['ApiEndpointHandlerArgs']]:
        """
        Uses API Endpoints to handle requests.
        """
        return pulumi.get(self, "api_endpoint")

    @api_endpoint.setter
    def api_endpoint(self, value: Optional[pulumi.Input['ApiEndpointHandlerArgs']]):
        pulumi.set(self, "api_endpoint", value)

    @property
    @pulumi.getter(name="authFailAction")
    def auth_fail_action(self) -> Optional[pulumi.Input[str]]:
        """
        Action to take when users access resources that require authentication. Defaults to redirect.
        """
        return pulumi.get(self, "auth_fail_action")

    @auth_fail_action.setter
    def auth_fail_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_fail_action", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[str]]:
        """
        Level of login required to access this resource. Not supported for Node.js in the App Engine standard environment.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter(name="redirectHttpResponseCode")
    def redirect_http_response_code(self) -> Optional[pulumi.Input[str]]:
        """
        30x code to use when performing redirects for the secure field. Defaults to 302.
        """
        return pulumi.get(self, "redirect_http_response_code")

    @redirect_http_response_code.setter
    def redirect_http_response_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_http_response_code", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input['ScriptHandlerArgs']]:
        """
        Executes a script to handle the requests that match this URL pattern. Only the auto value is supported for Node.js in the App Engine standard environment, for example "script": "auto".
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input['ScriptHandlerArgs']]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="securityLevel")
    def security_level(self) -> Optional[pulumi.Input[str]]:
        """
        Security (HTTPS) enforcement for this URL.
        """
        return pulumi.get(self, "security_level")

    @security_level.setter
    def security_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_level", value)

    @property
    @pulumi.getter(name="staticFiles")
    def static_files(self) -> Optional[pulumi.Input['StaticFilesHandlerArgs']]:
        """
        Returns the contents of a file, such as an image, as the response.
        """
        return pulumi.get(self, "static_files")

    @static_files.setter
    def static_files(self, value: Optional[pulumi.Input['StaticFilesHandlerArgs']]):
        pulumi.set(self, "static_files", value)

    @property
    @pulumi.getter(name="urlRegex")
    def url_regex(self) -> Optional[pulumi.Input[str]]:
        """
        URL prefix. Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings. All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
        """
        return pulumi.get(self, "url_regex")

    @url_regex.setter
    def url_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_regex", value)


@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 size_gb: Optional[pulumi.Input[float]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None):
        """
        Volumes mounted within the app container. Only applicable in the App Engine flexible environment.
        :param pulumi.Input[str] name: Unique name for the volume.
        :param pulumi.Input[float] size_gb: Volume size in gigabytes.
        :param pulumi.Input[str] volume_type: Underlying volume type, e.g. 'tmpfs'.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name for the volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Volume size in gigabytes.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "size_gb", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Underlying volume type, e.g. 'tmpfs'.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class VpcAccessConnectorArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        VPC access connector specification.
        :param pulumi.Input[str] name: Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ZipInfoArgs:
    def __init__(__self__, *,
                 files_count: Optional[pulumi.Input[int]] = None,
                 source_url: Optional[pulumi.Input[str]] = None):
        """
        The zip file information for a zip deployment.
        :param pulumi.Input[int] files_count: An estimate of the number of files in a zip for a zip deployment. If set, must be greater than or equal to the actual number of files. Used for optimizing performance; if not provided, deployment may be slow.
        :param pulumi.Input[str] source_url: URL of the zip file to deploy from. Must be a URL to a resource in Google Cloud Storage in the form 'http(s)://storage.googleapis.com//'.
        """
        if files_count is not None:
            pulumi.set(__self__, "files_count", files_count)
        if source_url is not None:
            pulumi.set(__self__, "source_url", source_url)

    @property
    @pulumi.getter(name="filesCount")
    def files_count(self) -> Optional[pulumi.Input[int]]:
        """
        An estimate of the number of files in a zip for a zip deployment. If set, must be greater than or equal to the actual number of files. Used for optimizing performance; if not provided, deployment may be slow.
        """
        return pulumi.get(self, "files_count")

    @files_count.setter
    def files_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "files_count", value)

    @property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the zip file to deploy from. Must be a URL to a resource in Google Cloud Storage in the form 'http(s)://storage.googleapis.com//'.
        """
        return pulumi.get(self, "source_url")

    @source_url.setter
    def source_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_url", value)


