# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = ['OrganizationEnvironmentApiRevisionDebugsession']


class OrganizationEnvironmentApiRevisionDebugsession(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apis_id: Optional[pulumi.Input[str]] = None,
                 count: Optional[pulumi.Input[int]] = None,
                 debugsessions_id: Optional[pulumi.Input[str]] = None,
                 environments_id: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organizations_id: Optional[pulumi.Input[str]] = None,
                 revisions_id: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 tracesize: Optional[pulumi.Input[int]] = None,
                 validity: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a debug session for a deployed API Proxy revision.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] count: Optional. The number of request to be traced. Min = 1, Max = 15, Default = 10.
        :param pulumi.Input[str] filter: Optional. A conditional statement which is evaluated against the request message to determine if it should be traced. Syntax matches that of on API Proxy bundle flow Condition.
        :param pulumi.Input[str] name: A unique ID for this DebugSession.
        :param pulumi.Input[str] timeout: Optional. The time in seconds after which this DebugSession should end. This value will override the value in query param, if both are provided.
        :param pulumi.Input[int] tracesize: Optional. The maximum number of bytes captured from the response payload. Min = 0, Max = 5120, Default = 5120.
        :param pulumi.Input[int] validity: Optional. The length of time, in seconds, that this debug session is valid, starting from when it's received in the control plane. Min = 1, Max = 15, Default = 10.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if apis_id is None and not opts.urn:
                raise TypeError("Missing required property 'apis_id'")
            __props__['apis_id'] = apis_id
            __props__['count'] = count
            if debugsessions_id is None and not opts.urn:
                raise TypeError("Missing required property 'debugsessions_id'")
            __props__['debugsessions_id'] = debugsessions_id
            if environments_id is None and not opts.urn:
                raise TypeError("Missing required property 'environments_id'")
            __props__['environments_id'] = environments_id
            __props__['filter'] = filter
            __props__['name'] = name
            if organizations_id is None and not opts.urn:
                raise TypeError("Missing required property 'organizations_id'")
            __props__['organizations_id'] = organizations_id
            if revisions_id is None and not opts.urn:
                raise TypeError("Missing required property 'revisions_id'")
            __props__['revisions_id'] = revisions_id
            __props__['timeout'] = timeout
            __props__['tracesize'] = tracesize
            __props__['validity'] = validity
        super(OrganizationEnvironmentApiRevisionDebugsession, __self__).__init__(
            'gcp-native:apigee/v1:OrganizationEnvironmentApiRevisionDebugsession',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'OrganizationEnvironmentApiRevisionDebugsession':
        """
        Get an existing OrganizationEnvironmentApiRevisionDebugsession resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["count"] = None
        __props__["filter"] = None
        __props__["name"] = None
        __props__["timeout"] = None
        __props__["tracesize"] = None
        __props__["validity"] = None
        return OrganizationEnvironmentApiRevisionDebugsession(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Output[int]:
        """
        Optional. The number of request to be traced. Min = 1, Max = 15, Default = 10.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[str]:
        """
        Optional. A conditional statement which is evaluated against the request message to determine if it should be traced. Syntax matches that of on API Proxy bundle flow Condition.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique ID for this DebugSession.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[str]:
        """
        Optional. The time in seconds after which this DebugSession should end. This value will override the value in query param, if both are provided.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def tracesize(self) -> pulumi.Output[int]:
        """
        Optional. The maximum number of bytes captured from the response payload. Min = 0, Max = 5120, Default = 5120.
        """
        return pulumi.get(self, "tracesize")

    @property
    @pulumi.getter
    def validity(self) -> pulumi.Output[int]:
        """
        Optional. The length of time, in seconds, that this debug session is valid, starting from when it's received in the control plane. Min = 1, Max = 15, Default = 10.
        """
        return pulumi.get(self, "validity")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

