# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict


class Agent(TeaModel):
    def __init__(
        self,
        agent_id: str = None,
        agent_name: str = None,
        agent_version: str = None,
        cpu_usage: str = None,
        disk_usage: str = None,
        gmt_modify: str = None,
        ip: str = None,
        kernel_version: str = None,
        memory_usage: str = None,
        security_domain: str = None,
        status: str = None,
    ):
        # 探针Id
        self.agent_id = agent_id
        # 探针名称
        self.agent_name = agent_name
        # 探针版本
        self.agent_version = agent_version
        # cpu使用率
        self.cpu_usage = cpu_usage
        # 磁盘利用率
        self.disk_usage = disk_usage
        # 更新时间
        self.gmt_modify = gmt_modify
        # 探针IP
        self.ip = ip
        # 系统版本
        self.kernel_version = kernel_version
        # 内存使用率
        self.memory_usage = memory_usage
        # 安全域
        self.security_domain = security_domain
        # 探针状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_name is not None:
            result['AgentName'] = self.agent_name
        if self.agent_version is not None:
            result['AgentVersion'] = self.agent_version
        if self.cpu_usage is not None:
            result['CpuUsage'] = self.cpu_usage
        if self.disk_usage is not None:
            result['DiskUsage'] = self.disk_usage
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.kernel_version is not None:
            result['KernelVersion'] = self.kernel_version
        if self.memory_usage is not None:
            result['MemoryUsage'] = self.memory_usage
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentName') is not None:
            self.agent_name = m.get('AgentName')
        if m.get('AgentVersion') is not None:
            self.agent_version = m.get('AgentVersion')
        if m.get('CpuUsage') is not None:
            self.cpu_usage = m.get('CpuUsage')
        if m.get('DiskUsage') is not None:
            self.disk_usage = m.get('DiskUsage')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('KernelVersion') is not None:
            self.kernel_version = m.get('KernelVersion')
        if m.get('MemoryUsage') is not None:
            self.memory_usage = m.get('MemoryUsage')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class AgentsTask(TeaModel):
    def __init__(
        self,
        action_type: str = None,
        agent_type: str = None,
        agents_task_id: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        params: str = None,
        status: str = None,
    ):
        # 操作类型
        self.action_type = action_type
        # 探针类型
        self.agent_type = agent_type
        # 任务ID
        self.agents_task_id = agents_task_id
        # 创建时间
        self.gmt_create = gmt_create
        # 更新时间
        self.gmt_modify = gmt_modify
        # 任务参数
        self.params = params
        # 任务状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_type is not None:
            result['ActionType'] = self.action_type
        if self.agent_type is not None:
            result['AgentType'] = self.agent_type
        if self.agents_task_id is not None:
            result['AgentsTaskId'] = self.agents_task_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.params is not None:
            result['Params'] = self.params
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActionType') is not None:
            self.action_type = m.get('ActionType')
        if m.get('AgentType') is not None:
            self.agent_type = m.get('AgentType')
        if m.get('AgentsTaskId') is not None:
            self.agents_task_id = m.get('AgentsTaskId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class AggregateData(TeaModel):
    def __init__(
        self,
        aggregate_data_description: str = None,
        aggregate_data_id: str = None,
        aggregate_data_name: str = None,
        aggregate_mode_list: List[str] = None,
        data_item: str = None,
        device_id_list: List[str] = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        is_all_device: int = None,
        monitor_item_id: str = None,
    ):
        # 描述
        self.aggregate_data_description = aggregate_data_description
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 聚合数据名称
        self.aggregate_data_name = aggregate_data_name
        # 聚合方式列表
        self.aggregate_mode_list = aggregate_mode_list
        # 数据项
        self.data_item = data_item
        # 聚合设备ID列表
        self.device_id_list = device_id_list
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 是否聚合全部设备
        self.is_all_device = is_all_device
        # 监控项ID
        self.monitor_item_id = monitor_item_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate_data_description is not None:
            result['AggregateDataDescription'] = self.aggregate_data_description
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.aggregate_data_name is not None:
            result['AggregateDataName'] = self.aggregate_data_name
        if self.aggregate_mode_list is not None:
            result['AggregateModeList'] = self.aggregate_mode_list
        if self.data_item is not None:
            result['DataItem'] = self.data_item
        if self.device_id_list is not None:
            result['DeviceIdList'] = self.device_id_list
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.is_all_device is not None:
            result['IsAllDevice'] = self.is_all_device
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregateDataDescription') is not None:
            self.aggregate_data_description = m.get('AggregateDataDescription')
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('AggregateDataName') is not None:
            self.aggregate_data_name = m.get('AggregateDataName')
        if m.get('AggregateModeList') is not None:
            self.aggregate_mode_list = m.get('AggregateModeList')
        if m.get('DataItem') is not None:
            self.data_item = m.get('DataItem')
        if m.get('DeviceIdList') is not None:
            self.device_id_list = m.get('DeviceIdList')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('IsAllDevice') is not None:
            self.is_all_device = m.get('IsAllDevice')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        return self


class AlarmOverviewConditionList(TeaModel):
    def __init__(
        self,
        condition_name: str = None,
        condition_value: str = None,
    ):
        # 过滤条件字段
        self.condition_name = condition_name
        # 过滤条件值
        self.condition_value = condition_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition_name is not None:
            result['ConditionName'] = self.condition_name
        if self.condition_value is not None:
            result['ConditionValue'] = self.condition_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionName') is not None:
            self.condition_name = m.get('ConditionName')
        if m.get('ConditionValue') is not None:
            self.condition_value = m.get('ConditionValue')
        return self


class AlarmOverview(TeaModel):
    def __init__(
        self,
        alarm_overview_id: str = None,
        alarm_overview_name: str = None,
        condition_list: List[AlarmOverviewConditionList] = None,
        serial_number: int = None,
    ):
        # 告警总览ID
        self.alarm_overview_id = alarm_overview_id
        # 告警总览名称
        self.alarm_overview_name = alarm_overview_name
        # 过滤条件列表
        self.condition_list = condition_list
        # 排序序号
        self.serial_number = serial_number

    def validate(self):
        if self.condition_list:
            for k in self.condition_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_overview_id is not None:
            result['AlarmOverviewId'] = self.alarm_overview_id
        if self.alarm_overview_name is not None:
            result['AlarmOverviewName'] = self.alarm_overview_name
        result['ConditionList'] = []
        if self.condition_list is not None:
            for k in self.condition_list:
                result['ConditionList'].append(k.to_map() if k else None)
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmOverviewId') is not None:
            self.alarm_overview_id = m.get('AlarmOverviewId')
        if m.get('AlarmOverviewName') is not None:
            self.alarm_overview_name = m.get('AlarmOverviewName')
        self.condition_list = []
        if m.get('ConditionList') is not None:
            for k in m.get('ConditionList'):
                temp_model = AlarmOverviewConditionList()
                self.condition_list.append(temp_model.from_map(k))
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        return self


class AtomicStepInput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AtomicStepOutput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AtomicStep(TeaModel):
    def __init__(
        self,
        description: str = None,
        input: List[AtomicStepInput] = None,
        output: List[AtomicStepOutput] = None,
        step_id: str = None,
        step_name: str = None,
        step_type: str = None,
    ):
        # 步骤说明
        self.description = description
        # 步骤入参
        self.input = input
        # 步骤出参
        self.output = output
        # 步骤id
        self.step_id = step_id
        # 步骤名称
        self.step_name = step_name
        # 步骤类型
        self.step_type = step_type

    def validate(self):
        if self.input:
            for k in self.input:
                if k:
                    k.validate()
        if self.output:
            for k in self.output:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        result['Input'] = []
        if self.input is not None:
            for k in self.input:
                result['Input'].append(k.to_map() if k else None)
        result['Output'] = []
        if self.output is not None:
            for k in self.output:
                result['Output'].append(k.to_map() if k else None)
        if self.step_id is not None:
            result['StepId'] = self.step_id
        if self.step_name is not None:
            result['StepName'] = self.step_name
        if self.step_type is not None:
            result['StepType'] = self.step_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.input = []
        if m.get('Input') is not None:
            for k in m.get('Input'):
                temp_model = AtomicStepInput()
                self.input.append(temp_model.from_map(k))
        self.output = []
        if m.get('Output') is not None:
            for k in m.get('Output'):
                temp_model = AtomicStepOutput()
                self.output.append(temp_model.from_map(k))
        if m.get('StepId') is not None:
            self.step_id = m.get('StepId')
        if m.get('StepName') is not None:
            self.step_name = m.get('StepName')
        if m.get('StepType') is not None:
            self.step_type = m.get('StepType')
        return self


class BusinessType(TeaModel):
    def __init__(
        self,
        abbr: str = None,
        action_flag: str = None,
        business_type_id: str = None,
        create_time: str = None,
        direction: int = None,
        gateway: int = None,
        lease_time: str = None,
        mask: str = None,
        name: str = None,
        reserve_number: int = None,
        sharing: str = None,
        type: str = None,
        update_time: str = None,
        vlan: str = None,
        zone_type: str = None,
    ):
        # 业务类型缩写
        self.abbr = abbr
        # 业务类型地址申请完对应的动作，DHCP表示需要触发DHCP变更
        self.action_flag = action_flag
        # 配置规范对象
        self.business_type_id = business_type_id
        # 创建时间
        self.create_time = create_time
        # 分配方向，0表示正向，1表示反向
        self.direction = direction
        # 网关地址位置，正数为正数序号，负数为倒数序号
        self.gateway = gateway
        # 有效时间
        self.lease_time = lease_time
        # 掩码
        self.mask = mask
        # 业务类型名称
        self.name = name
        # 保留地址数目
        self.reserve_number = reserve_number
        # 是否复用 reuse/single
        self.sharing = sharing
        # 业务类型大类
        self.type = type
        # 更新时间
        self.update_time = update_time
        # Vlan
        self.vlan = vlan
        # 绑定的园区类型
        self.zone_type = zone_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abbr is not None:
            result['Abbr'] = self.abbr
        if self.action_flag is not None:
            result['ActionFlag'] = self.action_flag
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.gateway is not None:
            result['Gateway'] = self.gateway
        if self.lease_time is not None:
            result['LeaseTime'] = self.lease_time
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.name is not None:
            result['Name'] = self.name
        if self.reserve_number is not None:
            result['ReserveNumber'] = self.reserve_number
        if self.sharing is not None:
            result['Sharing'] = self.sharing
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.vlan is not None:
            result['Vlan'] = self.vlan
        if self.zone_type is not None:
            result['ZoneType'] = self.zone_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Abbr') is not None:
            self.abbr = m.get('Abbr')
        if m.get('ActionFlag') is not None:
            self.action_flag = m.get('ActionFlag')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('Gateway') is not None:
            self.gateway = m.get('Gateway')
        if m.get('LeaseTime') is not None:
            self.lease_time = m.get('LeaseTime')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ReserveNumber') is not None:
            self.reserve_number = m.get('ReserveNumber')
        if m.get('Sharing') is not None:
            self.sharing = m.get('Sharing')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Vlan') is not None:
            self.vlan = m.get('Vlan')
        if m.get('ZoneType') is not None:
            self.zone_type = m.get('ZoneType')
        return self


class CliTask(TeaModel):
    def __init__(
        self,
        agent_ip: str = None,
        cli_task_id: str = None,
        command: str = None,
        device_id: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        output: str = None,
        protocol: str = None,
        response_code: str = None,
        result: str = None,
        session_id: str = None,
        status: str = None,
        timeout: int = None,
    ):
        # agent IP
        self.agent_ip = agent_ip
        # cli任务id
        self.cli_task_id = cli_task_id
        # cli命令
        self.command = command
        # 设备id
        self.device_id = device_id
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 设备回显
        self.output = output
        # 协议
        self.protocol = protocol
        # 任务错误码
        self.response_code = response_code
        # 任务结果
        self.result = result
        # 会话id
        self.session_id = session_id
        # cli任务状态
        self.status = status
        # 超时参数
        self.timeout = timeout

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ip is not None:
            result['AgentIp'] = self.agent_ip
        if self.cli_task_id is not None:
            result['CliTaskId'] = self.cli_task_id
        if self.command is not None:
            result['Command'] = self.command
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.output is not None:
            result['Output'] = self.output
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.response_code is not None:
            result['ResponseCode'] = self.response_code
        if self.result is not None:
            result['Result'] = self.result
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.status is not None:
            result['Status'] = self.status
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIp') is not None:
            self.agent_ip = m.get('AgentIp')
        if m.get('CliTaskId') is not None:
            self.cli_task_id = m.get('CliTaskId')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('ResponseCode') is not None:
            self.response_code = m.get('ResponseCode')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        return self


class ConfigurationSpecification(TeaModel):
    def __init__(
        self,
        architecture: str = None,
        configuration_specification_id: str = None,
        create_time: str = None,
        model: str = None,
        related_variate: List[str] = None,
        role: str = None,
        specification_content: str = None,
        specification_name: str = None,
        update_time: str = None,
        vendor: str = None,
    ):
        # 架构类型
        self.architecture = architecture
        # 配置规范uid
        self.configuration_specification_id = configuration_specification_id
        # 创建时间
        self.create_time = create_time
        # 型号
        self.model = model
        # 相关变量
        self.related_variate = related_variate
        # 角色
        self.role = role
        # 配置规范内容
        self.specification_content = specification_content
        # 配置规范名字
        self.specification_name = specification_name
        # 更新时间
        self.update_time = update_time
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.model is not None:
            result['Model'] = self.model
        if self.related_variate is not None:
            result['RelatedVariate'] = self.related_variate
        if self.role is not None:
            result['Role'] = self.role
        if self.specification_content is not None:
            result['SpecificationContent'] = self.specification_content
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('RelatedVariate') is not None:
            self.related_variate = m.get('RelatedVariate')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SpecificationContent') is not None:
            self.specification_content = m.get('SpecificationContent')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ConfigurationVariate(TeaModel):
    def __init__(
        self,
        comment: str = None,
        configuration_variate_id: str = None,
        create_time: str = None,
        format_function: str = None,
        update_time: str = None,
        variate_name: str = None,
    ):
        # 描述变量
        self.comment = comment
        # 资源一级ID
        self.configuration_variate_id = configuration_variate_id
        # 创建时间
        self.create_time = create_time
        # python转换函数
        self.format_function = format_function
        # 更新时间
        self.update_time = update_time
        # 变量名字
        self.variate_name = variate_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.configuration_variate_id is not None:
            result['ConfigurationVariateId'] = self.configuration_variate_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.format_function is not None:
            result['FormatFunction'] = self.format_function
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.variate_name is not None:
            result['VariateName'] = self.variate_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ConfigurationVariateId') is not None:
            self.configuration_variate_id = m.get('ConfigurationVariateId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FormatFunction') is not None:
            self.format_function = m.get('FormatFunction')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('VariateName') is not None:
            self.variate_name = m.get('VariateName')
        return self


class ConnectionPolicy(TeaModel):
    def __init__(
        self,
        algorithm: str = None,
        connection_policy_id: str = None,
        create_time: str = None,
        downlink_device_id: str = None,
        downlink_module_id: str = None,
        id: str = None,
        link_count: int = None,
        name: str = None,
        network_architecture_iteration_id: str = None,
        update_time: str = None,
        uplink_device_id: str = None,
        uplink_model_id: str = None,
    ):
        # 连接策略算法
        self.algorithm = algorithm
        # 资源一级ID
        self.connection_policy_id = connection_policy_id
        # 创建时间
        self.create_time = create_time
        # 下联设备uid
        self.downlink_device_id = downlink_device_id
        # 下联模块uid
        self.downlink_module_id = downlink_module_id
        # 连接策略uid
        self.id = id
        # 连接数
        self.link_count = link_count
        # 连接策略名字
        self.name = name
        # 架构迭代uid
        self.network_architecture_iteration_id = network_architecture_iteration_id
        # 更新时间
        self.update_time = update_time
        # 上联设备uid
        self.uplink_device_id = uplink_device_id
        # 上联模块uid
        self.uplink_model_id = uplink_model_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.connection_policy_id is not None:
            result['ConnectionPolicyId'] = self.connection_policy_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.downlink_device_id is not None:
            result['DownlinkDeviceId'] = self.downlink_device_id
        if self.downlink_module_id is not None:
            result['DownlinkModuleId'] = self.downlink_module_id
        if self.id is not None:
            result['Id'] = self.id
        if self.link_count is not None:
            result['LinkCount'] = self.link_count
        if self.name is not None:
            result['Name'] = self.name
        if self.network_architecture_iteration_id is not None:
            result['NetworkArchitectureIterationId'] = self.network_architecture_iteration_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.uplink_device_id is not None:
            result['UplinkDeviceId'] = self.uplink_device_id
        if self.uplink_model_id is not None:
            result['UplinkModelId'] = self.uplink_model_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('ConnectionPolicyId') is not None:
            self.connection_policy_id = m.get('ConnectionPolicyId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DownlinkDeviceId') is not None:
            self.downlink_device_id = m.get('DownlinkDeviceId')
        if m.get('DownlinkModuleId') is not None:
            self.downlink_module_id = m.get('DownlinkModuleId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LinkCount') is not None:
            self.link_count = m.get('LinkCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetworkArchitectureIterationId') is not None:
            self.network_architecture_iteration_id = m.get('NetworkArchitectureIterationId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UplinkDeviceId') is not None:
            self.uplink_device_id = m.get('UplinkDeviceId')
        if m.get('UplinkModelId') is not None:
            self.uplink_model_id = m.get('UplinkModelId')
        return self


class DataViewChart(TeaModel):
    def __init__(
        self,
        chart_type: str = None,
        data_view_id: str = None,
        data_view_source: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        grid: str = None,
    ):
        # 图表类型
        self.chart_type = chart_type
        # 数据视图ID
        self.data_view_id = data_view_id
        # 数据源类型
        self.data_view_source = data_view_source
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 布局配置
        self.grid = grid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.chart_type is not None:
            result['ChartType'] = self.chart_type
        if self.data_view_id is not None:
            result['DataViewId'] = self.data_view_id
        if self.data_view_source is not None:
            result['DataViewSource'] = self.data_view_source
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.grid is not None:
            result['Grid'] = self.grid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChartType') is not None:
            self.chart_type = m.get('ChartType')
        if m.get('DataViewId') is not None:
            self.data_view_id = m.get('DataViewId')
        if m.get('DataViewSource') is not None:
            self.data_view_source = m.get('DataViewSource')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Grid') is not None:
            self.grid = m.get('Grid')
        return self


class DataView(TeaModel):
    def __init__(
        self,
        data_view_chart_list: List[DataViewChart] = None,
        data_view_description: str = None,
        data_view_id: str = None,
        data_view_name: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
    ):
        # 图表列表
        self.data_view_chart_list = data_view_chart_list
        # 描述
        self.data_view_description = data_view_description
        # 聚合数据
        self.data_view_id = data_view_id
        # 数据视图名称
        self.data_view_name = data_view_name
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified

    def validate(self):
        if self.data_view_chart_list:
            for k in self.data_view_chart_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataViewChartList'] = []
        if self.data_view_chart_list is not None:
            for k in self.data_view_chart_list:
                result['DataViewChartList'].append(k.to_map() if k else None)
        if self.data_view_description is not None:
            result['DataViewDescription'] = self.data_view_description
        if self.data_view_id is not None:
            result['DataViewId'] = self.data_view_id
        if self.data_view_name is not None:
            result['DataViewName'] = self.data_view_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_view_chart_list = []
        if m.get('DataViewChartList') is not None:
            for k in m.get('DataViewChartList'):
                temp_model = DataViewChart()
                self.data_view_chart_list.append(temp_model.from_map(k))
        if m.get('DataViewDescription') is not None:
            self.data_view_description = m.get('DataViewDescription')
        if m.get('DataViewId') is not None:
            self.data_view_id = m.get('DataViewId')
        if m.get('DataViewName') is not None:
            self.data_view_name = m.get('DataViewName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class DedicatedLine(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        device_id: str = None,
        device_port: str = None,
        isp: str = None,
        line_gateway: str = None,
        line_id: str = None,
        line_ip: str = None,
        line_role: str = None,
    ):
        # 宽带（Mbps）
        self.bandwidth = bandwidth
        # 关联设备ID
        self.device_id = device_id
        # 关联设备端口
        self.device_port = device_port
        # 运营商
        self.isp = isp
        # 专线网关
        self.line_gateway = line_gateway
        # 物理空间专线ID
        self.line_id = line_id
        # 专线IP
        self.line_ip = line_ip
        # 专线角色
        self.line_role = line_role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_port is not None:
            result['DevicePort'] = self.device_port
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.line_gateway is not None:
            result['LineGateway'] = self.line_gateway
        if self.line_id is not None:
            result['LineId'] = self.line_id
        if self.line_ip is not None:
            result['LineIp'] = self.line_ip
        if self.line_role is not None:
            result['LineRole'] = self.line_role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DevicePort') is not None:
            self.device_port = m.get('DevicePort')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('LineGateway') is not None:
            self.line_gateway = m.get('LineGateway')
        if m.get('LineId') is not None:
            self.line_id = m.get('LineId')
        if m.get('LineIp') is not None:
            self.line_ip = m.get('LineIp')
        if m.get('LineRole') is not None:
            self.line_role = m.get('LineRole')
        return self


class Device(TeaModel):
    def __init__(
        self,
        account_type: str = None,
        account_version: str = None,
        auth_pass_phrase: str = None,
        auth_protocol: str = None,
        community: str = None,
        device_form: str = None,
        device_id: str = None,
        device_ip: str = None,
        device_mac: str = None,
        device_sn: str = None,
        hostname: str = None,
        model: str = None,
        privacy_pass_phrase: str = None,
        privacy_protocol: str = None,
        security_domain: str = None,
        security_level: str = None,
        space: str = None,
        ssh_account: str = None,
        ssh_password: str = None,
        status: str = None,
        telnet_account: str = None,
        telnet_password: str = None,
        user_name: str = None,
        vendor: str = None,
    ):
        # 账号类型
        self.account_type = account_type
        # snmp版本号
        self.account_version = account_version
        # Auth PassPhrase
        self.auth_pass_phrase = auth_pass_phrase
        # Auth Protocol
        self.auth_protocol = auth_protocol
        # community
        self.community = community
        # 设备形态
        self.device_form = device_form
        # 设备ID
        self.device_id = device_id
        # 设备IP
        self.device_ip = device_ip
        # 设备MAC地址
        self.device_mac = device_mac
        # 设备SN
        self.device_sn = device_sn
        # 主机名
        self.hostname = hostname
        # 设备型号
        self.model = model
        # Privacy PassPhrase
        self.privacy_pass_phrase = privacy_pass_phrase
        # Privacy Protocol
        self.privacy_protocol = privacy_protocol
        # 设备安全域
        self.security_domain = security_domain
        # 安全等级
        self.security_level = security_level
        # 设备所属物理空间
        self.space = space
        # SSH登录账号
        self.ssh_account = ssh_account
        # SSH登录密码
        self.ssh_password = ssh_password
        # 设备状态
        self.status = status
        # TELNET登录账号
        self.telnet_account = telnet_account
        # TELNET登录密码
        self.telnet_password = telnet_password
        # 用户名
        self.user_name = user_name
        # 设备厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.account_version is not None:
            result['AccountVersion'] = self.account_version
        if self.auth_pass_phrase is not None:
            result['AuthPassPhrase'] = self.auth_pass_phrase
        if self.auth_protocol is not None:
            result['AuthProtocol'] = self.auth_protocol
        if self.community is not None:
            result['Community'] = self.community
        if self.device_form is not None:
            result['DeviceForm'] = self.device_form
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_ip is not None:
            result['DeviceIp'] = self.device_ip
        if self.device_mac is not None:
            result['DeviceMac'] = self.device_mac
        if self.device_sn is not None:
            result['DeviceSn'] = self.device_sn
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.model is not None:
            result['Model'] = self.model
        if self.privacy_pass_phrase is not None:
            result['PrivacyPassPhrase'] = self.privacy_pass_phrase
        if self.privacy_protocol is not None:
            result['PrivacyProtocol'] = self.privacy_protocol
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.security_level is not None:
            result['SecurityLevel'] = self.security_level
        if self.space is not None:
            result['Space'] = self.space
        if self.ssh_account is not None:
            result['SshAccount'] = self.ssh_account
        if self.ssh_password is not None:
            result['SshPassword'] = self.ssh_password
        if self.status is not None:
            result['Status'] = self.status
        if self.telnet_account is not None:
            result['TelnetAccount'] = self.telnet_account
        if self.telnet_password is not None:
            result['TelnetPassword'] = self.telnet_password
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('AccountVersion') is not None:
            self.account_version = m.get('AccountVersion')
        if m.get('AuthPassPhrase') is not None:
            self.auth_pass_phrase = m.get('AuthPassPhrase')
        if m.get('AuthProtocol') is not None:
            self.auth_protocol = m.get('AuthProtocol')
        if m.get('Community') is not None:
            self.community = m.get('Community')
        if m.get('DeviceForm') is not None:
            self.device_form = m.get('DeviceForm')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceIp') is not None:
            self.device_ip = m.get('DeviceIp')
        if m.get('DeviceMac') is not None:
            self.device_mac = m.get('DeviceMac')
        if m.get('DeviceSn') is not None:
            self.device_sn = m.get('DeviceSn')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('PrivacyPassPhrase') is not None:
            self.privacy_pass_phrase = m.get('PrivacyPassPhrase')
        if m.get('PrivacyProtocol') is not None:
            self.privacy_protocol = m.get('PrivacyProtocol')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('SecurityLevel') is not None:
            self.security_level = m.get('SecurityLevel')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('SshAccount') is not None:
            self.ssh_account = m.get('SshAccount')
        if m.get('SshPassword') is not None:
            self.ssh_password = m.get('SshPassword')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TelnetAccount') is not None:
            self.telnet_account = m.get('TelnetAccount')
        if m.get('TelnetPassword') is not None:
            self.telnet_password = m.get('TelnetPassword')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class DeviceFormProperty(TeaModel):
    def __init__(
        self,
        content: str = None,
        keyword: str = None,
        placeholder: bool = None,
        required: bool = None,
        search_supported: bool = None,
        sequence: int = None,
        table_visible: bool = None,
        uniqueness: bool = None,
        value_reference: str = None,
        value_source: str = None,
        value_type: str = None,
    ):
        # 属性描述
        self.content = content
        # 属性关键词
        self.keyword = keyword
        # 前端界面控件占位符文字
        self.placeholder = placeholder
        # 属性是否必填
        self.required = required
        # 属性是否作为界面查询条件
        self.search_supported = search_supported
        # 属性展示的次序
        self.sequence = sequence
        # 前端界面是否展示为表格列
        self.table_visible = table_visible
        # 属性是否需要唯一检查
        self.uniqueness = uniqueness
        # 属性值来源具体的方式
        self.value_reference = value_reference
        # 属性值来源类型：枚举、接口等
        self.value_source = value_source
        # 属性类型，JSON或者分隔符
        self.value_type = value_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.placeholder is not None:
            result['Placeholder'] = self.placeholder
        if self.required is not None:
            result['Required'] = self.required
        if self.search_supported is not None:
            result['SearchSupported'] = self.search_supported
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.table_visible is not None:
            result['TableVisible'] = self.table_visible
        if self.uniqueness is not None:
            result['Uniqueness'] = self.uniqueness
        if self.value_reference is not None:
            result['ValueReference'] = self.value_reference
        if self.value_source is not None:
            result['ValueSource'] = self.value_source
        if self.value_type is not None:
            result['ValueType'] = self.value_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Placeholder') is not None:
            self.placeholder = m.get('Placeholder')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('SearchSupported') is not None:
            self.search_supported = m.get('SearchSupported')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('TableVisible') is not None:
            self.table_visible = m.get('TableVisible')
        if m.get('Uniqueness') is not None:
            self.uniqueness = m.get('Uniqueness')
        if m.get('ValueReference') is not None:
            self.value_reference = m.get('ValueReference')
        if m.get('ValueSource') is not None:
            self.value_source = m.get('ValueSource')
        if m.get('ValueType') is not None:
            self.value_type = m.get('ValueType')
        return self


class DeviceForm(TeaModel):
    def __init__(
        self,
        account_config: str = None,
        config_compare: str = None,
        form_id: str = None,
        form_name: str = None,
        properties_list: List[DeviceFormProperty] = None,
    ):
        # 是否需要配置账号信息
        self.account_config = account_config
        # 是否需要展示配置备份
        self.config_compare = config_compare
        # 设备形态ID
        self.form_id = form_id
        # 设备形态名称
        self.form_name = form_name
        # 设备形态属性列表
        self.properties_list = properties_list

    def validate(self):
        if self.properties_list:
            for k in self.properties_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_config is not None:
            result['AccountConfig'] = self.account_config
        if self.config_compare is not None:
            result['ConfigCompare'] = self.config_compare
        if self.form_id is not None:
            result['FormId'] = self.form_id
        if self.form_name is not None:
            result['FormName'] = self.form_name
        result['PropertiesList'] = []
        if self.properties_list is not None:
            for k in self.properties_list:
                result['PropertiesList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountConfig') is not None:
            self.account_config = m.get('AccountConfig')
        if m.get('ConfigCompare') is not None:
            self.config_compare = m.get('ConfigCompare')
        if m.get('FormId') is not None:
            self.form_id = m.get('FormId')
        if m.get('FormName') is not None:
            self.form_name = m.get('FormName')
        self.properties_list = []
        if m.get('PropertiesList') is not None:
            for k in m.get('PropertiesList'):
                temp_model = DeviceFormProperty()
                self.properties_list.append(temp_model.from_map(k))
        return self


class DeviceProperty(TeaModel):
    def __init__(
        self,
        content: str = None,
        device_form: str = None,
        format: str = None,
        name_cn: str = None,
        name_en: str = None,
        property_id: str = None,
    ):
        # 属性值
        self.content = content
        # 设备形态
        self.device_form = device_form
        # 属性格式，包括JSON和SPLITTER（分隔符）
        self.format = format
        # 属性展示名称
        self.name_cn = name_cn
        # 属性英文主键
        self.name_en = name_en
        # 设备属性ID
        self.property_id = property_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.device_form is not None:
            result['DeviceForm'] = self.device_form
        if self.format is not None:
            result['Format'] = self.format
        if self.name_cn is not None:
            result['NameCn'] = self.name_cn
        if self.name_en is not None:
            result['NameEn'] = self.name_en
        if self.property_id is not None:
            result['PropertyId'] = self.property_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('DeviceForm') is not None:
            self.device_form = m.get('DeviceForm')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('NameCn') is not None:
            self.name_cn = m.get('NameCn')
        if m.get('NameEn') is not None:
            self.name_en = m.get('NameEn')
        if m.get('PropertyId') is not None:
            self.property_id = m.get('PropertyId')
        return self


class DeviceResourceDeviceResource(TeaModel):
    def __init__(
        self,
        block_number: str = None,
        business: str = None,
        config: str = None,
        config_generate: bool = None,
        config_task_status: str = None,
        delivery_ip: str = None,
        device_number: str = None,
        device_resource_id: str = None,
        host_name: str = None,
        inter_connection: str = None,
        location: str = None,
        loopback: str = None,
        manager_ip: str = None,
        model: str = None,
        role: str = None,
        setup_project_id: str = None,
        sn: str = None,
        stack: bool = None,
        vendor: str = None,
    ):
        # 组号
        self.block_number = block_number
        # 设备业务地址
        self.business = business
        # 设备配置
        self.config = config
        # 配置生成
        self.config_generate = config_generate
        # 配置下发状态
        self.config_task_status = config_task_status
        # 交付登录地址
        self.delivery_ip = delivery_ip
        # 设备号
        self.device_number = device_number
        # 设备资源ID
        self.device_resource_id = device_resource_id
        # 主机名
        self.host_name = host_name
        # 设备互联地址
        self.inter_connection = inter_connection
        # 物理空间位置
        self.location = location
        # loopback地址
        self.loopback = loopback
        # 带内管理地址
        self.manager_ip = manager_ip
        # 模型
        self.model = model
        # 角色
        self.role = role
        # 建设项目id
        self.setup_project_id = setup_project_id
        # 设备sn号
        self.sn = sn
        # 堆叠状态
        self.stack = stack
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_number is not None:
            result['BlockNumber'] = self.block_number
        if self.business is not None:
            result['Business'] = self.business
        if self.config is not None:
            result['Config'] = self.config
        if self.config_generate is not None:
            result['ConfigGenerate'] = self.config_generate
        if self.config_task_status is not None:
            result['ConfigTaskStatus'] = self.config_task_status
        if self.delivery_ip is not None:
            result['DeliveryIp'] = self.delivery_ip
        if self.device_number is not None:
            result['DeviceNumber'] = self.device_number
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.inter_connection is not None:
            result['InterConnection'] = self.inter_connection
        if self.location is not None:
            result['Location'] = self.location
        if self.loopback is not None:
            result['Loopback'] = self.loopback
        if self.manager_ip is not None:
            result['ManagerIp'] = self.manager_ip
        if self.model is not None:
            result['Model'] = self.model
        if self.role is not None:
            result['Role'] = self.role
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.stack is not None:
            result['Stack'] = self.stack
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockNumber') is not None:
            self.block_number = m.get('BlockNumber')
        if m.get('Business') is not None:
            self.business = m.get('Business')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('ConfigGenerate') is not None:
            self.config_generate = m.get('ConfigGenerate')
        if m.get('ConfigTaskStatus') is not None:
            self.config_task_status = m.get('ConfigTaskStatus')
        if m.get('DeliveryIp') is not None:
            self.delivery_ip = m.get('DeliveryIp')
        if m.get('DeviceNumber') is not None:
            self.device_number = m.get('DeviceNumber')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InterConnection') is not None:
            self.inter_connection = m.get('InterConnection')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Loopback') is not None:
            self.loopback = m.get('Loopback')
        if m.get('ManagerIp') is not None:
            self.manager_ip = m.get('ManagerIp')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('Stack') is not None:
            self.stack = m.get('Stack')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class DeviceResource(TeaModel):
    def __init__(
        self,
        arch_id: str = None,
        business_type: str = None,
        business_type_id: str = None,
        business_type_params: str = None,
        create_time: str = None,
        data: str = None,
        device_resource: List[DeviceResourceDeviceResource] = None,
        device_resource_id: str = None,
        device_resource_ids: List[str] = None,
        download_type: str = None,
        ip_type: str = None,
        list_type: str = None,
        loopback_port: str = None,
        net_location: str = None,
        setup_project_id: str = None,
        type: str = None,
    ):
        # 架构资源ID
        self.arch_id = arch_id
        # 业务类型
        self.business_type = business_type
        # 业务类型id
        self.business_type_id = business_type_id
        # 业务参数
        self.business_type_params = business_type_params
        # 创建时间
        self.create_time = create_time
        # 更新数据
        self.data = data
        # 设备资源
        self.device_resource = device_resource
        # 设备资源id
        self.device_resource_id = device_resource_id
        # 资源一级ID
        self.device_resource_ids = device_resource_ids
        # 操作类型
        self.download_type = download_type
        # ip类型
        self.ip_type = ip_type
        # list类型
        self.list_type = list_type
        # Loopback口
        self.loopback_port = loopback_port
        # 位置
        self.net_location = net_location
        # 建设项目id
        self.setup_project_id = setup_project_id
        # 操作类型
        self.type = type

    def validate(self):
        if self.device_resource:
            for k in self.device_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arch_id is not None:
            result['ArchId'] = self.arch_id
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.business_type_params is not None:
            result['BusinessTypeParams'] = self.business_type_params
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data is not None:
            result['Data'] = self.data
        result['DeviceResource'] = []
        if self.device_resource is not None:
            for k in self.device_resource:
                result['DeviceResource'].append(k.to_map() if k else None)
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.device_resource_ids is not None:
            result['DeviceResourceIds'] = self.device_resource_ids
        if self.download_type is not None:
            result['DownloadType'] = self.download_type
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.list_type is not None:
            result['ListType'] = self.list_type
        if self.loopback_port is not None:
            result['LoopbackPort'] = self.loopback_port
        if self.net_location is not None:
            result['NetLocation'] = self.net_location
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArchId') is not None:
            self.arch_id = m.get('ArchId')
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('BusinessTypeParams') is not None:
            self.business_type_params = m.get('BusinessTypeParams')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        self.device_resource = []
        if m.get('DeviceResource') is not None:
            for k in m.get('DeviceResource'):
                temp_model = DeviceResourceDeviceResource()
                self.device_resource.append(temp_model.from_map(k))
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids = m.get('DeviceResourceIds')
        if m.get('DownloadType') is not None:
            self.download_type = m.get('DownloadType')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('ListType') is not None:
            self.list_type = m.get('ListType')
        if m.get('LoopbackPort') is not None:
            self.loopback_port = m.get('LoopbackPort')
        if m.get('NetLocation') is not None:
            self.net_location = m.get('NetLocation')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeviceTask(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        device_ip: str = None,
        device_name: str = None,
        device_task_id: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        output: str = None,
        params: str = None,
        response_code: str = None,
        result: str = None,
        script_id: str = None,
        script_version: str = None,
        status: str = None,
        template_id: str = None,
        template_name: str = None,
    ):
        # 设备id
        self.device_id = device_id
        # 设备ip
        self.device_ip = device_ip
        # 设备名
        self.device_name = device_name
        # 设备任务id
        self.device_task_id = device_task_id
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 设备任务回显
        self.output = output
        # 设备任务参数
        self.params = params
        # 设备任务错误码
        self.response_code = response_code
        # 设备任务返回
        self.result = result
        # 脚本id
        self.script_id = script_id
        # 版本id
        self.script_version = script_version
        # 设备任务状态
        self.status = status
        # 模板id
        self.template_id = template_id
        # 模板名称
        self.template_name = template_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_ip is not None:
            result['DeviceIp'] = self.device_ip
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_task_id is not None:
            result['DeviceTaskId'] = self.device_task_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.output is not None:
            result['Output'] = self.output
        if self.params is not None:
            result['Params'] = self.params
        if self.response_code is not None:
            result['ResponseCode'] = self.response_code
        if self.result is not None:
            result['Result'] = self.result
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        if self.script_version is not None:
            result['ScriptVersion'] = self.script_version
        if self.status is not None:
            result['Status'] = self.status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceIp') is not None:
            self.device_ip = m.get('DeviceIp')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceTaskId') is not None:
            self.device_task_id = m.get('DeviceTaskId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('ResponseCode') is not None:
            self.response_code = m.get('ResponseCode')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        if m.get('ScriptVersion') is not None:
            self.script_version = m.get('ScriptVersion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        return self


class EventResourceDevice(TeaModel):
    def __init__(
        self,
        host_name: str = None,
        physical_space: str = None,
    ):
        # 设备名
        self.host_name = host_name
        # 物理空间
        self.physical_space = physical_space

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.physical_space is not None:
            result['PhysicalSpace'] = self.physical_space
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('PhysicalSpace') is not None:
            self.physical_space = m.get('PhysicalSpace')
        return self


class Event(TeaModel):
    def __init__(
        self,
        alarm_status: str = None,
        count: int = None,
        create_time: str = None,
        device_id: str = None,
        event_name: str = None,
        event_object: str = None,
        event_object_id: str = None,
        event_type: str = None,
        message: str = None,
        resource_device: EventResourceDevice = None,
        template_id: str = None,
        update_time: str = None,
    ):
        # 事件告警状态
        self.alarm_status = alarm_status
        # 发生次数
        self.count = count
        # 事件发生时间
        self.create_time = create_time
        # 设备ID
        self.device_id = device_id
        # 事件名称
        self.event_name = event_name
        # 事件对象
        self.event_object = event_object
        # 事件对象ID
        self.event_object_id = event_object_id
        # 事件类型
        self.event_type = event_type
        # 事件内容
        self.message = message
        # 设备
        self.resource_device = resource_device
        # 自动化模板ID
        self.template_id = template_id
        # 事件更新时间
        self.update_time = update_time

    def validate(self):
        if self.resource_device:
            self.resource_device.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.count is not None:
            result['Count'] = self.count
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_object is not None:
            result['EventObject'] = self.event_object
        if self.event_object_id is not None:
            result['EventObjectId'] = self.event_object_id
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.message is not None:
            result['Message'] = self.message
        if self.resource_device is not None:
            result['ResourceDevice'] = self.resource_device.to_map()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventObject') is not None:
            self.event_object = m.get('EventObject')
        if m.get('EventObjectId') is not None:
            self.event_object_id = m.get('EventObjectId')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ResourceDevice') is not None:
            temp_model = EventResourceDevice()
            self.resource_device = temp_model.from_map(m['ResourceDevice'])
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class EventDefinition(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        event_id: str = None,
        event_name: str = None,
        event_type: str = None,
        template_id: str = None,
        update_time: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 事件项ID
        self.event_id = event_id
        # 事件名称
        self.event_name = event_name
        # 事件大类
        self.event_type = event_type
        # 自动化模板ID
        self.template_id = template_id
        # 修改时间
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class InspectionItem(TeaModel):
    def __init__(
        self,
        inspection_crontab: str = None,
        item_description: str = None,
        item_id: str = None,
        item_name: str = None,
    ):
        # 巡检定时表达式
        self.inspection_crontab = inspection_crontab
        # 巡检项描述
        self.item_description = item_description
        # 巡检项ID
        self.item_id = item_id
        # 巡检项名字
        self.item_name = item_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inspection_crontab is not None:
            result['InspectionCrontab'] = self.inspection_crontab
        if self.item_description is not None:
            result['ItemDescription'] = self.item_description
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InspectionCrontab') is not None:
            self.inspection_crontab = m.get('InspectionCrontab')
        if m.get('ItemDescription') is not None:
            self.item_description = m.get('ItemDescription')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        return self


class InspectionScriptInspectionAlarmRules(TeaModel):
    def __init__(
        self,
        alarm_expression: str = None,
        alarm_level: str = None,
        alarm_operator: str = None,
        alarm_value: str = None,
    ):
        # 告警表达式
        self.alarm_expression = alarm_expression
        # 告警级别
        self.alarm_level = alarm_level
        # 告警符号
        self.alarm_operator = alarm_operator
        # 告警值
        self.alarm_value = alarm_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_expression is not None:
            result['AlarmExpression'] = self.alarm_expression
        if self.alarm_level is not None:
            result['AlarmLevel'] = self.alarm_level
        if self.alarm_operator is not None:
            result['AlarmOperator'] = self.alarm_operator
        if self.alarm_value is not None:
            result['AlarmValue'] = self.alarm_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmExpression') is not None:
            self.alarm_expression = m.get('AlarmExpression')
        if m.get('AlarmLevel') is not None:
            self.alarm_level = m.get('AlarmLevel')
        if m.get('AlarmOperator') is not None:
            self.alarm_operator = m.get('AlarmOperator')
        if m.get('AlarmValue') is not None:
            self.alarm_value = m.get('AlarmValue')
        return self


class InspectionScript(TeaModel):
    def __init__(
        self,
        inspection_alarm_rules: List[InspectionScriptInspectionAlarmRules] = None,
        inspection_crontab: str = None,
        item_description: str = None,
        item_id: str = None,
        item_name: str = None,
        model: str = None,
        role: str = None,
        script: str = None,
        script_id: str = None,
        script_status: str = None,
        vendor: str = None,
    ):
        # 巡检告警规则
        self.inspection_alarm_rules = inspection_alarm_rules
        # 巡检项定时表达式
        self.inspection_crontab = inspection_crontab
        # 巡检项描述
        self.item_description = item_description
        # 巡检项ID
        self.item_id = item_id
        # 巡检项名字
        self.item_name = item_name
        # 型号
        self.model = model
        # 角色
        self.role = role
        # 模板执行内容
        self.script = script
        # 巡检模板ID
        self.script_id = script_id
        # 模板状态
        self.script_status = script_status
        # 厂商
        self.vendor = vendor

    def validate(self):
        if self.inspection_alarm_rules:
            for k in self.inspection_alarm_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InspectionAlarmRules'] = []
        if self.inspection_alarm_rules is not None:
            for k in self.inspection_alarm_rules:
                result['InspectionAlarmRules'].append(k.to_map() if k else None)
        if self.inspection_crontab is not None:
            result['InspectionCrontab'] = self.inspection_crontab
        if self.item_description is not None:
            result['ItemDescription'] = self.item_description
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.model is not None:
            result['Model'] = self.model
        if self.role is not None:
            result['Role'] = self.role
        if self.script is not None:
            result['Script'] = self.script
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        if self.script_status is not None:
            result['ScriptStatus'] = self.script_status
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.inspection_alarm_rules = []
        if m.get('InspectionAlarmRules') is not None:
            for k in m.get('InspectionAlarmRules'):
                temp_model = InspectionScriptInspectionAlarmRules()
                self.inspection_alarm_rules.append(temp_model.from_map(k))
        if m.get('InspectionCrontab') is not None:
            self.inspection_crontab = m.get('InspectionCrontab')
        if m.get('ItemDescription') is not None:
            self.item_description = m.get('ItemDescription')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        if m.get('ScriptStatus') is not None:
            self.script_status = m.get('ScriptStatus')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class InspectionTaskInspectionAlarmRules(TeaModel):
    def __init__(
        self,
        actual_value: str = None,
        expression: str = None,
        level: str = None,
        operator: str = None,
        value: str = None,
    ):
        # 告警实际值
        self.actual_value = actual_value
        # 告警表达式
        self.expression = expression
        # 告警级别
        self.level = level
        # 告警操作符
        self.operator = operator
        # 告警值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_value is not None:
            result['ActualValue'] = self.actual_value
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.level is not None:
            result['Level'] = self.level
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActualValue') is not None:
            self.actual_value = m.get('ActualValue')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class InspectionTask(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        error_code: str = None,
        execution_begin_time: str = None,
        execution_end_time: str = None,
        hostname: str = None,
        ip: str = None,
        inspection_alarm_rules: List[InspectionTaskInspectionAlarmRules] = None,
        inspection_result: str = None,
        item_id: str = None,
        item_name: str = None,
        model: str = None,
        role: str = None,
        space: str = None,
        task_status: str = None,
        template_id: str = None,
        vendor: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 错误码
        self.error_code = error_code
        # 执行开始时间
        self.execution_begin_time = execution_begin_time
        # 执行结束时间
        self.execution_end_time = execution_end_time
        # 主机名
        self.hostname = hostname
        # 设备IP
        self.ip = ip
        # 告警规则
        self.inspection_alarm_rules = inspection_alarm_rules
        # 执行结果
        self.inspection_result = inspection_result
        # 巡检项ID
        self.item_id = item_id
        # 巡检项名字
        self.item_name = item_name
        # 型号
        self.model = model
        # 角色
        self.role = role
        # 物理空间
        self.space = space
        # 任务状态
        self.task_status = task_status
        # 巡检模板ID
        self.template_id = template_id
        # 厂商
        self.vendor = vendor

    def validate(self):
        if self.inspection_alarm_rules:
            for k in self.inspection_alarm_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.execution_begin_time is not None:
            result['ExecutionBeginTime'] = self.execution_begin_time
        if self.execution_end_time is not None:
            result['ExecutionEndTime'] = self.execution_end_time
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.ip is not None:
            result['IP'] = self.ip
        result['InspectionAlarmRules'] = []
        if self.inspection_alarm_rules is not None:
            for k in self.inspection_alarm_rules:
                result['InspectionAlarmRules'].append(k.to_map() if k else None)
        if self.inspection_result is not None:
            result['InspectionResult'] = self.inspection_result
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.model is not None:
            result['Model'] = self.model
        if self.role is not None:
            result['Role'] = self.role
        if self.space is not None:
            result['Space'] = self.space
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ExecutionBeginTime') is not None:
            self.execution_begin_time = m.get('ExecutionBeginTime')
        if m.get('ExecutionEndTime') is not None:
            self.execution_end_time = m.get('ExecutionEndTime')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        self.inspection_alarm_rules = []
        if m.get('InspectionAlarmRules') is not None:
            for k in m.get('InspectionAlarmRules'):
                temp_model = InspectionTaskInspectionAlarmRules()
                self.inspection_alarm_rules.append(temp_model.from_map(k))
        if m.get('InspectionResult') is not None:
            self.inspection_result = m.get('InspectionResult')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class IpZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class Ip(TeaModel):
    def __init__(
        self,
        business_type_id: str = None,
        business_type_name: str = None,
        create_time: str = None,
        device_mac: str = None,
        device_name: str = None,
        ip_address: str = None,
        ip_id: str = None,
        ip_name: str = None,
        parent_ip_block: str = None,
        port: str = None,
        status: str = None,
        zone_layer: List[IpZoneLayer] = None,
    ):
        # 业务类型UID
        self.business_type_id = business_type_id
        # 业务类型名称
        self.business_type_name = business_type_name
        # 创建时间
        self.create_time = create_time
        # 设备MAC
        self.device_mac = device_mac
        # 设备名称
        self.device_name = device_name
        # IP地址
        self.ip_address = ip_address
        # 资源一级ID
        self.ip_id = ip_id
        # 资源名称
        self.ip_name = ip_name
        # 地址段
        self.parent_ip_block = parent_ip_block
        # 设备端口名称
        self.port = port
        # 状态 using available lock
        self.status = status
        # 园区层级
        self.zone_layer = zone_layer

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.business_type_name is not None:
            result['BusinessTypeName'] = self.business_type_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.device_mac is not None:
            result['DeviceMac'] = self.device_mac
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.ip_id is not None:
            result['IpId'] = self.ip_id
        if self.ip_name is not None:
            result['IpName'] = self.ip_name
        if self.parent_ip_block is not None:
            result['ParentIpBlock'] = self.parent_ip_block
        if self.port is not None:
            result['Port'] = self.port
        if self.status is not None:
            result['Status'] = self.status
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('BusinessTypeName') is not None:
            self.business_type_name = m.get('BusinessTypeName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeviceMac') is not None:
            self.device_mac = m.get('DeviceMac')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('IpId') is not None:
            self.ip_id = m.get('IpId')
        if m.get('IpName') is not None:
            self.ip_name = m.get('IpName')
        if m.get('ParentIpBlock') is not None:
            self.parent_ip_block = m.get('ParentIpBlock')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = IpZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        return self


class IpBlockZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class IpBlock(TeaModel):
    def __init__(
        self,
        application: str = None,
        backup_device_name: str = None,
        block: str = None,
        business_type_id: str = None,
        category: str = None,
        create_time: str = None,
        description: str = None,
        device_name: str = None,
        ip_block_id: str = None,
        mask: str = None,
        net_business: str = None,
        net_type: str = None,
        ownership: str = None,
        parent_id: str = None,
        reserve_parent_block: str = None,
        resource_group_id: str = None,
        update_type: str = None,
        zone_layer: List[IpBlockZoneLayer] = None,
        zone_name: str = None,
    ):
        # IP用途
        self.application = application
        # 备份设备名称
        self.backup_device_name = backup_device_name
        # IP段地址
        self.block = block
        # 业务类型UID
        self.business_type_id = business_type_id
        # 地址类别 IPV4
        self.category = category
        # 创建时间
        self.create_time = create_time
        # 备注
        self.description = description
        # 设备名称
        self.device_name = device_name
        # 资源一级ID
        self.ip_block_id = ip_block_id
        # IP段掩码
        self.mask = mask
        # 公网地址类型 INC GUEST VIP
        self.net_business = net_business
        # 公网私网标志 PUBLIC PRIVATE
        self.net_type = net_type
        # IP归属
        self.ownership = ownership
        # 父地址段UID
        self.parent_id = parent_id
        # 是否保留父段 true 是 false 否
        self.reserve_parent_block = reserve_parent_block
        # 资源组ID
        self.resource_group_id = resource_group_id
        # 更新类型 update 更新 split 拆分
        self.update_type = update_type
        # 园区层级
        self.zone_layer = zone_layer
        # 园区名称
        self.zone_name = zone_name

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application is not None:
            result['Application'] = self.application
        if self.backup_device_name is not None:
            result['BackupDeviceName'] = self.backup_device_name
        if self.block is not None:
            result['Block'] = self.block
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.category is not None:
            result['Category'] = self.category
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.ip_block_id is not None:
            result['IpBlockId'] = self.ip_block_id
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.net_business is not None:
            result['NetBusiness'] = self.net_business
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.ownership is not None:
            result['Ownership'] = self.ownership
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.reserve_parent_block is not None:
            result['ReserveParentBlock'] = self.reserve_parent_block
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.update_type is not None:
            result['UpdateType'] = self.update_type
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('BackupDeviceName') is not None:
            self.backup_device_name = m.get('BackupDeviceName')
        if m.get('Block') is not None:
            self.block = m.get('Block')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IpBlockId') is not None:
            self.ip_block_id = m.get('IpBlockId')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('NetBusiness') is not None:
            self.net_business = m.get('NetBusiness')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Ownership') is not None:
            self.ownership = m.get('Ownership')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ReserveParentBlock') is not None:
            self.reserve_parent_block = m.get('ReserveParentBlock')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('UpdateType') is not None:
            self.update_type = m.get('UpdateType')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = IpBlockZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        return self


class IpBlockRecordDetailZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class IpBlockRecordDetail(TeaModel):
    def __init__(
        self,
        business_type_name: str = None,
        device_name: str = None,
        gateway: str = None,
        parent_ip_blocks: List[str] = None,
        zone_layer: List[IpBlockRecordDetailZoneLayer] = None,
    ):
        # 业务类型
        self.business_type_name = business_type_name
        # 设备名称
        self.device_name = device_name
        # 网关
        self.gateway = gateway
        # 父地址段列表
        self.parent_ip_blocks = parent_ip_blocks
        # 园区层级
        self.zone_layer = zone_layer

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type_name is not None:
            result['BusinessTypeName'] = self.business_type_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.gateway is not None:
            result['Gateway'] = self.gateway
        if self.parent_ip_blocks is not None:
            result['ParentIpBlocks'] = self.parent_ip_blocks
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessTypeName') is not None:
            self.business_type_name = m.get('BusinessTypeName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Gateway') is not None:
            self.gateway = m.get('Gateway')
        if m.get('ParentIpBlocks') is not None:
            self.parent_ip_blocks = m.get('ParentIpBlocks')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = IpBlockRecordDetailZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        return self


class IpBlockRecord(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        creator: int = None,
        description: str = None,
        detail: List[IpBlockRecordDetail] = None,
        ip_block_code: List[str] = None,
        ip_block_record_id: str = None,
        net_type: str = None,
        record_type: str = None,
        status: str = None,
        title: str = None,
        update_time: str = None,
        work_no: str = None,
        zone_name: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 创建人
        self.creator = creator
        # 工单备注
        self.description = description
        # 工单详情
        self.detail = detail
        # 要释放的IP段
        self.ip_block_code = ip_block_code
        # 工单uuid
        self.ip_block_record_id = ip_block_record_id
        # 公网私网标志 PUBLIC PRIVATE
        self.net_type = net_type
        # 工单类型 Apply 申请工单 Recycle 释放工单
        self.record_type = record_type
        # 工单状态 running complete fail cancel lock approving
        self.status = status
        # 工单名称
        self.title = title
        # 更新时间
        self.update_time = update_time
        # 工号
        self.work_no = work_no
        # 园区名称
        self.zone_name = zone_name

    def validate(self):
        if self.detail:
            for k in self.detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.description is not None:
            result['Description'] = self.description
        result['Detail'] = []
        if self.detail is not None:
            for k in self.detail:
                result['Detail'].append(k.to_map() if k else None)
        if self.ip_block_code is not None:
            result['IpBlockCode'] = self.ip_block_code
        if self.ip_block_record_id is not None:
            result['IpBlockRecordId'] = self.ip_block_record_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.work_no is not None:
            result['WorkNo'] = self.work_no
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.detail = []
        if m.get('Detail') is not None:
            for k in m.get('Detail'):
                temp_model = IpBlockRecordDetail()
                self.detail.append(temp_model.from_map(k))
        if m.get('IpBlockCode') is not None:
            self.ip_block_code = m.get('IpBlockCode')
        if m.get('IpBlockRecordId') is not None:
            self.ip_block_record_id = m.get('IpBlockRecordId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('WorkNo') is not None:
            self.work_no = m.get('WorkNo')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        return self


class IpRecordDetailZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class IpRecordDetail(TeaModel):
    def __init__(
        self,
        device_mac: str = None,
        device_name: str = None,
        gateway: str = None,
        ip: str = None,
        parent_ip_blocks: List[str] = None,
        port: str = None,
        remote_device_name: str = None,
        remote_ip: str = None,
        remote_port: str = None,
        zone_layer: List[IpRecordDetailZoneLayer] = None,
    ):
        # 设备MAC
        self.device_mac = device_mac
        # 设备名称
        self.device_name = device_name
        # 网关
        self.gateway = gateway
        # 申请到的Ip
        self.ip = ip
        # 父地址段列表
        self.parent_ip_blocks = parent_ip_blocks
        # 设备端口
        self.port = port
        # 对端设备名称
        self.remote_device_name = remote_device_name
        # 对端IP
        self.remote_ip = remote_ip
        # 对端设备端口
        self.remote_port = remote_port
        # 园区层级
        self.zone_layer = zone_layer

    def validate(self):
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_mac is not None:
            result['DeviceMac'] = self.device_mac
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.gateway is not None:
            result['Gateway'] = self.gateway
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.parent_ip_blocks is not None:
            result['ParentIpBlocks'] = self.parent_ip_blocks
        if self.port is not None:
            result['Port'] = self.port
        if self.remote_device_name is not None:
            result['RemoteDeviceName'] = self.remote_device_name
        if self.remote_ip is not None:
            result['RemoteIp'] = self.remote_ip
        if self.remote_port is not None:
            result['RemotePort'] = self.remote_port
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceMac') is not None:
            self.device_mac = m.get('DeviceMac')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Gateway') is not None:
            self.gateway = m.get('Gateway')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('ParentIpBlocks') is not None:
            self.parent_ip_blocks = m.get('ParentIpBlocks')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RemoteDeviceName') is not None:
            self.remote_device_name = m.get('RemoteDeviceName')
        if m.get('RemoteIp') is not None:
            self.remote_ip = m.get('RemoteIp')
        if m.get('RemotePort') is not None:
            self.remote_port = m.get('RemotePort')
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = IpRecordDetailZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        return self


class IpRecord(TeaModel):
    def __init__(
        self,
        business_type_name: str = None,
        create_time: str = None,
        creator: str = None,
        description: str = None,
        detail: List[IpRecordDetail] = None,
        ip_block: str = None,
        ip_code: List[str] = None,
        ip_record_id: str = None,
        recode_type: str = None,
        status: str = None,
        update_time: str = None,
        zone_name: str = None,
    ):
        # 业务类型名称
        self.business_type_name = business_type_name
        # 创建时间
        self.create_time = create_time
        # 创建人
        self.creator = creator
        # 备注
        self.description = description
        # 工单详情
        self.detail = detail
        # 地址段
        self.ip_block = ip_block
        # IP地址列表
        self.ip_code = ip_code
        # 资源一级ID
        self.ip_record_id = ip_record_id
        # 工单类型 Apply 申请工单 Recycle 释放工单
        self.recode_type = recode_type
        # 工单状态 running complete fail
        self.status = status
        # 更新时间
        self.update_time = update_time
        # 园区名
        self.zone_name = zone_name

    def validate(self):
        if self.detail:
            for k in self.detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type_name is not None:
            result['BusinessTypeName'] = self.business_type_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.description is not None:
            result['Description'] = self.description
        result['Detail'] = []
        if self.detail is not None:
            for k in self.detail:
                result['Detail'].append(k.to_map() if k else None)
        if self.ip_block is not None:
            result['IpBlock'] = self.ip_block
        if self.ip_code is not None:
            result['IpCode'] = self.ip_code
        if self.ip_record_id is not None:
            result['IpRecordId'] = self.ip_record_id
        if self.recode_type is not None:
            result['RecodeType'] = self.recode_type
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessTypeName') is not None:
            self.business_type_name = m.get('BusinessTypeName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.detail = []
        if m.get('Detail') is not None:
            for k in m.get('Detail'):
                temp_model = IpRecordDetail()
                self.detail.append(temp_model.from_map(k))
        if m.get('IpBlock') is not None:
            self.ip_block = m.get('IpBlock')
        if m.get('IpCode') is not None:
            self.ip_code = m.get('IpCode')
        if m.get('IpRecordId') is not None:
            self.ip_record_id = m.get('IpRecordId')
        if m.get('RecodeType') is not None:
            self.recode_type = m.get('RecodeType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        return self


class ModelToRole(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        id: str = None,
        model: str = None,
        model_to_role_id: str = None,
        network_architecture_iteration_id: str = None,
        role: str = None,
        update_time: str = None,
        vendor: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 角色型号对应关系uid
        self.id = id
        # 设备型号
        self.model = model
        # 资源一级ID
        self.model_to_role_id = model_to_role_id
        # 架构迭代uid
        self.network_architecture_iteration_id = network_architecture_iteration_id
        # 角色
        self.role = role
        # 更新时间
        self.update_time = update_time
        # 设备厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.id is not None:
            result['Id'] = self.id
        if self.model is not None:
            result['Model'] = self.model
        if self.model_to_role_id is not None:
            result['ModelToRoleId'] = self.model_to_role_id
        if self.network_architecture_iteration_id is not None:
            result['NetworkArchitectureIterationId'] = self.network_architecture_iteration_id
        if self.role is not None:
            result['Role'] = self.role
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('ModelToRoleId') is not None:
            self.model_to_role_id = m.get('ModelToRoleId')
        if m.get('NetworkArchitectureIterationId') is not None:
            self.network_architecture_iteration_id = m.get('NetworkArchitectureIterationId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ModuleDevice(TeaModel):
    def __init__(
        self,
        count: int = None,
        create_time: str = None,
        device_count: int = None,
        device_role: str = None,
        device_x: str = None,
        device_y: str = None,
        id: str = None,
        role: str = None,
        update_time: str = None,
        x: str = None,
        y: str = None,
    ):
        # 区块内设备数量
        self.count = count
        # 创建时间
        self.create_time = create_time
        # 区块内设备数量
        self.device_count = device_count
        # 设备角色
        self.device_role = device_role
        # 设备x坐标
        self.device_x = device_x
        # 设备y坐标
        self.device_y = device_y
        # 设备uuid
        self.id = id
        # 设备角色
        self.role = role
        # 更新时间
        self.update_time = update_time
        # 设备x坐标
        self.x = x
        # 设备y坐标
        self.y = y

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.device_count is not None:
            result['DeviceCount'] = self.device_count
        if self.device_role is not None:
            result['DeviceRole'] = self.device_role
        if self.device_x is not None:
            result['DeviceX'] = self.device_x
        if self.device_y is not None:
            result['DeviceY'] = self.device_y
        if self.id is not None:
            result['Id'] = self.id
        if self.role is not None:
            result['Role'] = self.role
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.x is not None:
            result['X'] = self.x
        if self.y is not None:
            result['Y'] = self.y
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeviceCount') is not None:
            self.device_count = m.get('DeviceCount')
        if m.get('DeviceRole') is not None:
            self.device_role = m.get('DeviceRole')
        if m.get('DeviceX') is not None:
            self.device_x = m.get('DeviceX')
        if m.get('DeviceY') is not None:
            self.device_y = m.get('DeviceY')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('X') is not None:
            self.x = m.get('X')
        if m.get('Y') is not None:
            self.y = m.get('Y')
        return self


class ModuleModuleDetailsDeviceDetails(TeaModel):
    def __init__(
        self,
        order_number: int = None,
    ):
        # 设备序号
        self.order_number = order_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_number is not None:
            result['OrderNumber'] = self.order_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderNumber') is not None:
            self.order_number = m.get('OrderNumber')
        return self


class ModuleModuleDetails(TeaModel):
    def __init__(
        self,
        device_details: List[ModuleModuleDetailsDeviceDetails] = None,
        order_number: int = None,
    ):
        # 设备详情
        self.device_details = device_details
        # 模块序号
        self.order_number = order_number

    def validate(self):
        if self.device_details:
            for k in self.device_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceDetails'] = []
        if self.device_details is not None:
            for k in self.device_details:
                result['DeviceDetails'].append(k.to_map() if k else None)
        if self.order_number is not None:
            result['OrderNumber'] = self.order_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_details = []
        if m.get('DeviceDetails') is not None:
            for k in m.get('DeviceDetails'):
                temp_model = ModuleModuleDetailsDeviceDetails()
                self.device_details.append(temp_model.from_map(k))
        if m.get('OrderNumber') is not None:
            self.order_number = m.get('OrderNumber')
        return self


class Module(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        device: ModuleDevice = None,
        id: str = None,
        max_count: int = None,
        min_count: int = None,
        module_details: List[ModuleModuleDetails] = None,
        module_id: str = None,
        module_type: str = None,
        name: str = None,
        parent_module_id: str = None,
        stack: bool = None,
        update_time: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 设备信息
        self.device = device
        # 模块uuid
        self.id = id
        # 最大建设模块数量
        self.max_count = max_count
        # 最小建设模块数量
        self.min_count = min_count
        # 模块详情
        self.module_details = module_details
        # 资源一级ID
        self.module_id = module_id
        # 模块类型
        self.module_type = module_type
        # 模块名字
        self.name = name
        # 父模块uuid
        self.parent_module_id = parent_module_id
        # 堆叠
        self.stack = stack
        # 更新时间
        self.update_time = update_time

    def validate(self):
        if self.device:
            self.device.validate()
        if self.module_details:
            for k in self.module_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.device is not None:
            result['Device'] = self.device.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.max_count is not None:
            result['MaxCount'] = self.max_count
        if self.min_count is not None:
            result['MinCount'] = self.min_count
        result['ModuleDetails'] = []
        if self.module_details is not None:
            for k in self.module_details:
                result['ModuleDetails'].append(k.to_map() if k else None)
        if self.module_id is not None:
            result['ModuleId'] = self.module_id
        if self.module_type is not None:
            result['ModuleType'] = self.module_type
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_module_id is not None:
            result['ParentModuleId'] = self.parent_module_id
        if self.stack is not None:
            result['Stack'] = self.stack
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Device') is not None:
            temp_model = ModuleDevice()
            self.device = temp_model.from_map(m['Device'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MaxCount') is not None:
            self.max_count = m.get('MaxCount')
        if m.get('MinCount') is not None:
            self.min_count = m.get('MinCount')
        self.module_details = []
        if m.get('ModuleDetails') is not None:
            for k in m.get('ModuleDetails'):
                temp_model = ModuleModuleDetails()
                self.module_details.append(temp_model.from_map(k))
        if m.get('ModuleId') is not None:
            self.module_id = m.get('ModuleId')
        if m.get('ModuleType') is not None:
            self.module_type = m.get('ModuleType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentModuleId') is not None:
            self.parent_module_id = m.get('ParentModuleId')
        if m.get('Stack') is not None:
            self.stack = m.get('Stack')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class MonitorItem(TeaModel):
    def __init__(
        self,
        analysis_code: str = None,
        collection_type: str = None,
        config: str = None,
        enable: int = None,
        exec_interval: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        monitor_item_description: str = None,
        monitor_item_id: str = None,
        monitor_item_name: str = None,
        security_domain: str = None,
    ):
        # 解析代码
        self.analysis_code = analysis_code
        # 采集类型
        self.collection_type = collection_type
        # 采集配置
        self.config = config
        # 是否启用
        self.enable = enable
        # 采集间隔
        self.exec_interval = exec_interval
        # 创建时间
        self.gmt_create = gmt_create
        # 更新时间
        self.gmt_modified = gmt_modified
        # 描述
        self.monitor_item_description = monitor_item_description
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 监控项名称
        self.monitor_item_name = monitor_item_name
        # 安全域
        self.security_domain = security_domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_code is not None:
            result['AnalysisCode'] = self.analysis_code
        if self.collection_type is not None:
            result['CollectionType'] = self.collection_type
        if self.config is not None:
            result['Config'] = self.config
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.exec_interval is not None:
            result['ExecInterval'] = self.exec_interval
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.monitor_item_description is not None:
            result['MonitorItemDescription'] = self.monitor_item_description
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.monitor_item_name is not None:
            result['MonitorItemName'] = self.monitor_item_name
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnalysisCode') is not None:
            self.analysis_code = m.get('AnalysisCode')
        if m.get('CollectionType') is not None:
            self.collection_type = m.get('CollectionType')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('ExecInterval') is not None:
            self.exec_interval = m.get('ExecInterval')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('MonitorItemDescription') is not None:
            self.monitor_item_description = m.get('MonitorItemDescription')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('MonitorItemName') is not None:
            self.monitor_item_name = m.get('MonitorItemName')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        return self


class NetworkArchitecture(TeaModel):
    def __init__(
        self,
        arch_version_iteration_id: str = None,
        availabe: bool = None,
        children: List[str] = None,
        create_time: str = None,
        description: str = None,
        device_number: int = None,
        group_number: int = None,
        id: str = None,
        name: str = None,
        network_architecture_id: str = None,
        role: str = None,
        selected: bool = None,
        stack: bool = None,
        status: str = None,
        update_time: str = None,
        version: str = None,
    ):
        # 架构最新版本uuid
        self.arch_version_iteration_id = arch_version_iteration_id
        # 可用
        self.availabe = availabe
        # 子节点
        self.children = children
        # 创建时间
        self.create_time = create_time
        # 架构描述
        self.description = description
        # 设备数
        self.device_number = device_number
        # 组数
        self.group_number = group_number
        # 架构资源id
        self.id = id
        # 架构名称
        self.name = name
        # 资源一级ID
        self.network_architecture_id = network_architecture_id
        # 架构内容
        self.role = role
        # 可选
        self.selected = selected
        # 堆叠
        self.stack = stack
        # 架构状态
        self.status = status
        # 更新时间
        self.update_time = update_time
        # 架构版本
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arch_version_iteration_id is not None:
            result['ArchVersionIterationId'] = self.arch_version_iteration_id
        if self.availabe is not None:
            result['Availabe'] = self.availabe
        if self.children is not None:
            result['Children'] = self.children
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.device_number is not None:
            result['DeviceNumber'] = self.device_number
        if self.group_number is not None:
            result['GroupNumber'] = self.group_number
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.network_architecture_id is not None:
            result['NetworkArchitectureId'] = self.network_architecture_id
        if self.role is not None:
            result['Role'] = self.role
        if self.selected is not None:
            result['Selected'] = self.selected
        if self.stack is not None:
            result['Stack'] = self.stack
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArchVersionIterationId') is not None:
            self.arch_version_iteration_id = m.get('ArchVersionIterationId')
        if m.get('Availabe') is not None:
            self.availabe = m.get('Availabe')
        if m.get('Children') is not None:
            self.children = m.get('Children')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceNumber') is not None:
            self.device_number = m.get('DeviceNumber')
        if m.get('GroupNumber') is not None:
            self.group_number = m.get('GroupNumber')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetworkArchitectureId') is not None:
            self.network_architecture_id = m.get('NetworkArchitectureId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Selected') is not None:
            self.selected = m.get('Selected')
        if m.get('Stack') is not None:
            self.stack = m.get('Stack')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class NotificationGroup(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        notification_group_description: str = None,
        notification_group_id: str = None,
        notification_group_name: str = None,
        notification_group_type: str = None,
        webhook: str = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 描述
        self.notification_group_description = notification_group_description
        # 通知组ID
        self.notification_group_id = notification_group_id
        # 通知组名称
        self.notification_group_name = notification_group_name
        # 通知组类型
        self.notification_group_type = notification_group_type
        # 钉钉群webhook
        self.webhook = webhook

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.notification_group_description is not None:
            result['NotificationGroupDescription'] = self.notification_group_description
        if self.notification_group_id is not None:
            result['NotificationGroupId'] = self.notification_group_id
        if self.notification_group_name is not None:
            result['NotificationGroupName'] = self.notification_group_name
        if self.notification_group_type is not None:
            result['NotificationGroupType'] = self.notification_group_type
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('NotificationGroupDescription') is not None:
            self.notification_group_description = m.get('NotificationGroupDescription')
        if m.get('NotificationGroupId') is not None:
            self.notification_group_id = m.get('NotificationGroupId')
        if m.get('NotificationGroupName') is not None:
            self.notification_group_name = m.get('NotificationGroupName')
        if m.get('NotificationGroupType') is not None:
            self.notification_group_type = m.get('NotificationGroupType')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class Order(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modify: str = None,
        order_id: str = None,
        output: str = None,
        params: str = None,
        scheme_id: str = None,
        scheme_name: str = None,
        status: str = None,
        title: str = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 工单id
        self.order_id = order_id
        # 工单返回
        self.output = output
        # 工单参数
        self.params = params
        # 方案id
        self.scheme_id = scheme_id
        # 方案名
        self.scheme_name = scheme_name
        # 任务状态
        self.status = status
        # 工单标题
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.output is not None:
            result['Output'] = self.output
        if self.params is not None:
            result['Params'] = self.params
        if self.scheme_id is not None:
            result['SchemeId'] = self.scheme_id
        if self.scheme_name is not None:
            result['SchemeName'] = self.scheme_name
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('SchemeId') is not None:
            self.scheme_id = m.get('SchemeId')
        if m.get('SchemeName') is not None:
            self.scheme_name = m.get('SchemeName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class OrderStepRestriction(TeaModel):
    def __init__(
        self,
        label: str = None,
        value: str = None,
    ):
        # 步骤标题
        self.label = label
        # 步骤名
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label is not None:
            result['Label'] = self.label
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class OrderStep(TeaModel):
    def __init__(
        self,
        display_method: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        job_kwargs: str = None,
        job_message: str = None,
        job_return_status: str = None,
        job_return_values: str = None,
        job_system: str = None,
        order_id: str = None,
        order_step_id: str = None,
        real_next_step: str = None,
        restriction: List[OrderStepRestriction] = None,
        step_name: str = None,
        step_status: str = None,
        step_title: str = None,
        step_type: str = None,
    ):
        # 步骤展示方式
        self.display_method = display_method
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 步骤任务参数
        self.job_kwargs = job_kwargs
        # 步骤标题
        self.job_message = job_message
        # 步骤标题
        self.job_return_status = job_return_status
        # 步骤任务返回
        self.job_return_values = job_return_values
        # 步骤任务系统
        self.job_system = job_system
        # 工单id
        self.order_id = order_id
        # 工单步骤id
        self.order_step_id = order_step_id
        # 下一步步骤名
        self.real_next_step = real_next_step
        # 下一步步骤可选列表
        self.restriction = restriction
        # 步骤名
        self.step_name = step_name
        # 步骤状态
        self.step_status = step_status
        # 步骤标题
        self.step_title = step_title
        # 步骤类型
        self.step_type = step_type

    def validate(self):
        if self.restriction:
            for k in self.restriction:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_method is not None:
            result['DisplayMethod'] = self.display_method
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.job_kwargs is not None:
            result['JobKwargs'] = self.job_kwargs
        if self.job_message is not None:
            result['JobMessage'] = self.job_message
        if self.job_return_status is not None:
            result['JobReturnStatus'] = self.job_return_status
        if self.job_return_values is not None:
            result['JobReturnValues'] = self.job_return_values
        if self.job_system is not None:
            result['JobSystem'] = self.job_system
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.order_step_id is not None:
            result['OrderStepId'] = self.order_step_id
        if self.real_next_step is not None:
            result['RealNextStep'] = self.real_next_step
        result['Restriction'] = []
        if self.restriction is not None:
            for k in self.restriction:
                result['Restriction'].append(k.to_map() if k else None)
        if self.step_name is not None:
            result['StepName'] = self.step_name
        if self.step_status is not None:
            result['StepStatus'] = self.step_status
        if self.step_title is not None:
            result['StepTitle'] = self.step_title
        if self.step_type is not None:
            result['StepType'] = self.step_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayMethod') is not None:
            self.display_method = m.get('DisplayMethod')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('JobKwargs') is not None:
            self.job_kwargs = m.get('JobKwargs')
        if m.get('JobMessage') is not None:
            self.job_message = m.get('JobMessage')
        if m.get('JobReturnStatus') is not None:
            self.job_return_status = m.get('JobReturnStatus')
        if m.get('JobReturnValues') is not None:
            self.job_return_values = m.get('JobReturnValues')
        if m.get('JobSystem') is not None:
            self.job_system = m.get('JobSystem')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('OrderStepId') is not None:
            self.order_step_id = m.get('OrderStepId')
        if m.get('RealNextStep') is not None:
            self.real_next_step = m.get('RealNextStep')
        self.restriction = []
        if m.get('Restriction') is not None:
            for k in m.get('Restriction'):
                temp_model = OrderStepRestriction()
                self.restriction.append(temp_model.from_map(k))
        if m.get('StepName') is not None:
            self.step_name = m.get('StepName')
        if m.get('StepStatus') is not None:
            self.step_status = m.get('StepStatus')
        if m.get('StepTitle') is not None:
            self.step_title = m.get('StepTitle')
        if m.get('StepType') is not None:
            self.step_type = m.get('StepType')
        return self


class OsVersion(TeaModel):
    def __init__(
        self,
        access_id: str = None,
        create_time: str = None,
        directory: str = None,
        expire_time: str = None,
        file_name: str = None,
        file_path: str = None,
        host: str = None,
        model: str = None,
        os_version: str = None,
        os_version_id: str = None,
        policy: str = None,
        signature: str = None,
        status: str = None,
        vendor: str = None,
    ):
        # 用户名
        self.access_id = access_id
        # 创建时间
        self.create_time = create_time
        # 目录
        self.directory = directory
        # 过期时间
        self.expire_time = expire_time
        # file
        self.file_name = file_name
        # 文件路径
        self.file_path = file_path
        # 主机
        self.host = host
        # 型号
        self.model = model
        # 版本
        self.os_version = os_version
        # 资源id
        self.os_version_id = os_version_id
        # 策略
        self.policy = policy
        # 签名
        self.signature = signature
        # 状态
        self.status = status
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_id is not None:
            result['AccessId'] = self.access_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.directory is not None:
            result['Directory'] = self.directory
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.host is not None:
            result['Host'] = self.host
        if self.model is not None:
            result['Model'] = self.model
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.os_version_id is not None:
            result['OsVersionId'] = self.os_version_id
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.status is not None:
            result['Status'] = self.status
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessId') is not None:
            self.access_id = m.get('AccessId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Directory') is not None:
            self.directory = m.get('Directory')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('OsVersionId') is not None:
            self.os_version_id = m.get('OsVersionId')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class PhysicalSpace(TeaModel):
    def __init__(
        self,
        address: str = None,
        city: str = None,
        country: str = None,
        province: str = None,
        space_id: str = None,
        space_name: str = None,
    ):
        # 具体所在地址
        self.address = address
        # 所属城市
        self.city = city
        # 所属国家
        self.country = country
        # 所属省份
        self.province = province
        # 物理空间ID
        self.space_id = space_id
        # 物理空间名称
        self.space_name = space_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.city is not None:
            result['City'] = self.city
        if self.country is not None:
            result['Country'] = self.country
        if self.province is not None:
            result['Province'] = self.province
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.space_name is not None:
            result['SpaceName'] = self.space_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('SpaceName') is not None:
            self.space_name = m.get('SpaceName')
        return self


class Port(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        port_collection_id: str = None,
        port_name: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 端口名称
        self.port_name = port_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.port_name is not None:
            result['PortName'] = self.port_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        return self


class PortCollection(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modified: str = None,
        port_collection_description: str = None,
        port_collection_id: str = None,
        port_collection_name: str = None,
        port_list: List[Port] = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 描述
        self.port_collection_description = port_collection_description
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 端口集名称
        self.port_collection_name = port_collection_name
        # 端口列表
        self.port_list = port_list

    def validate(self):
        if self.port_list:
            for k in self.port_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.port_collection_description is not None:
            result['PortCollectionDescription'] = self.port_collection_description
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.port_collection_name is not None:
            result['PortCollectionName'] = self.port_collection_name
        result['PortList'] = []
        if self.port_list is not None:
            for k in self.port_list:
                result['PortList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('PortCollectionDescription') is not None:
            self.port_collection_description = m.get('PortCollectionDescription')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('PortCollectionName') is not None:
            self.port_collection_name = m.get('PortCollectionName')
        self.port_list = []
        if m.get('PortList') is not None:
            for k in m.get('PortList'):
                temp_model = Port()
                self.port_list.append(temp_model.from_map(k))
        return self


class ResourceInformationInformation(TeaModel):
    def __init__(
        self,
        key: str = None,
        key_action: str = None,
        key_attribute: str = None,
        key_description: str = None,
    ):
        # 键
        self.key = key
        # 键动作
        self.key_action = key_action
        # 键属性
        self.key_attribute = key_attribute
        # 键描述
        self.key_description = key_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.key_action is not None:
            result['KeyAction'] = self.key_action
        if self.key_attribute is not None:
            result['KeyAttribute'] = self.key_attribute
        if self.key_description is not None:
            result['KeyDescription'] = self.key_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyAction') is not None:
            self.key_action = m.get('KeyAction')
        if m.get('KeyAttribute') is not None:
            self.key_attribute = m.get('KeyAttribute')
        if m.get('KeyDescription') is not None:
            self.key_description = m.get('KeyDescription')
        return self


class ResourceInformation(TeaModel):
    def __init__(
        self,
        architecture_id: str = None,
        create_time: str = None,
        information: List[ResourceInformationInformation] = None,
        resource_attribute: str = None,
        resource_information_id: str = None,
        resource_type: str = None,
        setup_project_id: str = None,
        update_time: str = None,
    ):
        # 架构id
        self.architecture_id = architecture_id
        # 创建时间
        self.create_time = create_time
        # 信息
        self.information = information
        # 资源属性
        self.resource_attribute = resource_attribute
        # 资源一级ID
        self.resource_information_id = resource_information_id
        # 资源类型
        self.resource_type = resource_type
        # 建设项目资源id
        self.setup_project_id = setup_project_id
        # 更新时间
        self.update_time = update_time

    def validate(self):
        if self.information:
            for k in self.information:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture_id is not None:
            result['ArchitectureId'] = self.architecture_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['Information'] = []
        if self.information is not None:
            for k in self.information:
                result['Information'].append(k.to_map() if k else None)
        if self.resource_attribute is not None:
            result['ResourceAttribute'] = self.resource_attribute
        if self.resource_information_id is not None:
            result['ResourceInformationId'] = self.resource_information_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArchitectureId') is not None:
            self.architecture_id = m.get('ArchitectureId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.information = []
        if m.get('Information') is not None:
            for k in m.get('Information'):
                temp_model = ResourceInformationInformation()
                self.information.append(temp_model.from_map(k))
        if m.get('ResourceAttribute') is not None:
            self.resource_attribute = m.get('ResourceAttribute')
        if m.get('ResourceInformationId') is not None:
            self.resource_information_id = m.get('ResourceInformationId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ScheduleDutyTypeWorkerList(TeaModel):
    def __init__(
        self,
        schedule_type_id: str = None,
        schedule_worker_name: List[str] = None,
    ):
        # scheduleTypeId
        self.schedule_type_id = schedule_type_id
        # 值班人员姓名
        self.schedule_worker_name = schedule_worker_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_type_id is not None:
            result['ScheduleTypeId'] = self.schedule_type_id
        if self.schedule_worker_name is not None:
            result['ScheduleWorkerName'] = self.schedule_worker_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScheduleTypeId') is not None:
            self.schedule_type_id = m.get('ScheduleTypeId')
        if m.get('ScheduleWorkerName') is not None:
            self.schedule_worker_name = m.get('ScheduleWorkerName')
        return self


class ScheduleDuty(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        end_date: str = None,
        schedule_duty_id: str = None,
        schedule_type_ids: List[str] = None,
        start_date: str = None,
        type_worker_list: List[ScheduleDutyTypeWorkerList] = None,
        update_time: str = None,
        work_date: str = None,
        work_type: str = None,
        worker_id: str = None,
        worker_name: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 结束时间
        self.end_date = end_date
        # 资源一级ID
        self.schedule_duty_id = schedule_duty_id
        # scheduleTypeIds
        self.schedule_type_ids = schedule_type_ids
        # 开始时间
        self.start_date = start_date
        # typeWorkerList
        self.type_worker_list = type_worker_list
        # 更新时间
        self.update_time = update_time
        # 值班表日期
        self.work_date = work_date
        # 值班表类型
        self.work_type = work_type
        # 值班人员工号
        self.worker_id = worker_id
        # 值班人员姓名
        self.worker_name = worker_name

    def validate(self):
        if self.type_worker_list:
            for k in self.type_worker_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.schedule_duty_id is not None:
            result['ScheduleDutyId'] = self.schedule_duty_id
        if self.schedule_type_ids is not None:
            result['ScheduleTypeIds'] = self.schedule_type_ids
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        result['TypeWorkerList'] = []
        if self.type_worker_list is not None:
            for k in self.type_worker_list:
                result['TypeWorkerList'].append(k.to_map() if k else None)
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.work_date is not None:
            result['WorkDate'] = self.work_date
        if self.work_type is not None:
            result['WorkType'] = self.work_type
        if self.worker_id is not None:
            result['WorkerId'] = self.worker_id
        if self.worker_name is not None:
            result['WorkerName'] = self.worker_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ScheduleDutyId') is not None:
            self.schedule_duty_id = m.get('ScheduleDutyId')
        if m.get('ScheduleTypeIds') is not None:
            self.schedule_type_ids = m.get('ScheduleTypeIds')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        self.type_worker_list = []
        if m.get('TypeWorkerList') is not None:
            for k in m.get('TypeWorkerList'):
                temp_model = ScheduleDutyTypeWorkerList()
                self.type_worker_list.append(temp_model.from_map(k))
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('WorkDate') is not None:
            self.work_date = m.get('WorkDate')
        if m.get('WorkType') is not None:
            self.work_type = m.get('WorkType')
        if m.get('WorkerId') is not None:
            self.worker_id = m.get('WorkerId')
        if m.get('WorkerName') is not None:
            self.worker_name = m.get('WorkerName')
        return self


class ScheduleType(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        key: str = None,
        related_worker: List[str] = None,
        schedule_type_id: str = None,
        status: str = None,
        update_time: str = None,
        value: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 值班类型key
        self.key = key
        # relatedWorkerStr
        self.related_worker = related_worker
        # 资源一级ID
        self.schedule_type_id = schedule_type_id
        # 值班类型状态
        self.status = status
        # 更新时间
        self.update_time = update_time
        # 值班类型value
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.key is not None:
            result['Key'] = self.key
        if self.related_worker is not None:
            result['RelatedWorker'] = self.related_worker
        if self.schedule_type_id is not None:
            result['ScheduleTypeId'] = self.schedule_type_id
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('RelatedWorker') is not None:
            self.related_worker = m.get('RelatedWorker')
        if m.get('ScheduleTypeId') is not None:
            self.schedule_type_id = m.get('ScheduleTypeId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ScheduleWorker(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        schedule_worker_id: str = None,
        update_time: str = None,
        worker_contact: str = None,
        worker_id: str = None,
        worker_name: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.schedule_worker_id = schedule_worker_id
        # 更新时间
        self.update_time = update_time
        # 联系方式
        self.worker_contact = worker_contact
        # 值班人员工号
        self.worker_id = worker_id
        # 值班人员姓名
        self.worker_name = worker_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.schedule_worker_id is not None:
            result['ScheduleWorkerId'] = self.schedule_worker_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.worker_contact is not None:
            result['WorkerContact'] = self.worker_contact
        if self.worker_id is not None:
            result['WorkerId'] = self.worker_id
        if self.worker_name is not None:
            result['WorkerName'] = self.worker_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ScheduleWorkerId') is not None:
            self.schedule_worker_id = m.get('ScheduleWorkerId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('WorkerContact') is not None:
            self.worker_contact = m.get('WorkerContact')
        if m.get('WorkerId') is not None:
            self.worker_id = m.get('WorkerId')
        if m.get('WorkerName') is not None:
            self.worker_name = m.get('WorkerName')
        return self


class SchemeInput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class SchemeOutput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class Scheme(TeaModel):
    def __init__(
        self,
        category: str = None,
        content: str = None,
        description: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        input: List[SchemeInput] = None,
        output: List[SchemeOutput] = None,
        scheme_id: str = None,
        scheme_name: str = None,
        status: str = None,
        view: str = None,
    ):
        # 方案类型
        self.category = category
        # 方案内容
        self.content = content
        # 方案说明
        self.description = description
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 方案入参
        self.input = input
        # 方案出参
        self.output = output
        # 方案id
        self.scheme_id = scheme_id
        # 方案名称
        self.scheme_name = scheme_name
        # 方案状态
        self.status = status
        # 方案展示
        self.view = view

    def validate(self):
        if self.input:
            for k in self.input:
                if k:
                    k.validate()
        if self.output:
            for k in self.output:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.content is not None:
            result['Content'] = self.content
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        result['Input'] = []
        if self.input is not None:
            for k in self.input:
                result['Input'].append(k.to_map() if k else None)
        result['Output'] = []
        if self.output is not None:
            for k in self.output:
                result['Output'].append(k.to_map() if k else None)
        if self.scheme_id is not None:
            result['SchemeId'] = self.scheme_id
        if self.scheme_name is not None:
            result['SchemeName'] = self.scheme_name
        if self.status is not None:
            result['Status'] = self.status
        if self.view is not None:
            result['View'] = self.view
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        self.input = []
        if m.get('Input') is not None:
            for k in m.get('Input'):
                temp_model = SchemeInput()
                self.input.append(temp_model.from_map(k))
        self.output = []
        if m.get('Output') is not None:
            for k in m.get('Output'):
                temp_model = SchemeOutput()
                self.output.append(temp_model.from_map(k))
        if m.get('SchemeId') is not None:
            self.scheme_id = m.get('SchemeId')
        if m.get('SchemeName') is not None:
            self.scheme_name = m.get('SchemeName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('View') is not None:
            self.view = m.get('View')
        return self


class ScriptInput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ScriptOutput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ScriptRule(TeaModel):
    def __init__(
        self,
        arch: str = None,
        domain: str = None,
        model: str = None,
        os: str = None,
        role: str = None,
        rule_id: str = None,
        script_id: str = None,
        vendor: str = None,
    ):
        # 设备架构
        self.arch = arch
        # 设备安全域
        self.domain = domain
        # 设备型号
        self.model = model
        # 设备OS版本
        self.os = os
        # 设备角色
        self.role = role
        # 规则id
        self.rule_id = rule_id
        # 脚本id
        self.script_id = script_id
        # 设备厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arch is not None:
            result['Arch'] = self.arch
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.model is not None:
            result['Model'] = self.model
        if self.os is not None:
            result['Os'] = self.os
        if self.role is not None:
            result['Role'] = self.role
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arch') is not None:
            self.arch = m.get('Arch')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class Script(TeaModel):
    def __init__(
        self,
        content: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        input: List[ScriptInput] = None,
        output: List[ScriptOutput] = None,
        rules: List[ScriptRule] = None,
        script_id: str = None,
        template_id: str = None,
        version_id: str = None,
    ):
        # 脚本代码
        self.content = content
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 模板入参
        self.input = input
        # 模板出参
        self.output = output
        # 规则列表
        self.rules = rules
        # 脚本id
        self.script_id = script_id
        # 模板id
        self.template_id = template_id
        # 版本id
        self.version_id = version_id

    def validate(self):
        if self.input:
            for k in self.input:
                if k:
                    k.validate()
        if self.output:
            for k in self.output:
                if k:
                    k.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        result['Input'] = []
        if self.input is not None:
            for k in self.input:
                result['Input'].append(k.to_map() if k else None)
        result['Output'] = []
        if self.output is not None:
            for k in self.output:
                result['Output'].append(k.to_map() if k else None)
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.version_id is not None:
            result['VersionId'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        self.input = []
        if m.get('Input') is not None:
            for k in m.get('Input'):
                temp_model = ScriptInput()
                self.input.append(temp_model.from_map(k))
        self.output = []
        if m.get('Output') is not None:
            for k in m.get('Output'):
                temp_model = ScriptOutput()
                self.output.append(temp_model.from_map(k))
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = ScriptRule()
                self.rules.append(temp_model.from_map(k))
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('VersionId') is not None:
            self.version_id = m.get('VersionId')
        return self


class ScriptHistoryInput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ScriptHistoryOutput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ScriptHistory(TeaModel):
    def __init__(
        self,
        comment: str = None,
        content: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        input: List[ScriptHistoryInput] = None,
        output: List[ScriptHistoryOutput] = None,
        script_id: str = None,
        version_id: str = None,
    ):
        # 版本说明
        self.comment = comment
        # 脚本代码
        self.content = content
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 模板入参
        self.input = input
        # 模板出参
        self.output = output
        # 脚本id
        self.script_id = script_id
        # 版本id
        self.version_id = version_id

    def validate(self):
        if self.input:
            for k in self.input:
                if k:
                    k.validate()
        if self.output:
            for k in self.output:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.content is not None:
            result['Content'] = self.content
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        result['Input'] = []
        if self.input is not None:
            for k in self.input:
                result['Input'].append(k.to_map() if k else None)
        result['Output'] = []
        if self.output is not None:
            for k in self.output:
                result['Output'].append(k.to_map() if k else None)
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        if self.version_id is not None:
            result['VersionId'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        self.input = []
        if m.get('Input') is not None:
            for k in m.get('Input'):
                temp_model = ScriptHistoryInput()
                self.input.append(temp_model.from_map(k))
        self.output = []
        if m.get('Output') is not None:
            for k in m.get('Output'):
                temp_model = ScriptHistoryOutput()
                self.output.append(temp_model.from_map(k))
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        if m.get('VersionId') is not None:
            self.version_id = m.get('VersionId')
        return self


class SetupProjectPackages(TeaModel):
    def __init__(
        self,
        device_number: str = None,
        model: str = None,
        role: str = None,
        vendor: str = None,
    ):
        # 设备号
        self.device_number = device_number
        # 型号
        self.model = model
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_number is not None:
            result['DeviceNumber'] = self.device_number
        if self.model is not None:
            result['Model'] = self.model
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceNumber') is not None:
            self.device_number = m.get('DeviceNumber')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class SetupProject(TeaModel):
    def __init__(
        self,
        arch_id: str = None,
        arch_version: str = None,
        architecture_id: str = None,
        create_time: str = None,
        delivery_time: str = None,
        description: str = None,
        nodes: str = None,
        packages: List[SetupProjectPackages] = None,
        setup_project_id: str = None,
        setup_project_name: str = None,
        space_id: str = None,
        space_name: str = None,
        space_type: str = None,
        status: str = None,
    ):
        # 架构id
        self.arch_id = arch_id
        # 架构版本
        self.arch_version = arch_version
        # 架构id
        self.architecture_id = architecture_id
        # 创建时间
        self.create_time = create_time
        # 预计交付时间
        self.delivery_time = delivery_time
        # 描述
        self.description = description
        # 节点
        self.nodes = nodes
        # 套餐
        self.packages = packages
        # 资源一级ID
        self.setup_project_id = setup_project_id
        # 资源名称
        self.setup_project_name = setup_project_name
        # 物理空间uId
        self.space_id = space_id
        # 物理空间名称
        self.space_name = space_name
        # 物理空间类型
        self.space_type = space_type
        # 状态
        self.status = status

    def validate(self):
        if self.packages:
            for k in self.packages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arch_id is not None:
            result['ArchId'] = self.arch_id
        if self.arch_version is not None:
            result['ArchVersion'] = self.arch_version
        if self.architecture_id is not None:
            result['ArchitectureId'] = self.architecture_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.delivery_time is not None:
            result['DeliveryTime'] = self.delivery_time
        if self.description is not None:
            result['Description'] = self.description
        if self.nodes is not None:
            result['Nodes'] = self.nodes
        result['Packages'] = []
        if self.packages is not None:
            for k in self.packages:
                result['Packages'].append(k.to_map() if k else None)
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.setup_project_name is not None:
            result['SetupProjectName'] = self.setup_project_name
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.space_name is not None:
            result['SpaceName'] = self.space_name
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArchId') is not None:
            self.arch_id = m.get('ArchId')
        if m.get('ArchVersion') is not None:
            self.arch_version = m.get('ArchVersion')
        if m.get('ArchitectureId') is not None:
            self.architecture_id = m.get('ArchitectureId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeliveryTime') is not None:
            self.delivery_time = m.get('DeliveryTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Nodes') is not None:
            self.nodes = m.get('Nodes')
        self.packages = []
        if m.get('Packages') is not None:
            for k in m.get('Packages'):
                temp_model = SetupProjectPackages()
                self.packages.append(temp_model.from_map(k))
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('SetupProjectName') is not None:
            self.setup_project_name = m.get('SetupProjectName')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('SpaceName') is not None:
            self.space_name = m.get('SpaceName')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class SpaceModelSort(TeaModel):
    def __init__(
        self,
        level: int = None,
        level_name: str = None,
    ):
        # 层次
        self.level = level
        # 分层名称
        self.level_name = level_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.level_name is not None:
            result['LevelName'] = self.level_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LevelName') is not None:
            self.level_name = m.get('LevelName')
        return self


class SpaceModelSpaceModelSort(TeaModel):
    def __init__(
        self,
        level: int = None,
        levle_name: str = None,
    ):
        # 层级
        self.level = level
        # 层级名称
        self.levle_name = levle_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.levle_name is not None:
            result['LevleName'] = self.levle_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LevleName') is not None:
            self.levle_name = m.get('LevleName')
        return self


class SpaceModelSpaceModel(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        sort: SpaceModelSpaceModelSort = None,
        space_model_id: str = None,
        space_type: str = None,
        status: str = None,
        update_time: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 模型实例
        self.sort = sort
        # 物理空间模型id
        self.space_model_id = space_model_id
        # 物理空间类型
        self.space_type = space_type
        # 模型状态
        self.status = status
        # 更新时间
        self.update_time = update_time

    def validate(self):
        if self.sort:
            self.sort.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.sort is not None:
            result['Sort'] = self.sort.to_map()
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Sort') is not None:
            temp_model = SpaceModelSpaceModelSort()
            self.sort = temp_model.from_map(m['Sort'])
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class SpaceModel(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        instance: str = None,
        operate_type: str = None,
        sort: SpaceModelSort = None,
        space_id: str = None,
        space_model: SpaceModelSpaceModel = None,
        space_model_id: str = None,
        space_model_name: str = None,
        space_type: str = None,
        status: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 物理空间实例
        self.instance = instance
        # 操作类型
        self.operate_type = operate_type
        # 层级
        self.sort = sort
        # 物理空间id
        self.space_id = space_id
        # 物理空间模型
        self.space_model = space_model
        # 资源一级ID
        self.space_model_id = space_model_id
        # 资源名称
        self.space_model_name = space_model_name
        # 物理空间类型
        self.space_type = space_type
        # 状态
        self.status = status

    def validate(self):
        if self.sort:
            self.sort.validate()
        if self.space_model:
            self.space_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.instance is not None:
            result['Instance'] = self.instance
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.sort is not None:
            result['Sort'] = self.sort.to_map()
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.space_model is not None:
            result['SpaceModel'] = self.space_model.to_map()
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        if self.space_model_name is not None:
            result['SpaceModelName'] = self.space_model_name
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('Sort') is not None:
            temp_model = SpaceModelSort()
            self.sort = temp_model.from_map(m['Sort'])
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('SpaceModel') is not None:
            temp_model = SpaceModelSpaceModel()
            self.space_model = temp_model.from_map(m['SpaceModel'])
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        if m.get('SpaceModelName') is not None:
            self.space_model_name = m.get('SpaceModelName')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class SubscriptionItem(TeaModel):
    def __init__(
        self,
        alarm_status: str = None,
        language: str = None,
        monitor_item_id: str = None,
        notification_group_id: str = None,
        notification_mode: str = None,
        recovery_notice: int = None,
        subscription_item_id: str = None,
        subscription_type: str = None,
        suppression_strategy: str = None,
        trigger_times: int = None,
    ):
        # 告警状态
        self.alarm_status = alarm_status
        # 发送通知的语言
        self.language = language
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 通知组ID
        self.notification_group_id = notification_group_id
        # 通知方式
        self.notification_mode = notification_mode
        # 是否发送通知
        self.recovery_notice = recovery_notice
        # 订阅项ID
        self.subscription_item_id = subscription_item_id
        # 订阅类型
        self.subscription_type = subscription_type
        # 抑制策略
        self.suppression_strategy = suppression_strategy
        # 连续触发次数
        self.trigger_times = trigger_times

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.language is not None:
            result['Language'] = self.language
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.notification_group_id is not None:
            result['NotificationGroupId'] = self.notification_group_id
        if self.notification_mode is not None:
            result['NotificationMode'] = self.notification_mode
        if self.recovery_notice is not None:
            result['RecoveryNotice'] = self.recovery_notice
        if self.subscription_item_id is not None:
            result['SubscriptionItemId'] = self.subscription_item_id
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.suppression_strategy is not None:
            result['SuppressionStrategy'] = self.suppression_strategy
        if self.trigger_times is not None:
            result['TriggerTimes'] = self.trigger_times
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('Language') is not None:
            self.language = m.get('Language')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('NotificationGroupId') is not None:
            self.notification_group_id = m.get('NotificationGroupId')
        if m.get('NotificationMode') is not None:
            self.notification_mode = m.get('NotificationMode')
        if m.get('RecoveryNotice') is not None:
            self.recovery_notice = m.get('RecoveryNotice')
        if m.get('SubscriptionItemId') is not None:
            self.subscription_item_id = m.get('SubscriptionItemId')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('SuppressionStrategy') is not None:
            self.suppression_strategy = m.get('SuppressionStrategy')
        if m.get('TriggerTimes') is not None:
            self.trigger_times = m.get('TriggerTimes')
        return self


class Task(TeaModel):
    def __init__(
        self,
        category: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        params: str = None,
        response_code: str = None,
        result: str = None,
        status: str = None,
        task_id: str = None,
        template_id: str = None,
        template_name: str = None,
    ):
        # 模板类别
        self.category = category
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 任务参数
        self.params = params
        # 任务错误码
        self.response_code = response_code
        # 任务返回
        self.result = result
        # 任务状态
        self.status = status
        # 任务id
        self.task_id = task_id
        # 模板id
        self.template_id = template_id
        # 模板名称
        self.template_name = template_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        if self.params is not None:
            result['Params'] = self.params
        if self.response_code is not None:
            result['ResponseCode'] = self.response_code
        if self.result is not None:
            result['Result'] = self.result
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('ResponseCode') is not None:
            self.response_code = m.get('ResponseCode')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        return self


class TaskLog(TeaModel):
    def __init__(
        self,
        func_name: str = None,
        gmt_create: str = None,
        level: str = None,
        line_no: int = None,
        log_id: str = None,
        message: str = None,
        task_id: str = None,
    ):
        # 函数名
        self.func_name = func_name
        # 记录时间
        self.gmt_create = gmt_create
        # 日志等级
        self.level = level
        # 行数
        self.line_no = line_no
        # 日志id
        self.log_id = log_id
        # 日志信息
        self.message = message
        # 任务id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.func_name is not None:
            result['FuncName'] = self.func_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.level is not None:
            result['Level'] = self.level
        if self.line_no is not None:
            result['LineNo'] = self.line_no
        if self.log_id is not None:
            result['LogId'] = self.log_id
        if self.message is not None:
            result['Message'] = self.message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FuncName') is not None:
            self.func_name = m.get('FuncName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LineNo') is not None:
            self.line_no = m.get('LineNo')
        if m.get('LogId') is not None:
            self.log_id = m.get('LogId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class TemplateInput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class TemplateOutput(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        sample: str = None,
        type: str = None,
    ):
        # 参数说明
        self.description = description
        # 参数名称
        self.name = name
        # 参数示例
        self.sample = sample
        # 参数类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.sample is not None:
            result['Sample'] = self.sample
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Sample') is not None:
            self.sample = m.get('Sample')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class Template(TeaModel):
    def __init__(
        self,
        category: str = None,
        comment: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        input: List[TemplateInput] = None,
        output: List[TemplateOutput] = None,
        template_name: str = None,
        template_type: str = None,
    ):
        # 模板类型
        self.category = category
        # 模板说明
        self.comment = comment
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modify = gmt_modify
        # 模板入参
        self.input = input
        # 模板出参
        self.output = output
        # 模板名称
        self.template_name = template_name
        # 模板类型
        self.template_type = template_type

    def validate(self):
        if self.input:
            for k in self.input:
                if k:
                    k.validate()
        if self.output:
            for k in self.output:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modify is not None:
            result['GmtModify'] = self.gmt_modify
        result['Input'] = []
        if self.input is not None:
            for k in self.input:
                result['Input'].append(k.to_map() if k else None)
        result['Output'] = []
        if self.output is not None:
            for k in self.output:
                result['Output'].append(k.to_map() if k else None)
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModify') is not None:
            self.gmt_modify = m.get('GmtModify')
        self.input = []
        if m.get('Input') is not None:
            for k in m.get('Input'):
                temp_model = TemplateInput()
                self.input.append(temp_model.from_map(k))
        self.output = []
        if m.get('Output') is not None:
            for k in m.get('Output'):
                temp_model = TemplateOutput()
                self.output.append(temp_model.from_map(k))
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        return self


class TimePeriod(TeaModel):
    def __init__(
        self,
        cron_expression: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        source: str = None,
        time_period_description: str = None,
        time_period_id: str = None,
        time_period_name: str = None,
    ):
        # Cron表达式
        self.cron_expression = cron_expression
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 来源
        self.source = source
        # 描述
        self.time_period_description = time_period_description
        # 时间段ID
        self.time_period_id = time_period_id
        # 时间段名称
        self.time_period_name = time_period_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.source is not None:
            result['Source'] = self.source
        if self.time_period_description is not None:
            result['TimePeriodDescription'] = self.time_period_description
        if self.time_period_id is not None:
            result['TimePeriodId'] = self.time_period_id
        if self.time_period_name is not None:
            result['TimePeriodName'] = self.time_period_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('TimePeriodDescription') is not None:
            self.time_period_description = m.get('TimePeriodDescription')
        if m.get('TimePeriodId') is not None:
            self.time_period_id = m.get('TimePeriodId')
        if m.get('TimePeriodName') is not None:
            self.time_period_name = m.get('TimePeriodName')
        return self


class ZoneTypeZoneTypeLayer(TeaModel):
    def __init__(
        self,
        mask: int = None,
        name: str = None,
    ):
        # 园区层级掩码
        self.mask = mask
        # 园区层级名称
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ZoneType(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        name: str = None,
        zone_type_id: str = None,
        zone_type_layer: List[ZoneTypeZoneTypeLayer] = None,
        zone_type_name: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 园区类型名称
        self.name = name
        # 资源一级ID
        self.zone_type_id = zone_type_id
        # 园区层级
        self.zone_type_layer = zone_type_layer
        # 资源名称
        self.zone_type_name = zone_type_name

    def validate(self):
        if self.zone_type_layer:
            for k in self.zone_type_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.name is not None:
            result['Name'] = self.name
        if self.zone_type_id is not None:
            result['ZoneTypeId'] = self.zone_type_id
        result['ZoneTypeLayer'] = []
        if self.zone_type_layer is not None:
            for k in self.zone_type_layer:
                result['ZoneTypeLayer'].append(k.to_map() if k else None)
        if self.zone_type_name is not None:
            result['ZoneTypeName'] = self.zone_type_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ZoneTypeId') is not None:
            self.zone_type_id = m.get('ZoneTypeId')
        self.zone_type_layer = []
        if m.get('ZoneTypeLayer') is not None:
            for k in m.get('ZoneTypeLayer'):
                temp_model = ZoneTypeZoneTypeLayer()
                self.zone_type_layer.append(temp_model.from_map(k))
        if m.get('ZoneTypeName') is not None:
            self.zone_type_name = m.get('ZoneTypeName')
        return self


class ApplyIPRequest(TeaModel):
    def __init__(
        self,
        business_type_id: str = None,
        business_type_params: str = None,
        device_resource_id: str = None,
        device_resource_ids: List[str] = None,
        instance_id: str = None,
        ip_type: str = None,
        loopback_port: str = None,
        net_location: str = None,
        setup_project_id: str = None,
    ):
        # 业务类型id
        self.business_type_id = business_type_id
        # 业务参数
        self.business_type_params = business_type_params
        # deviceResourceId
        self.device_resource_id = device_resource_id
        # 设备uuid列表
        self.device_resource_ids = device_resource_ids
        # instanceId
        self.instance_id = instance_id
        # ip地址类型
        self.ip_type = ip_type
        # Loopback端口
        self.loopback_port = loopback_port
        # 位置空间
        self.net_location = net_location
        # 建设项目id
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.business_type_params is not None:
            result['BusinessTypeParams'] = self.business_type_params
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.device_resource_ids is not None:
            result['DeviceResourceIds'] = self.device_resource_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.loopback_port is not None:
            result['LoopbackPort'] = self.loopback_port
        if self.net_location is not None:
            result['NetLocation'] = self.net_location
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('BusinessTypeParams') is not None:
            self.business_type_params = m.get('BusinessTypeParams')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids = m.get('DeviceResourceIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('LoopbackPort') is not None:
            self.loopback_port = m.get('LoopbackPort')
        if m.get('NetLocation') is not None:
            self.net_location = m.get('NetLocation')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class ApplyIPShrinkRequest(TeaModel):
    def __init__(
        self,
        business_type_id: str = None,
        business_type_params: str = None,
        device_resource_id: str = None,
        device_resource_ids_shrink: str = None,
        instance_id: str = None,
        ip_type: str = None,
        loopback_port: str = None,
        net_location: str = None,
        setup_project_id: str = None,
    ):
        # 业务类型id
        self.business_type_id = business_type_id
        # 业务参数
        self.business_type_params = business_type_params
        # deviceResourceId
        self.device_resource_id = device_resource_id
        # 设备uuid列表
        self.device_resource_ids_shrink = device_resource_ids_shrink
        # instanceId
        self.instance_id = instance_id
        # ip地址类型
        self.ip_type = ip_type
        # Loopback端口
        self.loopback_port = loopback_port
        # 位置空间
        self.net_location = net_location
        # 建设项目id
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.business_type_params is not None:
            result['BusinessTypeParams'] = self.business_type_params
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.device_resource_ids_shrink is not None:
            result['DeviceResourceIds'] = self.device_resource_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.loopback_port is not None:
            result['LoopbackPort'] = self.loopback_port
        if self.net_location is not None:
            result['NetLocation'] = self.net_location
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('BusinessTypeParams') is not None:
            self.business_type_params = m.get('BusinessTypeParams')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids_shrink = m.get('DeviceResourceIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('LoopbackPort') is not None:
            self.loopback_port = m.get('LoopbackPort')
        if m.get('NetLocation') is not None:
            self.net_location = m.get('NetLocation')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class ApplyIPResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApplyIPResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ApplyIPResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ApplyIPResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AutoDutyRequest(TeaModel):
    def __init__(
        self,
        duty_batch: str = None,
        duty_name: str = None,
        end_date: str = None,
        instance_id: str = None,
        start_date: str = None,
    ):
        # 批次号
        self.duty_batch = duty_batch
        # 表明
        self.duty_name = duty_name
        # 结束时间
        self.end_date = end_date
        # instanceId
        self.instance_id = instance_id
        # 开始时间
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duty_batch is not None:
            result['DutyBatch'] = self.duty_batch
        if self.duty_name is not None:
            result['DutyName'] = self.duty_name
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DutyBatch') is not None:
            self.duty_batch = m.get('DutyBatch')
        if m.get('DutyName') is not None:
            self.duty_name = m.get('DutyName')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class AutoDutyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AutoDutyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AutoDutyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AutoDutyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloseEventRequest(TeaModel):
    def __init__(
        self,
        event_name: str = None,
        event_object_id: str = None,
        event_type: str = None,
        instance_id: str = None,
    ):
        # 事件名称
        self.event_name = event_name
        # 事件对象ID
        self.event_object_id = event_object_id
        # 事件类型
        self.event_type = event_type
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_object_id is not None:
            result['EventObjectId'] = self.event_object_id
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventObjectId') is not None:
            self.event_object_id = m.get('EventObjectId')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CloseEventResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CloseEventResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CloseEventResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CloseEventResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConfigurationSpecificationRequest(TeaModel):
    def __init__(
        self,
        architecture: str = None,
        client_token: str = None,
        instance_id: str = None,
        model: str = None,
        related_variate: List[bytes] = None,
        role: str = None,
        specification_content: str = None,
        specification_name: str = None,
        vendor: str = None,
    ):
        # 架构类型
        self.architecture = architecture
        # 幂等参数
        self.client_token = client_token
        # instanceId
        self.instance_id = instance_id
        # 型号
        self.model = model
        # 相关变量
        self.related_variate = related_variate
        # 角色
        self.role = role
        # 配置规范内容
        self.specification_content = specification_content
        # 配置规范名字
        self.specification_name = specification_name
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.model is not None:
            result['Model'] = self.model
        if self.related_variate is not None:
            result['RelatedVariate'] = self.related_variate
        if self.role is not None:
            result['Role'] = self.role
        if self.specification_content is not None:
            result['SpecificationContent'] = self.specification_content
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('RelatedVariate') is not None:
            self.related_variate = m.get('RelatedVariate')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SpecificationContent') is not None:
            self.specification_content = m.get('SpecificationContent')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class CreateConfigurationSpecificationShrinkRequest(TeaModel):
    def __init__(
        self,
        architecture: str = None,
        client_token: str = None,
        instance_id: str = None,
        model: str = None,
        related_variate_shrink: str = None,
        role: str = None,
        specification_content: str = None,
        specification_name: str = None,
        vendor: str = None,
    ):
        # 架构类型
        self.architecture = architecture
        # 幂等参数
        self.client_token = client_token
        # instanceId
        self.instance_id = instance_id
        # 型号
        self.model = model
        # 相关变量
        self.related_variate_shrink = related_variate_shrink
        # 角色
        self.role = role
        # 配置规范内容
        self.specification_content = specification_content
        # 配置规范名字
        self.specification_name = specification_name
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.model is not None:
            result['Model'] = self.model
        if self.related_variate_shrink is not None:
            result['RelatedVariate'] = self.related_variate_shrink
        if self.role is not None:
            result['Role'] = self.role
        if self.specification_content is not None:
            result['SpecificationContent'] = self.specification_content
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('RelatedVariate') is not None:
            self.related_variate_shrink = m.get('RelatedVariate')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SpecificationContent') is not None:
            self.specification_content = m.get('SpecificationContent')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class CreateConfigurationSpecificationResponseBody(TeaModel):
    def __init__(
        self,
        configuration_specification_id: str = None,
        request_id: str = None,
    ):
        # 资源uuid
        self.configuration_specification_id = configuration_specification_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateConfigurationSpecificationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateConfigurationSpecificationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConfigurationSpecificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConfigurationVariateRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        comment: str = None,
        format_function: str = None,
        instance_id: str = None,
        variate_name: str = None,
    ):
        # 幂等参数
        self.client_token = client_token
        # 描述变量
        self.comment = comment
        # python转换函数
        self.format_function = format_function
        # instanceId
        self.instance_id = instance_id
        # 资源名称
        self.variate_name = variate_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.format_function is not None:
            result['FormatFunction'] = self.format_function
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.variate_name is not None:
            result['VariateName'] = self.variate_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('FormatFunction') is not None:
            self.format_function = m.get('FormatFunction')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('VariateName') is not None:
            self.variate_name = m.get('VariateName')
        return self


class CreateConfigurationVariateResponseBody(TeaModel):
    def __init__(
        self,
        configuration_variate_id: str = None,
        request_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.configuration_variate_id = configuration_variate_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_variate_id is not None:
            result['ConfigurationVariateId'] = self.configuration_variate_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationVariateId') is not None:
            self.configuration_variate_id = m.get('ConfigurationVariateId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateConfigurationVariateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateConfigurationVariateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConfigurationVariateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDedicatedLineRequest(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        client_token: str = None,
        contact: str = None,
        dedicated_line_gateway: str = None,
        dedicated_line_ip: str = None,
        dedicated_line_role: str = None,
        description: str = None,
        device_id: str = None,
        device_port: str = None,
        instance_id: str = None,
        isp: str = None,
        phone: str = None,
        physical_space_id: str = None,
    ):
        # 宽带（Mbps）
        self.bandwidth = bandwidth
        # 幂等校验 token
        self.client_token = client_token
        # 联系人
        self.contact = contact
        # 专线网关
        self.dedicated_line_gateway = dedicated_line_gateway
        # 专线IP
        self.dedicated_line_ip = dedicated_line_ip
        # 专线角色
        self.dedicated_line_role = dedicated_line_role
        # 备注
        self.description = description
        # 关联设备ID
        self.device_id = device_id
        # 关联设备端口名称
        self.device_port = device_port
        # 实例ID
        self.instance_id = instance_id
        # 运营商
        self.isp = isp
        # 联系方式
        self.phone = phone
        # 物理空间ID
        self.physical_space_id = physical_space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.contact is not None:
            result['Contact'] = self.contact
        if self.dedicated_line_gateway is not None:
            result['DedicatedLineGateway'] = self.dedicated_line_gateway
        if self.dedicated_line_ip is not None:
            result['DedicatedLineIp'] = self.dedicated_line_ip
        if self.dedicated_line_role is not None:
            result['DedicatedLineRole'] = self.dedicated_line_role
        if self.description is not None:
            result['Description'] = self.description
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_port is not None:
            result['DevicePort'] = self.device_port
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.phone is not None:
            result['Phone'] = self.phone
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Contact') is not None:
            self.contact = m.get('Contact')
        if m.get('DedicatedLineGateway') is not None:
            self.dedicated_line_gateway = m.get('DedicatedLineGateway')
        if m.get('DedicatedLineIp') is not None:
            self.dedicated_line_ip = m.get('DedicatedLineIp')
        if m.get('DedicatedLineRole') is not None:
            self.dedicated_line_role = m.get('DedicatedLineRole')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DevicePort') is not None:
            self.device_port = m.get('DevicePort')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        return self


class CreateDedicatedLineResponseBody(TeaModel):
    def __init__(
        self,
        dedicated_line_id: str = None,
        request_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.dedicated_line_id = dedicated_line_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDedicatedLineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDedicatedLineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDedicatedLineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        device_form_id: str = None,
        enable_password: str = None,
        ext_attributes: str = None,
        host_name: str = None,
        instance_id: str = None,
        ip: str = None,
        login_password: str = None,
        login_type: str = None,
        login_username: str = None,
        mac: str = None,
        model: str = None,
        physical_space_id: str = None,
        security_domain: str = None,
        service_status: str = None,
        sn: str = None,
        snmp_account_type: str = None,
        snmp_account_version: str = None,
        snmp_auth_passphrase: str = None,
        snmp_auth_protocol: str = None,
        snmp_community: str = None,
        snmp_privacy_passphrase: str = None,
        snmp_privacy_protocol: str = None,
        snmp_security_level: str = None,
        snmp_username: str = None,
        vendor: str = None,
    ):
        # 幂等校验 token
        self.client_token = client_token
        # 设备形态ID
        self.device_form_id = device_form_id
        # enable密码
        self.enable_password = enable_password
        # 设备额外属性
        self.ext_attributes = ext_attributes
        # 主机名
        self.host_name = host_name
        # 实例ID
        self.instance_id = instance_id
        # 设备IP
        self.ip = ip
        # 登录密码
        self.login_password = login_password
        # 登录类型
        self.login_type = login_type
        # 登录账号
        self.login_username = login_username
        # 设备MAC地址
        self.mac = mac
        # 设备型号
        self.model = model
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 设备安全域
        self.security_domain = security_domain
        # 设备状态
        self.service_status = service_status
        # 设备SN
        self.sn = sn
        # SNMP 账号类型
        self.snmp_account_type = snmp_account_type
        # SNMP 版本号
        self.snmp_account_version = snmp_account_version
        # SNMP Auth PassPhrase
        self.snmp_auth_passphrase = snmp_auth_passphrase
        # SNMP Auth Protocol
        self.snmp_auth_protocol = snmp_auth_protocol
        # SNMP Community
        self.snmp_community = snmp_community
        # SNMP Privacy Passphrase
        self.snmp_privacy_passphrase = snmp_privacy_passphrase
        # SNMP Privacy Protocol
        self.snmp_privacy_protocol = snmp_privacy_protocol
        # SNMP 安全级别
        self.snmp_security_level = snmp_security_level
        # SNMP 用户名
        self.snmp_username = snmp_username
        # 设备厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.enable_password is not None:
            result['EnablePassword'] = self.enable_password
        if self.ext_attributes is not None:
            result['ExtAttributes'] = self.ext_attributes
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.login_password is not None:
            result['LoginPassword'] = self.login_password
        if self.login_type is not None:
            result['LoginType'] = self.login_type
        if self.login_username is not None:
            result['LoginUsername'] = self.login_username
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.model is not None:
            result['Model'] = self.model
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.snmp_account_type is not None:
            result['SnmpAccountType'] = self.snmp_account_type
        if self.snmp_account_version is not None:
            result['SnmpAccountVersion'] = self.snmp_account_version
        if self.snmp_auth_passphrase is not None:
            result['SnmpAuthPassphrase'] = self.snmp_auth_passphrase
        if self.snmp_auth_protocol is not None:
            result['SnmpAuthProtocol'] = self.snmp_auth_protocol
        if self.snmp_community is not None:
            result['SnmpCommunity'] = self.snmp_community
        if self.snmp_privacy_passphrase is not None:
            result['SnmpPrivacyPassphrase'] = self.snmp_privacy_passphrase
        if self.snmp_privacy_protocol is not None:
            result['SnmpPrivacyProtocol'] = self.snmp_privacy_protocol
        if self.snmp_security_level is not None:
            result['SnmpSecurityLevel'] = self.snmp_security_level
        if self.snmp_username is not None:
            result['SnmpUsername'] = self.snmp_username
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('EnablePassword') is not None:
            self.enable_password = m.get('EnablePassword')
        if m.get('ExtAttributes') is not None:
            self.ext_attributes = m.get('ExtAttributes')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('LoginPassword') is not None:
            self.login_password = m.get('LoginPassword')
        if m.get('LoginType') is not None:
            self.login_type = m.get('LoginType')
        if m.get('LoginUsername') is not None:
            self.login_username = m.get('LoginUsername')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('SnmpAccountType') is not None:
            self.snmp_account_type = m.get('SnmpAccountType')
        if m.get('SnmpAccountVersion') is not None:
            self.snmp_account_version = m.get('SnmpAccountVersion')
        if m.get('SnmpAuthPassphrase') is not None:
            self.snmp_auth_passphrase = m.get('SnmpAuthPassphrase')
        if m.get('SnmpAuthProtocol') is not None:
            self.snmp_auth_protocol = m.get('SnmpAuthProtocol')
        if m.get('SnmpCommunity') is not None:
            self.snmp_community = m.get('SnmpCommunity')
        if m.get('SnmpPrivacyPassphrase') is not None:
            self.snmp_privacy_passphrase = m.get('SnmpPrivacyPassphrase')
        if m.get('SnmpPrivacyProtocol') is not None:
            self.snmp_privacy_protocol = m.get('SnmpPrivacyProtocol')
        if m.get('SnmpSecurityLevel') is not None:
            self.snmp_security_level = m.get('SnmpSecurityLevel')
        if m.get('SnmpUsername') is not None:
            self.snmp_username = m.get('SnmpUsername')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class CreateDeviceResponseBody(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        request_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.device_id = device_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceFormRequest(TeaModel):
    def __init__(
        self,
        account_config: bool = None,
        client_token: str = None,
        config_compare: bool = None,
        detail_display: bool = None,
        device_form_name: str = None,
        instance_id: str = None,
        related_device_form_id: str = None,
        resource_use: str = None,
        script: str = None,
        unique_key: str = None,
    ):
        # 是否需要账号配置
        self.account_config = account_config
        # 幂等校验 token
        self.client_token = client_token
        # 是否支持配置生成
        self.config_compare = config_compare
        # 是否展示设备详情
        self.detail_display = detail_display
        # 设备形态名称
        self.device_form_name = device_form_name
        # 实例ID
        self.instance_id = instance_id
        # 关联设备形态ID
        self.related_device_form_id = related_device_form_id
        # 资源用途
        self.resource_use = resource_use
        # 设备代码
        self.script = script
        # 设备形态的主键
        self.unique_key = unique_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_config is not None:
            result['AccountConfig'] = self.account_config
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.config_compare is not None:
            result['ConfigCompare'] = self.config_compare
        if self.detail_display is not None:
            result['DetailDisplay'] = self.detail_display
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.related_device_form_id is not None:
            result['RelatedDeviceFormId'] = self.related_device_form_id
        if self.resource_use is not None:
            result['ResourceUse'] = self.resource_use
        if self.script is not None:
            result['Script'] = self.script
        if self.unique_key is not None:
            result['UniqueKey'] = self.unique_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountConfig') is not None:
            self.account_config = m.get('AccountConfig')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConfigCompare') is not None:
            self.config_compare = m.get('ConfigCompare')
        if m.get('DetailDisplay') is not None:
            self.detail_display = m.get('DetailDisplay')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RelatedDeviceFormId') is not None:
            self.related_device_form_id = m.get('RelatedDeviceFormId')
        if m.get('ResourceUse') is not None:
            self.resource_use = m.get('ResourceUse')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('UniqueKey') is not None:
            self.unique_key = m.get('UniqueKey')
        return self


class CreateDeviceFormResponseBody(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        request_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.device_form_id = device_form_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDeviceFormResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDeviceFormResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDeviceFormResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDevicePropertyRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        device_form_id: str = None,
        instance_id: str = None,
        property_content: str = None,
        property_format: str = None,
        property_key: str = None,
        property_name: str = None,
    ):
        # 幂等校验 token
        self.client_token = client_token
        # 设备形态ID
        self.device_form_id = device_form_id
        # 实例ID
        self.instance_id = instance_id
        # 属性内容
        self.property_content = property_content
        # 属性格式
        self.property_format = property_format
        # 属性主键
        self.property_key = property_key
        # 属性名称
        self.property_name = property_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.property_content is not None:
            result['PropertyContent'] = self.property_content
        if self.property_format is not None:
            result['PropertyFormat'] = self.property_format
        if self.property_key is not None:
            result['PropertyKey'] = self.property_key
        if self.property_name is not None:
            result['PropertyName'] = self.property_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PropertyContent') is not None:
            self.property_content = m.get('PropertyContent')
        if m.get('PropertyFormat') is not None:
            self.property_format = m.get('PropertyFormat')
        if m.get('PropertyKey') is not None:
            self.property_key = m.get('PropertyKey')
        if m.get('PropertyName') is not None:
            self.property_name = m.get('PropertyName')
        return self


class CreateDevicePropertyResponseBody(TeaModel):
    def __init__(
        self,
        device_property_id: str = None,
        request_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.device_property_id = device_property_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_property_id is not None:
            result['DevicePropertyId'] = self.device_property_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DevicePropertyId') is not None:
            self.device_property_id = m.get('DevicePropertyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDevicePropertyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDevicePropertyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDevicePropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDevicesRequestDeviceParamModelList(TeaModel):
    def __init__(
        self,
        enable_password: str = None,
        ext_attributes: str = None,
        host_name: str = None,
        ip: str = None,
        login_password: str = None,
        login_type: str = None,
        login_username: str = None,
        mac: str = None,
        model: str = None,
        physical_space_name: str = None,
        security_domain: str = None,
        service_status: str = None,
        sn: str = None,
        snmp_account_type: str = None,
        snmp_account_version: str = None,
        snmp_auth_passphrase: str = None,
        snmp_auth_protocol: str = None,
        snmp_community: str = None,
        snmp_privacy_passphrase: str = None,
        snmp_privacy_protocol: str = None,
        snmp_security_level: str = None,
        snmp_username: str = None,
        vendor: str = None,
    ):
        # enable密码
        self.enable_password = enable_password
        self.ext_attributes = ext_attributes
        # 主机名
        self.host_name = host_name
        # 设备IP
        self.ip = ip
        # 登录密码
        self.login_password = login_password
        # 登录类型
        self.login_type = login_type
        # 登录账号
        self.login_username = login_username
        # 设备MAC地址
        self.mac = mac
        # 设备型号
        self.model = model
        # 物理空间名称
        self.physical_space_name = physical_space_name
        # 设备安全域
        self.security_domain = security_domain
        # 设备状态
        self.service_status = service_status
        # 设备SN
        self.sn = sn
        # SNMP 账号类型
        self.snmp_account_type = snmp_account_type
        # SNMP 版本号
        self.snmp_account_version = snmp_account_version
        # SNMP Auth PassPhrase
        self.snmp_auth_passphrase = snmp_auth_passphrase
        # SNMP Auth Protocol
        self.snmp_auth_protocol = snmp_auth_protocol
        # SNMP Community
        self.snmp_community = snmp_community
        # SNMP Privacy Passphrase
        self.snmp_privacy_passphrase = snmp_privacy_passphrase
        # SNMP Privacy Protocol
        self.snmp_privacy_protocol = snmp_privacy_protocol
        # SNMP 安全级别
        self.snmp_security_level = snmp_security_level
        # SNMP 用户名
        self.snmp_username = snmp_username
        # 设备厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_password is not None:
            result['EnablePassword'] = self.enable_password
        if self.ext_attributes is not None:
            result['ExtAttributes'] = self.ext_attributes
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.login_password is not None:
            result['LoginPassword'] = self.login_password
        if self.login_type is not None:
            result['LoginType'] = self.login_type
        if self.login_username is not None:
            result['LoginUsername'] = self.login_username
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.model is not None:
            result['Model'] = self.model
        if self.physical_space_name is not None:
            result['PhysicalSpaceName'] = self.physical_space_name
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.snmp_account_type is not None:
            result['SnmpAccountType'] = self.snmp_account_type
        if self.snmp_account_version is not None:
            result['SnmpAccountVersion'] = self.snmp_account_version
        if self.snmp_auth_passphrase is not None:
            result['SnmpAuthPassphrase'] = self.snmp_auth_passphrase
        if self.snmp_auth_protocol is not None:
            result['SnmpAuthProtocol'] = self.snmp_auth_protocol
        if self.snmp_community is not None:
            result['SnmpCommunity'] = self.snmp_community
        if self.snmp_privacy_passphrase is not None:
            result['SnmpPrivacyPassphrase'] = self.snmp_privacy_passphrase
        if self.snmp_privacy_protocol is not None:
            result['SnmpPrivacyProtocol'] = self.snmp_privacy_protocol
        if self.snmp_security_level is not None:
            result['SnmpSecurityLevel'] = self.snmp_security_level
        if self.snmp_username is not None:
            result['SnmpUsername'] = self.snmp_username
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnablePassword') is not None:
            self.enable_password = m.get('EnablePassword')
        if m.get('ExtAttributes') is not None:
            self.ext_attributes = m.get('ExtAttributes')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('LoginPassword') is not None:
            self.login_password = m.get('LoginPassword')
        if m.get('LoginType') is not None:
            self.login_type = m.get('LoginType')
        if m.get('LoginUsername') is not None:
            self.login_username = m.get('LoginUsername')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('PhysicalSpaceName') is not None:
            self.physical_space_name = m.get('PhysicalSpaceName')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('SnmpAccountType') is not None:
            self.snmp_account_type = m.get('SnmpAccountType')
        if m.get('SnmpAccountVersion') is not None:
            self.snmp_account_version = m.get('SnmpAccountVersion')
        if m.get('SnmpAuthPassphrase') is not None:
            self.snmp_auth_passphrase = m.get('SnmpAuthPassphrase')
        if m.get('SnmpAuthProtocol') is not None:
            self.snmp_auth_protocol = m.get('SnmpAuthProtocol')
        if m.get('SnmpCommunity') is not None:
            self.snmp_community = m.get('SnmpCommunity')
        if m.get('SnmpPrivacyPassphrase') is not None:
            self.snmp_privacy_passphrase = m.get('SnmpPrivacyPassphrase')
        if m.get('SnmpPrivacyProtocol') is not None:
            self.snmp_privacy_protocol = m.get('SnmpPrivacyProtocol')
        if m.get('SnmpSecurityLevel') is not None:
            self.snmp_security_level = m.get('SnmpSecurityLevel')
        if m.get('SnmpUsername') is not None:
            self.snmp_username = m.get('SnmpUsername')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class CreateDevicesRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        device_form_id: str = None,
        device_param_model_list: List[CreateDevicesRequestDeviceParamModelList] = None,
        instance_id: str = None,
    ):
        # 幂等参数
        self.client_token = client_token
        # 设备形态ID
        self.device_form_id = device_form_id
        self.device_param_model_list = device_param_model_list
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        if self.device_param_model_list:
            for k in self.device_param_model_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        result['DeviceParamModelList'] = []
        if self.device_param_model_list is not None:
            for k in self.device_param_model_list:
                result['DeviceParamModelList'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        self.device_param_model_list = []
        if m.get('DeviceParamModelList') is not None:
            for k in m.get('DeviceParamModelList'):
                temp_model = CreateDevicesRequestDeviceParamModelList()
                self.device_param_model_list.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateDevicesShrinkRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        device_form_id: str = None,
        device_param_model_list_shrink: str = None,
        instance_id: str = None,
    ):
        # 幂等参数
        self.client_token = client_token
        # 设备形态ID
        self.device_form_id = device_form_id
        self.device_param_model_list_shrink = device_param_model_list_shrink
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_param_model_list_shrink is not None:
            result['DeviceParamModelList'] = self.device_param_model_list_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceParamModelList') is not None:
            self.device_param_model_list_shrink = m.get('DeviceParamModelList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateDevicesResponseBody(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        request_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.device_id = device_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDevicesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEventDefinitionRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        event_name: str = None,
        event_type: str = None,
        instance_id: str = None,
        template_id: str = None,
    ):
        # 幂等参数
        self.client_token = client_token
        # 事件名称
        self.event_name = event_name
        # 事件大类
        self.event_type = event_type
        # 实例ID
        self.instance_id = instance_id
        # 自动化模板ID
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class CreateEventDefinitionResponseBody(TeaModel):
    def __init__(
        self,
        event_id: str = None,
        request_id: str = None,
    ):
        # 事件定义ID
        self.event_id = event_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEventDefinitionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEventDefinitionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEventDefinitionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLinkJobRequest(TeaModel):
    def __init__(
        self,
        auto_confirm: bool = None,
        double_convert_strategy: str = None,
        instance_id: str = None,
        job_id: str = None,
        single_strategy: str = None,
    ):
        # 是否自动确认
        self.auto_confirm = auto_confirm
        # 双端链路转换策略
        self.double_convert_strategy = double_convert_strategy
        # 实例ID
        self.instance_id = instance_id
        # 任务ID
        self.job_id = job_id
        # 单端链路发现策略
        self.single_strategy = single_strategy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_confirm is not None:
            result['AutoConfirm'] = self.auto_confirm
        if self.double_convert_strategy is not None:
            result['DoubleConvertStrategy'] = self.double_convert_strategy
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.single_strategy is not None:
            result['SingleStrategy'] = self.single_strategy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoConfirm') is not None:
            self.auto_confirm = m.get('AutoConfirm')
        if m.get('DoubleConvertStrategy') is not None:
            self.double_convert_strategy = m.get('DoubleConvertStrategy')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('SingleStrategy') is not None:
            self.single_strategy = m.get('SingleStrategy')
        return self


class CreateLinkJobResponseBody(TeaModel):
    def __init__(
        self,
        content: str = None,
        request_id: str = None,
    ):
        # 若创建接口为异步实现，则需返回明确的JobId。
        self.content = content
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLinkJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateLinkJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateLinkJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorItemRequestAlarmRuleList(TeaModel):
    def __init__(
        self,
        alarm_status: str = None,
        expression: str = None,
        value: str = None,
        variable: str = None,
    ):
        # 告警状态
        self.alarm_status = alarm_status
        # 表达式
        self.expression = expression
        # 比较值
        self.value = value
        # 指标名
        self.variable = variable

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.value is not None:
            result['Value'] = self.value
        if self.variable is not None:
            result['Variable'] = self.variable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Variable') is not None:
            self.variable = m.get('Variable')
        return self


class CreateMonitorItemRequest(TeaModel):
    def __init__(
        self,
        alarm_rule_list: List[CreateMonitorItemRequestAlarmRuleList] = None,
        analysis_code: str = None,
        client_token: str = None,
        collection_type: str = None,
        config: str = None,
        data_item: str = None,
        device_form: str = None,
        effective: int = None,
        exec_interval: int = None,
        instance_id: str = None,
        monitor_item_description: str = None,
        monitor_item_name: str = None,
        security_domain: str = None,
        type: str = None,
    ):
        # 告警规则列表
        self.alarm_rule_list = alarm_rule_list
        # 解析代码
        self.analysis_code = analysis_code
        # 幂等参数
        self.client_token = client_token
        # 采集类型
        self.collection_type = collection_type
        # 监控项参数配置
        self.config = config
        # 数据项
        self.data_item = data_item
        # 设备形态
        self.device_form = device_form
        # 是否启用
        self.effective = effective
        # 执行间隔(s)
        self.exec_interval = exec_interval
        # 实例ID
        self.instance_id = instance_id
        # 监控项描述
        self.monitor_item_description = monitor_item_description
        # 监控项名称
        self.monitor_item_name = monitor_item_name
        # 安全域
        self.security_domain = security_domain
        # 类型
        self.type = type

    def validate(self):
        if self.alarm_rule_list:
            for k in self.alarm_rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlarmRuleList'] = []
        if self.alarm_rule_list is not None:
            for k in self.alarm_rule_list:
                result['AlarmRuleList'].append(k.to_map() if k else None)
        if self.analysis_code is not None:
            result['AnalysisCode'] = self.analysis_code
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.collection_type is not None:
            result['CollectionType'] = self.collection_type
        if self.config is not None:
            result['Config'] = self.config
        if self.data_item is not None:
            result['DataItem'] = self.data_item
        if self.device_form is not None:
            result['DeviceForm'] = self.device_form
        if self.effective is not None:
            result['Effective'] = self.effective
        if self.exec_interval is not None:
            result['ExecInterval'] = self.exec_interval
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.monitor_item_description is not None:
            result['MonitorItemDescription'] = self.monitor_item_description
        if self.monitor_item_name is not None:
            result['MonitorItemName'] = self.monitor_item_name
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alarm_rule_list = []
        if m.get('AlarmRuleList') is not None:
            for k in m.get('AlarmRuleList'):
                temp_model = CreateMonitorItemRequestAlarmRuleList()
                self.alarm_rule_list.append(temp_model.from_map(k))
        if m.get('AnalysisCode') is not None:
            self.analysis_code = m.get('AnalysisCode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CollectionType') is not None:
            self.collection_type = m.get('CollectionType')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('DataItem') is not None:
            self.data_item = m.get('DataItem')
        if m.get('DeviceForm') is not None:
            self.device_form = m.get('DeviceForm')
        if m.get('Effective') is not None:
            self.effective = m.get('Effective')
        if m.get('ExecInterval') is not None:
            self.exec_interval = m.get('ExecInterval')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MonitorItemDescription') is not None:
            self.monitor_item_description = m.get('MonitorItemDescription')
        if m.get('MonitorItemName') is not None:
            self.monitor_item_name = m.get('MonitorItemName')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateMonitorItemResponseBody(TeaModel):
    def __init__(
        self,
        monitor_item_id: str = None,
        request_id: str = None,
    ):
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateMonitorItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateMonitorItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMonitorItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOsVersionRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        create_time: str = None,
        file_name: str = None,
        file_path: str = None,
        instance_id: str = None,
        model: str = None,
        os_version: str = None,
        status: str = None,
        vendor: str = None,
    ):
        # 幂等参数
        self.client_token = client_token
        # 创建时间
        self.create_time = create_time
        # 文件名
        self.file_name = file_name
        # 文件路径
        self.file_path = file_path
        # instanceId
        self.instance_id = instance_id
        # 型号
        self.model = model
        # 系统版本
        self.os_version = os_version
        # 状态
        self.status = status
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.model is not None:
            result['Model'] = self.model
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.status is not None:
            result['Status'] = self.status
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class CreateOsVersionResponseBody(TeaModel):
    def __init__(
        self,
        os_version_id: str = None,
        request_id: str = None,
    ):
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.os_version_id = os_version_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.os_version_id is not None:
            result['OsVersionId'] = self.os_version_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OsVersionId') is not None:
            self.os_version_id = m.get('OsVersionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOsVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOsVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOsVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePhysicalSpaceRequest(TeaModel):
    def __init__(
        self,
        address: str = None,
        city: str = None,
        client_token: str = None,
        country: str = None,
        instance_id: str = None,
        owner: str = None,
        physical_space_name: str = None,
        province: str = None,
        remark: str = None,
        space_abbreviation: str = None,
        space_type: str = None,
    ):
        # 具体地址
        self.address = address
        # 所属城市
        self.city = city
        # 幂等校验 token
        self.client_token = client_token
        # 所属国家
        self.country = country
        # 实例ID
        self.instance_id = instance_id
        # 负责人
        self.owner = owner
        # 物理空间名称
        self.physical_space_name = physical_space_name
        # 所属省份
        self.province = province
        # 备注
        self.remark = remark
        # 物理空间缩写
        self.space_abbreviation = space_abbreviation
        # 物理空间模型
        self.space_type = space_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.city is not None:
            result['City'] = self.city
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.country is not None:
            result['Country'] = self.country
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.physical_space_name is not None:
            result['PhysicalSpaceName'] = self.physical_space_name
        if self.province is not None:
            result['Province'] = self.province
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.space_abbreviation is not None:
            result['SpaceAbbreviation'] = self.space_abbreviation
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('PhysicalSpaceName') is not None:
            self.physical_space_name = m.get('PhysicalSpaceName')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('SpaceAbbreviation') is not None:
            self.space_abbreviation = m.get('SpaceAbbreviation')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        return self


class CreatePhysicalSpaceResponseBody(TeaModel):
    def __init__(
        self,
        physical_space_id: str = None,
        request_id: str = None,
    ):
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePhysicalSpaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreatePhysicalSpaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreatePhysicalSpaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRealtimeTaskRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        device_id: str = None,
        instance_id: str = None,
        script: str = None,
    ):
        # token
        self.client_token = client_token
        # 设备ID
        self.device_id = device_id
        # 实例ID
        self.instance_id = instance_id
        # 模板执行脚本
        self.script = script

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.script is not None:
            result['Script'] = self.script
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        return self


class CreateRealtimeTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_id: str = None,
    ):
        # 请求ID
        self.request_id = request_id
        # 实时任务ID
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateRealtimeTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRealtimeTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRealtimeTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateResourceInformationRequestInformation(TeaModel):
    def __init__(
        self,
        key: str = None,
        key_action: str = None,
        key_attribute: str = None,
        key_description: str = None,
    ):
        # 键
        self.key = key
        # 键动作
        self.key_action = key_action
        # 键属性
        self.key_attribute = key_attribute
        # 键描述
        self.key_description = key_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.key_action is not None:
            result['KeyAction'] = self.key_action
        if self.key_attribute is not None:
            result['KeyAttribute'] = self.key_attribute
        if self.key_description is not None:
            result['KeyDescription'] = self.key_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyAction') is not None:
            self.key_action = m.get('KeyAction')
        if m.get('KeyAttribute') is not None:
            self.key_attribute = m.get('KeyAttribute')
        if m.get('KeyDescription') is not None:
            self.key_description = m.get('KeyDescription')
        return self


class CreateResourceInformationRequest(TeaModel):
    def __init__(
        self,
        architecture_id: str = None,
        client_token: str = None,
        information: List[CreateResourceInformationRequestInformation] = None,
        instance_id: str = None,
        resource_attribute: str = None,
        resource_type: str = None,
    ):
        # 架构id
        self.architecture_id = architecture_id
        # 幂等参数
        self.client_token = client_token
        # 信息
        self.information = information
        # instanceId
        self.instance_id = instance_id
        # 资源属性
        self.resource_attribute = resource_attribute
        # 资源类型
        self.resource_type = resource_type

    def validate(self):
        if self.information:
            for k in self.information:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture_id is not None:
            result['ArchitectureId'] = self.architecture_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['Information'] = []
        if self.information is not None:
            for k in self.information:
                result['Information'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_attribute is not None:
            result['ResourceAttribute'] = self.resource_attribute
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArchitectureId') is not None:
            self.architecture_id = m.get('ArchitectureId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.information = []
        if m.get('Information') is not None:
            for k in m.get('Information'):
                temp_model = CreateResourceInformationRequestInformation()
                self.information.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceAttribute') is not None:
            self.resource_attribute = m.get('ResourceAttribute')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class CreateResourceInformationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_information_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.resource_information_id = resource_information_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_information_id is not None:
            result['ResourceInformationId'] = self.resource_information_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceInformationId') is not None:
            self.resource_information_id = m.get('ResourceInformationId')
        return self


class CreateResourceInformationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateResourceInformationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateResourceInformationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSetupProjectRequest(TeaModel):
    def __init__(
        self,
        delivery_time: str = None,
        description: str = None,
        instance_id: str = None,
        space_id: str = None,
    ):
        # 创建时间
        self.delivery_time = delivery_time
        # 描述
        self.description = description
        # instanceId
        self.instance_id = instance_id
        # 物理空间uId
        self.space_id = space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delivery_time is not None:
            result['DeliveryTime'] = self.delivery_time
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeliveryTime') is not None:
            self.delivery_time = m.get('DeliveryTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        return self


class CreateSetupProjectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        setup_project_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class CreateSetupProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSetupProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSetupProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSpaceModelRequestSort(TeaModel):
    def __init__(
        self,
        level: int = None,
        level_name: str = None,
    ):
        # 层级
        self.level = level
        # 层级名称
        self.level_name = level_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.level_name is not None:
            result['LevelName'] = self.level_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LevelName') is not None:
            self.level_name = m.get('LevelName')
        return self


class CreateSpaceModelRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        instance_id: str = None,
        sort: List[CreateSpaceModelRequestSort] = None,
        space_type: str = None,
    ):
        # 幂等参数
        self.client_token = client_token
        # instanceId
        self.instance_id = instance_id
        # 层级
        self.sort = sort
        # 物理空间类型
        self.space_type = space_type

    def validate(self):
        if self.sort:
            for k in self.sort:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['Sort'] = []
        if self.sort is not None:
            for k in self.sort:
                result['Sort'].append(k.to_map() if k else None)
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.sort = []
        if m.get('Sort') is not None:
            for k in m.get('Sort'):
                temp_model = CreateSpaceModelRequestSort()
                self.sort.append(temp_model.from_map(k))
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        return self


class CreateSpaceModelShrinkRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        instance_id: str = None,
        sort_shrink: str = None,
        space_type: str = None,
    ):
        # 幂等参数
        self.client_token = client_token
        # instanceId
        self.instance_id = instance_id
        # 层级
        self.sort_shrink = sort_shrink
        # 物理空间类型
        self.space_type = space_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.sort_shrink is not None:
            result['Sort'] = self.sort_shrink
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Sort') is not None:
            self.sort_shrink = m.get('Sort')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        return self


class CreateSpaceModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        space_model_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 资源实例ID，如ECS实例的创建接口CreateInstance应返回InstanceId。
        self.space_model_id = space_model_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        return self


class CreateSpaceModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSpaceModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSpaceModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTimePeriodRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        expression: str = None,
        instance_id: str = None,
        time_period_description: str = None,
        time_period_name: str = None,
    ):
        # 幂等参数
        self.client_token = client_token
        # cron表达式
        self.expression = expression
        # 实例ID
        self.instance_id = instance_id
        # 描述
        self.time_period_description = time_period_description
        # 时间段名称
        self.time_period_name = time_period_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.time_period_description is not None:
            result['TimePeriodDescription'] = self.time_period_description
        if self.time_period_name is not None:
            result['TimePeriodName'] = self.time_period_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TimePeriodDescription') is not None:
            self.time_period_description = m.get('TimePeriodDescription')
        if m.get('TimePeriodName') is not None:
            self.time_period_name = m.get('TimePeriodName')
        return self


class CreateTimePeriodResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        time_period_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 时间段ID
        self.time_period_id = time_period_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.time_period_id is not None:
            result['TimePeriodId'] = self.time_period_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TimePeriodId') is not None:
            self.time_period_id = m.get('TimePeriodId')
        return self


class CreateTimePeriodResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateTimePeriodResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTimePeriodResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWorkOrderRequest(TeaModel):
    def __init__(
        self,
        alarm_happen_time: str = None,
        alarm_recover_time: str = None,
        alarm_related: str = None,
        area: str = None,
        circuit_id: str = None,
        circuit_name: str = None,
        circuit_type: str = None,
        client_token: str = None,
        device_ip: str = None,
        device_ip_a: str = None,
        device_ip_b: str = None,
        device_model_a: str = None,
        device_model_b: str = None,
        device_name: str = None,
        device_name_a: str = None,
        device_name_b: str = None,
        device_port_a: str = None,
        device_port_b: str = None,
        device_sn_a: str = None,
        device_sn_b: str = None,
        device_type: str = None,
        device_vendor: str = None,
        device_vendor_a: str = None,
        device_vendor_b: str = None,
        emergency_degree: str = None,
        impact_business: str = None,
        incident_description: str = None,
        incident_sub_type: str = None,
        incident_type: str = None,
        instance_id: str = None,
        liable_man: str = None,
        link_man: str = None,
        original_subject_alarm: str = None,
        process_limited: str = None,
        process_man: str = None,
        process_man_id: str = None,
        skill_groups: str = None,
        work_order_source: str = None,
        work_order_step: str = None,
        work_order_title: str = None,
        work_order_type: str = None,
    ):
        # 告警发生时间
        self.alarm_happen_time = alarm_happen_time
        # 告警恢复时间
        self.alarm_recover_time = alarm_recover_time
        # 关联告警项
        self.alarm_related = alarm_related
        # 区域
        self.area = area
        # 电路编码
        self.circuit_id = circuit_id
        # 电路名
        self.circuit_name = circuit_name
        # 电路类型
        self.circuit_type = circuit_type
        # 幂等校验 token
        self.client_token = client_token
        # 设备IP
        self.device_ip = device_ip
        # A-IP
        self.device_ip_a = device_ip_a
        # B-IP
        self.device_ip_b = device_ip_b
        # A-设备型号
        self.device_model_a = device_model_a
        # B-设备型号
        self.device_model_b = device_model_b
        # 设备名
        self.device_name = device_name
        # A-设备名
        self.device_name_a = device_name_a
        # B-设备名
        self.device_name_b = device_name_b
        # A-端口
        self.device_port_a = device_port_a
        # B-端口
        self.device_port_b = device_port_b
        # A-设备SN
        self.device_sn_a = device_sn_a
        # B-设备SN
        self.device_sn_b = device_sn_b
        # 设备类型
        self.device_type = device_type
        # 设备厂家
        self.device_vendor = device_vendor
        # A-厂家
        self.device_vendor_a = device_vendor_a
        # B-厂家
        self.device_vendor_b = device_vendor_b
        # 紧急程度
        self.emergency_degree = emergency_degree
        # 是否影响业务
        self.impact_business = impact_business
        # 问题描述
        self.incident_description = incident_description
        # 故障小类
        self.incident_sub_type = incident_sub_type
        # 故障分类
        self.incident_type = incident_type
        # 实例ID
        self.instance_id = instance_id
        # 责任人
        self.liable_man = liable_man
        # 用户/联系人
        self.link_man = link_man
        # 告警源主体
        self.original_subject_alarm = original_subject_alarm
        # 处理时限
        self.process_limited = process_limited
        # 处理人
        self.process_man = process_man
        # 处理人编号
        self.process_man_id = process_man_id
        # 技能组
        self.skill_groups = skill_groups
        # 工单来源
        self.work_order_source = work_order_source
        # 工单状态
        self.work_order_step = work_order_step
        # 工单标题
        self.work_order_title = work_order_title
        # 工单类型
        self.work_order_type = work_order_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_happen_time is not None:
            result['AlarmHappenTime'] = self.alarm_happen_time
        if self.alarm_recover_time is not None:
            result['AlarmRecoverTime'] = self.alarm_recover_time
        if self.alarm_related is not None:
            result['AlarmRelated'] = self.alarm_related
        if self.area is not None:
            result['Area'] = self.area
        if self.circuit_id is not None:
            result['CircuitId'] = self.circuit_id
        if self.circuit_name is not None:
            result['CircuitName'] = self.circuit_name
        if self.circuit_type is not None:
            result['CircuitType'] = self.circuit_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.device_ip is not None:
            result['DeviceIp'] = self.device_ip
        if self.device_ip_a is not None:
            result['DeviceIpA'] = self.device_ip_a
        if self.device_ip_b is not None:
            result['DeviceIpB'] = self.device_ip_b
        if self.device_model_a is not None:
            result['DeviceModelA'] = self.device_model_a
        if self.device_model_b is not None:
            result['DeviceModelB'] = self.device_model_b
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_name_a is not None:
            result['DeviceNameA'] = self.device_name_a
        if self.device_name_b is not None:
            result['DeviceNameB'] = self.device_name_b
        if self.device_port_a is not None:
            result['DevicePortA'] = self.device_port_a
        if self.device_port_b is not None:
            result['DevicePortB'] = self.device_port_b
        if self.device_sn_a is not None:
            result['DeviceSnA'] = self.device_sn_a
        if self.device_sn_b is not None:
            result['DeviceSnB'] = self.device_sn_b
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.device_vendor is not None:
            result['DeviceVendor'] = self.device_vendor
        if self.device_vendor_a is not None:
            result['DeviceVendorA'] = self.device_vendor_a
        if self.device_vendor_b is not None:
            result['DeviceVendorB'] = self.device_vendor_b
        if self.emergency_degree is not None:
            result['EmergencyDegree'] = self.emergency_degree
        if self.impact_business is not None:
            result['ImpactBusiness'] = self.impact_business
        if self.incident_description is not None:
            result['IncidentDescription'] = self.incident_description
        if self.incident_sub_type is not None:
            result['IncidentSubType'] = self.incident_sub_type
        if self.incident_type is not None:
            result['IncidentType'] = self.incident_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.liable_man is not None:
            result['LiableMan'] = self.liable_man
        if self.link_man is not None:
            result['LinkMan'] = self.link_man
        if self.original_subject_alarm is not None:
            result['OriginalSubjectAlarm'] = self.original_subject_alarm
        if self.process_limited is not None:
            result['ProcessLimited'] = self.process_limited
        if self.process_man is not None:
            result['ProcessMan'] = self.process_man
        if self.process_man_id is not None:
            result['ProcessManId'] = self.process_man_id
        if self.skill_groups is not None:
            result['SkillGroups'] = self.skill_groups
        if self.work_order_source is not None:
            result['WorkOrderSource'] = self.work_order_source
        if self.work_order_step is not None:
            result['WorkOrderStep'] = self.work_order_step
        if self.work_order_title is not None:
            result['WorkOrderTitle'] = self.work_order_title
        if self.work_order_type is not None:
            result['WorkOrderType'] = self.work_order_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmHappenTime') is not None:
            self.alarm_happen_time = m.get('AlarmHappenTime')
        if m.get('AlarmRecoverTime') is not None:
            self.alarm_recover_time = m.get('AlarmRecoverTime')
        if m.get('AlarmRelated') is not None:
            self.alarm_related = m.get('AlarmRelated')
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('CircuitId') is not None:
            self.circuit_id = m.get('CircuitId')
        if m.get('CircuitName') is not None:
            self.circuit_name = m.get('CircuitName')
        if m.get('CircuitType') is not None:
            self.circuit_type = m.get('CircuitType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DeviceIp') is not None:
            self.device_ip = m.get('DeviceIp')
        if m.get('DeviceIpA') is not None:
            self.device_ip_a = m.get('DeviceIpA')
        if m.get('DeviceIpB') is not None:
            self.device_ip_b = m.get('DeviceIpB')
        if m.get('DeviceModelA') is not None:
            self.device_model_a = m.get('DeviceModelA')
        if m.get('DeviceModelB') is not None:
            self.device_model_b = m.get('DeviceModelB')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceNameA') is not None:
            self.device_name_a = m.get('DeviceNameA')
        if m.get('DeviceNameB') is not None:
            self.device_name_b = m.get('DeviceNameB')
        if m.get('DevicePortA') is not None:
            self.device_port_a = m.get('DevicePortA')
        if m.get('DevicePortB') is not None:
            self.device_port_b = m.get('DevicePortB')
        if m.get('DeviceSnA') is not None:
            self.device_sn_a = m.get('DeviceSnA')
        if m.get('DeviceSnB') is not None:
            self.device_sn_b = m.get('DeviceSnB')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('DeviceVendor') is not None:
            self.device_vendor = m.get('DeviceVendor')
        if m.get('DeviceVendorA') is not None:
            self.device_vendor_a = m.get('DeviceVendorA')
        if m.get('DeviceVendorB') is not None:
            self.device_vendor_b = m.get('DeviceVendorB')
        if m.get('EmergencyDegree') is not None:
            self.emergency_degree = m.get('EmergencyDegree')
        if m.get('ImpactBusiness') is not None:
            self.impact_business = m.get('ImpactBusiness')
        if m.get('IncidentDescription') is not None:
            self.incident_description = m.get('IncidentDescription')
        if m.get('IncidentSubType') is not None:
            self.incident_sub_type = m.get('IncidentSubType')
        if m.get('IncidentType') is not None:
            self.incident_type = m.get('IncidentType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LiableMan') is not None:
            self.liable_man = m.get('LiableMan')
        if m.get('LinkMan') is not None:
            self.link_man = m.get('LinkMan')
        if m.get('OriginalSubjectAlarm') is not None:
            self.original_subject_alarm = m.get('OriginalSubjectAlarm')
        if m.get('ProcessLimited') is not None:
            self.process_limited = m.get('ProcessLimited')
        if m.get('ProcessMan') is not None:
            self.process_man = m.get('ProcessMan')
        if m.get('ProcessManId') is not None:
            self.process_man_id = m.get('ProcessManId')
        if m.get('SkillGroups') is not None:
            self.skill_groups = m.get('SkillGroups')
        if m.get('WorkOrderSource') is not None:
            self.work_order_source = m.get('WorkOrderSource')
        if m.get('WorkOrderStep') is not None:
            self.work_order_step = m.get('WorkOrderStep')
        if m.get('WorkOrderTitle') is not None:
            self.work_order_title = m.get('WorkOrderTitle')
        if m.get('WorkOrderType') is not None:
            self.work_order_type = m.get('WorkOrderType')
        return self


class CreateWorkOrderResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        work_order_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 工单ID
        self.work_order_id = work_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.work_order_id is not None:
            result['WorkOrderId'] = self.work_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('WorkOrderId') is not None:
            self.work_order_id = m.get('WorkOrderId')
        return self


class CreateWorkOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateWorkOrderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateWorkOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConfigurationSpecificationRequest(TeaModel):
    def __init__(
        self,
        configuration_specification_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.configuration_specification_id = configuration_specification_id
        # instanceId
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteConfigurationSpecificationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteConfigurationSpecificationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteConfigurationSpecificationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConfigurationSpecificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConfigurationVariateRequest(TeaModel):
    def __init__(
        self,
        configuration_variate_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.configuration_variate_id = configuration_variate_id
        # instanceId
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_variate_id is not None:
            result['ConfigurationVariateId'] = self.configuration_variate_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationVariateId') is not None:
            self.configuration_variate_id = m.get('ConfigurationVariateId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteConfigurationVariateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteConfigurationVariateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteConfigurationVariateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConfigurationVariateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDedicatedLineRequest(TeaModel):
    def __init__(
        self,
        dedicated_line_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.dedicated_line_id = dedicated_line_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDedicatedLineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDedicatedLineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDedicatedLineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDedicatedLineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeliveryArchVersionRequest(TeaModel):
    def __init__(
        self,
        delivery_arch_version_id: str = None,
        instance_id: str = None,
    ):
        # 资源 ID。
        self.delivery_arch_version_id = delivery_arch_version_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delivery_arch_version_id is not None:
            result['DeliveryArchVersionId'] = self.delivery_arch_version_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeliveryArchVersionId') is not None:
            self.delivery_arch_version_id = m.get('DeliveryArchVersionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDeliveryArchVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDeliveryArchVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeliveryArchVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeliveryArchVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeliveryProjectRequest(TeaModel):
    def __init__(
        self,
        delivery_project_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.delivery_project_id = delivery_project_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delivery_project_id is not None:
            result['DeliveryProjectId'] = self.delivery_project_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeliveryProjectId') is not None:
            self.delivery_project_id = m.get('DeliveryProjectId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDeliveryProjectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDeliveryProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeliveryProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeliveryProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_id = device_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDeviceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceFormRequest(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_form_id = device_form_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDeviceFormResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDeviceFormResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeviceFormResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceFormResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDevicePropertyRequest(TeaModel):
    def __init__(
        self,
        device_property_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_property_id = device_property_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_property_id is not None:
            result['DevicePropertyId'] = self.device_property_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DevicePropertyId') is not None:
            self.device_property_id = m.get('DevicePropertyId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDevicePropertyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDevicePropertyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDevicePropertyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDevicePropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceResourceRequest(TeaModel):
    def __init__(
        self,
        device_resource_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_resource_id = device_resource_id
        # instanceId
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDeviceResourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDeviceResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDeviceResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDevicesRequest(TeaModel):
    def __init__(
        self,
        device_ids: List[str] = None,
        instance_id: str = None,
    ):
        # 实例 ID列表。
        self.device_ids = device_ids
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_ids is not None:
            result['DeviceIds'] = self.device_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceIds') is not None:
            self.device_ids = m.get('DeviceIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDevicesShrinkRequest(TeaModel):
    def __init__(
        self,
        device_ids_shrink: str = None,
        instance_id: str = None,
    ):
        # 实例 ID列表。
        self.device_ids_shrink = device_ids_shrink
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_ids_shrink is not None:
            result['DeviceIds'] = self.device_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceIds') is not None:
            self.device_ids_shrink = m.get('DeviceIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDevicesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDevicesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEventDefinitionRequest(TeaModel):
    def __init__(
        self,
        event_id: str = None,
        instance_id: str = None,
    ):
        # 事件ID
        self.event_id = event_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteEventDefinitionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEventDefinitionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteEventDefinitionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEventDefinitionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInspectionTaskRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        task_id: str = None,
    ):
        # 实例ID
        self.instance_id = instance_id
        # 周期性任务的ID
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteInspectionTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # 请求ID
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInspectionTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteInspectionTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteInspectionTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOsVersionRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        os_version_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.os_version_id = os_version_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.os_version_id is not None:
            result['OsVersionId'] = self.os_version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OsVersionId') is not None:
            self.os_version_id = m.get('OsVersionId')
        return self


class DeleteOsVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteOsVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteOsVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteOsVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePhysicalSpaceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        physical_space_id: str = None,
    ):
        # 实例ID
        self.instance_id = instance_id
        # 实例 ID。
        self.physical_space_id = physical_space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        return self


class DeletePhysicalSpaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePhysicalSpaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeletePhysicalSpaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeletePhysicalSpaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteResourceInformationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        resource_information_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.resource_information_id = resource_information_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_information_id is not None:
            result['ResourceInformationId'] = self.resource_information_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceInformationId') is not None:
            self.resource_information_id = m.get('ResourceInformationId')
        return self


class DeleteResourceInformationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteResourceInformationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteResourceInformationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteResourceInformationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSetupProjectRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        setup_project_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class DeleteSetupProjectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSetupProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSetupProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSetupProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSpaceModelRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        space_model_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.space_model_id = space_model_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        return self


class DeleteSpaceModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSpaceModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSpaceModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSpaceModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWorkOrderRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        work_order_id: str = None,
    ):
        self.instance_id = instance_id
        # 工单编号
        self.work_order_id = work_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.work_order_id is not None:
            result['WorkOrderId'] = self.work_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('WorkOrderId') is not None:
            self.work_order_id = m.get('WorkOrderId')
        return self


class DeleteWorkOrderResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteWorkOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteWorkOrderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteWorkOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableNotificationRequestList(TeaModel):
    def __init__(
        self,
        aggregate_data_id: str = None,
        app_id: str = None,
        dedicated_line_id: str = None,
        device_id: str = None,
        monitor_item_id: str = None,
        port_collection_id: str = None,
        type: str = None,
    ):
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 应用ID
        self.app_id = app_id
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 设备ID
        self.device_id = device_id
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DisableNotificationRequest(TeaModel):
    def __init__(
        self,
        expiry_time: str = None,
        instance_id: str = None,
        list: List[DisableNotificationRequestList] = None,
        reason: str = None,
    ):
        # 到期时间
        self.expiry_time = expiry_time
        # 实例ID
        self.instance_id = instance_id
        # 关闭通知的对象
        self.list = list
        # 关闭原因
        self.reason = reason

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expiry_time is not None:
            result['ExpiryTime'] = self.expiry_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpiryTime') is not None:
            self.expiry_time = m.get('ExpiryTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DisableNotificationRequestList()
                self.list.append(temp_model.from_map(k))
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        return self


class DisableNotificationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # request id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableNotificationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DisableNotificationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableNotificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DownloadDeviceResourceRequest(TeaModel):
    def __init__(
        self,
        device_resource_id: str = None,
        device_resource_ids: List[str] = None,
        download_type: str = None,
        instance_id: str = None,
        setup_project_id: str = None,
    ):
        # deviceResourceId
        self.device_resource_id = device_resource_id
        # 资源uuid
        self.device_resource_ids = device_resource_ids
        # 操作类型
        self.download_type = download_type
        # instanceId
        self.instance_id = instance_id
        # 建设项目id
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.device_resource_ids is not None:
            result['DeviceResourceIds'] = self.device_resource_ids
        if self.download_type is not None:
            result['DownloadType'] = self.download_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids = m.get('DeviceResourceIds')
        if m.get('DownloadType') is not None:
            self.download_type = m.get('DownloadType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class DownloadDeviceResourceShrinkRequest(TeaModel):
    def __init__(
        self,
        device_resource_id: str = None,
        device_resource_ids_shrink: str = None,
        download_type: str = None,
        instance_id: str = None,
        setup_project_id: str = None,
    ):
        # deviceResourceId
        self.device_resource_id = device_resource_id
        # 资源uuid
        self.device_resource_ids_shrink = device_resource_ids_shrink
        # 操作类型
        self.download_type = download_type
        # instanceId
        self.instance_id = instance_id
        # 建设项目id
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.device_resource_ids_shrink is not None:
            result['DeviceResourceIds'] = self.device_resource_ids_shrink
        if self.download_type is not None:
            result['DownloadType'] = self.download_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids_shrink = m.get('DeviceResourceIds')
        if m.get('DownloadType') is not None:
            self.download_type = m.get('DownloadType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class DownloadDeviceResourceResponseBody(TeaModel):
    def __init__(
        self,
        download_url: str = None,
        request_id: str = None,
    ):
        # 下载链接
        self.download_url = download_url
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DownloadDeviceResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DownloadDeviceResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DownloadDeviceResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableNotificationRequestList(TeaModel):
    def __init__(
        self,
        aggregate_data_id: str = None,
        app_id: str = None,
        dedicated_line_id: str = None,
        device_id: str = None,
        monitor_item_id: str = None,
        port_collection_id: str = None,
        type: str = None,
    ):
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 应用ID
        self.app_id = app_id
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 设备ID
        self.device_id = device_id
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class EnableNotificationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        list: List[EnableNotificationRequestList] = None,
    ):
        # 实例ID
        self.instance_id = instance_id
        # 通知对象
        self.list = list

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = EnableNotificationRequestList()
                self.list.append(temp_model.from_map(k))
        return self


class EnableNotificationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # request id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableNotificationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EnableNotificationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableNotificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAlarmStatusRequest(TeaModel):
    def __init__(
        self,
        aggregate_data_id: str = None,
        app_id: str = None,
        dedicated_line_id: str = None,
        device_id: str = None,
        instance_id: str = None,
        monitor_item_id: str = None,
        port_collection_id: str = None,
        type: str = None,
    ):
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 应用ID
        self.app_id = app_id
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 设备ID
        self.device_id = device_id
        # 实例ID
        self.instance_id = instance_id
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 数据类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetAlarmStatusResponseBodyAlarmStatusAggregateData(TeaModel):
    def __init__(
        self,
        aggregate_data_description: str = None,
        aggregate_data_id: str = None,
        aggregate_data_name: str = None,
        aggregate_mode: str = None,
        data_item: str = None,
        device_id: str = None,
        is_all_device: int = None,
        monitor_item_id: str = None,
    ):
        # 描述
        self.aggregate_data_description = aggregate_data_description
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 聚合数据名称
        self.aggregate_data_name = aggregate_data_name
        # 聚合方式
        self.aggregate_mode = aggregate_mode
        # 数据项
        self.data_item = data_item
        # 设备ID
        self.device_id = device_id
        # 是否聚合全部设备
        self.is_all_device = is_all_device
        # 监控项ID
        self.monitor_item_id = monitor_item_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate_data_description is not None:
            result['AggregateDataDescription'] = self.aggregate_data_description
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.aggregate_data_name is not None:
            result['AggregateDataName'] = self.aggregate_data_name
        if self.aggregate_mode is not None:
            result['AggregateMode'] = self.aggregate_mode
        if self.data_item is not None:
            result['DataItem'] = self.data_item
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.is_all_device is not None:
            result['IsAllDevice'] = self.is_all_device
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregateDataDescription') is not None:
            self.aggregate_data_description = m.get('AggregateDataDescription')
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('AggregateDataName') is not None:
            self.aggregate_data_name = m.get('AggregateDataName')
        if m.get('AggregateMode') is not None:
            self.aggregate_mode = m.get('AggregateMode')
        if m.get('DataItem') is not None:
            self.data_item = m.get('DataItem')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('IsAllDevice') is not None:
            self.is_all_device = m.get('IsAllDevice')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        return self


class GetAlarmStatusResponseBodyAlarmStatusDedicatedLine(TeaModel):
    def __init__(
        self,
        bandwidth: str = None,
        dedicated_line_gateway: str = None,
        dedicated_line_name: str = None,
        device_id: str = None,
        ip: str = None,
        port_name: str = None,
        space: str = None,
    ):
        # 带宽
        self.bandwidth = bandwidth
        # 对端IP
        self.dedicated_line_gateway = dedicated_line_gateway
        # 专线名称
        self.dedicated_line_name = dedicated_line_name
        # 设备ID
        self.device_id = device_id
        # IP
        self.ip = ip
        # 端口名
        self.port_name = port_name
        # 物理空间
        self.space = space

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.dedicated_line_gateway is not None:
            result['DedicatedLineGateway'] = self.dedicated_line_gateway
        if self.dedicated_line_name is not None:
            result['DedicatedLineName'] = self.dedicated_line_name
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.space is not None:
            result['Space'] = self.space
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('DedicatedLineGateway') is not None:
            self.dedicated_line_gateway = m.get('DedicatedLineGateway')
        if m.get('DedicatedLineName') is not None:
            self.dedicated_line_name = m.get('DedicatedLineName')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        return self


class GetAlarmStatusResponseBodyAlarmStatusMonitorItem(TeaModel):
    def __init__(
        self,
        collection_type: str = None,
        device_form: str = None,
        effective: int = None,
        exec_interval: str = None,
        monitor_item_description: str = None,
        monitor_item_id: str = None,
        monitor_item_name: str = None,
        security_domain: str = None,
    ):
        # 采集类型
        self.collection_type = collection_type
        # 设备形态
        self.device_form = device_form
        # 是否启用
        self.effective = effective
        # 执行间隔
        self.exec_interval = exec_interval
        # 描述
        self.monitor_item_description = monitor_item_description
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 监控项名称
        self.monitor_item_name = monitor_item_name
        # 安全域
        self.security_domain = security_domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection_type is not None:
            result['CollectionType'] = self.collection_type
        if self.device_form is not None:
            result['DeviceForm'] = self.device_form
        if self.effective is not None:
            result['Effective'] = self.effective
        if self.exec_interval is not None:
            result['ExecInterval'] = self.exec_interval
        if self.monitor_item_description is not None:
            result['MonitorItemDescription'] = self.monitor_item_description
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.monitor_item_name is not None:
            result['MonitorItemName'] = self.monitor_item_name
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CollectionType') is not None:
            self.collection_type = m.get('CollectionType')
        if m.get('DeviceForm') is not None:
            self.device_form = m.get('DeviceForm')
        if m.get('Effective') is not None:
            self.effective = m.get('Effective')
        if m.get('ExecInterval') is not None:
            self.exec_interval = m.get('ExecInterval')
        if m.get('MonitorItemDescription') is not None:
            self.monitor_item_description = m.get('MonitorItemDescription')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('MonitorItemName') is not None:
            self.monitor_item_name = m.get('MonitorItemName')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        return self


class GetAlarmStatusResponseBodyAlarmStatusNotificationSwitch(TeaModel):
    def __init__(
        self,
        expiry_time: str = None,
        reason: str = None,
    ):
        # 关闭到期时间
        self.expiry_time = expiry_time
        # 关闭原因
        self.reason = reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expiry_time is not None:
            result['ExpiryTime'] = self.expiry_time
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpiryTime') is not None:
            self.expiry_time = m.get('ExpiryTime')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        return self


class GetAlarmStatusResponseBodyAlarmStatusPortCollectionPortListResourceDevice(TeaModel):
    def __init__(
        self,
        host_name: str = None,
        ip: str = None,
        security_domain: str = None,
    ):
        # 设备名
        self.host_name = host_name
        # IP
        self.ip = ip
        # 安全域
        self.security_domain = security_domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        return self


class GetAlarmStatusResponseBodyAlarmStatusPortCollectionPortList(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        port_name: str = None,
        resource_device: GetAlarmStatusResponseBodyAlarmStatusPortCollectionPortListResourceDevice = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 端口名
        self.port_name = port_name
        # 设备详情
        self.resource_device = resource_device

    def validate(self):
        if self.resource_device:
            self.resource_device.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.resource_device is not None:
            result['ResourceDevice'] = self.resource_device.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('ResourceDevice') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusPortCollectionPortListResourceDevice()
            self.resource_device = temp_model.from_map(m['ResourceDevice'])
        return self


class GetAlarmStatusResponseBodyAlarmStatusPortCollection(TeaModel):
    def __init__(
        self,
        port_collection_description: str = None,
        port_collection_id: str = None,
        port_collection_name: str = None,
        port_list: List[GetAlarmStatusResponseBodyAlarmStatusPortCollectionPortList] = None,
    ):
        # 端口集描述
        self.port_collection_description = port_collection_description
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 端口集名称
        self.port_collection_name = port_collection_name
        # 端口列表
        self.port_list = port_list

    def validate(self):
        if self.port_list:
            for k in self.port_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port_collection_description is not None:
            result['PortCollectionDescription'] = self.port_collection_description
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.port_collection_name is not None:
            result['PortCollectionName'] = self.port_collection_name
        result['PortList'] = []
        if self.port_list is not None:
            for k in self.port_list:
                result['PortList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PortCollectionDescription') is not None:
            self.port_collection_description = m.get('PortCollectionDescription')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('PortCollectionName') is not None:
            self.port_collection_name = m.get('PortCollectionName')
        self.port_list = []
        if m.get('PortList') is not None:
            for k in m.get('PortList'):
                temp_model = GetAlarmStatusResponseBodyAlarmStatusPortCollectionPortList()
                self.port_list.append(temp_model.from_map(k))
        return self


class GetAlarmStatusResponseBodyAlarmStatusResourceApp(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        domain: str = None,
        port: str = None,
        security_domain: str = None,
        type: str = None,
    ):
        # 应用ID
        self.app_id = app_id
        # 监控域名
        self.domain = domain
        # 端口
        self.port = port
        # 所属探针
        self.security_domain = security_domain
        # 资源类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.port is not None:
            result['Port'] = self.port
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetAlarmStatusResponseBodyAlarmStatusResourceDevice(TeaModel):
    def __init__(
        self,
        device_form: str = None,
        device_id: str = None,
        host_name: str = None,
        ip: str = None,
        model: str = None,
        security_domain: str = None,
        sn: str = None,
        space: str = None,
        status: str = None,
        vendor: str = None,
    ):
        # 设备形态
        self.device_form = device_form
        # 设备ID
        self.device_id = device_id
        # 设备名
        self.host_name = host_name
        # IP
        self.ip = ip
        # 型号
        self.model = model
        # 安全域
        self.security_domain = security_domain
        # sn
        self.sn = sn
        # 物理空间
        self.space = space
        # 状态
        self.status = status
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form is not None:
            result['DeviceForm'] = self.device_form
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.model is not None:
            result['Model'] = self.model
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.space is not None:
            result['Space'] = self.space
        if self.status is not None:
            result['Status'] = self.status
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceForm') is not None:
            self.device_form = m.get('DeviceForm')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class GetAlarmStatusResponseBodyAlarmStatus(TeaModel):
    def __init__(
        self,
        abnormal_data_item: str = None,
        agent_ip: str = None,
        aggregate_data: GetAlarmStatusResponseBodyAlarmStatusAggregateData = None,
        aggregate_data_id: str = None,
        alarm_rule: str = None,
        alarm_status: str = None,
        app_id: str = None,
        collection_time: str = None,
        dedicated_line: GetAlarmStatusResponseBodyAlarmStatusDedicatedLine = None,
        dedicated_line_id: str = None,
        device_id: str = None,
        first_abnormal_time: str = None,
        monitor_item: GetAlarmStatusResponseBodyAlarmStatusMonitorItem = None,
        monitor_item_id: str = None,
        notification_switch: GetAlarmStatusResponseBodyAlarmStatusNotificationSwitch = None,
        port_collection: GetAlarmStatusResponseBodyAlarmStatusPortCollection = None,
        port_collection_id: str = None,
        receive_time: str = None,
        resource_app: GetAlarmStatusResponseBodyAlarmStatusResourceApp = None,
        resource_device: GetAlarmStatusResponseBodyAlarmStatusResourceDevice = None,
        response_code: str = None,
        result: str = None,
        unique_key: str = None,
    ):
        # 异常数据项
        self.abnormal_data_item = abnormal_data_item
        # 采集探针IP
        self.agent_ip = agent_ip
        # 聚合数据详情
        self.aggregate_data = aggregate_data
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 命中告警规则
        self.alarm_rule = alarm_rule
        # 告警状态
        self.alarm_status = alarm_status
        # 应用ID
        self.app_id = app_id
        # 采集时间
        self.collection_time = collection_time
        # 专线详情
        self.dedicated_line = dedicated_line
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 设备ID
        self.device_id = device_id
        # 首次异常时间
        self.first_abnormal_time = first_abnormal_time
        # 监控项
        self.monitor_item = monitor_item
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 告警开关
        self.notification_switch = notification_switch
        self.port_collection = port_collection
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 接收时间
        self.receive_time = receive_time
        # 应用
        self.resource_app = resource_app
        # 设备
        self.resource_device = resource_device
        # 采集状态码
        self.response_code = response_code
        # 采集结果
        self.result = result
        # 索引
        self.unique_key = unique_key

    def validate(self):
        if self.aggregate_data:
            self.aggregate_data.validate()
        if self.dedicated_line:
            self.dedicated_line.validate()
        if self.monitor_item:
            self.monitor_item.validate()
        if self.notification_switch:
            self.notification_switch.validate()
        if self.port_collection:
            self.port_collection.validate()
        if self.resource_app:
            self.resource_app.validate()
        if self.resource_device:
            self.resource_device.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abnormal_data_item is not None:
            result['AbnormalDataItem'] = self.abnormal_data_item
        if self.agent_ip is not None:
            result['AgentIp'] = self.agent_ip
        if self.aggregate_data is not None:
            result['AggregateData'] = self.aggregate_data.to_map()
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.alarm_rule is not None:
            result['AlarmRule'] = self.alarm_rule
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.collection_time is not None:
            result['CollectionTime'] = self.collection_time
        if self.dedicated_line is not None:
            result['DedicatedLine'] = self.dedicated_line.to_map()
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.first_abnormal_time is not None:
            result['FirstAbnormalTime'] = self.first_abnormal_time
        if self.monitor_item is not None:
            result['MonitorItem'] = self.monitor_item.to_map()
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.notification_switch is not None:
            result['NotificationSwitch'] = self.notification_switch.to_map()
        if self.port_collection is not None:
            result['PortCollection'] = self.port_collection.to_map()
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.receive_time is not None:
            result['ReceiveTime'] = self.receive_time
        if self.resource_app is not None:
            result['ResourceApp'] = self.resource_app.to_map()
        if self.resource_device is not None:
            result['ResourceDevice'] = self.resource_device.to_map()
        if self.response_code is not None:
            result['ResponseCode'] = self.response_code
        if self.result is not None:
            result['Result'] = self.result
        if self.unique_key is not None:
            result['UniqueKey'] = self.unique_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AbnormalDataItem') is not None:
            self.abnormal_data_item = m.get('AbnormalDataItem')
        if m.get('AgentIp') is not None:
            self.agent_ip = m.get('AgentIp')
        if m.get('AggregateData') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusAggregateData()
            self.aggregate_data = temp_model.from_map(m['AggregateData'])
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('AlarmRule') is not None:
            self.alarm_rule = m.get('AlarmRule')
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CollectionTime') is not None:
            self.collection_time = m.get('CollectionTime')
        if m.get('DedicatedLine') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusDedicatedLine()
            self.dedicated_line = temp_model.from_map(m['DedicatedLine'])
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('FirstAbnormalTime') is not None:
            self.first_abnormal_time = m.get('FirstAbnormalTime')
        if m.get('MonitorItem') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusMonitorItem()
            self.monitor_item = temp_model.from_map(m['MonitorItem'])
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('NotificationSwitch') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusNotificationSwitch()
            self.notification_switch = temp_model.from_map(m['NotificationSwitch'])
        if m.get('PortCollection') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusPortCollection()
            self.port_collection = temp_model.from_map(m['PortCollection'])
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('ReceiveTime') is not None:
            self.receive_time = m.get('ReceiveTime')
        if m.get('ResourceApp') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusResourceApp()
            self.resource_app = temp_model.from_map(m['ResourceApp'])
        if m.get('ResourceDevice') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatusResourceDevice()
            self.resource_device = temp_model.from_map(m['ResourceDevice'])
        if m.get('ResponseCode') is not None:
            self.response_code = m.get('ResponseCode')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('UniqueKey') is not None:
            self.unique_key = m.get('UniqueKey')
        return self


class GetAlarmStatusResponseBody(TeaModel):
    def __init__(
        self,
        alarm_status: GetAlarmStatusResponseBodyAlarmStatus = None,
        request_id: str = None,
    ):
        # 告警状态
        self.alarm_status = alarm_status
        # request Id
        self.request_id = request_id

    def validate(self):
        if self.alarm_status:
            self.alarm_status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmStatus') is not None:
            temp_model = GetAlarmStatusResponseBodyAlarmStatus()
            self.alarm_status = temp_model.from_map(m['AlarmStatus'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAlarmStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetAlarmStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetAlarmStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConfigurationSpecificationRequest(TeaModel):
    def __init__(
        self,
        configuration_specification_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.configuration_specification_id = configuration_specification_id
        # instanceId
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetConfigurationSpecificationResponseBodyConfigurationSpecification(TeaModel):
    def __init__(
        self,
        architecture: str = None,
        configuration_specification_id: str = None,
        create_time: str = None,
        mode: str = None,
        related_variate: List[str] = None,
        role: str = None,
        specification_content: str = None,
        specification_name: str = None,
        update_time: str = None,
        vendor: str = None,
    ):
        # 架构
        self.architecture = architecture
        # 配置规范资源ID
        self.configuration_specification_id = configuration_specification_id
        # 创建时间
        self.create_time = create_time
        # 型号
        self.mode = mode
        # 相关变量
        self.related_variate = related_variate
        # 角色
        self.role = role
        # 规范内容
        self.specification_content = specification_content
        # 配置规范名字
        self.specification_name = specification_name
        # 更新时间
        self.update_time = update_time
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.related_variate is not None:
            result['RelatedVariate'] = self.related_variate
        if self.role is not None:
            result['Role'] = self.role
        if self.specification_content is not None:
            result['SpecificationContent'] = self.specification_content
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('RelatedVariate') is not None:
            self.related_variate = m.get('RelatedVariate')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SpecificationContent') is not None:
            self.specification_content = m.get('SpecificationContent')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class GetConfigurationSpecificationResponseBody(TeaModel):
    def __init__(
        self,
        configuration_specification: GetConfigurationSpecificationResponseBodyConfigurationSpecification = None,
        request_id: str = None,
    ):
        # 配置规范对象
        self.configuration_specification = configuration_specification
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.configuration_specification:
            self.configuration_specification.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_specification is not None:
            result['ConfigurationSpecification'] = self.configuration_specification.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationSpecification') is not None:
            temp_model = GetConfigurationSpecificationResponseBodyConfigurationSpecification()
            self.configuration_specification = temp_model.from_map(m['ConfigurationSpecification'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetConfigurationSpecificationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetConfigurationSpecificationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetConfigurationSpecificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConfigurationVariateRequest(TeaModel):
    def __init__(
        self,
        configuration_variate_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.configuration_variate_id = configuration_variate_id
        # instanceId
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_variate_id is not None:
            result['ConfigurationVariateId'] = self.configuration_variate_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationVariateId') is not None:
            self.configuration_variate_id = m.get('ConfigurationVariateId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetConfigurationVariateResponseBodyConfigurationVariate(TeaModel):
    def __init__(
        self,
        comment: str = None,
        format_function: str = None,
        variate_name: str = None,
    ):
        # 变量描述
        self.comment = comment
        # 转换函数
        self.format_function = format_function
        # project
        self.variate_name = variate_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.format_function is not None:
            result['FormatFunction'] = self.format_function
        if self.variate_name is not None:
            result['VariateName'] = self.variate_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('FormatFunction') is not None:
            self.format_function = m.get('FormatFunction')
        if m.get('VariateName') is not None:
            self.variate_name = m.get('VariateName')
        return self


class GetConfigurationVariateResponseBody(TeaModel):
    def __init__(
        self,
        configuration_variate: GetConfigurationVariateResponseBodyConfigurationVariate = None,
        request_id: str = None,
    ):
        # 资源对象
        self.configuration_variate = configuration_variate
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.configuration_variate:
            self.configuration_variate.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configuration_variate is not None:
            result['ConfigurationVariate'] = self.configuration_variate.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigurationVariate') is not None:
            temp_model = GetConfigurationVariateResponseBodyConfigurationVariate()
            self.configuration_variate = temp_model.from_map(m['ConfigurationVariate'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetConfigurationVariateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetConfigurationVariateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetConfigurationVariateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDedicatedLineRequest(TeaModel):
    def __init__(
        self,
        dedicated_line_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.dedicated_line_id = dedicated_line_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDedicatedLineResponseBodyDedicatedLine(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        dedicated_line_gateway: str = None,
        dedicated_line_id: str = None,
        dedicated_line_ip: str = None,
        dedicated_line_role: str = None,
        description: str = None,
        device_id: str = None,
        device_name: str = None,
        device_port: str = None,
        isp: str = None,
        physical_space_id: str = None,
    ):
        # 宽带（Mbps）
        self.bandwidth = bandwidth
        # 专线网关
        self.dedicated_line_gateway = dedicated_line_gateway
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 专线IP
        self.dedicated_line_ip = dedicated_line_ip
        # 专线角色
        self.dedicated_line_role = dedicated_line_role
        # 备注
        self.description = description
        # 关联设备ID
        self.device_id = device_id
        # 关联设备名称
        self.device_name = device_name
        # 关联设备端口名称
        self.device_port = device_port
        # 运营商
        self.isp = isp
        # 物理空间ID
        self.physical_space_id = physical_space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.dedicated_line_gateway is not None:
            result['DedicatedLineGateway'] = self.dedicated_line_gateway
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.dedicated_line_ip is not None:
            result['DedicatedLineIp'] = self.dedicated_line_ip
        if self.dedicated_line_role is not None:
            result['DedicatedLineRole'] = self.dedicated_line_role
        if self.description is not None:
            result['Description'] = self.description
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_port is not None:
            result['DevicePort'] = self.device_port
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('DedicatedLineGateway') is not None:
            self.dedicated_line_gateway = m.get('DedicatedLineGateway')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('DedicatedLineIp') is not None:
            self.dedicated_line_ip = m.get('DedicatedLineIp')
        if m.get('DedicatedLineRole') is not None:
            self.dedicated_line_role = m.get('DedicatedLineRole')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DevicePort') is not None:
            self.device_port = m.get('DevicePort')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        return self


class GetDedicatedLineResponseBody(TeaModel):
    def __init__(
        self,
        dedicated_line: GetDedicatedLineResponseBodyDedicatedLine = None,
        request_id: str = None,
    ):
        # 物理空间专线详情
        self.dedicated_line = dedicated_line
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.dedicated_line:
            self.dedicated_line.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_line is not None:
            result['DedicatedLine'] = self.dedicated_line.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedLine') is not None:
            temp_model = GetDedicatedLineResponseBodyDedicatedLine()
            self.dedicated_line = temp_model.from_map(m['DedicatedLine'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDedicatedLineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDedicatedLineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDedicatedLineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_id = device_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDeviceResponseBodyDevice(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        device_form_name: str = None,
        device_id: str = None,
        enable_password: str = None,
        ext_attributes: str = None,
        host_name: str = None,
        ip: str = None,
        login_password: str = None,
        login_type: str = None,
        login_username: str = None,
        mac: str = None,
        model: str = None,
        physical_space_id: str = None,
        physical_space_name: str = None,
        security_domain: str = None,
        service_status: str = None,
        sn: str = None,
        snmp_account_type: str = None,
        snmp_account_version: str = None,
        snmp_auth_passphrase: str = None,
        snmp_auth_protocol: str = None,
        snmp_community: str = None,
        snmp_privacy_passphrase: str = None,
        snmp_privacy_protocol: str = None,
        snmp_security_level: str = None,
        snmp_username: str = None,
        vendor: str = None,
    ):
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 设备ID
        self.device_id = device_id
        # enable密码
        self.enable_password = enable_password
        # 设备额外属性
        self.ext_attributes = ext_attributes
        # 主机名
        self.host_name = host_name
        # 设备IP
        self.ip = ip
        # 登录密码
        self.login_password = login_password
        # 登录类型
        self.login_type = login_type
        # 登录账号
        self.login_username = login_username
        # 设备MAC地址
        self.mac = mac
        # 设备型号
        self.model = model
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 物理空间名称
        self.physical_space_name = physical_space_name
        # 设备安全域
        self.security_domain = security_domain
        # 设备状态
        self.service_status = service_status
        # 设备SN
        self.sn = sn
        # SNMP 账号类型
        self.snmp_account_type = snmp_account_type
        # SNMP版本号
        self.snmp_account_version = snmp_account_version
        # SNMP Auth PassPhrase
        self.snmp_auth_passphrase = snmp_auth_passphrase
        # SNMP Auth Protocol
        self.snmp_auth_protocol = snmp_auth_protocol
        # SNMP Community
        self.snmp_community = snmp_community
        # SNMP Privacy Passphrase
        self.snmp_privacy_passphrase = snmp_privacy_passphrase
        # SNMP Privacy Protocol
        self.snmp_privacy_protocol = snmp_privacy_protocol
        # SNMP 安全级别
        self.snmp_security_level = snmp_security_level
        # SNMP 用户名
        self.snmp_username = snmp_username
        # 设备厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.enable_password is not None:
            result['EnablePassword'] = self.enable_password
        if self.ext_attributes is not None:
            result['ExtAttributes'] = self.ext_attributes
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.login_password is not None:
            result['LoginPassword'] = self.login_password
        if self.login_type is not None:
            result['LoginType'] = self.login_type
        if self.login_username is not None:
            result['LoginUsername'] = self.login_username
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.model is not None:
            result['Model'] = self.model
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.physical_space_name is not None:
            result['PhysicalSpaceName'] = self.physical_space_name
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.snmp_account_type is not None:
            result['SnmpAccountType'] = self.snmp_account_type
        if self.snmp_account_version is not None:
            result['SnmpAccountVersion'] = self.snmp_account_version
        if self.snmp_auth_passphrase is not None:
            result['SnmpAuthPassphrase'] = self.snmp_auth_passphrase
        if self.snmp_auth_protocol is not None:
            result['SnmpAuthProtocol'] = self.snmp_auth_protocol
        if self.snmp_community is not None:
            result['SnmpCommunity'] = self.snmp_community
        if self.snmp_privacy_passphrase is not None:
            result['SnmpPrivacyPassphrase'] = self.snmp_privacy_passphrase
        if self.snmp_privacy_protocol is not None:
            result['SnmpPrivacyProtocol'] = self.snmp_privacy_protocol
        if self.snmp_security_level is not None:
            result['SnmpSecurityLevel'] = self.snmp_security_level
        if self.snmp_username is not None:
            result['SnmpUsername'] = self.snmp_username
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('EnablePassword') is not None:
            self.enable_password = m.get('EnablePassword')
        if m.get('ExtAttributes') is not None:
            self.ext_attributes = m.get('ExtAttributes')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('LoginPassword') is not None:
            self.login_password = m.get('LoginPassword')
        if m.get('LoginType') is not None:
            self.login_type = m.get('LoginType')
        if m.get('LoginUsername') is not None:
            self.login_username = m.get('LoginUsername')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('PhysicalSpaceName') is not None:
            self.physical_space_name = m.get('PhysicalSpaceName')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('SnmpAccountType') is not None:
            self.snmp_account_type = m.get('SnmpAccountType')
        if m.get('SnmpAccountVersion') is not None:
            self.snmp_account_version = m.get('SnmpAccountVersion')
        if m.get('SnmpAuthPassphrase') is not None:
            self.snmp_auth_passphrase = m.get('SnmpAuthPassphrase')
        if m.get('SnmpAuthProtocol') is not None:
            self.snmp_auth_protocol = m.get('SnmpAuthProtocol')
        if m.get('SnmpCommunity') is not None:
            self.snmp_community = m.get('SnmpCommunity')
        if m.get('SnmpPrivacyPassphrase') is not None:
            self.snmp_privacy_passphrase = m.get('SnmpPrivacyPassphrase')
        if m.get('SnmpPrivacyProtocol') is not None:
            self.snmp_privacy_protocol = m.get('SnmpPrivacyProtocol')
        if m.get('SnmpSecurityLevel') is not None:
            self.snmp_security_level = m.get('SnmpSecurityLevel')
        if m.get('SnmpUsername') is not None:
            self.snmp_username = m.get('SnmpUsername')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class GetDeviceResponseBody(TeaModel):
    def __init__(
        self,
        device: GetDeviceResponseBodyDevice = None,
        request_id: str = None,
    ):
        # 设备详情
        self.device = device
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.device:
            self.device.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device is not None:
            result['Device'] = self.device.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Device') is not None:
            temp_model = GetDeviceResponseBodyDevice()
            self.device = temp_model.from_map(m['Device'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDeviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceConfigRequest(TeaModel):
    def __init__(
        self,
        date: str = None,
        device_id: str = None,
        instance_id: str = None,
    ):
        # 查询日期，格式 yyyy-MM-dd
        self.date = date
        # 实例 ID。
        self.device_id = device_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDeviceConfigResponseBody(TeaModel):
    def __init__(
        self,
        device_config: str = None,
        request_id: str = None,
    ):
        # 设备配置内容
        self.device_config = device_config
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_config is not None:
            result['DeviceConfig'] = self.device_config
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceConfig') is not None:
            self.device_config = m.get('DeviceConfig')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDeviceConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceConfigDateRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_id = device_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDeviceConfigDateResponseBody(TeaModel):
    def __init__(
        self,
        device_config_date: List[str] = None,
        request_id: str = None,
    ):
        # 设备配置变化日期
        self.device_config_date = device_config_date
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_config_date is not None:
            result['DeviceConfigDate'] = self.device_config_date
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceConfigDate') is not None:
            self.device_config_date = m.get('DeviceConfigDate')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDeviceConfigDateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceConfigDateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceConfigDateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceConfigDiffRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        end_date: str = None,
        instance_id: str = None,
        start_date: str = None,
    ):
        # 实例 ID。
        self.device_id = device_id
        # 查询日期2，格式 yyyy-MM-dd
        self.end_date = end_date
        # 实例ID
        self.instance_id = instance_id
        # 查询日期1，格式 yyyy-MM-dd
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetDeviceConfigDiffResponseBodyDeviceConfigDiff(TeaModel):
    def __init__(
        self,
        extract_diff: str = None,
        total_diff: str = None,
    ):
        # 差异提取
        self.extract_diff = extract_diff
        # 全量比对
        self.total_diff = total_diff

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extract_diff is not None:
            result['ExtractDiff'] = self.extract_diff
        if self.total_diff is not None:
            result['TotalDiff'] = self.total_diff
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExtractDiff') is not None:
            self.extract_diff = m.get('ExtractDiff')
        if m.get('TotalDiff') is not None:
            self.total_diff = m.get('TotalDiff')
        return self


class GetDeviceConfigDiffResponseBody(TeaModel):
    def __init__(
        self,
        device_config_diff: GetDeviceConfigDiffResponseBodyDeviceConfigDiff = None,
        request_id: str = None,
    ):
        self.device_config_diff = device_config_diff
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.device_config_diff:
            self.device_config_diff.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_config_diff is not None:
            result['DeviceConfigDiff'] = self.device_config_diff.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceConfigDiff') is not None:
            temp_model = GetDeviceConfigDiffResponseBodyDeviceConfigDiff()
            self.device_config_diff = temp_model.from_map(m['DeviceConfigDiff'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDeviceConfigDiffResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceConfigDiffResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceConfigDiffResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceFormRequest(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_form_id = device_form_id
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDeviceFormResponseBodyDeviceFormAttributeList(TeaModel):
    def __init__(
        self,
        attribute_built_in: bool = None,
        attribute_format: str = None,
        attribute_fuzzy_query: bool = None,
        attribute_key: str = None,
        attribute_name: str = None,
        attribute_placeholder: str = None,
        attribute_query: bool = None,
        attribute_reference: str = None,
        attribute_requirement: bool = None,
        attribute_table_display: bool = None,
        attribute_type: str = None,
        attribute_uniqueness: bool = None,
    ):
        # 设备形态属性是否内置
        self.attribute_built_in = attribute_built_in
        # 设备形态属性值格式
        self.attribute_format = attribute_format
        # 前端查询控件是否支持模糊搜索
        self.attribute_fuzzy_query = attribute_fuzzy_query
        # 设备形态属性主键
        self.attribute_key = attribute_key
        # 设备形态属性名称
        self.attribute_name = attribute_name
        # 前端查询控件占位符
        self.attribute_placeholder = attribute_placeholder
        # 前端是否展示对应的查询控件
        self.attribute_query = attribute_query
        # 设备形态属性关联对象
        self.attribute_reference = attribute_reference
        # 设备形态属性是否必填
        self.attribute_requirement = attribute_requirement
        # 设备形态属性是否表格可见
        self.attribute_table_display = attribute_table_display
        # 设备形态属性值类型
        self.attribute_type = attribute_type
        # 设备形态属性是否唯一
        self.attribute_uniqueness = attribute_uniqueness

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_built_in is not None:
            result['AttributeBuiltIn'] = self.attribute_built_in
        if self.attribute_format is not None:
            result['AttributeFormat'] = self.attribute_format
        if self.attribute_fuzzy_query is not None:
            result['AttributeFuzzyQuery'] = self.attribute_fuzzy_query
        if self.attribute_key is not None:
            result['AttributeKey'] = self.attribute_key
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.attribute_placeholder is not None:
            result['AttributePlaceholder'] = self.attribute_placeholder
        if self.attribute_query is not None:
            result['AttributeQuery'] = self.attribute_query
        if self.attribute_reference is not None:
            result['AttributeReference'] = self.attribute_reference
        if self.attribute_requirement is not None:
            result['AttributeRequirement'] = self.attribute_requirement
        if self.attribute_table_display is not None:
            result['AttributeTableDisplay'] = self.attribute_table_display
        if self.attribute_type is not None:
            result['AttributeType'] = self.attribute_type
        if self.attribute_uniqueness is not None:
            result['AttributeUniqueness'] = self.attribute_uniqueness
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttributeBuiltIn') is not None:
            self.attribute_built_in = m.get('AttributeBuiltIn')
        if m.get('AttributeFormat') is not None:
            self.attribute_format = m.get('AttributeFormat')
        if m.get('AttributeFuzzyQuery') is not None:
            self.attribute_fuzzy_query = m.get('AttributeFuzzyQuery')
        if m.get('AttributeKey') is not None:
            self.attribute_key = m.get('AttributeKey')
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('AttributePlaceholder') is not None:
            self.attribute_placeholder = m.get('AttributePlaceholder')
        if m.get('AttributeQuery') is not None:
            self.attribute_query = m.get('AttributeQuery')
        if m.get('AttributeReference') is not None:
            self.attribute_reference = m.get('AttributeReference')
        if m.get('AttributeRequirement') is not None:
            self.attribute_requirement = m.get('AttributeRequirement')
        if m.get('AttributeTableDisplay') is not None:
            self.attribute_table_display = m.get('AttributeTableDisplay')
        if m.get('AttributeType') is not None:
            self.attribute_type = m.get('AttributeType')
        if m.get('AttributeUniqueness') is not None:
            self.attribute_uniqueness = m.get('AttributeUniqueness')
        return self


class GetDeviceFormResponseBodyDeviceForm(TeaModel):
    def __init__(
        self,
        account_config: bool = None,
        attribute_list: List[GetDeviceFormResponseBodyDeviceFormAttributeList] = None,
        config_compare: bool = None,
        detail_display: bool = None,
        device_form_id: str = None,
        device_form_name: str = None,
        form_built_in: bool = None,
        resource_use: str = None,
        script: str = None,
        unique_key: str = None,
    ):
        # 是否需要账号配置
        self.account_config = account_config
        # 设备形态属性列表
        self.attribute_list = attribute_list
        # 是否支持配置生成
        self.config_compare = config_compare
        # 是否展示设备详情
        self.detail_display = detail_display
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 设备形态是否内置
        self.form_built_in = form_built_in
        # 资源用途
        self.resource_use = resource_use
        # 设备代码
        self.script = script
        # 设备形态主键
        self.unique_key = unique_key

    def validate(self):
        if self.attribute_list:
            for k in self.attribute_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_config is not None:
            result['AccountConfig'] = self.account_config
        result['AttributeList'] = []
        if self.attribute_list is not None:
            for k in self.attribute_list:
                result['AttributeList'].append(k.to_map() if k else None)
        if self.config_compare is not None:
            result['ConfigCompare'] = self.config_compare
        if self.detail_display is not None:
            result['DetailDisplay'] = self.detail_display
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.form_built_in is not None:
            result['FormBuiltIn'] = self.form_built_in
        if self.resource_use is not None:
            result['ResourceUse'] = self.resource_use
        if self.script is not None:
            result['Script'] = self.script
        if self.unique_key is not None:
            result['UniqueKey'] = self.unique_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountConfig') is not None:
            self.account_config = m.get('AccountConfig')
        self.attribute_list = []
        if m.get('AttributeList') is not None:
            for k in m.get('AttributeList'):
                temp_model = GetDeviceFormResponseBodyDeviceFormAttributeList()
                self.attribute_list.append(temp_model.from_map(k))
        if m.get('ConfigCompare') is not None:
            self.config_compare = m.get('ConfigCompare')
        if m.get('DetailDisplay') is not None:
            self.detail_display = m.get('DetailDisplay')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('FormBuiltIn') is not None:
            self.form_built_in = m.get('FormBuiltIn')
        if m.get('ResourceUse') is not None:
            self.resource_use = m.get('ResourceUse')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('UniqueKey') is not None:
            self.unique_key = m.get('UniqueKey')
        return self


class GetDeviceFormResponseBody(TeaModel):
    def __init__(
        self,
        device_form: GetDeviceFormResponseBodyDeviceForm = None,
        request_id: str = None,
    ):
        # 设备详情
        self.device_form = device_form
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.device_form:
            self.device_form.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form is not None:
            result['DeviceForm'] = self.device_form.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceForm') is not None:
            temp_model = GetDeviceFormResponseBodyDeviceForm()
            self.device_form = temp_model.from_map(m['DeviceForm'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDeviceFormResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceFormResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceFormResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceOpLogRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 实例ID
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class GetDeviceOpLogResponseBodyOperationLogs(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        gmt_modified_time: str = None,
        keyword: str = None,
        new_value: str = None,
        old_value: str = None,
        operator: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 操作时间
        self.gmt_modified_time = gmt_modified_time
        # 属性
        self.keyword = keyword
        # 新值
        self.new_value = new_value
        # 旧值
        self.old_value = old_value
        # 操作描述
        self.operator = operator

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.gmt_modified_time is not None:
            result['GmtModifiedTime'] = self.gmt_modified_time
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.new_value is not None:
            result['NewValue'] = self.new_value
        if self.old_value is not None:
            result['OldValue'] = self.old_value
        if self.operator is not None:
            result['Operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('GmtModifiedTime') is not None:
            self.gmt_modified_time = m.get('GmtModifiedTime')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('NewValue') is not None:
            self.new_value = m.get('NewValue')
        if m.get('OldValue') is not None:
            self.old_value = m.get('OldValue')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        return self


class GetDeviceOpLogResponseBody(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: int = None,
        operation_logs: List[GetDeviceOpLogResponseBodyOperationLogs] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 每页数量。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 数组，返回示例目录。
        self.operation_logs = operation_logs
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.operation_logs:
            for k in self.operation_logs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['OperationLogs'] = []
        if self.operation_logs is not None:
            for k in self.operation_logs:
                result['OperationLogs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.operation_logs = []
        if m.get('OperationLogs') is not None:
            for k in m.get('OperationLogs'):
                temp_model = GetDeviceOpLogResponseBodyOperationLogs()
                self.operation_logs.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetDeviceOpLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceOpLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceOpLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDevicePropertyRequest(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        device_property_id: str = None,
        instance_id: str = None,
        property_key: str = None,
    ):
        # 设备形态ID
        self.device_form_id = device_form_id
        # 实例 ID。
        self.device_property_id = device_property_id
        # 实例ID
        self.instance_id = instance_id
        # 属性主键
        self.property_key = property_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_property_id is not None:
            result['DevicePropertyId'] = self.device_property_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.property_key is not None:
            result['PropertyKey'] = self.property_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DevicePropertyId') is not None:
            self.device_property_id = m.get('DevicePropertyId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PropertyKey') is not None:
            self.property_key = m.get('PropertyKey')
        return self


class GetDevicePropertyResponseBodyDeviceProperty(TeaModel):
    def __init__(
        self,
        built_in: bool = None,
        device_form_id: str = None,
        device_form_name: str = None,
        device_property_id: str = None,
        property_content: str = None,
        property_format: str = None,
        property_key: str = None,
        property_name: str = None,
    ):
        # 是否内置属性
        self.built_in = built_in
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 设备属性ID
        self.device_property_id = device_property_id
        # 属性内容
        self.property_content = property_content
        # 属性格式
        self.property_format = property_format
        # 属性主键
        self.property_key = property_key
        # 属性名称
        self.property_name = property_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.built_in is not None:
            result['BuiltIn'] = self.built_in
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.device_property_id is not None:
            result['DevicePropertyId'] = self.device_property_id
        if self.property_content is not None:
            result['PropertyContent'] = self.property_content
        if self.property_format is not None:
            result['PropertyFormat'] = self.property_format
        if self.property_key is not None:
            result['PropertyKey'] = self.property_key
        if self.property_name is not None:
            result['PropertyName'] = self.property_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BuiltIn') is not None:
            self.built_in = m.get('BuiltIn')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('DevicePropertyId') is not None:
            self.device_property_id = m.get('DevicePropertyId')
        if m.get('PropertyContent') is not None:
            self.property_content = m.get('PropertyContent')
        if m.get('PropertyFormat') is not None:
            self.property_format = m.get('PropertyFormat')
        if m.get('PropertyKey') is not None:
            self.property_key = m.get('PropertyKey')
        if m.get('PropertyName') is not None:
            self.property_name = m.get('PropertyName')
        return self


class GetDevicePropertyResponseBody(TeaModel):
    def __init__(
        self,
        device_property: GetDevicePropertyResponseBodyDeviceProperty = None,
        request_id: str = None,
    ):
        # 设备属性详情
        self.device_property = device_property
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.device_property:
            self.device_property.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_property is not None:
            result['DeviceProperty'] = self.device_property.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceProperty') is not None:
            temp_model = GetDevicePropertyResponseBodyDeviceProperty()
            self.device_property = temp_model.from_map(m['DeviceProperty'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDevicePropertyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDevicePropertyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDevicePropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceResourceRequest(TeaModel):
    def __init__(
        self,
        device_resource_id: str = None,
        instance_id: str = None,
    ):
        # 实例 ID。
        self.device_resource_id = device_resource_id
        # instanceId
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDeviceResourceResponseBodyDeviceResource(TeaModel):
    def __init__(
        self,
        block_number: str = None,
        business: str = None,
        config: str = None,
        config_task_status: str = None,
        delivery_ip: str = None,
        device_num: str = None,
        device_resource_id: str = None,
        generate_config: str = None,
        host_name: str = None,
        inter_connection: str = None,
        location: str = None,
        loopback: str = None,
        manager_ip: str = None,
        model: str = None,
        role: str = None,
        setup_project_id: str = None,
        sn: str = None,
        stack: bool = None,
        vendor: str = None,
    ):
        # 组号
        self.block_number = block_number
        # 设备业务地址
        self.business = business
        # 设备配置
        self.config = config
        # 配置下发状态
        self.config_task_status = config_task_status
        # 交付登录地址
        self.delivery_ip = delivery_ip
        # 设备号
        self.device_num = device_num
        # 资源一级ID
        self.device_resource_id = device_resource_id
        # 配置生成
        self.generate_config = generate_config
        # 主机名
        self.host_name = host_name
        # 设备互联地址
        self.inter_connection = inter_connection
        # 物理空间位置
        self.location = location
        # loopback地址
        self.loopback = loopback
        # 带内管理地址
        self.manager_ip = manager_ip
        # 模型
        self.model = model
        # 角色
        self.role = role
        # 建设项目id
        self.setup_project_id = setup_project_id
        # 设备sn号
        self.sn = sn
        # 堆叠状态
        self.stack = stack
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_number is not None:
            result['BlockNumber'] = self.block_number
        if self.business is not None:
            result['Business'] = self.business
        if self.config is not None:
            result['Config'] = self.config
        if self.config_task_status is not None:
            result['ConfigTaskStatus'] = self.config_task_status
        if self.delivery_ip is not None:
            result['DeliveryIp'] = self.delivery_ip
        if self.device_num is not None:
            result['DeviceNum'] = self.device_num
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.generate_config is not None:
            result['GenerateConfig'] = self.generate_config
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.inter_connection is not None:
            result['InterConnection'] = self.inter_connection
        if self.location is not None:
            result['Location'] = self.location
        if self.loopback is not None:
            result['Loopback'] = self.loopback
        if self.manager_ip is not None:
            result['ManagerIp'] = self.manager_ip
        if self.model is not None:
            result['Model'] = self.model
        if self.role is not None:
            result['Role'] = self.role
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.stack is not None:
            result['Stack'] = self.stack
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockNumber') is not None:
            self.block_number = m.get('BlockNumber')
        if m.get('Business') is not None:
            self.business = m.get('Business')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('ConfigTaskStatus') is not None:
            self.config_task_status = m.get('ConfigTaskStatus')
        if m.get('DeliveryIp') is not None:
            self.delivery_ip = m.get('DeliveryIp')
        if m.get('DeviceNum') is not None:
            self.device_num = m.get('DeviceNum')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('GenerateConfig') is not None:
            self.generate_config = m.get('GenerateConfig')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InterConnection') is not None:
            self.inter_connection = m.get('InterConnection')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Loopback') is not None:
            self.loopback = m.get('Loopback')
        if m.get('ManagerIp') is not None:
            self.manager_ip = m.get('ManagerIp')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('Stack') is not None:
            self.stack = m.get('Stack')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class GetDeviceResourceResponseBody(TeaModel):
    def __init__(
        self,
        device_resource: GetDeviceResourceResponseBodyDeviceResource = None,
        request_id: str = None,
    ):
        # 设备资源
        self.device_resource = device_resource
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.device_resource:
            self.device_resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_resource is not None:
            result['DeviceResource'] = self.device_resource.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceResource') is not None:
            temp_model = GetDeviceResourceResponseBodyDeviceResource()
            self.device_resource = temp_model.from_map(m['DeviceResource'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetDeviceResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeviceResourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInspectionTaskRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        instance_id: str = None,
        item_name: str = None,
        task_id: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 实例ID
        self.instance_id = instance_id
        # 巡检项名称
        self.item_name = item_name
        # 巡检项ID
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetInspectionTaskResponseBodyInspectionTaskInspectionAlarmRules(TeaModel):
    def __init__(
        self,
        actual_value: str = None,
        expression: str = None,
        level: str = None,
        operator: str = None,
        value: str = None,
    ):
        # 告警实际值
        self.actual_value = actual_value
        # 告警符号
        self.expression = expression
        # 告警级别
        self.level = level
        # 告警操作符
        self.operator = operator
        # 告警值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_value is not None:
            result['ActualValue'] = self.actual_value
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.level is not None:
            result['Level'] = self.level
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActualValue') is not None:
            self.actual_value = m.get('ActualValue')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetInspectionTaskResponseBodyInspectionTask(TeaModel):
    def __init__(
        self,
        device_display: str = None,
        device_id: str = None,
        error_code: str = None,
        execution_begin_time: str = None,
        execution_end_time: str = None,
        host_name: str = None,
        ip: str = None,
        inspection_alarm_rules: List[GetInspectionTaskResponseBodyInspectionTaskInspectionAlarmRules] = None,
        inspection_result: str = None,
        item_id: str = None,
        item_name: str = None,
        model: List[str] = None,
        script_id: str = None,
        space: str = None,
        task_id: str = None,
        task_status: str = None,
        vendor: str = None,
    ):
        # 设备回显
        self.device_display = device_display
        # 设备ID
        self.device_id = device_id
        # 错误码
        self.error_code = error_code
        # 巡检开始时间
        self.execution_begin_time = execution_begin_time
        # 巡检结束时间
        self.execution_end_time = execution_end_time
        # 主机名
        self.host_name = host_name
        # IP地址
        self.ip = ip
        # 告警规则
        self.inspection_alarm_rules = inspection_alarm_rules
        # 巡检结果
        self.inspection_result = inspection_result
        # 巡检项ID
        self.item_id = item_id
        # 巡检项名字
        self.item_name = item_name
        # 型号
        self.model = model
        # 模板ID
        self.script_id = script_id
        # 物理空间
        self.space = space
        # 任务ID
        self.task_id = task_id
        # 任务状态
        self.task_status = task_status
        # 厂商
        self.vendor = vendor

    def validate(self):
        if self.inspection_alarm_rules:
            for k in self.inspection_alarm_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_display is not None:
            result['DeviceDisplay'] = self.device_display
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.execution_begin_time is not None:
            result['ExecutionBeginTime'] = self.execution_begin_time
        if self.execution_end_time is not None:
            result['ExecutionEndTime'] = self.execution_end_time
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['IP'] = self.ip
        result['InspectionAlarmRules'] = []
        if self.inspection_alarm_rules is not None:
            for k in self.inspection_alarm_rules:
                result['InspectionAlarmRules'].append(k.to_map() if k else None)
        if self.inspection_result is not None:
            result['InspectionResult'] = self.inspection_result
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.model is not None:
            result['Model'] = self.model
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        if self.space is not None:
            result['Space'] = self.space
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceDisplay') is not None:
            self.device_display = m.get('DeviceDisplay')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ExecutionBeginTime') is not None:
            self.execution_begin_time = m.get('ExecutionBeginTime')
        if m.get('ExecutionEndTime') is not None:
            self.execution_end_time = m.get('ExecutionEndTime')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        self.inspection_alarm_rules = []
        if m.get('InspectionAlarmRules') is not None:
            for k in m.get('InspectionAlarmRules'):
                temp_model = GetInspectionTaskResponseBodyInspectionTaskInspectionAlarmRules()
                self.inspection_alarm_rules.append(temp_model.from_map(k))
        if m.get('InspectionResult') is not None:
            self.inspection_result = m.get('InspectionResult')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class GetInspectionTaskResponseBody(TeaModel):
    def __init__(
        self,
        inspection_task: GetInspectionTaskResponseBodyInspectionTask = None,
        request_id: str = None,
    ):
        # 周期巡检任务详情
        self.inspection_task = inspection_task
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.inspection_task:
            self.inspection_task.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inspection_task is not None:
            result['InspectionTask'] = self.inspection_task.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InspectionTask') is not None:
            temp_model = GetInspectionTaskResponseBodyInspectionTask()
            self.inspection_task = temp_model.from_map(m['InspectionTask'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetInspectionTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInspectionTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInspectionTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOsDownloadPathRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        os_version_id: str = None,
    ):
        self.instance_id = instance_id
        # 架构资源uuid
        self.os_version_id = os_version_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.os_version_id is not None:
            result['OsVersionId'] = self.os_version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OsVersionId') is not None:
            self.os_version_id = m.get('OsVersionId')
        return self


class GetOsDownloadPathResponseBodyOsVersion(TeaModel):
    def __init__(
        self,
        download_path: str = None,
    ):
        # 系统版本下载路径
        self.download_path = download_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_path is not None:
            result['DownloadPath'] = self.download_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownloadPath') is not None:
            self.download_path = m.get('DownloadPath')
        return self


class GetOsDownloadPathResponseBody(TeaModel):
    def __init__(
        self,
        os_version: GetOsDownloadPathResponseBodyOsVersion = None,
        request_id: str = None,
    ):
        # 系统版本
        self.os_version = os_version
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.os_version:
            self.os_version.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.os_version is not None:
            result['OsVersion'] = self.os_version.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OsVersion') is not None:
            temp_model = GetOsDownloadPathResponseBodyOsVersion()
            self.os_version = temp_model.from_map(m['OsVersion'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetOsDownloadPathResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetOsDownloadPathResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetOsDownloadPathResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOsVersionRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        os_version_id: str = None,
    ):
        self.instance_id = instance_id
        # 实例 ID。
        self.os_version_id = os_version_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.os_version_id is not None:
            result['OsVersionId'] = self.os_version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OsVersionId') is not None:
            self.os_version_id = m.get('OsVersionId')
        return self


class GetOsVersionResponseBodyOsVersion(TeaModel):
    def __init__(
        self,
        download_path: str = None,
    ):
        # 下载路径
        self.download_path = download_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_path is not None:
            result['DownloadPath'] = self.download_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownloadPath') is not None:
            self.download_path = m.get('DownloadPath')
        return self


class GetOsVersionResponseBody(TeaModel):
    def __init__(
        self,
        os_version: List[GetOsVersionResponseBodyOsVersion] = None,
        request_id: str = None,
    ):
        # 数组，返回示例目录。
        self.os_version = os_version
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.os_version:
            for k in self.os_version:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OsVersion'] = []
        if self.os_version is not None:
            for k in self.os_version:
                result['OsVersion'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.os_version = []
        if m.get('OsVersion') is not None:
            for k in m.get('OsVersion'):
                temp_model = GetOsVersionResponseBodyOsVersion()
                self.os_version.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetOsVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetOsVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetOsVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOssPolicyRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetOssPolicyResponseBodyOssPolicy(TeaModel):
    def __init__(
        self,
        access_id: str = None,
        directory: str = None,
        expire_time: str = None,
        host: str = None,
        policy: str = None,
        signature: str = None,
    ):
        # 通行id
        self.access_id = access_id
        # 目录
        self.directory = directory
        # 过期时间
        self.expire_time = expire_time
        # 主机名
        self.host = host
        # 通行规则
        self.policy = policy
        # 签名
        self.signature = signature

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_id is not None:
            result['AccessId'] = self.access_id
        if self.directory is not None:
            result['Directory'] = self.directory
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessId') is not None:
            self.access_id = m.get('AccessId')
        if m.get('Directory') is not None:
            self.directory = m.get('Directory')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        return self


class GetOssPolicyResponseBody(TeaModel):
    def __init__(
        self,
        oss_policy: GetOssPolicyResponseBodyOssPolicy = None,
        request_id: str = None,
    ):
        # 资源上传规则
        self.oss_policy = oss_policy
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.oss_policy:
            self.oss_policy.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.oss_policy is not None:
            result['OssPolicy'] = self.oss_policy.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OssPolicy') is not None:
            temp_model = GetOssPolicyResponseBodyOssPolicy()
            self.oss_policy = temp_model.from_map(m['OssPolicy'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetOssPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetOssPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetOssPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPhysicalSpaceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        physical_space_id: str = None,
    ):
        # 实例ID
        self.instance_id = instance_id
        # 实例 ID。
        self.physical_space_id = physical_space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        return self


class GetPhysicalSpaceResponseBodyPhysicalSpace(TeaModel):
    def __init__(
        self,
        address: str = None,
        city: str = None,
        country: str = None,
        owner: str = None,
        physical_space_id: str = None,
        physical_space_name: str = None,
        province: str = None,
        remark: str = None,
        space_abbreviation: str = None,
        space_type: str = None,
    ):
        # 具体地址
        self.address = address
        # 所属城市
        self.city = city
        # 所属国家
        self.country = country
        # 负责人
        self.owner = owner
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 物理空间名称
        self.physical_space_name = physical_space_name
        # 所属省份
        self.province = province
        # 备注
        self.remark = remark
        # 缩写
        self.space_abbreviation = space_abbreviation
        # 模型
        self.space_type = space_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.city is not None:
            result['City'] = self.city
        if self.country is not None:
            result['Country'] = self.country
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.physical_space_name is not None:
            result['PhysicalSpaceName'] = self.physical_space_name
        if self.province is not None:
            result['Province'] = self.province
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.space_abbreviation is not None:
            result['SpaceAbbreviation'] = self.space_abbreviation
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('PhysicalSpaceName') is not None:
            self.physical_space_name = m.get('PhysicalSpaceName')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('SpaceAbbreviation') is not None:
            self.space_abbreviation = m.get('SpaceAbbreviation')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        return self


class GetPhysicalSpaceResponseBody(TeaModel):
    def __init__(
        self,
        physical_space: GetPhysicalSpaceResponseBodyPhysicalSpace = None,
        request_id: str = None,
    ):
        # 物理空间详情
        self.physical_space = physical_space
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.physical_space:
            self.physical_space.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.physical_space is not None:
            result['PhysicalSpace'] = self.physical_space.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PhysicalSpace') is not None:
            temp_model = GetPhysicalSpaceResponseBodyPhysicalSpace()
            self.physical_space = temp_model.from_map(m['PhysicalSpace'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetPhysicalSpaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetPhysicalSpaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetPhysicalSpaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPhysicalSpaceTopoRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        physical_space_id: str = None,
        topo_type: str = None,
    ):
        # 实例ID
        self.instance_id = instance_id
        # 物理空间id
        self.physical_space_id = physical_space_id
        # 拓扑类型
        self.topo_type = topo_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.topo_type is not None:
            result['TopoType'] = self.topo_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('TopoType') is not None:
            self.topo_type = m.get('TopoType')
        return self


class GetPhysicalSpaceTopoResponseBodyTopoDataDevices(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        device_role: str = None,
        host_name: str = None,
        ip: str = None,
    ):
        # 设备id
        self.device_id = device_id
        # 设备角色
        self.device_role = device_role
        # 设备主机名
        self.host_name = host_name
        # 设备ip
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_role is not None:
            result['DeviceRole'] = self.device_role
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['Ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceRole') is not None:
            self.device_role = m.get('DeviceRole')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        return self


class GetPhysicalSpaceTopoResponseBodyTopoDataLinks(TeaModel):
    def __init__(
        self,
        source_device_id: str = None,
        source_device_name: str = None,
        source_port: str = None,
        target_device_id: str = None,
        target_device_name: str = None,
        target_port: str = None,
    ):
        # 源设备id
        self.source_device_id = source_device_id
        # 源设备名
        self.source_device_name = source_device_name
        # 源设备端口
        self.source_port = source_port
        # 目标设备id
        self.target_device_id = target_device_id
        # 目标设备名
        self.target_device_name = target_device_name
        # 目标设备端口
        self.target_port = target_port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_device_id is not None:
            result['SourceDeviceId'] = self.source_device_id
        if self.source_device_name is not None:
            result['SourceDeviceName'] = self.source_device_name
        if self.source_port is not None:
            result['SourcePort'] = self.source_port
        if self.target_device_id is not None:
            result['TargetDeviceId'] = self.target_device_id
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        if self.target_port is not None:
            result['TargetPort'] = self.target_port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceDeviceId') is not None:
            self.source_device_id = m.get('SourceDeviceId')
        if m.get('SourceDeviceName') is not None:
            self.source_device_name = m.get('SourceDeviceName')
        if m.get('SourcePort') is not None:
            self.source_port = m.get('SourcePort')
        if m.get('TargetDeviceId') is not None:
            self.target_device_id = m.get('TargetDeviceId')
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        if m.get('TargetPort') is not None:
            self.target_port = m.get('TargetPort')
        return self


class GetPhysicalSpaceTopoResponseBodyTopoData(TeaModel):
    def __init__(
        self,
        devices: List[GetPhysicalSpaceTopoResponseBodyTopoDataDevices] = None,
        links: List[GetPhysicalSpaceTopoResponseBodyTopoDataLinks] = None,
        update_time: str = None,
    ):
        self.devices = devices
        self.links = links
        # 更新时间
        self.update_time = update_time

    def validate(self):
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()
        if self.links:
            for k in self.links:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        result['Links'] = []
        if self.links is not None:
            for k in self.links:
                result['Links'].append(k.to_map() if k else None)
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = GetPhysicalSpaceTopoResponseBodyTopoDataDevices()
                self.devices.append(temp_model.from_map(k))
        self.links = []
        if m.get('Links') is not None:
            for k in m.get('Links'):
                temp_model = GetPhysicalSpaceTopoResponseBodyTopoDataLinks()
                self.links.append(temp_model.from_map(k))
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetPhysicalSpaceTopoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        topo_data: GetPhysicalSpaceTopoResponseBodyTopoData = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 拓扑数据
        self.topo_data = topo_data

    def validate(self):
        if self.topo_data:
            self.topo_data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.topo_data is not None:
            result['TopoData'] = self.topo_data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TopoData') is not None:
            temp_model = GetPhysicalSpaceTopoResponseBodyTopoData()
            self.topo_data = temp_model.from_map(m['TopoData'])
        return self


class GetPhysicalSpaceTopoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetPhysicalSpaceTopoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetPhysicalSpaceTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRealtimeTaskRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        task_id: str = None,
    ):
        # 实例ID
        self.instance_id = instance_id
        # 实时任务ID
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetRealtimeTaskResponseBodyInspectionTask(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        inspection_message: str = None,
        inspection_result: str = None,
        task_status: str = None,
    ):
        # 巡检错误码
        self.error_code = error_code
        # 巡检错误信息
        self.inspection_message = inspection_message
        # 巡检输出
        self.inspection_result = inspection_result
        # 巡检状态
        self.task_status = task_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.inspection_message is not None:
            result['InspectionMessage'] = self.inspection_message
        if self.inspection_result is not None:
            result['InspectionResult'] = self.inspection_result
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('InspectionMessage') is not None:
            self.inspection_message = m.get('InspectionMessage')
        if m.get('InspectionResult') is not None:
            self.inspection_result = m.get('InspectionResult')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class GetRealtimeTaskResponseBody(TeaModel):
    def __init__(
        self,
        inspection_task: GetRealtimeTaskResponseBodyInspectionTask = None,
        request_id: str = None,
    ):
        # 请求任务结果
        self.inspection_task = inspection_task
        # 请求ID
        self.request_id = request_id

    def validate(self):
        if self.inspection_task:
            self.inspection_task.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inspection_task is not None:
            result['InspectionTask'] = self.inspection_task.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InspectionTask') is not None:
            temp_model = GetRealtimeTaskResponseBodyInspectionTask()
            self.inspection_task = temp_model.from_map(m['InspectionTask'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetRealtimeTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetRealtimeTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRealtimeTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetScheduleWorkerRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        schedule_worker_id: str = None,
    ):
        self.instance_id = instance_id
        # 实例 ID。
        self.schedule_worker_id = schedule_worker_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.schedule_worker_id is not None:
            result['ScheduleWorkerId'] = self.schedule_worker_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScheduleWorkerId') is not None:
            self.schedule_worker_id = m.get('ScheduleWorkerId')
        return self


class GetScheduleWorkerResponseBodyScheduleWorker(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        schedule_worker_id: str = None,
        update_time: str = None,
        worker_contact: str = None,
        worker_id: str = None,
        worker_name: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 资源一级ID
        self.schedule_worker_id = schedule_worker_id
        # 更新时间
        self.update_time = update_time
        # 联系方式
        self.worker_contact = worker_contact
        # 值班人员工号
        self.worker_id = worker_id
        # 值班人员姓名
        self.worker_name = worker_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.schedule_worker_id is not None:
            result['ScheduleWorkerId'] = self.schedule_worker_id
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.worker_contact is not None:
            result['WorkerContact'] = self.worker_contact
        if self.worker_id is not None:
            result['WorkerId'] = self.worker_id
        if self.worker_name is not None:
            result['WorkerName'] = self.worker_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ScheduleWorkerId') is not None:
            self.schedule_worker_id = m.get('ScheduleWorkerId')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('WorkerContact') is not None:
            self.worker_contact = m.get('WorkerContact')
        if m.get('WorkerId') is not None:
            self.worker_id = m.get('WorkerId')
        if m.get('WorkerName') is not None:
            self.worker_name = m.get('WorkerName')
        return self


class GetScheduleWorkerResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        schedule_worker: GetScheduleWorkerResponseBodyScheduleWorker = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 值班人员对象
        self.schedule_worker = schedule_worker

    def validate(self):
        if self.schedule_worker:
            self.schedule_worker.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.schedule_worker is not None:
            result['ScheduleWorker'] = self.schedule_worker.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduleWorker') is not None:
            temp_model = GetScheduleWorkerResponseBodyScheduleWorker()
            self.schedule_worker = temp_model.from_map(m['ScheduleWorker'])
        return self


class GetScheduleWorkerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetScheduleWorkerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetScheduleWorkerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSetupProjectRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        setup_project_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class GetSetupProjectResponseBodySetupProjectPackages(TeaModel):
    def __init__(
        self,
        device_number: str = None,
        model: str = None,
        role: str = None,
        vendor: str = None,
    ):
        # 设备号
        self.device_number = device_number
        # 型号
        self.model = model
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_number is not None:
            result['DeviceNumber'] = self.device_number
        if self.model is not None:
            result['Model'] = self.model
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceNumber') is not None:
            self.device_number = m.get('DeviceNumber')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class GetSetupProjectResponseBodySetupProject(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        delivery_time: str = None,
        nodes: str = None,
        packages: List[GetSetupProjectResponseBodySetupProjectPackages] = None,
        progress: str = None,
        setup_project_id: str = None,
        space_id: str = None,
        space_name: str = None,
        space_type: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 预计交付时间
        self.delivery_time = delivery_time
        # 节点
        self.nodes = nodes
        # 套餐
        self.packages = packages
        # 项目进展
        self.progress = progress
        # 资源一级ID
        self.setup_project_id = setup_project_id
        # 物理空间uId
        self.space_id = space_id
        # 物理空间名称
        self.space_name = space_name
        # 物理空间类型
        self.space_type = space_type

    def validate(self):
        if self.packages:
            for k in self.packages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.delivery_time is not None:
            result['DeliveryTime'] = self.delivery_time
        if self.nodes is not None:
            result['Nodes'] = self.nodes
        result['Packages'] = []
        if self.packages is not None:
            for k in self.packages:
                result['Packages'].append(k.to_map() if k else None)
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.space_name is not None:
            result['SpaceName'] = self.space_name
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeliveryTime') is not None:
            self.delivery_time = m.get('DeliveryTime')
        if m.get('Nodes') is not None:
            self.nodes = m.get('Nodes')
        self.packages = []
        if m.get('Packages') is not None:
            for k in m.get('Packages'):
                temp_model = GetSetupProjectResponseBodySetupProjectPackages()
                self.packages.append(temp_model.from_map(k))
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('SpaceName') is not None:
            self.space_name = m.get('SpaceName')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        return self


class GetSetupProjectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        setup_project: GetSetupProjectResponseBodySetupProject = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 建设项目
        self.setup_project = setup_project

    def validate(self):
        if self.setup_project:
            self.setup_project.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.setup_project is not None:
            result['SetupProject'] = self.setup_project.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SetupProject') is not None:
            temp_model = GetSetupProjectResponseBodySetupProject()
            self.setup_project = temp_model.from_map(m['SetupProject'])
        return self


class GetSetupProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSetupProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSetupProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSpaceModelRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        space_model_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 实例 ID。
        self.space_model_id = space_model_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        return self


class GetSpaceModelResponseBodySpaceModelSort(TeaModel):
    def __init__(
        self,
        level: int = None,
        level_name: str = None,
    ):
        # 层级
        self.level = level
        # 层级名称
        self.level_name = level_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.level_name is not None:
            result['LevelName'] = self.level_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LevelName') is not None:
            self.level_name = m.get('LevelName')
        return self


class GetSpaceModelResponseBodySpaceModel(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        sort: List[GetSpaceModelResponseBodySpaceModelSort] = None,
        space_model_id: str = None,
        space_type: str = None,
        status: str = None,
        update_time: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 模型实例
        self.sort = sort
        # 物理空间模型id
        self.space_model_id = space_model_id
        # 物理空间类型
        self.space_type = space_type
        # 模型状态
        self.status = status
        # 更新时间
        self.update_time = update_time

    def validate(self):
        if self.sort:
            for k in self.sort:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['Sort'] = []
        if self.sort is not None:
            for k in self.sort:
                result['Sort'].append(k.to_map() if k else None)
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.sort = []
        if m.get('Sort') is not None:
            for k in m.get('Sort'):
                temp_model = GetSpaceModelResponseBodySpaceModelSort()
                self.sort.append(temp_model.from_map(k))
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class GetSpaceModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        space_model: GetSpaceModelResponseBodySpaceModel = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 物理空间模型
        self.space_model = space_model

    def validate(self):
        if self.space_model:
            self.space_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.space_model is not None:
            result['SpaceModel'] = self.space_model.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SpaceModel') is not None:
            temp_model = GetSpaceModelResponseBodySpaceModel()
            self.space_model = temp_model.from_map(m['SpaceModel'])
        return self


class GetSpaceModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSpaceModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSpaceModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSpaceModelInstanceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        operate_type: str = None,
        space_id: str = None,
        space_type: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 操作类型
        self.operate_type = operate_type
        # 资源id
        self.space_id = space_id
        # 物理空间类型
        self.space_type = space_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        return self


class GetSpaceModelInstanceResponseBodySpaceModel(TeaModel):
    def __init__(
        self,
        instance: str = None,
    ):
        # 物理空间实例
        self.instance = instance

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance is not None:
            result['Instance'] = self.instance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        return self


class GetSpaceModelInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        space_model: GetSpaceModelInstanceResponseBodySpaceModel = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 建设项目
        self.space_model = space_model

    def validate(self):
        if self.space_model:
            self.space_model.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.space_model is not None:
            result['SpaceModel'] = self.space_model.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SpaceModel') is not None:
            temp_model = GetSpaceModelInstanceResponseBodySpaceModel()
            self.space_model = temp_model.from_map(m['SpaceModel'])
        return self


class GetSpaceModelInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSpaceModelInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSpaceModelInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSpaceModelSortRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        operate_type: str = None,
        space_type: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 操作类型
        self.operate_type = operate_type
        # 物理空间类型
        self.space_type = space_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        return self


class GetSpaceModelSortResponseBodySpaceModel(TeaModel):
    def __init__(
        self,
        level: int = None,
        level_name: str = None,
    ):
        # 层级
        self.level = level
        # 层级名称
        self.level_name = level_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.level_name is not None:
            result['LevelName'] = self.level_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LevelName') is not None:
            self.level_name = m.get('LevelName')
        return self


class GetSpaceModelSortResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        space_model: List[GetSpaceModelSortResponseBodySpaceModel] = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 建设项目
        self.space_model = space_model

    def validate(self):
        if self.space_model:
            for k in self.space_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SpaceModel'] = []
        if self.space_model is not None:
            for k in self.space_model:
                result['SpaceModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.space_model = []
        if m.get('SpaceModel') is not None:
            for k in m.get('SpaceModel'):
                temp_model = GetSpaceModelSortResponseBodySpaceModel()
                self.space_model.append(temp_model.from_map(k))
        return self


class GetSpaceModelSortResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSpaceModelSortResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSpaceModelSortResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetWorkOrderRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        work_order_id: str = None,
    ):
        self.instance_id = instance_id
        # 工单Id
        self.work_order_id = work_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.work_order_id is not None:
            result['WorkOrderId'] = self.work_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('WorkOrderId') is not None:
            self.work_order_id = m.get('WorkOrderId')
        return self


class GetWorkOrderResponseBodyContentWorkOrderOperationDtos(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        operation: str = None,
        operation_id: str = None,
        operator: str = None,
        remark: str = None,
        work_order_id: str = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 操作
        self.operation = operation
        # 操作编号
        self.operation_id = operation_id
        # 操作人
        self.operator = operator
        # 备注
        self.remark = remark
        # 工单编号
        self.work_order_id = work_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.operation is not None:
            result['Operation'] = self.operation
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.work_order_id is not None:
            result['WorkOrderId'] = self.work_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Operation') is not None:
            self.operation = m.get('Operation')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('WorkOrderId') is not None:
            self.work_order_id = m.get('WorkOrderId')
        return self


class GetWorkOrderResponseBodyContent(TeaModel):
    def __init__(
        self,
        alarm_happen_time: str = None,
        alarm_recover_time: str = None,
        alarm_related: str = None,
        area: str = None,
        circuit_id: str = None,
        circuit_name: str = None,
        circuit_type: str = None,
        device_alarm_info: str = None,
        device_ip: str = None,
        device_ip_a: str = None,
        device_ip_b: str = None,
        device_model_a: str = None,
        device_model_b: str = None,
        device_name: str = None,
        device_name_a: str = None,
        device_name_b: str = None,
        device_port_a: str = None,
        device_port_b: str = None,
        device_sn_a: str = None,
        device_sn_b: str = None,
        device_type: str = None,
        device_vendor: str = None,
        device_vendor_a: str = None,
        device_vendor_b: str = None,
        emergency_degree: str = None,
        extra: str = None,
        fault_duration: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        hang_file_name: str = None,
        hang_file_path: str = None,
        hang_reason: str = None,
        impact_business: str = None,
        incident_description: str = None,
        incident_sub_type: str = None,
        incident_type: str = None,
        liable_man: str = None,
        link_man: str = None,
        original_subject_alarm: str = None,
        process_limited: str = None,
        process_man: str = None,
        process_man_id: str = None,
        process_result: str = None,
        skill_groups: str = None,
        timeout: str = None,
        work_order_id: str = None,
        work_order_operation_dtos: List[GetWorkOrderResponseBodyContentWorkOrderOperationDtos] = None,
        work_order_source: str = None,
        work_order_step: str = None,
        work_order_title: str = None,
        work_order_type: str = None,
    ):
        # 告警发生时间
        self.alarm_happen_time = alarm_happen_time
        # 告警恢复时间
        self.alarm_recover_time = alarm_recover_time
        # 关联告警项
        self.alarm_related = alarm_related
        # 区域
        self.area = area
        # 电路编码
        self.circuit_id = circuit_id
        # 电路名
        self.circuit_name = circuit_name
        # 电路类型
        self.circuit_type = circuit_type
        # 设备告警信息
        self.device_alarm_info = device_alarm_info
        # 设备IP
        self.device_ip = device_ip
        # A-IP
        self.device_ip_a = device_ip_a
        # B-IP
        self.device_ip_b = device_ip_b
        # A-设备型号
        self.device_model_a = device_model_a
        # B-设备型号
        self.device_model_b = device_model_b
        # 设备名
        self.device_name = device_name
        # A-设备名
        self.device_name_a = device_name_a
        # B-设备名
        self.device_name_b = device_name_b
        # A-端口
        self.device_port_a = device_port_a
        # B-端口
        self.device_port_b = device_port_b
        # A-设备SN
        self.device_sn_a = device_sn_a
        # B-设备SN
        self.device_sn_b = device_sn_b
        # 设备类型
        self.device_type = device_type
        # 设备厂家
        self.device_vendor = device_vendor
        # A-厂家
        self.device_vendor_a = device_vendor_a
        # B-厂家
        self.device_vendor_b = device_vendor_b
        # 紧急程度
        self.emergency_degree = emergency_degree
        # 额外字段
        self.extra = extra
        # 故障时常(时)
        self.fault_duration = fault_duration
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 文件名
        self.hang_file_name = hang_file_name
        # 文件id
        self.hang_file_path = hang_file_path
        # 挂起/转交原因
        self.hang_reason = hang_reason
        # 是否影响业务
        self.impact_business = impact_business
        # 问题描述
        self.incident_description = incident_description
        # 故障小类
        self.incident_sub_type = incident_sub_type
        # 故障分类
        self.incident_type = incident_type
        # 责任人
        self.liable_man = liable_man
        # 用户/联系人
        self.link_man = link_man
        # 告警源主体
        self.original_subject_alarm = original_subject_alarm
        # 处理时限
        self.process_limited = process_limited
        # 处理人
        self.process_man = process_man
        # 处理人编号
        self.process_man_id = process_man_id
        # 处理结果
        self.process_result = process_result
        # 技能组
        self.skill_groups = skill_groups
        # 是否超时
        self.timeout = timeout
        # 工单编号
        self.work_order_id = work_order_id
        # 操作流水
        self.work_order_operation_dtos = work_order_operation_dtos
        # 工单来源
        self.work_order_source = work_order_source
        # 工单状态
        self.work_order_step = work_order_step
        # 工单标题
        self.work_order_title = work_order_title
        # 工单类型
        self.work_order_type = work_order_type

    def validate(self):
        if self.work_order_operation_dtos:
            for k in self.work_order_operation_dtos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_happen_time is not None:
            result['AlarmHappenTime'] = self.alarm_happen_time
        if self.alarm_recover_time is not None:
            result['AlarmRecoverTime'] = self.alarm_recover_time
        if self.alarm_related is not None:
            result['AlarmRelated'] = self.alarm_related
        if self.area is not None:
            result['Area'] = self.area
        if self.circuit_id is not None:
            result['CircuitId'] = self.circuit_id
        if self.circuit_name is not None:
            result['CircuitName'] = self.circuit_name
        if self.circuit_type is not None:
            result['CircuitType'] = self.circuit_type
        if self.device_alarm_info is not None:
            result['DeviceAlarmInfo'] = self.device_alarm_info
        if self.device_ip is not None:
            result['DeviceIp'] = self.device_ip
        if self.device_ip_a is not None:
            result['DeviceIpA'] = self.device_ip_a
        if self.device_ip_b is not None:
            result['DeviceIpB'] = self.device_ip_b
        if self.device_model_a is not None:
            result['DeviceModelA'] = self.device_model_a
        if self.device_model_b is not None:
            result['DeviceModelB'] = self.device_model_b
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_name_a is not None:
            result['DeviceNameA'] = self.device_name_a
        if self.device_name_b is not None:
            result['DeviceNameB'] = self.device_name_b
        if self.device_port_a is not None:
            result['DevicePortA'] = self.device_port_a
        if self.device_port_b is not None:
            result['DevicePortB'] = self.device_port_b
        if self.device_sn_a is not None:
            result['DeviceSnA'] = self.device_sn_a
        if self.device_sn_b is not None:
            result['DeviceSnB'] = self.device_sn_b
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.device_vendor is not None:
            result['DeviceVendor'] = self.device_vendor
        if self.device_vendor_a is not None:
            result['DeviceVendorA'] = self.device_vendor_a
        if self.device_vendor_b is not None:
            result['DeviceVendorB'] = self.device_vendor_b
        if self.emergency_degree is not None:
            result['EmergencyDegree'] = self.emergency_degree
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.fault_duration is not None:
            result['FaultDuration'] = self.fault_duration
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.hang_file_name is not None:
            result['HangFileName'] = self.hang_file_name
        if self.hang_file_path is not None:
            result['HangFilePath'] = self.hang_file_path
        if self.hang_reason is not None:
            result['HangReason'] = self.hang_reason
        if self.impact_business is not None:
            result['ImpactBusiness'] = self.impact_business
        if self.incident_description is not None:
            result['IncidentDescription'] = self.incident_description
        if self.incident_sub_type is not None:
            result['IncidentSubType'] = self.incident_sub_type
        if self.incident_type is not None:
            result['IncidentType'] = self.incident_type
        if self.liable_man is not None:
            result['LiableMan'] = self.liable_man
        if self.link_man is not None:
            result['LinkMan'] = self.link_man
        if self.original_subject_alarm is not None:
            result['OriginalSubjectAlarm'] = self.original_subject_alarm
        if self.process_limited is not None:
            result['ProcessLimited'] = self.process_limited
        if self.process_man is not None:
            result['ProcessMan'] = self.process_man
        if self.process_man_id is not None:
            result['ProcessManId'] = self.process_man_id
        if self.process_result is not None:
            result['ProcessResult'] = self.process_result
        if self.skill_groups is not None:
            result['SkillGroups'] = self.skill_groups
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.work_order_id is not None:
            result['WorkOrderId'] = self.work_order_id
        result['WorkOrderOperationDtos'] = []
        if self.work_order_operation_dtos is not None:
            for k in self.work_order_operation_dtos:
                result['WorkOrderOperationDtos'].append(k.to_map() if k else None)
        if self.work_order_source is not None:
            result['WorkOrderSource'] = self.work_order_source
        if self.work_order_step is not None:
            result['WorkOrderStep'] = self.work_order_step
        if self.work_order_title is not None:
            result['WorkOrderTitle'] = self.work_order_title
        if self.work_order_type is not None:
            result['WorkOrderType'] = self.work_order_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmHappenTime') is not None:
            self.alarm_happen_time = m.get('AlarmHappenTime')
        if m.get('AlarmRecoverTime') is not None:
            self.alarm_recover_time = m.get('AlarmRecoverTime')
        if m.get('AlarmRelated') is not None:
            self.alarm_related = m.get('AlarmRelated')
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('CircuitId') is not None:
            self.circuit_id = m.get('CircuitId')
        if m.get('CircuitName') is not None:
            self.circuit_name = m.get('CircuitName')
        if m.get('CircuitType') is not None:
            self.circuit_type = m.get('CircuitType')
        if m.get('DeviceAlarmInfo') is not None:
            self.device_alarm_info = m.get('DeviceAlarmInfo')
        if m.get('DeviceIp') is not None:
            self.device_ip = m.get('DeviceIp')
        if m.get('DeviceIpA') is not None:
            self.device_ip_a = m.get('DeviceIpA')
        if m.get('DeviceIpB') is not None:
            self.device_ip_b = m.get('DeviceIpB')
        if m.get('DeviceModelA') is not None:
            self.device_model_a = m.get('DeviceModelA')
        if m.get('DeviceModelB') is not None:
            self.device_model_b = m.get('DeviceModelB')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceNameA') is not None:
            self.device_name_a = m.get('DeviceNameA')
        if m.get('DeviceNameB') is not None:
            self.device_name_b = m.get('DeviceNameB')
        if m.get('DevicePortA') is not None:
            self.device_port_a = m.get('DevicePortA')
        if m.get('DevicePortB') is not None:
            self.device_port_b = m.get('DevicePortB')
        if m.get('DeviceSnA') is not None:
            self.device_sn_a = m.get('DeviceSnA')
        if m.get('DeviceSnB') is not None:
            self.device_sn_b = m.get('DeviceSnB')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('DeviceVendor') is not None:
            self.device_vendor = m.get('DeviceVendor')
        if m.get('DeviceVendorA') is not None:
            self.device_vendor_a = m.get('DeviceVendorA')
        if m.get('DeviceVendorB') is not None:
            self.device_vendor_b = m.get('DeviceVendorB')
        if m.get('EmergencyDegree') is not None:
            self.emergency_degree = m.get('EmergencyDegree')
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('FaultDuration') is not None:
            self.fault_duration = m.get('FaultDuration')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('HangFileName') is not None:
            self.hang_file_name = m.get('HangFileName')
        if m.get('HangFilePath') is not None:
            self.hang_file_path = m.get('HangFilePath')
        if m.get('HangReason') is not None:
            self.hang_reason = m.get('HangReason')
        if m.get('ImpactBusiness') is not None:
            self.impact_business = m.get('ImpactBusiness')
        if m.get('IncidentDescription') is not None:
            self.incident_description = m.get('IncidentDescription')
        if m.get('IncidentSubType') is not None:
            self.incident_sub_type = m.get('IncidentSubType')
        if m.get('IncidentType') is not None:
            self.incident_type = m.get('IncidentType')
        if m.get('LiableMan') is not None:
            self.liable_man = m.get('LiableMan')
        if m.get('LinkMan') is not None:
            self.link_man = m.get('LinkMan')
        if m.get('OriginalSubjectAlarm') is not None:
            self.original_subject_alarm = m.get('OriginalSubjectAlarm')
        if m.get('ProcessLimited') is not None:
            self.process_limited = m.get('ProcessLimited')
        if m.get('ProcessMan') is not None:
            self.process_man = m.get('ProcessMan')
        if m.get('ProcessManId') is not None:
            self.process_man_id = m.get('ProcessManId')
        if m.get('ProcessResult') is not None:
            self.process_result = m.get('ProcessResult')
        if m.get('SkillGroups') is not None:
            self.skill_groups = m.get('SkillGroups')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('WorkOrderId') is not None:
            self.work_order_id = m.get('WorkOrderId')
        self.work_order_operation_dtos = []
        if m.get('WorkOrderOperationDtos') is not None:
            for k in m.get('WorkOrderOperationDtos'):
                temp_model = GetWorkOrderResponseBodyContentWorkOrderOperationDtos()
                self.work_order_operation_dtos.append(temp_model.from_map(k))
        if m.get('WorkOrderSource') is not None:
            self.work_order_source = m.get('WorkOrderSource')
        if m.get('WorkOrderStep') is not None:
            self.work_order_step = m.get('WorkOrderStep')
        if m.get('WorkOrderTitle') is not None:
            self.work_order_title = m.get('WorkOrderTitle')
        if m.get('WorkOrderType') is not None:
            self.work_order_type = m.get('WorkOrderType')
        return self


class GetWorkOrderResponseBody(TeaModel):
    def __init__(
        self,
        content: GetWorkOrderResponseBodyContent = None,
        request_id: str = None,
    ):
        self.content = content
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            temp_model = GetWorkOrderResponseBodyContent()
            self.content = temp_model.from_map(m['Content'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetWorkOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetWorkOrderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetWorkOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAlarmStatusRequest(TeaModel):
    def __init__(
        self,
        aggregate_data_name: str = None,
        city: str = None,
        country: str = None,
        dedicated_line_name: str = None,
        device_form: str = None,
        device_id: str = None,
        domain: str = None,
        host_name: str = None,
        instance_id: str = None,
        manufacturer: str = None,
        max_results: int = None,
        model: str = None,
        monitor_item_id: str = None,
        next_token: str = None,
        physical_space_id: str = None,
        port_collection_id: str = None,
        port_collection_name: str = None,
        province: str = None,
        region: str = None,
        role: str = None,
        security_domain: str = None,
        service_status: str = None,
        space: str = None,
        space_type: str = None,
        status: str = None,
        type: str = None,
        unique_key: str = None,
    ):
        self.aggregate_data_name = aggregate_data_name
        # 所属城市
        self.city = city
        # 所属国家
        self.country = country
        # 专线名称
        self.dedicated_line_name = dedicated_line_name
        # 设备形态
        self.device_form = device_form
        # 设备ID
        self.device_id = device_id
        self.domain = domain
        self.host_name = host_name
        # 实例ID
        self.instance_id = instance_id
        # 设备厂商
        self.manufacturer = manufacturer
        # 本次读取的最大数据记录数量
        self.max_results = max_results
        # 设备型号
        self.model = model
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 标记当前开始读取的位置，置空表示从头开始
        self.next_token = next_token
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 端口集ID
        self.port_collection_id = port_collection_id
        self.port_collection_name = port_collection_name
        # 所属省份
        self.province = province
        # 设备所属地域
        self.region = region
        # 设备角色
        self.role = role
        # 探针标识
        self.security_domain = security_domain
        # 设备状态
        self.service_status = service_status
        # 物理空间
        self.space = space
        # 物理空间模型
        self.space_type = space_type
        # 告警状态
        self.status = status
        # 数据类型
        self.type = type
        self.unique_key = unique_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate_data_name is not None:
            result['AggregateDataName'] = self.aggregate_data_name
        if self.city is not None:
            result['City'] = self.city
        if self.country is not None:
            result['Country'] = self.country
        if self.dedicated_line_name is not None:
            result['DedicatedLineName'] = self.dedicated_line_name
        if self.device_form is not None:
            result['DeviceForm'] = self.device_form
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.manufacturer is not None:
            result['Manufacturer'] = self.manufacturer
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.model is not None:
            result['Model'] = self.model
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.port_collection_name is not None:
            result['PortCollectionName'] = self.port_collection_name
        if self.province is not None:
            result['Province'] = self.province
        if self.region is not None:
            result['Region'] = self.region
        if self.role is not None:
            result['Role'] = self.role
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.space is not None:
            result['Space'] = self.space
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.unique_key is not None:
            result['UniqueKey'] = self.unique_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregateDataName') is not None:
            self.aggregate_data_name = m.get('AggregateDataName')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('DedicatedLineName') is not None:
            self.dedicated_line_name = m.get('DedicatedLineName')
        if m.get('DeviceForm') is not None:
            self.device_form = m.get('DeviceForm')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Manufacturer') is not None:
            self.manufacturer = m.get('Manufacturer')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('PortCollectionName') is not None:
            self.port_collection_name = m.get('PortCollectionName')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UniqueKey') is not None:
            self.unique_key = m.get('UniqueKey')
        return self


class ListAlarmStatusResponseBodyAlarmStatusAggregateData(TeaModel):
    def __init__(
        self,
        aggregate_data_name: str = None,
        data_item: str = None,
    ):
        # 聚合数据名称
        self.aggregate_data_name = aggregate_data_name
        # 数据项
        self.data_item = data_item

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate_data_name is not None:
            result['AggregateDataName'] = self.aggregate_data_name
        if self.data_item is not None:
            result['DataItem'] = self.data_item
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregateDataName') is not None:
            self.aggregate_data_name = m.get('AggregateDataName')
        if m.get('DataItem') is not None:
            self.data_item = m.get('DataItem')
        return self


class ListAlarmStatusResponseBodyAlarmStatusDedicatedLine(TeaModel):
    def __init__(
        self,
        dedicated_line_name: str = None,
        physical_space: str = None,
    ):
        # 专线名称
        self.dedicated_line_name = dedicated_line_name
        self.physical_space = physical_space

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_line_name is not None:
            result['DedicatedLineName'] = self.dedicated_line_name
        if self.physical_space is not None:
            result['PhysicalSpace'] = self.physical_space
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DedicatedLineName') is not None:
            self.dedicated_line_name = m.get('DedicatedLineName')
        if m.get('PhysicalSpace') is not None:
            self.physical_space = m.get('PhysicalSpace')
        return self


class ListAlarmStatusResponseBodyAlarmStatusMonitorItem(TeaModel):
    def __init__(
        self,
        collection_type: str = None,
        monitor_item_description: str = None,
        monitor_item_name: str = None,
    ):
        # 采集类型
        self.collection_type = collection_type
        # 监控项描述
        self.monitor_item_description = monitor_item_description
        # 监控项名称
        self.monitor_item_name = monitor_item_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collection_type is not None:
            result['CollectionType'] = self.collection_type
        if self.monitor_item_description is not None:
            result['MonitorItemDescription'] = self.monitor_item_description
        if self.monitor_item_name is not None:
            result['MonitorItemName'] = self.monitor_item_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CollectionType') is not None:
            self.collection_type = m.get('CollectionType')
        if m.get('MonitorItemDescription') is not None:
            self.monitor_item_description = m.get('MonitorItemDescription')
        if m.get('MonitorItemName') is not None:
            self.monitor_item_name = m.get('MonitorItemName')
        return self


class ListAlarmStatusResponseBodyAlarmStatusNotificationSwitch(TeaModel):
    def __init__(
        self,
        expiry_time: str = None,
        reason: str = None,
    ):
        # 关闭到期时间
        self.expiry_time = expiry_time
        # 关闭原因
        self.reason = reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expiry_time is not None:
            result['ExpiryTime'] = self.expiry_time
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpiryTime') is not None:
            self.expiry_time = m.get('ExpiryTime')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        return self


class ListAlarmStatusResponseBodyAlarmStatusPortCollection(TeaModel):
    def __init__(
        self,
        port_collection_name: str = None,
    ):
        # 端口集名称
        self.port_collection_name = port_collection_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port_collection_name is not None:
            result['PortCollectionName'] = self.port_collection_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PortCollectionName') is not None:
            self.port_collection_name = m.get('PortCollectionName')
        return self


class ListAlarmStatusResponseBodyAlarmStatusResourceApp(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        domain: str = None,
        port: str = None,
        security_domain: str = None,
        type: str = None,
    ):
        # 应用ID
        self.app_id = app_id
        # 监控域名
        self.domain = domain
        # 端口
        self.port = port
        # 所属探针
        self.security_domain = security_domain
        # 资源类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.port is not None:
            result['Port'] = self.port
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListAlarmStatusResponseBodyAlarmStatusResourceDevice(TeaModel):
    def __init__(
        self,
        device_form: str = None,
        host_name: str = None,
        physical_space: str = None,
    ):
        self.device_form = device_form
        # 设备名
        self.host_name = host_name
        self.physical_space = physical_space

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form is not None:
            result['DeviceForm'] = self.device_form
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.physical_space is not None:
            result['PhysicalSpace'] = self.physical_space
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceForm') is not None:
            self.device_form = m.get('DeviceForm')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('PhysicalSpace') is not None:
            self.physical_space = m.get('PhysicalSpace')
        return self


class ListAlarmStatusResponseBodyAlarmStatus(TeaModel):
    def __init__(
        self,
        abnormal_data_item: str = None,
        agent_ip: str = None,
        aggregate_data: ListAlarmStatusResponseBodyAlarmStatusAggregateData = None,
        aggregate_data_id: str = None,
        alarm_rule: str = None,
        alarm_status: str = None,
        app_id: str = None,
        collection_time: str = None,
        dedicated_line: ListAlarmStatusResponseBodyAlarmStatusDedicatedLine = None,
        dedicated_line_id: str = None,
        device_id: str = None,
        first_abnormal_time: str = None,
        monitor_item: ListAlarmStatusResponseBodyAlarmStatusMonitorItem = None,
        monitor_item_id: str = None,
        notification_switch: ListAlarmStatusResponseBodyAlarmStatusNotificationSwitch = None,
        port_collection: ListAlarmStatusResponseBodyAlarmStatusPortCollection = None,
        port_collection_id: str = None,
        receive_time: str = None,
        resource_app: ListAlarmStatusResponseBodyAlarmStatusResourceApp = None,
        resource_device: ListAlarmStatusResponseBodyAlarmStatusResourceDevice = None,
        response_code: str = None,
        result: str = None,
        unique_key: str = None,
    ):
        # 异常数据项
        self.abnormal_data_item = abnormal_data_item
        # 采集探针IP
        self.agent_ip = agent_ip
        # 聚合数据
        self.aggregate_data = aggregate_data
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 命中告警规则
        self.alarm_rule = alarm_rule
        # 告警状态
        self.alarm_status = alarm_status
        # 应用ID
        self.app_id = app_id
        # 检测时间
        self.collection_time = collection_time
        # 专线
        self.dedicated_line = dedicated_line
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 设备ID
        self.device_id = device_id
        # 首次异常时间
        self.first_abnormal_time = first_abnormal_time
        # 监控项
        self.monitor_item = monitor_item
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 告警开关配置
        self.notification_switch = notification_switch
        # 端口集
        self.port_collection = port_collection
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 接收时间
        self.receive_time = receive_time
        # 应用资源
        self.resource_app = resource_app
        # 设备
        self.resource_device = resource_device
        # 采集状态码
        self.response_code = response_code
        # 采集结果
        self.result = result
        # 索引
        self.unique_key = unique_key

    def validate(self):
        if self.aggregate_data:
            self.aggregate_data.validate()
        if self.dedicated_line:
            self.dedicated_line.validate()
        if self.monitor_item:
            self.monitor_item.validate()
        if self.notification_switch:
            self.notification_switch.validate()
        if self.port_collection:
            self.port_collection.validate()
        if self.resource_app:
            self.resource_app.validate()
        if self.resource_device:
            self.resource_device.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abnormal_data_item is not None:
            result['AbnormalDataItem'] = self.abnormal_data_item
        if self.agent_ip is not None:
            result['AgentIp'] = self.agent_ip
        if self.aggregate_data is not None:
            result['AggregateData'] = self.aggregate_data.to_map()
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.alarm_rule is not None:
            result['AlarmRule'] = self.alarm_rule
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.collection_time is not None:
            result['CollectionTime'] = self.collection_time
        if self.dedicated_line is not None:
            result['DedicatedLine'] = self.dedicated_line.to_map()
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.first_abnormal_time is not None:
            result['FirstAbnormalTime'] = self.first_abnormal_time
        if self.monitor_item is not None:
            result['MonitorItem'] = self.monitor_item.to_map()
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.notification_switch is not None:
            result['NotificationSwitch'] = self.notification_switch.to_map()
        if self.port_collection is not None:
            result['PortCollection'] = self.port_collection.to_map()
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.receive_time is not None:
            result['ReceiveTime'] = self.receive_time
        if self.resource_app is not None:
            result['ResourceApp'] = self.resource_app.to_map()
        if self.resource_device is not None:
            result['ResourceDevice'] = self.resource_device.to_map()
        if self.response_code is not None:
            result['ResponseCode'] = self.response_code
        if self.result is not None:
            result['Result'] = self.result
        if self.unique_key is not None:
            result['UniqueKey'] = self.unique_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AbnormalDataItem') is not None:
            self.abnormal_data_item = m.get('AbnormalDataItem')
        if m.get('AgentIp') is not None:
            self.agent_ip = m.get('AgentIp')
        if m.get('AggregateData') is not None:
            temp_model = ListAlarmStatusResponseBodyAlarmStatusAggregateData()
            self.aggregate_data = temp_model.from_map(m['AggregateData'])
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('AlarmRule') is not None:
            self.alarm_rule = m.get('AlarmRule')
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CollectionTime') is not None:
            self.collection_time = m.get('CollectionTime')
        if m.get('DedicatedLine') is not None:
            temp_model = ListAlarmStatusResponseBodyAlarmStatusDedicatedLine()
            self.dedicated_line = temp_model.from_map(m['DedicatedLine'])
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('FirstAbnormalTime') is not None:
            self.first_abnormal_time = m.get('FirstAbnormalTime')
        if m.get('MonitorItem') is not None:
            temp_model = ListAlarmStatusResponseBodyAlarmStatusMonitorItem()
            self.monitor_item = temp_model.from_map(m['MonitorItem'])
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('NotificationSwitch') is not None:
            temp_model = ListAlarmStatusResponseBodyAlarmStatusNotificationSwitch()
            self.notification_switch = temp_model.from_map(m['NotificationSwitch'])
        if m.get('PortCollection') is not None:
            temp_model = ListAlarmStatusResponseBodyAlarmStatusPortCollection()
            self.port_collection = temp_model.from_map(m['PortCollection'])
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('ReceiveTime') is not None:
            self.receive_time = m.get('ReceiveTime')
        if m.get('ResourceApp') is not None:
            temp_model = ListAlarmStatusResponseBodyAlarmStatusResourceApp()
            self.resource_app = temp_model.from_map(m['ResourceApp'])
        if m.get('ResourceDevice') is not None:
            temp_model = ListAlarmStatusResponseBodyAlarmStatusResourceDevice()
            self.resource_device = temp_model.from_map(m['ResourceDevice'])
        if m.get('ResponseCode') is not None:
            self.response_code = m.get('ResponseCode')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('UniqueKey') is not None:
            self.unique_key = m.get('UniqueKey')
        return self


class ListAlarmStatusResponseBodyStatistics(TeaModel):
    def __init__(
        self,
        count: int = None,
        status: str = None,
    ):
        # 数量
        self.count = count
        # 告警状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListAlarmStatusResponseBody(TeaModel):
    def __init__(
        self,
        alarm_status: List[ListAlarmStatusResponseBodyAlarmStatus] = None,
        max_results: int = None,
        next_token: str = None,
        request_id: str = None,
        statistics: List[ListAlarmStatusResponseBodyStatistics] = None,
        total_count: int = None,
    ):
        # 告警状态列表
        self.alarm_status = alarm_status
        # MaxResults本次请求所返回的最大记录条数
        self.max_results = max_results
        # 表示当前调用返回读取到的位置，空代表数据已经读取完毕
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 告警状态统计
        self.statistics = statistics
        # TotalCount本次请求条件下的数据总量，此参数为可选参数，默认可不返回
        self.total_count = total_count

    def validate(self):
        if self.alarm_status:
            for k in self.alarm_status:
                if k:
                    k.validate()
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlarmStatus'] = []
        if self.alarm_status is not None:
            for k in self.alarm_status:
                result['AlarmStatus'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alarm_status = []
        if m.get('AlarmStatus') is not None:
            for k in m.get('AlarmStatus'):
                temp_model = ListAlarmStatusResponseBodyAlarmStatus()
                self.alarm_status.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = ListAlarmStatusResponseBodyStatistics()
                self.statistics.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAlarmStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAlarmStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAlarmStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAlarmStatusHistoriesRequest(TeaModel):
    def __init__(
        self,
        aggregate_data_id: str = None,
        app_id: str = None,
        dedicated_line_id: str = None,
        device_id: str = None,
        end: int = None,
        instance_id: str = None,
        monitor_item_id: str = None,
        port_collection_id: str = None,
        start: int = None,
        type: str = None,
    ):
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 应用ID
        self.app_id = app_id
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 设备ID
        self.device_id = device_id
        # 结束时间秒级时间戳
        self.end = end
        # 实例ID
        self.instance_id = instance_id
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 开始时间秒级时间戳
        self.start = start
        # 类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.end is not None:
            result['End'] = self.end
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.start is not None:
            result['Start'] = self.start
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListAlarmStatusHistoriesResponseBodyAlarmStatusHistories(TeaModel):
    def __init__(
        self,
        timestamp: int = None,
        value: str = None,
    ):
        # 时间戳
        self.timestamp = timestamp
        # 数值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListAlarmStatusHistoriesResponseBody(TeaModel):
    def __init__(
        self,
        alarm_status_histories: List[ListAlarmStatusHistoriesResponseBodyAlarmStatusHistories] = None,
        request_id: str = None,
    ):
        # 数据列表
        self.alarm_status_histories = alarm_status_histories
        # request id
        self.request_id = request_id

    def validate(self):
        if self.alarm_status_histories:
            for k in self.alarm_status_histories:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlarmStatusHistories'] = []
        if self.alarm_status_histories is not None:
            for k in self.alarm_status_histories:
                result['AlarmStatusHistories'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alarm_status_histories = []
        if m.get('AlarmStatusHistories') is not None:
            for k in m.get('AlarmStatusHistories'):
                temp_model = ListAlarmStatusHistoriesResponseBodyAlarmStatusHistories()
                self.alarm_status_histories.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAlarmStatusHistoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAlarmStatusHistoriesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAlarmStatusHistoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAlarmStatusStatisticsRequest(TeaModel):
    def __init__(
        self,
        alarm_status: str = None,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        physical_space_id: str = None,
        security_domain: str = None,
        type: str = None,
    ):
        # 告警状态
        self.alarm_status = alarm_status
        # 实例ID
        self.instance_id = instance_id
        # 本次读取的最大数据记录数量
        self.max_results = max_results
        # 标记当前开始读取的位置，置空表示从头开始
        self.next_token = next_token
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 探针标识
        self.security_domain = security_domain
        # 数据类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListAlarmStatusStatisticsResponseBodyStatistics(TeaModel):
    def __init__(
        self,
        count: int = None,
        name: str = None,
        resource_id: str = None,
    ):
        # 数量
        self.count = count
        # 名称
        self.name = name
        # 资源ID
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class ListAlarmStatusStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        request_id: str = None,
        statistics: List[ListAlarmStatusStatisticsResponseBodyStatistics] = None,
        total_count: int = None,
    ):
        # MaxResults本次请求所返回的最大记录条数
        self.max_results = max_results
        # 表示当前调用返回读取到的位置，空代表数据已经读取完毕
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 统计数据
        self.statistics = statistics
        # TotalCount本次请求条件下的数据总量，此参数为可选参数，默认可不返回
        self.total_count = total_count

    def validate(self):
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = ListAlarmStatusStatisticsResponseBodyStatistics()
                self.statistics.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAlarmStatusStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAlarmStatusStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAlarmStatusStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListArchitectureAttributeRequest(TeaModel):
    def __init__(
        self,
        architecture_id: str = None,
        instance_id: str = None,
        role: str = None,
        vendor: str = None,
    ):
        # 架构id
        self.architecture_id = architecture_id
        self.instance_id = instance_id
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture_id is not None:
            result['ArchitectureId'] = self.architecture_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArchitectureId') is not None:
            self.architecture_id = m.get('ArchitectureId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListArchitectureAttributeResponseBodyArchitecture(TeaModel):
    def __init__(
        self,
        model: List[str] = None,
        role: List[str] = None,
        vendor: List[str] = None,
    ):
        # 型号
        self.model = model
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.model is not None:
            result['Model'] = self.model
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListArchitectureAttributeResponseBody(TeaModel):
    def __init__(
        self,
        architecture: List[ListArchitectureAttributeResponseBodyArchitecture] = None,
        request_id: str = None,
    ):
        # 架构对象
        self.architecture = architecture
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.architecture:
            for k in self.architecture:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Architecture'] = []
        if self.architecture is not None:
            for k in self.architecture:
                result['Architecture'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.architecture = []
        if m.get('Architecture') is not None:
            for k in m.get('Architecture'):
                temp_model = ListArchitectureAttributeResponseBodyArchitecture()
                self.architecture.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListArchitectureAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListArchitectureAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListArchitectureAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConfigurationSpecificationsRequest(TeaModel):
    def __init__(
        self,
        architecture: str = None,
        instance_id: str = None,
        max_results: int = None,
        model: str = None,
        next_token: str = None,
        role: str = None,
        specification_name: str = None,
        vendor: str = None,
    ):
        # 架构类型
        self.architecture = architecture
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 型号
        self.model = model
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 角色
        self.role = role
        # 配置规范名字
        self.specification_name = specification_name
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.model is not None:
            result['Model'] = self.model
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.role is not None:
            result['Role'] = self.role
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListConfigurationSpecificationsResponseBodyConfigurationSpecification(TeaModel):
    def __init__(
        self,
        architecture: str = None,
        configuration_specification_id: str = None,
        create_time: str = None,
        model: str = None,
        related_variate: List[str] = None,
        role: str = None,
        specification_content: str = None,
        specification_name: str = None,
        update_time: str = None,
        vendor: str = None,
    ):
        # 架构
        self.architecture = architecture
        # 配置规范id
        self.configuration_specification_id = configuration_specification_id
        # 创建时间
        self.create_time = create_time
        # 型号
        self.model = model
        # 相关变量
        self.related_variate = related_variate
        # 角色
        self.role = role
        # 规范内容
        self.specification_content = specification_content
        # 配置规范名字
        self.specification_name = specification_name
        # 更新时间
        self.update_time = update_time
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.model is not None:
            result['Model'] = self.model
        if self.related_variate is not None:
            result['RelatedVariate'] = self.related_variate
        if self.role is not None:
            result['Role'] = self.role
        if self.specification_content is not None:
            result['SpecificationContent'] = self.specification_content
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('RelatedVariate') is not None:
            self.related_variate = m.get('RelatedVariate')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SpecificationContent') is not None:
            self.specification_content = m.get('SpecificationContent')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListConfigurationSpecificationsResponseBody(TeaModel):
    def __init__(
        self,
        configuration_specification: List[ListConfigurationSpecificationsResponseBodyConfigurationSpecification] = None,
        max_results: int = None,
        next_token: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 数组，返回示例目录。
        self.configuration_specification = configuration_specification
        # 本次读取的最大数据量
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.configuration_specification:
            for k in self.configuration_specification:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigurationSpecification'] = []
        if self.configuration_specification is not None:
            for k in self.configuration_specification:
                result['ConfigurationSpecification'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.configuration_specification = []
        if m.get('ConfigurationSpecification') is not None:
            for k in m.get('ConfigurationSpecification'):
                temp_model = ListConfigurationSpecificationsResponseBodyConfigurationSpecification()
                self.configuration_specification.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListConfigurationSpecificationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListConfigurationSpecificationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConfigurationSpecificationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConfigurationVariateRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        variate_name: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 变量名字
        self.variate_name = variate_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.variate_name is not None:
            result['VariateName'] = self.variate_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('VariateName') is not None:
            self.variate_name = m.get('VariateName')
        return self


class ListConfigurationVariateResponseBodyConfigurationVariate(TeaModel):
    def __init__(
        self,
        comment: str = None,
        configuration_variate_id: str = None,
        create_time: str = None,
        format_function: str = None,
        update_time: str = None,
        variate_name: str = None,
    ):
        # 配置变量描述
        self.comment = comment
        # 配置变量id
        self.configuration_variate_id = configuration_variate_id
        # 创建时间
        self.create_time = create_time
        # 配置变量转换函数
        self.format_function = format_function
        # 更新时间
        self.update_time = update_time
        # 配置变量名称
        self.variate_name = variate_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.configuration_variate_id is not None:
            result['ConfigurationVariateId'] = self.configuration_variate_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.format_function is not None:
            result['FormatFunction'] = self.format_function
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.variate_name is not None:
            result['VariateName'] = self.variate_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ConfigurationVariateId') is not None:
            self.configuration_variate_id = m.get('ConfigurationVariateId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FormatFunction') is not None:
            self.format_function = m.get('FormatFunction')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('VariateName') is not None:
            self.variate_name = m.get('VariateName')
        return self


class ListConfigurationVariateResponseBody(TeaModel):
    def __init__(
        self,
        configuration_variate: List[ListConfigurationVariateResponseBodyConfigurationVariate] = None,
        max_results: int = None,
        next_token: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 数组，返回示例目录。
        self.configuration_variate = configuration_variate
        # 本次读取的最大数据量
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.configuration_variate:
            for k in self.configuration_variate:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigurationVariate'] = []
        if self.configuration_variate is not None:
            for k in self.configuration_variate:
                result['ConfigurationVariate'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.configuration_variate = []
        if m.get('ConfigurationVariate') is not None:
            for k in m.get('ConfigurationVariate'):
                temp_model = ListConfigurationVariateResponseBodyConfigurationVariate()
                self.configuration_variate.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListConfigurationVariateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListConfigurationVariateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConfigurationVariateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConnectionPoliciesRequest(TeaModel):
    def __init__(
        self,
        architecture_iteration_id: str = None,
        connection_policy_id: str = None,
        downlink_architecture_device_id: str = None,
        downlink_architecture_module_id: str = None,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        uplink_architecture_device_id: str = None,
        uplink_architecture_module_id: str = None,
    ):
        # 架构迭代uid
        self.architecture_iteration_id = architecture_iteration_id
        # 连接策略id
        self.connection_policy_id = connection_policy_id
        # 下联设备uid
        self.downlink_architecture_device_id = downlink_architecture_device_id
        # 下联模块uid
        self.downlink_architecture_module_id = downlink_architecture_module_id
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 上联设备uid
        self.uplink_architecture_device_id = uplink_architecture_device_id
        # 上联模块uid
        self.uplink_architecture_module_id = uplink_architecture_module_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture_iteration_id is not None:
            result['ArchitectureIterationId'] = self.architecture_iteration_id
        if self.connection_policy_id is not None:
            result['ConnectionPolicyId'] = self.connection_policy_id
        if self.downlink_architecture_device_id is not None:
            result['DownlinkArchitectureDeviceId'] = self.downlink_architecture_device_id
        if self.downlink_architecture_module_id is not None:
            result['DownlinkArchitectureModuleId'] = self.downlink_architecture_module_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.uplink_architecture_device_id is not None:
            result['UplinkArchitectureDeviceId'] = self.uplink_architecture_device_id
        if self.uplink_architecture_module_id is not None:
            result['UplinkArchitectureModuleId'] = self.uplink_architecture_module_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArchitectureIterationId') is not None:
            self.architecture_iteration_id = m.get('ArchitectureIterationId')
        if m.get('ConnectionPolicyId') is not None:
            self.connection_policy_id = m.get('ConnectionPolicyId')
        if m.get('DownlinkArchitectureDeviceId') is not None:
            self.downlink_architecture_device_id = m.get('DownlinkArchitectureDeviceId')
        if m.get('DownlinkArchitectureModuleId') is not None:
            self.downlink_architecture_module_id = m.get('DownlinkArchitectureModuleId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('UplinkArchitectureDeviceId') is not None:
            self.uplink_architecture_device_id = m.get('UplinkArchitectureDeviceId')
        if m.get('UplinkArchitectureModuleId') is not None:
            self.uplink_architecture_module_id = m.get('UplinkArchitectureModuleId')
        return self


class ListConnectionPoliciesResponseBodyConnectionPolicy(TeaModel):
    def __init__(
        self,
        algorithm: str = None,
        architecture_iteration_id: str = None,
        create_time: str = None,
        downlink_architecture_device_id: str = None,
        downlink_architecture_module_id: str = None,
        id: str = None,
        link_count: int = None,
        name: str = None,
        update_time: str = None,
        uplink_architecture_device_id: str = None,
        uplink_architecture_module_id: str = None,
    ):
        # 连接策略算法
        self.algorithm = algorithm
        # 架构迭代uid
        self.architecture_iteration_id = architecture_iteration_id
        # 创建时间
        self.create_time = create_time
        # 上联设备uid
        self.downlink_architecture_device_id = downlink_architecture_device_id
        # 下联设备uid
        self.downlink_architecture_module_id = downlink_architecture_module_id
        # 连接策略uid
        self.id = id
        # 连接数
        self.link_count = link_count
        # 连接策略名字
        self.name = name
        # 更新是啊金
        self.update_time = update_time
        # 上联模块uid
        self.uplink_architecture_device_id = uplink_architecture_device_id
        # 下联模块uid
        self.uplink_architecture_module_id = uplink_architecture_module_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.architecture_iteration_id is not None:
            result['ArchitectureIterationId'] = self.architecture_iteration_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.downlink_architecture_device_id is not None:
            result['DownlinkArchitectureDeviceId'] = self.downlink_architecture_device_id
        if self.downlink_architecture_module_id is not None:
            result['DownlinkArchitectureModuleId'] = self.downlink_architecture_module_id
        if self.id is not None:
            result['Id'] = self.id
        if self.link_count is not None:
            result['LinkCount'] = self.link_count
        if self.name is not None:
            result['Name'] = self.name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.uplink_architecture_device_id is not None:
            result['UplinkArchitectureDeviceId'] = self.uplink_architecture_device_id
        if self.uplink_architecture_module_id is not None:
            result['UplinkArchitectureModuleId'] = self.uplink_architecture_module_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('ArchitectureIterationId') is not None:
            self.architecture_iteration_id = m.get('ArchitectureIterationId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DownlinkArchitectureDeviceId') is not None:
            self.downlink_architecture_device_id = m.get('DownlinkArchitectureDeviceId')
        if m.get('DownlinkArchitectureModuleId') is not None:
            self.downlink_architecture_module_id = m.get('DownlinkArchitectureModuleId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LinkCount') is not None:
            self.link_count = m.get('LinkCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UplinkArchitectureDeviceId') is not None:
            self.uplink_architecture_device_id = m.get('UplinkArchitectureDeviceId')
        if m.get('UplinkArchitectureModuleId') is not None:
            self.uplink_architecture_module_id = m.get('UplinkArchitectureModuleId')
        return self


class ListConnectionPoliciesResponseBody(TeaModel):
    def __init__(
        self,
        connection_policy: List[ListConnectionPoliciesResponseBodyConnectionPolicy] = None,
        max_results: int = None,
        next_token: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 数组，返回示例目录。
        self.connection_policy = connection_policy
        # 本次读取的最大数据量
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.connection_policy:
            for k in self.connection_policy:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConnectionPolicy'] = []
        if self.connection_policy is not None:
            for k in self.connection_policy:
                result['ConnectionPolicy'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.connection_policy = []
        if m.get('ConnectionPolicy') is not None:
            for k in m.get('ConnectionPolicy'):
                temp_model = ListConnectionPoliciesResponseBodyConnectionPolicy()
                self.connection_policy.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListConnectionPoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListConnectionPoliciesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConnectionPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDedicatedLinesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        physical_space_id: str = None,
    ):
        # 实例ID
        self.instance_id = instance_id
        # 物理空间ID
        self.physical_space_id = physical_space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        return self


class ListDedicatedLinesResponseBodyDedicatedLines(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        contact: str = None,
        dedicated_line_gateway: str = None,
        dedicated_line_id: str = None,
        dedicated_line_ip: str = None,
        dedicated_line_role: str = None,
        description: str = None,
        device_id: str = None,
        device_name: str = None,
        device_port: str = None,
        isp: str = None,
        phone: str = None,
        physical_space_id: str = None,
    ):
        # 宽带（Mbps）
        self.bandwidth = bandwidth
        # 联系人
        self.contact = contact
        # 专线网关
        self.dedicated_line_gateway = dedicated_line_gateway
        # 物理空间专线ID
        self.dedicated_line_id = dedicated_line_id
        # 专线IP
        self.dedicated_line_ip = dedicated_line_ip
        # 专线角色
        self.dedicated_line_role = dedicated_line_role
        # 备注
        self.description = description
        # 关联设备ID
        self.device_id = device_id
        # 关联设备名称
        self.device_name = device_name
        # 关联设备端口
        self.device_port = device_port
        # 运营商
        self.isp = isp
        # 联系电话
        self.phone = phone
        # 关联物理空间ID
        self.physical_space_id = physical_space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.contact is not None:
            result['Contact'] = self.contact
        if self.dedicated_line_gateway is not None:
            result['DedicatedLineGateway'] = self.dedicated_line_gateway
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.dedicated_line_ip is not None:
            result['DedicatedLineIp'] = self.dedicated_line_ip
        if self.dedicated_line_role is not None:
            result['DedicatedLineRole'] = self.dedicated_line_role
        if self.description is not None:
            result['Description'] = self.description
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_port is not None:
            result['DevicePort'] = self.device_port
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.phone is not None:
            result['Phone'] = self.phone
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('Contact') is not None:
            self.contact = m.get('Contact')
        if m.get('DedicatedLineGateway') is not None:
            self.dedicated_line_gateway = m.get('DedicatedLineGateway')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('DedicatedLineIp') is not None:
            self.dedicated_line_ip = m.get('DedicatedLineIp')
        if m.get('DedicatedLineRole') is not None:
            self.dedicated_line_role = m.get('DedicatedLineRole')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DevicePort') is not None:
            self.device_port = m.get('DevicePort')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        return self


class ListDedicatedLinesResponseBody(TeaModel):
    def __init__(
        self,
        dedicated_lines: List[ListDedicatedLinesResponseBodyDedicatedLines] = None,
        request_id: str = None,
    ):
        # 数组，返回示例目录。
        self.dedicated_lines = dedicated_lines
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.dedicated_lines:
            for k in self.dedicated_lines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedLines'] = []
        if self.dedicated_lines is not None:
            for k in self.dedicated_lines:
                result['DedicatedLines'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dedicated_lines = []
        if m.get('DedicatedLines') is not None:
            for k in m.get('DedicatedLines'):
                temp_model = ListDedicatedLinesResponseBodyDedicatedLines()
                self.dedicated_lines.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDedicatedLinesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDedicatedLinesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDedicatedLinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDeviceFormsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # 实例ID
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListDeviceFormsResponseBodyDeviceFormsAttributeList(TeaModel):
    def __init__(
        self,
        attribute_built_in: bool = None,
        attribute_format: str = None,
        attribute_fuzzy_query: bool = None,
        attribute_key: str = None,
        attribute_name: str = None,
        attribute_placeholder: str = None,
        attribute_query: bool = None,
        attribute_reference: str = None,
        attribute_requirement: bool = None,
        attribute_table_display: bool = None,
        attribute_type: str = None,
        attribute_uniqueness: bool = None,
    ):
        # 设备形态属性是否内置
        self.attribute_built_in = attribute_built_in
        # 设备形态属性值格式
        self.attribute_format = attribute_format
        # 前端查询控件是否支持模糊搜索
        self.attribute_fuzzy_query = attribute_fuzzy_query
        # 设备形态属性主键
        self.attribute_key = attribute_key
        # 设备形态属性名称
        self.attribute_name = attribute_name
        # 前端查询控件占位符
        self.attribute_placeholder = attribute_placeholder
        # 前端是否展示对应的查询控件
        self.attribute_query = attribute_query
        # 设备形态属性关联对象
        self.attribute_reference = attribute_reference
        # 设备形态属性是否必填
        self.attribute_requirement = attribute_requirement
        # 设备形态属性是否表格可见
        self.attribute_table_display = attribute_table_display
        # 设备形态属性值类型
        self.attribute_type = attribute_type
        # 设备形态属性是否唯一
        self.attribute_uniqueness = attribute_uniqueness

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_built_in is not None:
            result['AttributeBuiltIn'] = self.attribute_built_in
        if self.attribute_format is not None:
            result['AttributeFormat'] = self.attribute_format
        if self.attribute_fuzzy_query is not None:
            result['AttributeFuzzyQuery'] = self.attribute_fuzzy_query
        if self.attribute_key is not None:
            result['AttributeKey'] = self.attribute_key
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.attribute_placeholder is not None:
            result['AttributePlaceholder'] = self.attribute_placeholder
        if self.attribute_query is not None:
            result['AttributeQuery'] = self.attribute_query
        if self.attribute_reference is not None:
            result['AttributeReference'] = self.attribute_reference
        if self.attribute_requirement is not None:
            result['AttributeRequirement'] = self.attribute_requirement
        if self.attribute_table_display is not None:
            result['AttributeTableDisplay'] = self.attribute_table_display
        if self.attribute_type is not None:
            result['AttributeType'] = self.attribute_type
        if self.attribute_uniqueness is not None:
            result['AttributeUniqueness'] = self.attribute_uniqueness
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttributeBuiltIn') is not None:
            self.attribute_built_in = m.get('AttributeBuiltIn')
        if m.get('AttributeFormat') is not None:
            self.attribute_format = m.get('AttributeFormat')
        if m.get('AttributeFuzzyQuery') is not None:
            self.attribute_fuzzy_query = m.get('AttributeFuzzyQuery')
        if m.get('AttributeKey') is not None:
            self.attribute_key = m.get('AttributeKey')
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('AttributePlaceholder') is not None:
            self.attribute_placeholder = m.get('AttributePlaceholder')
        if m.get('AttributeQuery') is not None:
            self.attribute_query = m.get('AttributeQuery')
        if m.get('AttributeReference') is not None:
            self.attribute_reference = m.get('AttributeReference')
        if m.get('AttributeRequirement') is not None:
            self.attribute_requirement = m.get('AttributeRequirement')
        if m.get('AttributeTableDisplay') is not None:
            self.attribute_table_display = m.get('AttributeTableDisplay')
        if m.get('AttributeType') is not None:
            self.attribute_type = m.get('AttributeType')
        if m.get('AttributeUniqueness') is not None:
            self.attribute_uniqueness = m.get('AttributeUniqueness')
        return self


class ListDeviceFormsResponseBodyDeviceForms(TeaModel):
    def __init__(
        self,
        account_config: bool = None,
        attribute_list: List[ListDeviceFormsResponseBodyDeviceFormsAttributeList] = None,
        config_compare: bool = None,
        detail_display: bool = None,
        device_form_id: str = None,
        device_form_name: str = None,
        form_built_in: bool = None,
        related_device_form_id: str = None,
        resource_use: str = None,
        script: str = None,
        unique_key: str = None,
    ):
        # 是否需要账号配置
        self.account_config = account_config
        # 设备形态属性列表
        self.attribute_list = attribute_list
        # 是否支持配置生成
        self.config_compare = config_compare
        # 是否展示详情
        self.detail_display = detail_display
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 设备形态是否内置
        self.form_built_in = form_built_in
        # 关联设备形态ID
        self.related_device_form_id = related_device_form_id
        # 资源用途
        self.resource_use = resource_use
        # 设备代码
        self.script = script
        # 设备形态主键
        self.unique_key = unique_key

    def validate(self):
        if self.attribute_list:
            for k in self.attribute_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_config is not None:
            result['AccountConfig'] = self.account_config
        result['AttributeList'] = []
        if self.attribute_list is not None:
            for k in self.attribute_list:
                result['AttributeList'].append(k.to_map() if k else None)
        if self.config_compare is not None:
            result['ConfigCompare'] = self.config_compare
        if self.detail_display is not None:
            result['DetailDisplay'] = self.detail_display
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.form_built_in is not None:
            result['FormBuiltIn'] = self.form_built_in
        if self.related_device_form_id is not None:
            result['RelatedDeviceFormId'] = self.related_device_form_id
        if self.resource_use is not None:
            result['ResourceUse'] = self.resource_use
        if self.script is not None:
            result['Script'] = self.script
        if self.unique_key is not None:
            result['UniqueKey'] = self.unique_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountConfig') is not None:
            self.account_config = m.get('AccountConfig')
        self.attribute_list = []
        if m.get('AttributeList') is not None:
            for k in m.get('AttributeList'):
                temp_model = ListDeviceFormsResponseBodyDeviceFormsAttributeList()
                self.attribute_list.append(temp_model.from_map(k))
        if m.get('ConfigCompare') is not None:
            self.config_compare = m.get('ConfigCompare')
        if m.get('DetailDisplay') is not None:
            self.detail_display = m.get('DetailDisplay')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('FormBuiltIn') is not None:
            self.form_built_in = m.get('FormBuiltIn')
        if m.get('RelatedDeviceFormId') is not None:
            self.related_device_form_id = m.get('RelatedDeviceFormId')
        if m.get('ResourceUse') is not None:
            self.resource_use = m.get('ResourceUse')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('UniqueKey') is not None:
            self.unique_key = m.get('UniqueKey')
        return self


class ListDeviceFormsResponseBody(TeaModel):
    def __init__(
        self,
        device_forms: List[ListDeviceFormsResponseBodyDeviceForms] = None,
        max_results: int = None,
        next_token: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 数组，返回示例目录。
        self.device_forms = device_forms
        # 每页数量。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.device_forms:
            for k in self.device_forms:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceForms'] = []
        if self.device_forms is not None:
            for k in self.device_forms:
                result['DeviceForms'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_forms = []
        if m.get('DeviceForms') is not None:
            for k in m.get('DeviceForms'):
                temp_model = ListDeviceFormsResponseBodyDeviceForms()
                self.device_forms.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListDeviceFormsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDeviceFormsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDeviceFormsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDevicePropertiesRequest(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # 设备形态ID
        self.device_form_id = device_form_id
        # 实例ID
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListDevicePropertiesResponseBodyDeviceProperties(TeaModel):
    def __init__(
        self,
        built_in: bool = None,
        device_form_id: str = None,
        device_form_name: str = None,
        device_property_id: str = None,
        property_content: str = None,
        property_format: str = None,
        property_key: str = None,
        property_name: str = None,
    ):
        # 是否内置属性
        self.built_in = built_in
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 设备属性ID
        self.device_property_id = device_property_id
        # 属性内容
        self.property_content = property_content
        # 属性格式
        self.property_format = property_format
        # 属性主键
        self.property_key = property_key
        # 属性名称
        self.property_name = property_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.built_in is not None:
            result['BuiltIn'] = self.built_in
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.device_property_id is not None:
            result['DevicePropertyId'] = self.device_property_id
        if self.property_content is not None:
            result['PropertyContent'] = self.property_content
        if self.property_format is not None:
            result['PropertyFormat'] = self.property_format
        if self.property_key is not None:
            result['PropertyKey'] = self.property_key
        if self.property_name is not None:
            result['PropertyName'] = self.property_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BuiltIn') is not None:
            self.built_in = m.get('BuiltIn')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('DevicePropertyId') is not None:
            self.device_property_id = m.get('DevicePropertyId')
        if m.get('PropertyContent') is not None:
            self.property_content = m.get('PropertyContent')
        if m.get('PropertyFormat') is not None:
            self.property_format = m.get('PropertyFormat')
        if m.get('PropertyKey') is not None:
            self.property_key = m.get('PropertyKey')
        if m.get('PropertyName') is not None:
            self.property_name = m.get('PropertyName')
        return self


class ListDevicePropertiesResponseBody(TeaModel):
    def __init__(
        self,
        device_properties: List[ListDevicePropertiesResponseBodyDeviceProperties] = None,
        max_results: int = None,
        next_token: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 数组，返回示例目录。
        self.device_properties = device_properties
        # 每页数量。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.device_properties:
            for k in self.device_properties:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceProperties'] = []
        if self.device_properties is not None:
            for k in self.device_properties:
                result['DeviceProperties'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_properties = []
        if m.get('DeviceProperties') is not None:
            for k in m.get('DeviceProperties'):
                temp_model = ListDevicePropertiesResponseBodyDeviceProperties()
                self.device_properties.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListDevicePropertiesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDevicePropertiesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDevicePropertiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDeviceResourcesRequest(TeaModel):
    def __init__(
        self,
        business_type: str = None,
        instance_id: str = None,
        list_type: str = None,
        max_results: int = None,
        next_token: str = None,
        setup_project_id: str = None,
    ):
        # 业务类型
        self.business_type = business_type
        # instanceId
        self.instance_id = instance_id
        # List类型
        self.list_type = list_type
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 建设项目id
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.list_type is not None:
            result['ListType'] = self.list_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ListType') is not None:
            self.list_type = m.get('ListType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class ListDeviceResourcesResponseBodyDeviceResource(TeaModel):
    def __init__(
        self,
        block_number: str = None,
        business: str = None,
        config: str = None,
        config_task_id: str = None,
        config_task_status: str = None,
        delivery_ip: str = None,
        device_number: str = None,
        device_resource_id: str = None,
        generate_config: str = None,
        host_name: str = None,
        inter_connection: str = None,
        location: str = None,
        loopback: str = None,
        manager_ip: str = None,
        model: str = None,
        params: str = None,
        role: str = None,
        setup_project_id: str = None,
        sn: str = None,
        specification: str = None,
        stack: bool = None,
        vendor: str = None,
    ):
        # 组号
        self.block_number = block_number
        # 设备业务地址
        self.business = business
        # 设备配置
        self.config = config
        # 配置任务Id
        self.config_task_id = config_task_id
        # 配置下发状态
        self.config_task_status = config_task_status
        # 交付登录地址
        self.delivery_ip = delivery_ip
        # 设备号
        self.device_number = device_number
        # 资源一级ID
        self.device_resource_id = device_resource_id
        # 配置生成
        self.generate_config = generate_config
        # 主机名
        self.host_name = host_name
        # 设备互联地址
        self.inter_connection = inter_connection
        # 物理空间位置
        self.location = location
        # loopback地址
        self.loopback = loopback
        # 带内管理地址
        self.manager_ip = manager_ip
        # 模型
        self.model = model
        # 配置入参
        self.params = params
        # 角色
        self.role = role
        # 建设项目id
        self.setup_project_id = setup_project_id
        # 设备sn号
        self.sn = sn
        # 配置规范
        self.specification = specification
        # 堆叠状态
        self.stack = stack
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_number is not None:
            result['BlockNumber'] = self.block_number
        if self.business is not None:
            result['Business'] = self.business
        if self.config is not None:
            result['Config'] = self.config
        if self.config_task_id is not None:
            result['ConfigTaskId'] = self.config_task_id
        if self.config_task_status is not None:
            result['ConfigTaskStatus'] = self.config_task_status
        if self.delivery_ip is not None:
            result['DeliveryIp'] = self.delivery_ip
        if self.device_number is not None:
            result['DeviceNumber'] = self.device_number
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.generate_config is not None:
            result['GenerateConfig'] = self.generate_config
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.inter_connection is not None:
            result['InterConnection'] = self.inter_connection
        if self.location is not None:
            result['Location'] = self.location
        if self.loopback is not None:
            result['Loopback'] = self.loopback
        if self.manager_ip is not None:
            result['ManagerIp'] = self.manager_ip
        if self.model is not None:
            result['Model'] = self.model
        if self.params is not None:
            result['Params'] = self.params
        if self.role is not None:
            result['Role'] = self.role
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.stack is not None:
            result['Stack'] = self.stack
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockNumber') is not None:
            self.block_number = m.get('BlockNumber')
        if m.get('Business') is not None:
            self.business = m.get('Business')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('ConfigTaskId') is not None:
            self.config_task_id = m.get('ConfigTaskId')
        if m.get('ConfigTaskStatus') is not None:
            self.config_task_status = m.get('ConfigTaskStatus')
        if m.get('DeliveryIp') is not None:
            self.delivery_ip = m.get('DeliveryIp')
        if m.get('DeviceNumber') is not None:
            self.device_number = m.get('DeviceNumber')
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('GenerateConfig') is not None:
            self.generate_config = m.get('GenerateConfig')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InterConnection') is not None:
            self.inter_connection = m.get('InterConnection')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Loopback') is not None:
            self.loopback = m.get('Loopback')
        if m.get('ManagerIp') is not None:
            self.manager_ip = m.get('ManagerIp')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Stack') is not None:
            self.stack = m.get('Stack')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListDeviceResourcesResponseBody(TeaModel):
    def __init__(
        self,
        device_resource: List[ListDeviceResourcesResponseBodyDeviceResource] = None,
        max_results: int = None,
        next_token: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 数组，返回示例目录。
        self.device_resource = device_resource
        # 本次读取的最大数据量
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.device_resource:
            for k in self.device_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceResource'] = []
        if self.device_resource is not None:
            for k in self.device_resource:
                result['DeviceResource'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device_resource = []
        if m.get('DeviceResource') is not None:
            for k in m.get('DeviceResource'):
                temp_model = ListDeviceResourcesResponseBodyDeviceResource()
                self.device_resource.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListDeviceResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDeviceResourcesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDeviceResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDeviceValuesRequest(TeaModel):
    def __init__(
        self,
        attribute_group: str = None,
        attribute_keyword: str = None,
        device_form_id: str = None,
        device_form_name: str = None,
        instance_id: str = None,
    ):
        # 查询属性对应JSON中主键
        self.attribute_group = attribute_group
        # 查询属性主键
        self.attribute_keyword = attribute_keyword
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 实例ID
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_group is not None:
            result['AttributeGroup'] = self.attribute_group
        if self.attribute_keyword is not None:
            result['AttributeKeyword'] = self.attribute_keyword
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttributeGroup') is not None:
            self.attribute_group = m.get('AttributeGroup')
        if m.get('AttributeKeyword') is not None:
            self.attribute_keyword = m.get('AttributeKeyword')
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListDeviceValuesResponseBody(TeaModel):
    def __init__(
        self,
        device_values: List[str] = None,
        request_id: str = None,
    ):
        # 数组，返回示例目录。
        self.device_values = device_values
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_values is not None:
            result['DeviceValues'] = self.device_values
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceValues') is not None:
            self.device_values = m.get('DeviceValues')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDeviceValuesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDeviceValuesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDeviceValuesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDevicesRequest(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        device_form_name: str = None,
        device_ids: List[str] = None,
        ext_attributes: str = None,
        host_name: List[str] = None,
        instance_id: str = None,
        ip: List[str] = None,
        keyword: str = None,
        mac: List[str] = None,
        max_results: int = None,
        model: List[str] = None,
        next_token: str = None,
        physical_space_id: str = None,
        physical_space_ids: List[str] = None,
        security_domain: List[str] = None,
        service_status: List[str] = None,
        sn: List[str] = None,
        vendor: List[str] = None,
    ):
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 设备Id列表
        self.device_ids = device_ids
        # 设备额外属性
        self.ext_attributes = ext_attributes
        # 设备主机名
        self.host_name = host_name
        # 实例ID
        self.instance_id = instance_id
        # 设备IP
        self.ip = ip
        # 模糊查询值
        self.keyword = keyword
        # 设备MAC
        self.mac = mac
        # 返回结果的最大个数。
        self.max_results = max_results
        # 设备型号
        self.model = model
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 物理空间IDS
        self.physical_space_ids = physical_space_ids
        # 安全域
        self.security_domain = security_domain
        # 设备服务状态
        self.service_status = service_status
        # 设备SN
        self.sn = sn
        # 设备厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.device_ids is not None:
            result['DeviceIds'] = self.device_ids
        if self.ext_attributes is not None:
            result['ExtAttributes'] = self.ext_attributes
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.model is not None:
            result['Model'] = self.model
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.physical_space_ids is not None:
            result['PhysicalSpaceIds'] = self.physical_space_ids
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('DeviceIds') is not None:
            self.device_ids = m.get('DeviceIds')
        if m.get('ExtAttributes') is not None:
            self.ext_attributes = m.get('ExtAttributes')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('PhysicalSpaceIds') is not None:
            self.physical_space_ids = m.get('PhysicalSpaceIds')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListDevicesShrinkRequest(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        device_form_name: str = None,
        device_ids_shrink: str = None,
        ext_attributes: str = None,
        host_name: List[str] = None,
        instance_id: str = None,
        ip: List[str] = None,
        keyword: str = None,
        mac: List[str] = None,
        max_results: int = None,
        model: List[str] = None,
        next_token: str = None,
        physical_space_id: str = None,
        physical_space_ids_shrink: str = None,
        security_domain: List[str] = None,
        service_status: List[str] = None,
        sn: List[str] = None,
        vendor: List[str] = None,
    ):
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 设备Id列表
        self.device_ids_shrink = device_ids_shrink
        # 设备额外属性
        self.ext_attributes = ext_attributes
        # 设备主机名
        self.host_name = host_name
        # 实例ID
        self.instance_id = instance_id
        # 设备IP
        self.ip = ip
        # 模糊查询值
        self.keyword = keyword
        # 设备MAC
        self.mac = mac
        # 返回结果的最大个数。
        self.max_results = max_results
        # 设备型号
        self.model = model
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 物理空间IDS
        self.physical_space_ids_shrink = physical_space_ids_shrink
        # 安全域
        self.security_domain = security_domain
        # 设备服务状态
        self.service_status = service_status
        # 设备SN
        self.sn = sn
        # 设备厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.device_ids_shrink is not None:
            result['DeviceIds'] = self.device_ids_shrink
        if self.ext_attributes is not None:
            result['ExtAttributes'] = self.ext_attributes
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.model is not None:
            result['Model'] = self.model
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.physical_space_ids_shrink is not None:
            result['PhysicalSpaceIds'] = self.physical_space_ids_shrink
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('DeviceIds') is not None:
            self.device_ids_shrink = m.get('DeviceIds')
        if m.get('ExtAttributes') is not None:
            self.ext_attributes = m.get('ExtAttributes')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('PhysicalSpaceIds') is not None:
            self.physical_space_ids_shrink = m.get('PhysicalSpaceIds')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListDevicesResponseBodyDevices(TeaModel):
    def __init__(
        self,
        device_form_id: str = None,
        device_form_name: str = None,
        device_id: str = None,
        enable_password: str = None,
        ext_attributes: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        host_name: str = None,
        ip: str = None,
        login_password: str = None,
        login_type: str = None,
        login_username: str = None,
        mac: str = None,
        model: str = None,
        physical_space_id: str = None,
        physical_space_name: str = None,
        security_domain: str = None,
        service_status: str = None,
        sn: str = None,
        snmp_account_type: str = None,
        snmp_account_version: str = None,
        snmp_auth_passphrase: str = None,
        snmp_auth_protocol: str = None,
        snmp_community: str = None,
        snmp_privacy_passphrase: str = None,
        snmp_privacy_protocol: str = None,
        snmp_security_level: str = None,
        snmp_username: str = None,
        vendor: str = None,
    ):
        # 设备形态ID
        self.device_form_id = device_form_id
        # 设备形态名称
        self.device_form_name = device_form_name
        # 设备ID
        self.device_id = device_id
        # enable密码
        self.enable_password = enable_password
        # 设备额外属性
        self.ext_attributes = ext_attributes
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 主机名
        self.host_name = host_name
        # 设备IP
        self.ip = ip
        # 登录密码
        self.login_password = login_password
        # 登录类型
        self.login_type = login_type
        # 登录账号
        self.login_username = login_username
        # 设备MAC地址
        self.mac = mac
        # 设备型号
        self.model = model
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 物理空间名称
        self.physical_space_name = physical_space_name
        # 设备安全域
        self.security_domain = security_domain
        # 设备状态
        self.service_status = service_status
        # 设备SN
        self.sn = sn
        # SNMP 账号类型
        self.snmp_account_type = snmp_account_type
        # SNMP版本号
        self.snmp_account_version = snmp_account_version
        # SNMP Auth Passphrase
        self.snmp_auth_passphrase = snmp_auth_passphrase
        # SNMP Auth Protocol
        self.snmp_auth_protocol = snmp_auth_protocol
        # SNMP Community
        self.snmp_community = snmp_community
        # SNMP Privacy Passphrase
        self.snmp_privacy_passphrase = snmp_privacy_passphrase
        # SNMP Privacy Protocol
        self.snmp_privacy_protocol = snmp_privacy_protocol
        # SNMP 安全级别
        self.snmp_security_level = snmp_security_level
        # SNMP 用户名
        self.snmp_username = snmp_username
        # 设备厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_form_id is not None:
            result['DeviceFormId'] = self.device_form_id
        if self.device_form_name is not None:
            result['DeviceFormName'] = self.device_form_name
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.enable_password is not None:
            result['EnablePassword'] = self.enable_password
        if self.ext_attributes is not None:
            result['ExtAttributes'] = self.ext_attributes
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.login_password is not None:
            result['LoginPassword'] = self.login_password
        if self.login_type is not None:
            result['LoginType'] = self.login_type
        if self.login_username is not None:
            result['LoginUsername'] = self.login_username
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.model is not None:
            result['Model'] = self.model
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.physical_space_name is not None:
            result['PhysicalSpaceName'] = self.physical_space_name
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.snmp_account_type is not None:
            result['SnmpAccountType'] = self.snmp_account_type
        if self.snmp_account_version is not None:
            result['SnmpAccountVersion'] = self.snmp_account_version
        if self.snmp_auth_passphrase is not None:
            result['SnmpAuthPassphrase'] = self.snmp_auth_passphrase
        if self.snmp_auth_protocol is not None:
            result['SnmpAuthProtocol'] = self.snmp_auth_protocol
        if self.snmp_community is not None:
            result['SnmpCommunity'] = self.snmp_community
        if self.snmp_privacy_passphrase is not None:
            result['SnmpPrivacyPassphrase'] = self.snmp_privacy_passphrase
        if self.snmp_privacy_protocol is not None:
            result['SnmpPrivacyProtocol'] = self.snmp_privacy_protocol
        if self.snmp_security_level is not None:
            result['SnmpSecurityLevel'] = self.snmp_security_level
        if self.snmp_username is not None:
            result['SnmpUsername'] = self.snmp_username
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceFormId') is not None:
            self.device_form_id = m.get('DeviceFormId')
        if m.get('DeviceFormName') is not None:
            self.device_form_name = m.get('DeviceFormName')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('EnablePassword') is not None:
            self.enable_password = m.get('EnablePassword')
        if m.get('ExtAttributes') is not None:
            self.ext_attributes = m.get('ExtAttributes')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('LoginPassword') is not None:
            self.login_password = m.get('LoginPassword')
        if m.get('LoginType') is not None:
            self.login_type = m.get('LoginType')
        if m.get('LoginUsername') is not None:
            self.login_username = m.get('LoginUsername')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('PhysicalSpaceName') is not None:
            self.physical_space_name = m.get('PhysicalSpaceName')
        if m.get('SecurityDomain') is not None:
            self.security_domain = m.get('SecurityDomain')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('Sn') is not None:
            self.sn = m.get('Sn')
        if m.get('SnmpAccountType') is not None:
            self.snmp_account_type = m.get('SnmpAccountType')
        if m.get('SnmpAccountVersion') is not None:
            self.snmp_account_version = m.get('SnmpAccountVersion')
        if m.get('SnmpAuthPassphrase') is not None:
            self.snmp_auth_passphrase = m.get('SnmpAuthPassphrase')
        if m.get('SnmpAuthProtocol') is not None:
            self.snmp_auth_protocol = m.get('SnmpAuthProtocol')
        if m.get('SnmpCommunity') is not None:
            self.snmp_community = m.get('SnmpCommunity')
        if m.get('SnmpPrivacyPassphrase') is not None:
            self.snmp_privacy_passphrase = m.get('SnmpPrivacyPassphrase')
        if m.get('SnmpPrivacyProtocol') is not None:
            self.snmp_privacy_protocol = m.get('SnmpPrivacyProtocol')
        if m.get('SnmpSecurityLevel') is not None:
            self.snmp_security_level = m.get('SnmpSecurityLevel')
        if m.get('SnmpUsername') is not None:
            self.snmp_username = m.get('SnmpUsername')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListDevicesResponseBody(TeaModel):
    def __init__(
        self,
        devices: List[ListDevicesResponseBodyDevices] = None,
        max_results: int = None,
        next_token: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 数组，返回示例目录。
        self.devices = devices
        # 每页数量。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = ListDevicesResponseBodyDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDevicesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEventDefinitionsRequest(TeaModel):
    def __init__(
        self,
        event_id: str = None,
        event_name: str = None,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # 事件项ID
        self.event_id = event_id
        # 事件项名称
        self.event_name = event_name
        # 实例ID
        self.instance_id = instance_id
        # 本次读取的最大数据记录数量
        self.max_results = max_results
        # 标记当前开始读取的位置，置空表示从头开始
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListEventDefinitionsResponseBody(TeaModel):
    def __init__(
        self,
        event_definitions: List[EventDefinition] = None,
        max_results: int = None,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 事件项列表
        self.event_definitions = event_definitions
        # MaxResults本次请求所返回的最大记录条数
        self.max_results = max_results
        # 表示当前调用返回读取到的位置，空代表数据已经读取完毕
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # TotalCount本次请求条件下的数据总量，此参数为可选参数，默认可不返回
        self.total_count = total_count

    def validate(self):
        if self.event_definitions:
            for k in self.event_definitions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventDefinitions'] = []
        if self.event_definitions is not None:
            for k in self.event_definitions:
                result['EventDefinitions'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_definitions = []
        if m.get('EventDefinitions') is not None:
            for k in m.get('EventDefinitions'):
                temp_model = EventDefinition()
                self.event_definitions.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListEventDefinitionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListEventDefinitionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListEventDefinitionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEventsRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        event_type: str = None,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        physical_space_id: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 事件类型
        self.event_type = event_type
        # 实例ID
        self.instance_id = instance_id
        # 本次读取的最大数据记录数量
        self.max_results = max_results
        # 标记当前开始读取的位置，置空表示从头开始
        self.next_token = next_token
        # 物理空间ID
        self.physical_space_id = physical_space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        return self


class ListEventsResponseBodyStatistics(TeaModel):
    def __init__(
        self,
        count: int = None,
        status: str = None,
    ):
        # 总量
        self.count = count
        # 事件告警状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListEventsResponseBody(TeaModel):
    def __init__(
        self,
        events: List[Event] = None,
        max_results: int = None,
        next_token: str = None,
        request_id: str = None,
        statistics: List[ListEventsResponseBodyStatistics] = None,
        total_count: int = None,
    ):
        # 事件列表
        self.events = events
        # MaxResults本次请求所返回的最大记录条数
        self.max_results = max_results
        # 表示当前调用返回读取到的位置，空代表数据已经读取完毕
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 事件统计
        self.statistics = statistics
        # TotalCount本次请求条件下的数据总量，此参数为可选参数，默认可不返回
        self.total_count = total_count

    def validate(self):
        if self.events:
            for k in self.events:
                if k:
                    k.validate()
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Events'] = []
        if self.events is not None:
            for k in self.events:
                result['Events'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.events = []
        if m.get('Events') is not None:
            for k in m.get('Events'):
                temp_model = Event()
                self.events.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = ListEventsResponseBodyStatistics()
                self.statistics.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListEventsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInspectionDevicesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        model: List[str] = None,
        role: str = None,
        vendor: str = None,
    ):
        # 实例id
        self.instance_id = instance_id
        # 型号
        self.model = model
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.model is not None:
            result['Model'] = self.model
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListInspectionDevicesShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        model_shrink: str = None,
        role: str = None,
        vendor: str = None,
    ):
        # 实例id
        self.instance_id = instance_id
        # 型号
        self.model_shrink = model_shrink
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.model_shrink is not None:
            result['Model'] = self.model_shrink
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Model') is not None:
            self.model_shrink = m.get('Model')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListInspectionDevicesResponseBodyInspectionScripts(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        device_state: str = None,
        host_name: str = None,
        manage_ip: str = None,
        model: str = None,
        role: str = None,
        space: str = None,
        vendor: str = None,
    ):
        # 设备id
        self.device_id = device_id
        # 设备状态
        self.device_state = device_state
        # 主机名
        self.host_name = host_name
        # 管理ip
        self.manage_ip = manage_ip
        # 型号
        self.model = model
        # 角色
        self.role = role
        # 物理空间
        self.space = space
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_state is not None:
            result['DeviceState'] = self.device_state
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.manage_ip is not None:
            result['ManageIp'] = self.manage_ip
        if self.model is not None:
            result['Model'] = self.model
        if self.role is not None:
            result['Role'] = self.role
        if self.space is not None:
            result['Space'] = self.space
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceState') is not None:
            self.device_state = m.get('DeviceState')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ManageIp') is not None:
            self.manage_ip = m.get('ManageIp')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListInspectionDevicesResponseBody(TeaModel):
    def __init__(
        self,
        inspection_scripts: List[ListInspectionDevicesResponseBodyInspectionScripts] = None,
        request_id: str = None,
    ):
        # content
        self.inspection_scripts = inspection_scripts
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.inspection_scripts:
            for k in self.inspection_scripts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InspectionScripts'] = []
        if self.inspection_scripts is not None:
            for k in self.inspection_scripts:
                result['InspectionScripts'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.inspection_scripts = []
        if m.get('InspectionScripts') is not None:
            for k in m.get('InspectionScripts'):
                temp_model = ListInspectionDevicesResponseBodyInspectionScripts()
                self.inspection_scripts.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListInspectionDevicesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListInspectionDevicesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInspectionDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInspectionTaskReportsRequest(TeaModel):
    def __init__(
        self,
        inspection_item_id: str = None,
        instance_id: str = None,
        vendor: str = None,
    ):
        # 巡检项id
        self.inspection_item_id = inspection_item_id
        # 实例id
        self.instance_id = instance_id
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.inspection_item_id is not None:
            result['InspectionItemId'] = self.inspection_item_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InspectionItemId') is not None:
            self.inspection_item_id = m.get('InspectionItemId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListInspectionTaskReportsResponseBodyInspectionTaskAlarmStatistic(TeaModel):
    def __init__(
        self,
        critical_number: int = None,
        inspection_item: str = None,
        model: str = None,
        vendor: str = None,
        warning_number: int = None,
    ):
        # 高危数量
        self.critical_number = critical_number
        # 巡检项
        self.inspection_item = inspection_item
        # 型号
        self.model = model
        # 厂商
        self.vendor = vendor
        # 中危数量
        self.warning_number = warning_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical_number is not None:
            result['CriticalNumber'] = self.critical_number
        if self.inspection_item is not None:
            result['InspectionItem'] = self.inspection_item
        if self.model is not None:
            result['Model'] = self.model
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.warning_number is not None:
            result['WarningNumber'] = self.warning_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CriticalNumber') is not None:
            self.critical_number = m.get('CriticalNumber')
        if m.get('InspectionItem') is not None:
            self.inspection_item = m.get('InspectionItem')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('WarningNumber') is not None:
            self.warning_number = m.get('WarningNumber')
        return self


class ListInspectionTaskReportsResponseBodyInspectionTask(TeaModel):
    def __init__(
        self,
        actual_device_number: int = None,
        alarm_number: int = None,
        alarm_statistic: List[ListInspectionTaskReportsResponseBodyInspectionTaskAlarmStatistic] = None,
        critical_number: int = None,
        critical_rate: str = None,
        device_rate: str = None,
        failure_statistic: str = None,
        failure_task_number: int = None,
        failure_task_rate: str = None,
        normal_number: int = None,
        normal_rate: str = None,
        running_task_number: int = None,
        running_task_rate: str = None,
        success_task_number: int = None,
        success_task_rate: str = None,
        task_number: int = None,
        total_device_number: int = None,
        warning_number: int = None,
        warning_rate: str = None,
    ):
        # 实际设备数
        self.actual_device_number = actual_device_number
        # 告警数量
        self.alarm_number = alarm_number
        self.alarm_statistic = alarm_statistic
        # 高危数量
        self.critical_number = critical_number
        # 高危占比
        self.critical_rate = critical_rate
        # 设备占比
        self.device_rate = device_rate
        # 失败详情
        self.failure_statistic = failure_statistic
        # 失败任务数
        self.failure_task_number = failure_task_number
        # 失败占比
        self.failure_task_rate = failure_task_rate
        # 正常数量
        self.normal_number = normal_number
        # 正常占比
        self.normal_rate = normal_rate
        # 正在运行任务数
        self.running_task_number = running_task_number
        # 运行占比
        self.running_task_rate = running_task_rate
        # 成功任务数
        self.success_task_number = success_task_number
        # 成功占比
        self.success_task_rate = success_task_rate
        # 任务数
        self.task_number = task_number
        # 总设备数
        self.total_device_number = total_device_number
        # 中危数量
        self.warning_number = warning_number
        # 中危占比
        self.warning_rate = warning_rate

    def validate(self):
        if self.alarm_statistic:
            for k in self.alarm_statistic:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_device_number is not None:
            result['ActualDeviceNumber'] = self.actual_device_number
        if self.alarm_number is not None:
            result['AlarmNumber'] = self.alarm_number
        result['AlarmStatistic'] = []
        if self.alarm_statistic is not None:
            for k in self.alarm_statistic:
                result['AlarmStatistic'].append(k.to_map() if k else None)
        if self.critical_number is not None:
            result['CriticalNumber'] = self.critical_number
        if self.critical_rate is not None:
            result['CriticalRate'] = self.critical_rate
        if self.device_rate is not None:
            result['DeviceRate'] = self.device_rate
        if self.failure_statistic is not None:
            result['FailureStatistic'] = self.failure_statistic
        if self.failure_task_number is not None:
            result['FailureTaskNumber'] = self.failure_task_number
        if self.failure_task_rate is not None:
            result['FailureTaskRate'] = self.failure_task_rate
        if self.normal_number is not None:
            result['NormalNumber'] = self.normal_number
        if self.normal_rate is not None:
            result['NormalRate'] = self.normal_rate
        if self.running_task_number is not None:
            result['RunningTaskNumber'] = self.running_task_number
        if self.running_task_rate is not None:
            result['RunningTaskRate'] = self.running_task_rate
        if self.success_task_number is not None:
            result['SuccessTaskNumber'] = self.success_task_number
        if self.success_task_rate is not None:
            result['SuccessTaskRate'] = self.success_task_rate
        if self.task_number is not None:
            result['TaskNumber'] = self.task_number
        if self.total_device_number is not None:
            result['TotalDeviceNumber'] = self.total_device_number
        if self.warning_number is not None:
            result['WarningNumber'] = self.warning_number
        if self.warning_rate is not None:
            result['WarningRate'] = self.warning_rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActualDeviceNumber') is not None:
            self.actual_device_number = m.get('ActualDeviceNumber')
        if m.get('AlarmNumber') is not None:
            self.alarm_number = m.get('AlarmNumber')
        self.alarm_statistic = []
        if m.get('AlarmStatistic') is not None:
            for k in m.get('AlarmStatistic'):
                temp_model = ListInspectionTaskReportsResponseBodyInspectionTaskAlarmStatistic()
                self.alarm_statistic.append(temp_model.from_map(k))
        if m.get('CriticalNumber') is not None:
            self.critical_number = m.get('CriticalNumber')
        if m.get('CriticalRate') is not None:
            self.critical_rate = m.get('CriticalRate')
        if m.get('DeviceRate') is not None:
            self.device_rate = m.get('DeviceRate')
        if m.get('FailureStatistic') is not None:
            self.failure_statistic = m.get('FailureStatistic')
        if m.get('FailureTaskNumber') is not None:
            self.failure_task_number = m.get('FailureTaskNumber')
        if m.get('FailureTaskRate') is not None:
            self.failure_task_rate = m.get('FailureTaskRate')
        if m.get('NormalNumber') is not None:
            self.normal_number = m.get('NormalNumber')
        if m.get('NormalRate') is not None:
            self.normal_rate = m.get('NormalRate')
        if m.get('RunningTaskNumber') is not None:
            self.running_task_number = m.get('RunningTaskNumber')
        if m.get('RunningTaskRate') is not None:
            self.running_task_rate = m.get('RunningTaskRate')
        if m.get('SuccessTaskNumber') is not None:
            self.success_task_number = m.get('SuccessTaskNumber')
        if m.get('SuccessTaskRate') is not None:
            self.success_task_rate = m.get('SuccessTaskRate')
        if m.get('TaskNumber') is not None:
            self.task_number = m.get('TaskNumber')
        if m.get('TotalDeviceNumber') is not None:
            self.total_device_number = m.get('TotalDeviceNumber')
        if m.get('WarningNumber') is not None:
            self.warning_number = m.get('WarningNumber')
        if m.get('WarningRate') is not None:
            self.warning_rate = m.get('WarningRate')
        return self


class ListInspectionTaskReportsResponseBody(TeaModel):
    def __init__(
        self,
        inspection_task: List[ListInspectionTaskReportsResponseBodyInspectionTask] = None,
        request_id: str = None,
    ):
        # 内容
        self.inspection_task = inspection_task
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.inspection_task:
            for k in self.inspection_task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InspectionTask'] = []
        if self.inspection_task is not None:
            for k in self.inspection_task:
                result['InspectionTask'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.inspection_task = []
        if m.get('InspectionTask') is not None:
            for k in m.get('InspectionTask'):
                temp_model = ListInspectionTaskReportsResponseBodyInspectionTask()
                self.inspection_task.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListInspectionTaskReportsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListInspectionTaskReportsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInspectionTaskReportsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInspectionTasksRequest(TeaModel):
    def __init__(
        self,
        alarm_status: List[str] = None,
        device_type: str = None,
        host_name: str = None,
        ip: str = None,
        instance_id: str = None,
        item_id: str = None,
        max_results: int = None,
        model: str = None,
        next_token: str = None,
        role: str = None,
        space: str = None,
        task_status: str = None,
        vendor: str = None,
    ):
        # 告警结果状态
        self.alarm_status = alarm_status
        # 设备类型
        self.device_type = device_type
        # 主机名
        self.host_name = host_name
        # 设备IP
        self.ip = ip
        # 实例ID
        self.instance_id = instance_id
        # 巡检项ID
        self.item_id = item_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 型号
        self.model = model
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 角色
        self.role = role
        # 物理空间
        self.space = space
        # 巡检状态
        self.task_status = task_status
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['IP'] = self.ip
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.model is not None:
            result['Model'] = self.model
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.role is not None:
            result['Role'] = self.role
        if self.space is not None:
            result['Space'] = self.space
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListInspectionTasksShrinkRequest(TeaModel):
    def __init__(
        self,
        alarm_status_shrink: str = None,
        device_type: str = None,
        host_name: str = None,
        ip: str = None,
        instance_id: str = None,
        item_id: str = None,
        max_results: int = None,
        model: str = None,
        next_token: str = None,
        role: str = None,
        space: str = None,
        task_status: str = None,
        vendor: str = None,
    ):
        # 告警结果状态
        self.alarm_status_shrink = alarm_status_shrink
        # 设备类型
        self.device_type = device_type
        # 主机名
        self.host_name = host_name
        # 设备IP
        self.ip = ip
        # 实例ID
        self.instance_id = instance_id
        # 巡检项ID
        self.item_id = item_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 型号
        self.model = model
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 角色
        self.role = role
        # 物理空间
        self.space = space
        # 巡检状态
        self.task_status = task_status
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_status_shrink is not None:
            result['AlarmStatus'] = self.alarm_status_shrink
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['IP'] = self.ip
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.model is not None:
            result['Model'] = self.model
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.role is not None:
            result['Role'] = self.role
        if self.space is not None:
            result['Space'] = self.space
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmStatus') is not None:
            self.alarm_status_shrink = m.get('AlarmStatus')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListInspectionTasksResponseBodyInspectionTasksInspectionAlarmRules(TeaModel):
    def __init__(
        self,
        actual_value: str = None,
        alarm_expression: str = None,
        alarm_level: str = None,
        alarm_operator: str = None,
        alarm_value: str = None,
    ):
        # 告警实际值
        self.actual_value = actual_value
        # 告警符号
        self.alarm_expression = alarm_expression
        # 告警级别
        self.alarm_level = alarm_level
        # 告警变量
        self.alarm_operator = alarm_operator
        # 告警值
        self.alarm_value = alarm_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_value is not None:
            result['ActualValue'] = self.actual_value
        if self.alarm_expression is not None:
            result['AlarmExpression'] = self.alarm_expression
        if self.alarm_level is not None:
            result['AlarmLevel'] = self.alarm_level
        if self.alarm_operator is not None:
            result['AlarmOperator'] = self.alarm_operator
        if self.alarm_value is not None:
            result['AlarmValue'] = self.alarm_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActualValue') is not None:
            self.actual_value = m.get('ActualValue')
        if m.get('AlarmExpression') is not None:
            self.alarm_expression = m.get('AlarmExpression')
        if m.get('AlarmLevel') is not None:
            self.alarm_level = m.get('AlarmLevel')
        if m.get('AlarmOperator') is not None:
            self.alarm_operator = m.get('AlarmOperator')
        if m.get('AlarmValue') is not None:
            self.alarm_value = m.get('AlarmValue')
        return self


class ListInspectionTasksResponseBodyInspectionTasks(TeaModel):
    def __init__(
        self,
        alarm_status: str = None,
        device_id: str = None,
        device_type: str = None,
        error_code: str = None,
        execution_begin_time: str = None,
        execution_end_time: str = None,
        host_name: str = None,
        ip: str = None,
        inspection_alarm_rules: List[ListInspectionTasksResponseBodyInspectionTasksInspectionAlarmRules] = None,
        inspection_message: str = None,
        inspection_result: str = None,
        item_id: str = None,
        item_name: str = None,
        model: List[str] = None,
        role: str = None,
        script_id: str = None,
        space: str = None,
        task_id: str = None,
        task_status: str = None,
        vendor: str = None,
    ):
        # 告警结果状态
        self.alarm_status = alarm_status
        # 设备ID
        self.device_id = device_id
        # 设备类型
        self.device_type = device_type
        # 错误码
        self.error_code = error_code
        # 巡检开始时间
        self.execution_begin_time = execution_begin_time
        # 巡检结束时间
        self.execution_end_time = execution_end_time
        # 主机名
        self.host_name = host_name
        # IP地址
        self.ip = ip
        # 告警规则
        self.inspection_alarm_rules = inspection_alarm_rules
        # 巡检信息
        self.inspection_message = inspection_message
        # 巡检结果（可能截断）
        self.inspection_result = inspection_result
        # 巡检项ID
        self.item_id = item_id
        # 巡检项名字
        self.item_name = item_name
        # 型号
        self.model = model
        # 角色
        self.role = role
        # 模板ID
        self.script_id = script_id
        # 物理空间
        self.space = space
        # 任务ID
        self.task_id = task_id
        # 任务状态
        self.task_status = task_status
        # 厂商
        self.vendor = vendor

    def validate(self):
        if self.inspection_alarm_rules:
            for k in self.inspection_alarm_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.execution_begin_time is not None:
            result['ExecutionBeginTime'] = self.execution_begin_time
        if self.execution_end_time is not None:
            result['ExecutionEndTime'] = self.execution_end_time
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ip is not None:
            result['IP'] = self.ip
        result['InspectionAlarmRules'] = []
        if self.inspection_alarm_rules is not None:
            for k in self.inspection_alarm_rules:
                result['InspectionAlarmRules'].append(k.to_map() if k else None)
        if self.inspection_message is not None:
            result['InspectionMessage'] = self.inspection_message
        if self.inspection_result is not None:
            result['InspectionResult'] = self.inspection_result
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.model is not None:
            result['Model'] = self.model
        if self.role is not None:
            result['Role'] = self.role
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        if self.space is not None:
            result['Space'] = self.space
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ExecutionBeginTime') is not None:
            self.execution_begin_time = m.get('ExecutionBeginTime')
        if m.get('ExecutionEndTime') is not None:
            self.execution_end_time = m.get('ExecutionEndTime')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        self.inspection_alarm_rules = []
        if m.get('InspectionAlarmRules') is not None:
            for k in m.get('InspectionAlarmRules'):
                temp_model = ListInspectionTasksResponseBodyInspectionTasksInspectionAlarmRules()
                self.inspection_alarm_rules.append(temp_model.from_map(k))
        if m.get('InspectionMessage') is not None:
            self.inspection_message = m.get('InspectionMessage')
        if m.get('InspectionResult') is not None:
            self.inspection_result = m.get('InspectionResult')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        if m.get('Space') is not None:
            self.space = m.get('Space')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListInspectionTasksResponseBody(TeaModel):
    def __init__(
        self,
        inspection_tasks: List[ListInspectionTasksResponseBodyInspectionTasks] = None,
        next_token: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 数组，返回示例目录。
        self.inspection_tasks = inspection_tasks
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 请求ID
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.inspection_tasks:
            for k in self.inspection_tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InspectionTasks'] = []
        if self.inspection_tasks is not None:
            for k in self.inspection_tasks:
                result['InspectionTasks'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.inspection_tasks = []
        if m.get('InspectionTasks') is not None:
            for k in m.get('InspectionTasks'):
                temp_model = ListInspectionTasksResponseBodyInspectionTasks()
                self.inspection_tasks.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListInspectionTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListInspectionTasksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInspectionTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        instance_device_max_count: str = None,
        instance_end_date: str = None,
        instance_id: str = None,
        instance_name: str = None,
        instance_open_date: str = None,
        instance_spec: str = None,
        instance_status: str = None,
    ):
        # 最大纳管设备数量
        self.instance_device_max_count = instance_device_max_count
        # 实例到期时间
        self.instance_end_date = instance_end_date
        # 实例ID
        self.instance_id = instance_id
        # 实例名称
        self.instance_name = instance_name
        # 实例开通时间
        self.instance_open_date = instance_open_date
        # 实例规格
        self.instance_spec = instance_spec
        # 实例状态
        self.instance_status = instance_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_device_max_count is not None:
            result['InstanceDeviceMaxCount'] = self.instance_device_max_count
        if self.instance_end_date is not None:
            result['InstanceEndDate'] = self.instance_end_date
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_open_date is not None:
            result['InstanceOpenDate'] = self.instance_open_date
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.instance_status is not None:
            result['InstanceStatus'] = self.instance_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceDeviceMaxCount') is not None:
            self.instance_device_max_count = m.get('InstanceDeviceMaxCount')
        if m.get('InstanceEndDate') is not None:
            self.instance_end_date = m.get('InstanceEndDate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceOpenDate') is not None:
            self.instance_open_date = m.get('InstanceOpenDate')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('InstanceStatus') is not None:
            self.instance_status = m.get('InstanceStatus')
        return self


class ListInstancesResponseBody(TeaModel):
    def __init__(
        self,
        instances: List[ListInstancesResponseBodyInstances] = None,
        request_id: str = None,
    ):
        # 实例列表
        self.instances = instances
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = ListInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListIpBlocksRequest(TeaModel):
    def __init__(
        self,
        category: str = None,
        instance_id: str = None,
        ip: str = None,
        ip_block_code: str = None,
        max_results: int = None,
        net_business: str = None,
        net_type: str = None,
        next_token: str = None,
        status: str = None,
        sub_net_business: str = None,
        tree_type: bool = None,
        zone_name: str = None,
    ):
        # 地址类别
        self.category = category
        self.instance_id = instance_id
        # IP地址
        self.ip = ip
        # 地址段
        self.ip_block_code = ip_block_code
        # 返回结果的最大个数。
        self.max_results = max_results
        # 公网地址类型，NetType为PUBLIC有效
        self.net_business = net_business
        # 网络类型 PRIVATE PUBLIC
        self.net_type = net_type
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 地址段状态
        self.status = status
        # 业务类型小类
        self.sub_net_business = sub_net_business
        # 是否树状展示地址段
        self.tree_type = tree_type
        # 园区名称，NetType为PUBLIC有效
        self.zone_name = zone_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.ip_block_code is not None:
            result['IpBlockCode'] = self.ip_block_code
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.net_business is not None:
            result['NetBusiness'] = self.net_business
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.status is not None:
            result['Status'] = self.status
        if self.sub_net_business is not None:
            result['SubNetBusiness'] = self.sub_net_business
        if self.tree_type is not None:
            result['TreeType'] = self.tree_type
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('IpBlockCode') is not None:
            self.ip_block_code = m.get('IpBlockCode')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NetBusiness') is not None:
            self.net_business = m.get('NetBusiness')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubNetBusiness') is not None:
            self.sub_net_business = m.get('SubNetBusiness')
        if m.get('TreeType') is not None:
            self.tree_type = m.get('TreeType')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        return self


class ListIpBlocksResponseBodyIpBlockTasksIpList(TeaModel):
    def __init__(
        self,
        dev_id: str = None,
        dev_name: str = None,
        ip: str = None,
        origin: str = None,
        ping: str = None,
    ):
        # 设备ID
        self.dev_id = dev_id
        # 设备名
        self.dev_name = dev_name
        # Ip
        self.ip = ip
        # 来源，SYSTEM表示系统校正
        self.origin = origin
        # Ping
        self.ping = ping

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dev_id is not None:
            result['DevId'] = self.dev_id
        if self.dev_name is not None:
            result['DevName'] = self.dev_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.origin is not None:
            result['Origin'] = self.origin
        if self.ping is not None:
            result['Ping'] = self.ping
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DevId') is not None:
            self.dev_id = m.get('DevId')
        if m.get('DevName') is not None:
            self.dev_name = m.get('DevName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Origin') is not None:
            self.origin = m.get('Origin')
        if m.get('Ping') is not None:
            self.ping = m.get('Ping')
        return self


class ListIpBlocksResponseBodyIpBlockTasks(TeaModel):
    def __init__(
        self,
        domain: str = None,
        gmt_create_time: str = None,
        gmt_modified_time: str = None,
        ip: str = None,
        ip_list: List[ListIpBlocksResponseBodyIpBlockTasksIpList] = None,
        msg: str = None,
        status: str = None,
        task_id: str = None,
        total_ip_count: int = None,
    ):
        # 探针
        self.domain = domain
        # 创建时间
        self.gmt_create_time = gmt_create_time
        # 更新时间
        self.gmt_modified_time = gmt_modified_time
        # Ip
        self.ip = ip
        # IP列表
        self.ip_list = ip_list
        # 错误信息
        self.msg = msg
        # 状态
        self.status = status
        # 任务id
        self.task_id = task_id
        # ip总数
        self.total_ip_count = total_ip_count

    def validate(self):
        if self.ip_list:
            for k in self.ip_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.gmt_create_time is not None:
            result['GmtCreateTime'] = self.gmt_create_time
        if self.gmt_modified_time is not None:
            result['GmtModifiedTime'] = self.gmt_modified_time
        if self.ip is not None:
            result['Ip'] = self.ip
        result['IpList'] = []
        if self.ip_list is not None:
            for k in self.ip_list:
                result['IpList'].append(k.to_map() if k else None)
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.total_ip_count is not None:
            result['TotalIpCount'] = self.total_ip_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('GmtCreateTime') is not None:
            self.gmt_create_time = m.get('GmtCreateTime')
        if m.get('GmtModifiedTime') is not None:
            self.gmt_modified_time = m.get('GmtModifiedTime')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        self.ip_list = []
        if m.get('IpList') is not None:
            for k in m.get('IpList'):
                temp_model = ListIpBlocksResponseBodyIpBlockTasksIpList()
                self.ip_list.append(temp_model.from_map(k))
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TotalIpCount') is not None:
            self.total_ip_count = m.get('TotalIpCount')
        return self


class ListIpBlocksResponseBodyIpBlockZoneLayer(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # 园区层级名称
        self.name = name
        # 园区层级值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListIpBlocksResponseBodyIpBlock(TeaModel):
    def __init__(
        self,
        application: str = None,
        backup_device_name: str = None,
        business_type_id: str = None,
        business_type_name: str = None,
        category: str = None,
        description: str = None,
        device_name: str = None,
        ip_block_code: str = None,
        ip_block_id: str = None,
        ip_blocks: List[str] = None,
        is_lock: int = None,
        limit_zone_types: str = None,
        net_business: str = None,
        net_type: str = None,
        ownership: str = None,
        parent_id: str = None,
        status: str = None,
        sub_business_type_name: str = None,
        tasks: List[ListIpBlocksResponseBodyIpBlockTasks] = None,
        zone_layer: List[ListIpBlocksResponseBodyIpBlockZoneLayer] = None,
        zone_name: str = None,
    ):
        # IP用途
        self.application = application
        # 备份设备名称
        self.backup_device_name = backup_device_name
        # 业务类型UID
        self.business_type_id = business_type_id
        # 业务类型名称
        self.business_type_name = business_type_name
        # 地址类别 IPV4
        self.category = category
        # 备注
        self.description = description
        # 设备名称
        self.device_name = device_name
        # IP段
        self.ip_block_code = ip_block_code
        # IP地址段UID
        self.ip_block_id = ip_block_id
        # 地址段子段列表
        self.ip_blocks = ip_blocks
        # 是否锁定
        self.is_lock = is_lock
        # 限制园区类型
        self.limit_zone_types = limit_zone_types
        # 公网地址类型 INC GUEST VIP
        self.net_business = net_business
        # 公网私网标志 PUBLIC PRIVATE
        self.net_type = net_type
        # IP归属
        self.ownership = ownership
        # 父地址段UID
        self.parent_id = parent_id
        # 状态： using available lock
        self.status = status
        # 业务小类名称
        self.sub_business_type_name = sub_business_type_name
        # 任务集
        self.tasks = tasks
        # 园区层级
        self.zone_layer = zone_layer
        # 园区名称
        self.zone_name = zone_name

    def validate(self):
        if self.tasks:
            for k in self.tasks:
                if k:
                    k.validate()
        if self.zone_layer:
            for k in self.zone_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application is not None:
            result['Application'] = self.application
        if self.backup_device_name is not None:
            result['BackupDeviceName'] = self.backup_device_name
        if self.business_type_id is not None:
            result['BusinessTypeId'] = self.business_type_id
        if self.business_type_name is not None:
            result['BusinessTypeName'] = self.business_type_name
        if self.category is not None:
            result['Category'] = self.category
        if self.description is not None:
            result['Description'] = self.description
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.ip_block_code is not None:
            result['IpBlockCode'] = self.ip_block_code
        if self.ip_block_id is not None:
            result['IpBlockId'] = self.ip_block_id
        if self.ip_blocks is not None:
            result['IpBlocks'] = self.ip_blocks
        if self.is_lock is not None:
            result['IsLock'] = self.is_lock
        if self.limit_zone_types is not None:
            result['LimitZoneTypes'] = self.limit_zone_types
        if self.net_business is not None:
            result['NetBusiness'] = self.net_business
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.ownership is not None:
            result['Ownership'] = self.ownership
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.status is not None:
            result['Status'] = self.status
        if self.sub_business_type_name is not None:
            result['SubBusinessTypeName'] = self.sub_business_type_name
        result['Tasks'] = []
        if self.tasks is not None:
            for k in self.tasks:
                result['Tasks'].append(k.to_map() if k else None)
        result['ZoneLayer'] = []
        if self.zone_layer is not None:
            for k in self.zone_layer:
                result['ZoneLayer'].append(k.to_map() if k else None)
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('BackupDeviceName') is not None:
            self.backup_device_name = m.get('BackupDeviceName')
        if m.get('BusinessTypeId') is not None:
            self.business_type_id = m.get('BusinessTypeId')
        if m.get('BusinessTypeName') is not None:
            self.business_type_name = m.get('BusinessTypeName')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IpBlockCode') is not None:
            self.ip_block_code = m.get('IpBlockCode')
        if m.get('IpBlockId') is not None:
            self.ip_block_id = m.get('IpBlockId')
        if m.get('IpBlocks') is not None:
            self.ip_blocks = m.get('IpBlocks')
        if m.get('IsLock') is not None:
            self.is_lock = m.get('IsLock')
        if m.get('LimitZoneTypes') is not None:
            self.limit_zone_types = m.get('LimitZoneTypes')
        if m.get('NetBusiness') is not None:
            self.net_business = m.get('NetBusiness')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Ownership') is not None:
            self.ownership = m.get('Ownership')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubBusinessTypeName') is not None:
            self.sub_business_type_name = m.get('SubBusinessTypeName')
        self.tasks = []
        if m.get('Tasks') is not None:
            for k in m.get('Tasks'):
                temp_model = ListIpBlocksResponseBodyIpBlockTasks()
                self.tasks.append(temp_model.from_map(k))
        self.zone_layer = []
        if m.get('ZoneLayer') is not None:
            for k in m.get('ZoneLayer'):
                temp_model = ListIpBlocksResponseBodyIpBlockZoneLayer()
                self.zone_layer.append(temp_model.from_map(k))
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        return self


class ListIpBlocksResponseBody(TeaModel):
    def __init__(
        self,
        ip_block: List[ListIpBlocksResponseBodyIpBlock] = None,
        max_results: int = None,
        next_token: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 地址段对象
        self.ip_block = ip_block
        # 每页数量。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.ip_block:
            for k in self.ip_block:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IpBlock'] = []
        if self.ip_block is not None:
            for k in self.ip_block:
                result['IpBlock'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ip_block = []
        if m.get('IpBlock') is not None:
            for k in m.get('IpBlock'):
                temp_model = ListIpBlocksResponseBodyIpBlock()
                self.ip_block.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListIpBlocksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListIpBlocksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListIpBlocksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLinksRequest(TeaModel):
    def __init__(
        self,
        device_name_a: str = None,
        device_name_b: str = None,
        ip_a: str = None,
        ip_b: str = None,
        link_name: str = None,
        link_status: str = None,
        link_type: str = None,
        max_results: int = None,
        next_token: str = None,
        port_a: str = None,
        port_b: str = None,
    ):
        # A端设备名
        self.device_name_a = device_name_a
        # B端设备名
        self.device_name_b = device_name_b
        # A端IP
        self.ip_a = ip_a
        # B端IP
        self.ip_b = ip_b
        # 链路名称
        self.link_name = link_name
        # 链路状态
        self.link_status = link_status
        # 链路类型（单端、双端）
        self.link_type = link_type
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # A端端口名
        self.port_a = port_a
        # B端端口名
        self.port_b = port_b

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name_a is not None:
            result['DeviceNameA'] = self.device_name_a
        if self.device_name_b is not None:
            result['DeviceNameB'] = self.device_name_b
        if self.ip_a is not None:
            result['IpA'] = self.ip_a
        if self.ip_b is not None:
            result['IpB'] = self.ip_b
        if self.link_name is not None:
            result['LinkName'] = self.link_name
        if self.link_status is not None:
            result['LinkStatus'] = self.link_status
        if self.link_type is not None:
            result['LinkType'] = self.link_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.port_a is not None:
            result['PortA'] = self.port_a
        if self.port_b is not None:
            result['PortB'] = self.port_b
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceNameA') is not None:
            self.device_name_a = m.get('DeviceNameA')
        if m.get('DeviceNameB') is not None:
            self.device_name_b = m.get('DeviceNameB')
        if m.get('IpA') is not None:
            self.ip_a = m.get('IpA')
        if m.get('IpB') is not None:
            self.ip_b = m.get('IpB')
        if m.get('LinkName') is not None:
            self.link_name = m.get('LinkName')
        if m.get('LinkStatus') is not None:
            self.link_status = m.get('LinkStatus')
        if m.get('LinkType') is not None:
            self.link_type = m.get('LinkType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PortA') is not None:
            self.port_a = m.get('PortA')
        if m.get('PortB') is not None:
            self.port_b = m.get('PortB')
        return self


class ListLinksResponseBodyContent(TeaModel):
    def __init__(
        self,
        device_name_a: str = None,
        device_name_b: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        idx_a: str = None,
        idx_b: str = None,
        ip_a: str = None,
        ip_b: str = None,
        job_id: str = None,
        link_name: str = None,
        link_no: str = None,
        link_status: str = None,
        link_type: str = None,
        message: str = None,
        port_a: str = None,
        port_b: str = None,
        port_desc_a: str = None,
        port_desc_b: str = None,
        port_status_a: str = None,
        port_status_b: str = None,
        port_type_a: str = None,
        port_type_b: str = None,
        region_id: str = None,
    ):
        # A端设备名
        self.device_name_a = device_name_a
        # B端设备名
        self.device_name_b = device_name_b
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # A端端口索引
        self.idx_a = idx_a
        # B端端口索引
        self.idx_b = idx_b
        # A端IP
        self.ip_a = ip_a
        # B端IP
        self.ip_b = ip_b
        # 链路发现任务
        self.job_id = job_id
        # 链路名称
        self.link_name = link_name
        # 链路编号
        self.link_no = link_no
        # 链路状态
        self.link_status = link_status
        # 链路类型（单端、双端）
        self.link_type = link_type
        # 报错信息或者日志
        self.message = message
        # A端端口名
        self.port_a = port_a
        # B端端口名
        self.port_b = port_b
        # A端描述
        self.port_desc_a = port_desc_a
        # B端描述
        self.port_desc_b = port_desc_b
        # A端端口状态
        self.port_status_a = port_status_a
        # B端端口状态
        self.port_status_b = port_status_b
        # A端端口类型
        self.port_type_a = port_type_a
        # B端端口类型
        self.port_type_b = port_type_b
        # 地域ID
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name_a is not None:
            result['DeviceNameA'] = self.device_name_a
        if self.device_name_b is not None:
            result['DeviceNameB'] = self.device_name_b
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.idx_a is not None:
            result['IdxA'] = self.idx_a
        if self.idx_b is not None:
            result['IdxB'] = self.idx_b
        if self.ip_a is not None:
            result['IpA'] = self.ip_a
        if self.ip_b is not None:
            result['IpB'] = self.ip_b
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.link_name is not None:
            result['LinkName'] = self.link_name
        if self.link_no is not None:
            result['LinkNo'] = self.link_no
        if self.link_status is not None:
            result['LinkStatus'] = self.link_status
        if self.link_type is not None:
            result['LinkType'] = self.link_type
        if self.message is not None:
            result['Message'] = self.message
        if self.port_a is not None:
            result['PortA'] = self.port_a
        if self.port_b is not None:
            result['PortB'] = self.port_b
        if self.port_desc_a is not None:
            result['PortDescA'] = self.port_desc_a
        if self.port_desc_b is not None:
            result['PortDescB'] = self.port_desc_b
        if self.port_status_a is not None:
            result['PortStatusA'] = self.port_status_a
        if self.port_status_b is not None:
            result['PortStatusB'] = self.port_status_b
        if self.port_type_a is not None:
            result['PortTypeA'] = self.port_type_a
        if self.port_type_b is not None:
            result['PortTypeB'] = self.port_type_b
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceNameA') is not None:
            self.device_name_a = m.get('DeviceNameA')
        if m.get('DeviceNameB') is not None:
            self.device_name_b = m.get('DeviceNameB')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('IdxA') is not None:
            self.idx_a = m.get('IdxA')
        if m.get('IdxB') is not None:
            self.idx_b = m.get('IdxB')
        if m.get('IpA') is not None:
            self.ip_a = m.get('IpA')
        if m.get('IpB') is not None:
            self.ip_b = m.get('IpB')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('LinkName') is not None:
            self.link_name = m.get('LinkName')
        if m.get('LinkNo') is not None:
            self.link_no = m.get('LinkNo')
        if m.get('LinkStatus') is not None:
            self.link_status = m.get('LinkStatus')
        if m.get('LinkType') is not None:
            self.link_type = m.get('LinkType')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PortA') is not None:
            self.port_a = m.get('PortA')
        if m.get('PortB') is not None:
            self.port_b = m.get('PortB')
        if m.get('PortDescA') is not None:
            self.port_desc_a = m.get('PortDescA')
        if m.get('PortDescB') is not None:
            self.port_desc_b = m.get('PortDescB')
        if m.get('PortStatusA') is not None:
            self.port_status_a = m.get('PortStatusA')
        if m.get('PortStatusB') is not None:
            self.port_status_b = m.get('PortStatusB')
        if m.get('PortTypeA') is not None:
            self.port_type_a = m.get('PortTypeA')
        if m.get('PortTypeB') is not None:
            self.port_type_b = m.get('PortTypeB')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListLinksResponseBody(TeaModel):
    def __init__(
        self,
        content: List[ListLinksResponseBodyContent] = None,
        next_token: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 数组，返回示例目录。
        self.content = content
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.content:
            for k in self.content:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Content'] = []
        if self.content is not None:
            for k in self.content:
                result['Content'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('Content') is not None:
            for k in m.get('Content'):
                temp_model = ListLinksResponseBodyContent()
                self.content.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListLinksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListLinksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListLinksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLogsRequest(TeaModel):
    def __init__(
        self,
        content: str = None,
        end: int = None,
        instance_id: str = None,
        log_type: str = None,
        max_results: int = None,
        next_token: str = None,
        start: int = None,
    ):
        # 搜索内容
        self.content = content
        # 查询结束时间戳
        self.end = end
        # 实例ID
        self.instance_id = instance_id
        # 日志类型
        self.log_type = log_type
        # 本次读取的最大数据记录数量
        self.max_results = max_results
        # 标记当前开始读取的位置，置空表示从头开始
        self.next_token = next_token
        # 查询开始时间戳
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.end is not None:
            result['End'] = self.end
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.log_type is not None:
            result['LogType'] = self.log_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LogType') is not None:
            self.log_type = m.get('LogType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class ListLogsResponseBodyLogsResourceDevice(TeaModel):
    def __init__(
        self,
        host_name: str = None,
        physical_space: str = None,
    ):
        self.host_name = host_name
        self.physical_space = physical_space

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.physical_space is not None:
            result['PhysicalSpace'] = self.physical_space
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('PhysicalSpace') is not None:
            self.physical_space = m.get('PhysicalSpace')
        return self


class ListLogsResponseBodyLogs(TeaModel):
    def __init__(
        self,
        log: str = None,
        resource_device: ListLogsResponseBodyLogsResourceDevice = None,
        time: str = None,
    ):
        # 日志内容
        self.log = log
        self.resource_device = resource_device
        # 日志时间戳
        self.time = time

    def validate(self):
        if self.resource_device:
            self.resource_device.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log is not None:
            result['Log'] = self.log
        if self.resource_device is not None:
            result['ResourceDevice'] = self.resource_device.to_map()
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Log') is not None:
            self.log = m.get('Log')
        if m.get('ResourceDevice') is not None:
            temp_model = ListLogsResponseBodyLogsResourceDevice()
            self.resource_device = temp_model.from_map(m['ResourceDevice'])
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class ListLogsResponseBody(TeaModel):
    def __init__(
        self,
        logs: List[ListLogsResponseBodyLogs] = None,
        max_results: int = None,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 日志列表
        self.logs = logs
        # MaxResults本次请求所返回的最大记录条数
        self.max_results = max_results
        # 表示当前调用返回读取到的位置，空代表数据已经读取完毕
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # TotalCount本次请求条件下的数据总量，此参数为可选参数，默认可不返回
        self.total_count = total_count

    def validate(self):
        if self.logs:
            for k in self.logs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Logs'] = []
        if self.logs is not None:
            for k in self.logs:
                result['Logs'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.logs = []
        if m.get('Logs') is not None:
            for k in m.get('Logs'):
                temp_model = ListLogsResponseBodyLogs()
                self.logs.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListLogsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListLogsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMonitorDataRequest(TeaModel):
    def __init__(
        self,
        aggregate_data_id: str = None,
        app_id: str = None,
        data_item: str = None,
        data_type: str = None,
        dedicated_line_id: str = None,
        device_id: str = None,
        end: int = None,
        instance_id: str = None,
        key: str = None,
        monitor_item_id: str = None,
        port_collection_id: str = None,
        start: int = None,
    ):
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 应用ID
        self.app_id = app_id
        # 数据项
        self.data_item = data_item
        # 数据类型
        self.data_type = data_type
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 设备ID
        self.device_id = device_id
        # 结束时间
        self.end = end
        # 实例ID
        self.instance_id = instance_id
        # key
        self.key = key
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 开始时间
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.data_item is not None:
            result['DataItem'] = self.data_item
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.end is not None:
            result['End'] = self.end
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.key is not None:
            result['Key'] = self.key
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DataItem') is not None:
            self.data_item = m.get('DataItem')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class ListMonitorDataResponseBodyMonitorData(TeaModel):
    def __init__(
        self,
        data_item: str = None,
        key: str = None,
        timestamp: int = None,
        value: str = None,
    ):
        # 数据项
        self.data_item = data_item
        # key
        self.key = key
        # 时间戳
        self.timestamp = timestamp
        # 数值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_item is not None:
            result['DataItem'] = self.data_item
        if self.key is not None:
            result['Key'] = self.key
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataItem') is not None:
            self.data_item = m.get('DataItem')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListMonitorDataResponseBody(TeaModel):
    def __init__(
        self,
        monitor_data: List[ListMonitorDataResponseBodyMonitorData] = None,
        request_id: str = None,
    ):
        # 数据列表
        self.monitor_data = monitor_data
        # Request Id
        self.request_id = request_id

    def validate(self):
        if self.monitor_data:
            for k in self.monitor_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MonitorData'] = []
        if self.monitor_data is not None:
            for k in self.monitor_data:
                result['MonitorData'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.monitor_data = []
        if m.get('MonitorData') is not None:
            for k in m.get('MonitorData'):
                temp_model = ListMonitorDataResponseBodyMonitorData()
                self.monitor_data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListMonitorDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListMonitorDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListMonitorDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListNotificationHistoriesRequest(TeaModel):
    def __init__(
        self,
        aggregate_data_id: str = None,
        alarm_status: str = None,
        app_id: str = None,
        dedicated_line_id: str = None,
        device_id: str = None,
        end: int = None,
        instance_id: str = None,
        max_results: int = None,
        message: str = None,
        monitor_item_id: str = None,
        next_token: str = None,
        notification_group_id: str = None,
        notification_mode: str = None,
        physical_space_id: str = None,
        port_collection_id: str = None,
        start: int = None,
        status: str = None,
        type: str = None,
    ):
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 监控状态
        self.alarm_status = alarm_status
        # 应用ID
        self.app_id = app_id
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 设备ID
        self.device_id = device_id
        # 查询结束时间戳
        self.end = end
        # 实例ID
        self.instance_id = instance_id
        # 本次读取的最大数据记录数量
        self.max_results = max_results
        # 发送内容
        self.message = message
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 标记当前开始读取的位置，置空表示从头开始
        self.next_token = next_token
        # 通知组ID
        self.notification_group_id = notification_group_id
        # 发送方式
        self.notification_mode = notification_mode
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 查询开始时间戳
        self.start = start
        # 发送状态
        self.status = status
        # 类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.end is not None:
            result['End'] = self.end
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.message is not None:
            result['Message'] = self.message
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.notification_group_id is not None:
            result['NotificationGroupId'] = self.notification_group_id
        if self.notification_mode is not None:
            result['NotificationMode'] = self.notification_mode
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.start is not None:
            result['Start'] = self.start
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('NotificationGroupId') is not None:
            self.notification_group_id = m.get('NotificationGroupId')
        if m.get('NotificationMode') is not None:
            self.notification_mode = m.get('NotificationMode')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListNotificationHistoriesResponseBodyNotificationHistories(TeaModel):
    def __init__(
        self,
        aggregate_data_id: str = None,
        alarm_status: str = None,
        app_id: str = None,
        dedicated_line_id: str = None,
        device_id: str = None,
        message: str = None,
        monitor_item_id: str = None,
        notification_group_id: str = None,
        notification_group_name: str = None,
        notification_mode: str = None,
        output: str = None,
        port_collection_id: str = None,
        status: str = None,
        time: str = None,
    ):
        # 聚合数据ID
        self.aggregate_data_id = aggregate_data_id
        # 监控状态
        self.alarm_status = alarm_status
        # 应用ID
        self.app_id = app_id
        # 专线ID
        self.dedicated_line_id = dedicated_line_id
        # 设备ID
        self.device_id = device_id
        # 发送内容
        self.message = message
        # 监控项ID
        self.monitor_item_id = monitor_item_id
        # 通知组ID
        self.notification_group_id = notification_group_id
        # 通知组名称
        self.notification_group_name = notification_group_name
        # 发送方式
        self.notification_mode = notification_mode
        # 输出内容
        self.output = output
        # 端口集ID
        self.port_collection_id = port_collection_id
        # 发送状态
        self.status = status
        # 发送时间
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate_data_id is not None:
            result['AggregateDataId'] = self.aggregate_data_id
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.message is not None:
            result['Message'] = self.message
        if self.monitor_item_id is not None:
            result['MonitorItemId'] = self.monitor_item_id
        if self.notification_group_id is not None:
            result['NotificationGroupId'] = self.notification_group_id
        if self.notification_group_name is not None:
            result['NotificationGroupName'] = self.notification_group_name
        if self.notification_mode is not None:
            result['NotificationMode'] = self.notification_mode
        if self.output is not None:
            result['Output'] = self.output
        if self.port_collection_id is not None:
            result['PortCollectionId'] = self.port_collection_id
        if self.status is not None:
            result['Status'] = self.status
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AggregateDataId') is not None:
            self.aggregate_data_id = m.get('AggregateDataId')
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MonitorItemId') is not None:
            self.monitor_item_id = m.get('MonitorItemId')
        if m.get('NotificationGroupId') is not None:
            self.notification_group_id = m.get('NotificationGroupId')
        if m.get('NotificationGroupName') is not None:
            self.notification_group_name = m.get('NotificationGroupName')
        if m.get('NotificationMode') is not None:
            self.notification_mode = m.get('NotificationMode')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('PortCollectionId') is not None:
            self.port_collection_id = m.get('PortCollectionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class ListNotificationHistoriesResponseBody(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        notification_histories: List[ListNotificationHistoriesResponseBodyNotificationHistories] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # MaxResults本次请求所返回的最大记录条数
        self.max_results = max_results
        # 表示当前调用返回读取到的位置，空代表数据已经读取完毕
        self.next_token = next_token
        # 数据列表
        self.notification_histories = notification_histories
        # request Id
        self.request_id = request_id
        # TotalCount本次请求条件下的数据总量，此参数为可选参数，默认可不返回
        self.total_count = total_count

    def validate(self):
        if self.notification_histories:
            for k in self.notification_histories:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['NotificationHistories'] = []
        if self.notification_histories is not None:
            for k in self.notification_histories:
                result['NotificationHistories'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.notification_histories = []
        if m.get('NotificationHistories') is not None:
            for k in m.get('NotificationHistories'):
                temp_model = ListNotificationHistoriesResponseBodyNotificationHistories()
                self.notification_histories.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListNotificationHistoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListNotificationHistoriesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListNotificationHistoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOsVersionsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListOsVersionsResponseBodyOsVersion(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        file_name: str = None,
        file_path: str = None,
        model: str = None,
        os_version: str = None,
        os_version_id: str = None,
        status: str = None,
        update_time: str = None,
        vendor: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 文件名
        self.file_name = file_name
        # 文件路径
        self.file_path = file_path
        # 型号
        self.model = model
        # 系统版本
        self.os_version = os_version
        # 资源uuid
        self.os_version_id = os_version_id
        # 状态
        self.status = status
        # 修改时间
        self.update_time = update_time
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.model is not None:
            result['Model'] = self.model
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.os_version_id is not None:
            result['OsVersionId'] = self.os_version_id
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('OsVersionId') is not None:
            self.os_version_id = m.get('OsVersionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListOsVersionsResponseBody(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: int = None,
        os_version: List[ListOsVersionsResponseBodyOsVersion] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 本次读取的最大数据量
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 数组，返回示例目录。
        self.os_version = os_version
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.os_version:
            for k in self.os_version:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['OsVersion'] = []
        if self.os_version is not None:
            for k in self.os_version:
                result['OsVersion'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.os_version = []
        if m.get('OsVersion') is not None:
            for k in m.get('OsVersion'):
                temp_model = ListOsVersionsResponseBodyOsVersion()
                self.os_version.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListOsVersionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListOsVersionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOsVersionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListPhysicalSpacesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        physical_space_ids: List[str] = None,
        physical_space_name: str = None,
    ):
        # 实例ID
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 物理空间ID
        self.physical_space_ids = physical_space_ids
        # 物理空间名称，支持模糊搜索。
        self.physical_space_name = physical_space_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.physical_space_ids is not None:
            result['PhysicalSpaceIds'] = self.physical_space_ids
        if self.physical_space_name is not None:
            result['PhysicalSpaceName'] = self.physical_space_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PhysicalSpaceIds') is not None:
            self.physical_space_ids = m.get('PhysicalSpaceIds')
        if m.get('PhysicalSpaceName') is not None:
            self.physical_space_name = m.get('PhysicalSpaceName')
        return self


class ListPhysicalSpacesResponseBodyPhysicalSpaces(TeaModel):
    def __init__(
        self,
        address: str = None,
        city: str = None,
        country: str = None,
        instance: str = None,
        owner: str = None,
        physical_space_id: str = None,
        physical_space_name: str = None,
        province: str = None,
        remark: str = None,
        space_abbreviation: str = None,
        space_type: str = None,
    ):
        # 具体地址
        self.address = address
        # 所属城市
        self.city = city
        # 所属国家
        self.country = country
        # 实例
        self.instance = instance
        # 负责人
        self.owner = owner
        # 物理空间ID
        self.physical_space_id = physical_space_id
        # 物理空间名称
        self.physical_space_name = physical_space_name
        # 所属省份
        self.province = province
        # 备注
        self.remark = remark
        # 缩写
        self.space_abbreviation = space_abbreviation
        # 模型
        self.space_type = space_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.city is not None:
            result['City'] = self.city
        if self.country is not None:
            result['Country'] = self.country
        if self.instance is not None:
            result['Instance'] = self.instance
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.physical_space_name is not None:
            result['PhysicalSpaceName'] = self.physical_space_name
        if self.province is not None:
            result['Province'] = self.province
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.space_abbreviation is not None:
            result['SpaceAbbreviation'] = self.space_abbreviation
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('PhysicalSpaceId') is not None:
            self.physical_space_id = m.get('PhysicalSpaceId')
        if m.get('PhysicalSpaceName') is not None:
            self.physical_space_name = m.get('PhysicalSpaceName')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('SpaceAbbreviation') is not None:
            self.space_abbreviation = m.get('SpaceAbbreviation')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        return self


class ListPhysicalSpacesResponseBody(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: int = None,
        physical_spaces: List[ListPhysicalSpacesResponseBodyPhysicalSpaces] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 每页数量。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 数组，返回示例目录。
        self.physical_spaces = physical_spaces
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.physical_spaces:
            for k in self.physical_spaces:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['PhysicalSpaces'] = []
        if self.physical_spaces is not None:
            for k in self.physical_spaces:
                result['PhysicalSpaces'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.physical_spaces = []
        if m.get('PhysicalSpaces') is not None:
            for k in m.get('PhysicalSpaces'):
                temp_model = ListPhysicalSpacesResponseBodyPhysicalSpaces()
                self.physical_spaces.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListPhysicalSpacesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListPhysicalSpacesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListPhysicalSpacesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRegionsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListRegionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListResourceInformationsRequest(TeaModel):
    def __init__(
        self,
        architecture_id: str = None,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # 架构id
        self.architecture_id = architecture_id
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture_id is not None:
            result['ArchitectureId'] = self.architecture_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArchitectureId') is not None:
            self.architecture_id = m.get('ArchitectureId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListResourceInformationsResponseBodyResourceInformationInformation(TeaModel):
    def __init__(
        self,
        key: str = None,
        key_action: str = None,
        key_attribute: str = None,
        key_description: str = None,
    ):
        # 键
        self.key = key
        # 键动作
        self.key_action = key_action
        # 键属性
        self.key_attribute = key_attribute
        # 键描述
        self.key_description = key_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.key_action is not None:
            result['KeyAction'] = self.key_action
        if self.key_attribute is not None:
            result['KeyAttribute'] = self.key_attribute
        if self.key_description is not None:
            result['KeyDescription'] = self.key_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyAction') is not None:
            self.key_action = m.get('KeyAction')
        if m.get('KeyAttribute') is not None:
            self.key_attribute = m.get('KeyAttribute')
        if m.get('KeyDescription') is not None:
            self.key_description = m.get('KeyDescription')
        return self


class ListResourceInformationsResponseBodyResourceInformation(TeaModel):
    def __init__(
        self,
        information: List[ListResourceInformationsResponseBodyResourceInformationInformation] = None,
        resource_attribute: str = None,
        resource_information_id: str = None,
        resource_type: str = None,
    ):
        # 信息
        self.information = information
        # 资源属性
        self.resource_attribute = resource_attribute
        # 资源一级ID
        self.resource_information_id = resource_information_id
        # 资源类型
        self.resource_type = resource_type

    def validate(self):
        if self.information:
            for k in self.information:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Information'] = []
        if self.information is not None:
            for k in self.information:
                result['Information'].append(k.to_map() if k else None)
        if self.resource_attribute is not None:
            result['ResourceAttribute'] = self.resource_attribute
        if self.resource_information_id is not None:
            result['ResourceInformationId'] = self.resource_information_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.information = []
        if m.get('Information') is not None:
            for k in m.get('Information'):
                temp_model = ListResourceInformationsResponseBodyResourceInformationInformation()
                self.information.append(temp_model.from_map(k))
        if m.get('ResourceAttribute') is not None:
            self.resource_attribute = m.get('ResourceAttribute')
        if m.get('ResourceInformationId') is not None:
            self.resource_information_id = m.get('ResourceInformationId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class ListResourceInformationsResponseBody(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: int = None,
        request_id: str = None,
        resource_information: List[ListResourceInformationsResponseBodyResourceInformation] = None,
        total_count: int = None,
    ):
        # 本次读取的最大数据量
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 数组，返回示例目录。
        self.resource_information = resource_information
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.resource_information:
            for k in self.resource_information:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ResourceInformation'] = []
        if self.resource_information is not None:
            for k in self.resource_information:
                result['ResourceInformation'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.resource_information = []
        if m.get('ResourceInformation') is not None:
            for k in m.get('ResourceInformation'):
                temp_model = ListResourceInformationsResponseBodyResourceInformation()
                self.resource_information.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListResourceInformationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListResourceInformationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListResourceInformationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListResourceInstancesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        setup_project_id: str = None,
    ):
        self.instance_id = instance_id
        # 建设项目资源id
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class ListResourceInstancesResponseBodyLogicResourceKeyList(TeaModel):
    def __init__(
        self,
        key: str = None,
        key_action: str = None,
        key_attribute: str = None,
        key_description: str = None,
        value: str = None,
    ):
        self.key = key
        self.key_action = key_action
        self.key_attribute = key_attribute
        self.key_description = key_description
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.key_action is not None:
            result['KeyAction'] = self.key_action
        if self.key_attribute is not None:
            result['KeyAttribute'] = self.key_attribute
        if self.key_description is not None:
            result['KeyDescription'] = self.key_description
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyAction') is not None:
            self.key_action = m.get('KeyAction')
        if m.get('KeyAttribute') is not None:
            self.key_attribute = m.get('KeyAttribute')
        if m.get('KeyDescription') is not None:
            self.key_description = m.get('KeyDescription')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListResourceInstancesResponseBodyLogicResource(TeaModel):
    def __init__(
        self,
        key_list: List[ListResourceInstancesResponseBodyLogicResourceKeyList] = None,
        resource_attribute: str = None,
        resource_type: str = None,
    ):
        self.key_list = key_list
        self.resource_attribute = resource_attribute
        self.resource_type = resource_type

    def validate(self):
        if self.key_list:
            for k in self.key_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['KeyList'] = []
        if self.key_list is not None:
            for k in self.key_list:
                result['KeyList'].append(k.to_map() if k else None)
        if self.resource_attribute is not None:
            result['ResourceAttribute'] = self.resource_attribute
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.key_list = []
        if m.get('KeyList') is not None:
            for k in m.get('KeyList'):
                temp_model = ListResourceInstancesResponseBodyLogicResourceKeyList()
                self.key_list.append(temp_model.from_map(k))
        if m.get('ResourceAttribute') is not None:
            self.resource_attribute = m.get('ResourceAttribute')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class ListResourceInstancesResponseBody(TeaModel):
    def __init__(
        self,
        logic_resource: List[ListResourceInstancesResponseBodyLogicResource] = None,
        request_id: str = None,
    ):
        self.logic_resource = logic_resource
        # 请求id
        self.request_id = request_id

    def validate(self):
        if self.logic_resource:
            for k in self.logic_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LogicResource'] = []
        if self.logic_resource is not None:
            for k in self.logic_resource:
                result['LogicResource'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.logic_resource = []
        if m.get('LogicResource') is not None:
            for k in m.get('LogicResource'):
                temp_model = ListResourceInstancesResponseBodyLogicResource()
                self.logic_resource.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListResourceInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListResourceInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListResourceInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListResourceTypesResponseBodyResourceType(TeaModel):
    def __init__(
        self,
        key: str = None,
        resource_type: str = None,
        resource_type_name: str = None,
    ):
        self.key = key
        # 资源类型
        self.resource_type = resource_type
        # 资源名称
        self.resource_type_name = resource_type_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_type_name is not None:
            result['ResourceTypeName'] = self.resource_type_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceTypeName') is not None:
            self.resource_type_name = m.get('ResourceTypeName')
        return self


class ListResourceTypesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_type: List[ListResourceTypesResponseBodyResourceType] = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 资源类型
        self.resource_type = resource_type

    def validate(self):
        if self.resource_type:
            for k in self.resource_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ResourceType'] = []
        if self.resource_type is not None:
            for k in self.resource_type:
                result['ResourceType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.resource_type = []
        if m.get('ResourceType') is not None:
            for k in m.get('ResourceType'):
                temp_model = ListResourceTypesResponseBodyResourceType()
                self.resource_type.append(temp_model.from_map(k))
        return self


class ListResourceTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListResourceTypesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListResourceTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSetupProjectsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        space_id: str = None,
        status: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 物理空间id
        self.space_id = space_id
        # 集群名
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListSetupProjectsResponseBodySetupProjectPackages(TeaModel):
    def __init__(
        self,
        device_number: int = None,
        model: str = None,
        role: str = None,
        vendor: str = None,
    ):
        # 设备号
        self.device_number = device_number
        # 型号
        self.model = model
        # 角色
        self.role = role
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_number is not None:
            result['DeviceNumber'] = self.device_number
        if self.model is not None:
            result['Model'] = self.model
        if self.role is not None:
            result['Role'] = self.role
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceNumber') is not None:
            self.device_number = m.get('DeviceNumber')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class ListSetupProjectsResponseBodySetupProject(TeaModel):
    def __init__(
        self,
        arch_version: str = None,
        architecture_id: str = None,
        create_time: str = None,
        delivery_time: str = None,
        description: str = None,
        nodes: str = None,
        packages: List[ListSetupProjectsResponseBodySetupProjectPackages] = None,
        progress: str = None,
        setup_project_id: str = None,
        space_id: str = None,
        space_name: str = None,
        space_type: str = None,
    ):
        # 架构版本
        self.arch_version = arch_version
        # 架构id
        self.architecture_id = architecture_id
        # 创建时间
        self.create_time = create_time
        # 预计交付时间
        self.delivery_time = delivery_time
        # 描述
        self.description = description
        # 节点
        self.nodes = nodes
        # 套餐
        self.packages = packages
        # 项目进展
        self.progress = progress
        # 资源一级ID
        self.setup_project_id = setup_project_id
        # 物理空间uId
        self.space_id = space_id
        # 物理空间名称
        self.space_name = space_name
        # 物理空间类型
        self.space_type = space_type

    def validate(self):
        if self.packages:
            for k in self.packages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arch_version is not None:
            result['ArchVersion'] = self.arch_version
        if self.architecture_id is not None:
            result['ArchitectureId'] = self.architecture_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.delivery_time is not None:
            result['DeliveryTime'] = self.delivery_time
        if self.description is not None:
            result['Description'] = self.description
        if self.nodes is not None:
            result['Nodes'] = self.nodes
        result['Packages'] = []
        if self.packages is not None:
            for k in self.packages:
                result['Packages'].append(k.to_map() if k else None)
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        if self.space_id is not None:
            result['SpaceId'] = self.space_id
        if self.space_name is not None:
            result['SpaceName'] = self.space_name
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArchVersion') is not None:
            self.arch_version = m.get('ArchVersion')
        if m.get('ArchitectureId') is not None:
            self.architecture_id = m.get('ArchitectureId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeliveryTime') is not None:
            self.delivery_time = m.get('DeliveryTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Nodes') is not None:
            self.nodes = m.get('Nodes')
        self.packages = []
        if m.get('Packages') is not None:
            for k in m.get('Packages'):
                temp_model = ListSetupProjectsResponseBodySetupProjectPackages()
                self.packages.append(temp_model.from_map(k))
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        if m.get('SpaceId') is not None:
            self.space_id = m.get('SpaceId')
        if m.get('SpaceName') is not None:
            self.space_name = m.get('SpaceName')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        return self


class ListSetupProjectsResponseBody(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: int = None,
        request_id: str = None,
        setup_project: List[ListSetupProjectsResponseBodySetupProject] = None,
        total_count: int = None,
    ):
        # 本次读取的最大数据量
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 数组，返回示例目录。
        self.setup_project = setup_project
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.setup_project:
            for k in self.setup_project:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SetupProject'] = []
        if self.setup_project is not None:
            for k in self.setup_project:
                result['SetupProject'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.setup_project = []
        if m.get('SetupProject') is not None:
            for k in m.get('SetupProject'):
                temp_model = ListSetupProjectsResponseBodySetupProject()
                self.setup_project.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListSetupProjectsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListSetupProjectsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListSetupProjectsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSpaceModelsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        space_type: str = None,
        status: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 物理空间类型
        self.space_type = space_type
        # 物理空间状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListSpaceModelsResponseBodySpaceModelSort(TeaModel):
    def __init__(
        self,
        level: int = None,
        level_name: str = None,
    ):
        # 层级
        self.level = level
        # 层级名称
        self.level_name = level_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.level_name is not None:
            result['LevelName'] = self.level_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LevelName') is not None:
            self.level_name = m.get('LevelName')
        return self


class ListSpaceModelsResponseBodySpaceModel(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        sort: List[ListSpaceModelsResponseBodySpaceModelSort] = None,
        space_model_id: str = None,
        space_type: str = None,
        status: str = None,
        update_time: str = None,
    ):
        # 创建时间
        self.create_time = create_time
        # 层级
        self.sort = sort
        # 资源一级ID
        self.space_model_id = space_model_id
        # 物理空间类型
        self.space_type = space_type
        # 模型状态
        self.status = status
        # 更新时间
        self.update_time = update_time

    def validate(self):
        if self.sort:
            for k in self.sort:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['Sort'] = []
        if self.sort is not None:
            for k in self.sort:
                result['Sort'].append(k.to_map() if k else None)
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        if self.space_type is not None:
            result['SpaceType'] = self.space_type
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.sort = []
        if m.get('Sort') is not None:
            for k in m.get('Sort'):
                temp_model = ListSpaceModelsResponseBodySpaceModelSort()
                self.sort.append(temp_model.from_map(k))
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        if m.get('SpaceType') is not None:
            self.space_type = m.get('SpaceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class ListSpaceModelsResponseBody(TeaModel):
    def __init__(
        self,
        max_results: int = None,
        next_token: str = None,
        request_id: str = None,
        space_model: List[ListSpaceModelsResponseBodySpaceModel] = None,
        total_count: int = None,
    ):
        # 本次读取的最大数据量
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 数组，返回示例目录。
        self.space_model = space_model
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.space_model:
            for k in self.space_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SpaceModel'] = []
        if self.space_model is not None:
            for k in self.space_model:
                result['SpaceModel'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.space_model = []
        if m.get('SpaceModel') is not None:
            for k in m.get('SpaceModel'):
                temp_model = ListSpaceModelsResponseBodySpaceModel()
                self.space_model.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListSpaceModelsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListSpaceModelsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListSpaceModelsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTasksHistoriesRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        instance_id: str = None,
        item_id: str = None,
        max_results: int = None,
        next_token: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 实例ID
        self.instance_id = instance_id
        # 巡检项ID
        self.item_id = item_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListTasksHistoriesResponseBodyInspectionTasksInspectionAlarmRules(TeaModel):
    def __init__(
        self,
        actual_value: str = None,
        alarm_expression: str = None,
        alarm_level: str = None,
        alarm_operator: str = None,
        alarm_value: str = None,
    ):
        # 告警实际值
        self.actual_value = actual_value
        # 告警表达式
        self.alarm_expression = alarm_expression
        # 告警级别
        self.alarm_level = alarm_level
        # 告警操作符
        self.alarm_operator = alarm_operator
        # 告警值
        self.alarm_value = alarm_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_value is not None:
            result['ActualValue'] = self.actual_value
        if self.alarm_expression is not None:
            result['AlarmExpression'] = self.alarm_expression
        if self.alarm_level is not None:
            result['AlarmLevel'] = self.alarm_level
        if self.alarm_operator is not None:
            result['AlarmOperator'] = self.alarm_operator
        if self.alarm_value is not None:
            result['AlarmValue'] = self.alarm_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActualValue') is not None:
            self.actual_value = m.get('ActualValue')
        if m.get('AlarmExpression') is not None:
            self.alarm_expression = m.get('AlarmExpression')
        if m.get('AlarmLevel') is not None:
            self.alarm_level = m.get('AlarmLevel')
        if m.get('AlarmOperator') is not None:
            self.alarm_operator = m.get('AlarmOperator')
        if m.get('AlarmValue') is not None:
            self.alarm_value = m.get('AlarmValue')
        return self


class ListTasksHistoriesResponseBodyInspectionTasks(TeaModel):
    def __init__(
        self,
        execution_begin_time: str = None,
        execution_end_time: str = None,
        inspection_alarm_rules: List[ListTasksHistoriesResponseBodyInspectionTasksInspectionAlarmRules] = None,
        inspection_result: str = None,
        task_id: str = None,
    ):
        # 巡检开始时间
        self.execution_begin_time = execution_begin_time
        # 巡检结束时间
        self.execution_end_time = execution_end_time
        # 告警规则
        self.inspection_alarm_rules = inspection_alarm_rules
        # 巡检结果
        self.inspection_result = inspection_result
        # 任务ID
        self.task_id = task_id

    def validate(self):
        if self.inspection_alarm_rules:
            for k in self.inspection_alarm_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.execution_begin_time is not None:
            result['ExecutionBeginTime'] = self.execution_begin_time
        if self.execution_end_time is not None:
            result['ExecutionEndTime'] = self.execution_end_time
        result['InspectionAlarmRules'] = []
        if self.inspection_alarm_rules is not None:
            for k in self.inspection_alarm_rules:
                result['InspectionAlarmRules'].append(k.to_map() if k else None)
        if self.inspection_result is not None:
            result['InspectionResult'] = self.inspection_result
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExecutionBeginTime') is not None:
            self.execution_begin_time = m.get('ExecutionBeginTime')
        if m.get('ExecutionEndTime') is not None:
            self.execution_end_time = m.get('ExecutionEndTime')
        self.inspection_alarm_rules = []
        if m.get('InspectionAlarmRules') is not None:
            for k in m.get('InspectionAlarmRules'):
                temp_model = ListTasksHistoriesResponseBodyInspectionTasksInspectionAlarmRules()
                self.inspection_alarm_rules.append(temp_model.from_map(k))
        if m.get('InspectionResult') is not None:
            self.inspection_result = m.get('InspectionResult')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ListTasksHistoriesResponseBody(TeaModel):
    def __init__(
        self,
        inspection_tasks: List[ListTasksHistoriesResponseBodyInspectionTasks] = None,
        next_token: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # 数组，返回示例目录。
        self.inspection_tasks = inspection_tasks
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 请求ID
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.inspection_tasks:
            for k in self.inspection_tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InspectionTasks'] = []
        if self.inspection_tasks is not None:
            for k in self.inspection_tasks:
                result['InspectionTasks'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.inspection_tasks = []
        if m.get('InspectionTasks') is not None:
            for k in m.get('InspectionTasks'):
                temp_model = ListTasksHistoriesResponseBodyInspectionTasks()
                self.inspection_tasks.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListTasksHistoriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListTasksHistoriesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTasksHistoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListWorkOrdersRequest(TeaModel):
    def __init__(
        self,
        device_sn_a: str = None,
        instance_id: str = None,
        max_results: str = None,
        next_token: str = None,
        work_order_source: str = None,
        work_order_step: str = None,
        work_order_title: str = None,
    ):
        # A-设备SN
        self.device_sn_a = device_sn_a
        # 实例ID
        self.instance_id = instance_id
        # 返回结果的最大个数。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # 工单来源
        self.work_order_source = work_order_source
        # 工单状态
        self.work_order_step = work_order_step
        # 工单标题
        self.work_order_title = work_order_title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_sn_a is not None:
            result['DeviceSnA'] = self.device_sn_a
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.work_order_source is not None:
            result['WorkOrderSource'] = self.work_order_source
        if self.work_order_step is not None:
            result['WorkOrderStep'] = self.work_order_step
        if self.work_order_title is not None:
            result['WorkOrderTitle'] = self.work_order_title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceSnA') is not None:
            self.device_sn_a = m.get('DeviceSnA')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('WorkOrderSource') is not None:
            self.work_order_source = m.get('WorkOrderSource')
        if m.get('WorkOrderStep') is not None:
            self.work_order_step = m.get('WorkOrderStep')
        if m.get('WorkOrderTitle') is not None:
            self.work_order_title = m.get('WorkOrderTitle')
        return self


class ListWorkOrdersResponseBodyContentWorkOrderOperationDtos(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        operation: str = None,
        operation_id: str = None,
        operator: str = None,
        remark: str = None,
        work_order_id: str = None,
    ):
        # 创建时间
        self.gmt_create = gmt_create
        # 操作
        self.operation = operation
        # 操作编号
        self.operation_id = operation_id
        # 操作人
        self.operator = operator
        # 备注
        self.remark = remark
        # 工单编号
        self.work_order_id = work_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.operation is not None:
            result['Operation'] = self.operation
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.work_order_id is not None:
            result['WorkOrderId'] = self.work_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Operation') is not None:
            self.operation = m.get('Operation')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('WorkOrderId') is not None:
            self.work_order_id = m.get('WorkOrderId')
        return self


class ListWorkOrdersResponseBodyContent(TeaModel):
    def __init__(
        self,
        alarm_happen_time: str = None,
        alarm_recover_time: str = None,
        alarm_related: str = None,
        area: str = None,
        circuit_id: str = None,
        circuit_name: str = None,
        circuit_type: str = None,
        device_alarm_info: str = None,
        device_ip: str = None,
        device_ip_a: str = None,
        device_ip_b: str = None,
        device_model_a: str = None,
        device_model_b: str = None,
        device_name: str = None,
        device_name_a: str = None,
        device_name_b: str = None,
        device_port_a: str = None,
        device_port_b: str = None,
        device_sn_a: str = None,
        device_sn_b: str = None,
        device_type: str = None,
        device_vendor: str = None,
        device_vendor_a: str = None,
        device_vendor_b: str = None,
        emergency_degree: str = None,
        extra: str = None,
        fault_duration: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        hang_file_name: str = None,
        hang_file_path: str = None,
        hang_reason: str = None,
        impact_business: str = None,
        incident_description: str = None,
        incident_sub_type: str = None,
        incident_type: str = None,
        liable_man: str = None,
        link_man: str = None,
        original_subject_alarm: str = None,
        process_limited: str = None,
        process_man: str = None,
        process_man_id: str = None,
        process_result: str = None,
        skill_groups: str = None,
        timeout: str = None,
        work_order_id: str = None,
        work_order_operation_dtos: List[ListWorkOrdersResponseBodyContentWorkOrderOperationDtos] = None,
        work_order_source: str = None,
        work_order_step: str = None,
        work_order_title: str = None,
        work_order_type: str = None,
    ):
        # 告警发生时间
        self.alarm_happen_time = alarm_happen_time
        # 告警恢复时间
        self.alarm_recover_time = alarm_recover_time
        # 关联告警项
        self.alarm_related = alarm_related
        # 区域
        self.area = area
        # 电路编码
        self.circuit_id = circuit_id
        # 电路名
        self.circuit_name = circuit_name
        # 电路类型
        self.circuit_type = circuit_type
        # 设备告警信息
        self.device_alarm_info = device_alarm_info
        # 设备IP
        self.device_ip = device_ip
        # A-IP
        self.device_ip_a = device_ip_a
        # B-IP
        self.device_ip_b = device_ip_b
        # A-设备型号
        self.device_model_a = device_model_a
        # B-设备型号
        self.device_model_b = device_model_b
        # 设备名
        self.device_name = device_name
        # A-设备名
        self.device_name_a = device_name_a
        # B-设备名
        self.device_name_b = device_name_b
        # A-端口
        self.device_port_a = device_port_a
        # B-端口
        self.device_port_b = device_port_b
        # A-设备SN
        self.device_sn_a = device_sn_a
        # B-设备SN
        self.device_sn_b = device_sn_b
        # 设备类型
        self.device_type = device_type
        # 设备厂家
        self.device_vendor = device_vendor
        # A-厂家
        self.device_vendor_a = device_vendor_a
        # B-厂家
        self.device_vendor_b = device_vendor_b
        # 紧急程度
        self.emergency_degree = emergency_degree
        # 额外字段
        self.extra = extra
        # 故障时常(时)
        self.fault_duration = fault_duration
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # 文件名称
        self.hang_file_name = hang_file_name
        # 文件路径
        self.hang_file_path = hang_file_path
        # 挂起/转交原因
        self.hang_reason = hang_reason
        # 是否影响业务
        self.impact_business = impact_business
        # 问题描述
        self.incident_description = incident_description
        # 故障小类
        self.incident_sub_type = incident_sub_type
        # 故障分类
        self.incident_type = incident_type
        # 责任人
        self.liable_man = liable_man
        # 用户/联系人
        self.link_man = link_man
        # 告警源主体
        self.original_subject_alarm = original_subject_alarm
        # 处理时限
        self.process_limited = process_limited
        # 处理人
        self.process_man = process_man
        # 处理人编号
        self.process_man_id = process_man_id
        # 处理结果
        self.process_result = process_result
        # 技能组
        self.skill_groups = skill_groups
        # 是否超时
        self.timeout = timeout
        # 工单编号
        self.work_order_id = work_order_id
        # 操作流水
        self.work_order_operation_dtos = work_order_operation_dtos
        # 工单来源
        self.work_order_source = work_order_source
        # 工单状态
        self.work_order_step = work_order_step
        # 工单编号
        self.work_order_title = work_order_title
        # 工单类型
        self.work_order_type = work_order_type

    def validate(self):
        if self.work_order_operation_dtos:
            for k in self.work_order_operation_dtos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_happen_time is not None:
            result['AlarmHappenTime'] = self.alarm_happen_time
        if self.alarm_recover_time is not None:
            result['AlarmRecoverTime'] = self.alarm_recover_time
        if self.alarm_related is not None:
            result['AlarmRelated'] = self.alarm_related
        if self.area is not None:
            result['Area'] = self.area
        if self.circuit_id is not None:
            result['CircuitId'] = self.circuit_id
        if self.circuit_name is not None:
            result['CircuitName'] = self.circuit_name
        if self.circuit_type is not None:
            result['CircuitType'] = self.circuit_type
        if self.device_alarm_info is not None:
            result['DeviceAlarmInfo'] = self.device_alarm_info
        if self.device_ip is not None:
            result['DeviceIp'] = self.device_ip
        if self.device_ip_a is not None:
            result['DeviceIpA'] = self.device_ip_a
        if self.device_ip_b is not None:
            result['DeviceIpB'] = self.device_ip_b
        if self.device_model_a is not None:
            result['DeviceModelA'] = self.device_model_a
        if self.device_model_b is not None:
            result['DeviceModelB'] = self.device_model_b
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_name_a is not None:
            result['DeviceNameA'] = self.device_name_a
        if self.device_name_b is not None:
            result['DeviceNameB'] = self.device_name_b
        if self.device_port_a is not None:
            result['DevicePortA'] = self.device_port_a
        if self.device_port_b is not None:
            result['DevicePortB'] = self.device_port_b
        if self.device_sn_a is not None:
            result['DeviceSnA'] = self.device_sn_a
        if self.device_sn_b is not None:
            result['DeviceSnB'] = self.device_sn_b
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.device_vendor is not None:
            result['DeviceVendor'] = self.device_vendor
        if self.device_vendor_a is not None:
            result['DeviceVendorA'] = self.device_vendor_a
        if self.device_vendor_b is not None:
            result['DeviceVendorB'] = self.device_vendor_b
        if self.emergency_degree is not None:
            result['EmergencyDegree'] = self.emergency_degree
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.fault_duration is not None:
            result['FaultDuration'] = self.fault_duration
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.hang_file_name is not None:
            result['HangFileName'] = self.hang_file_name
        if self.hang_file_path is not None:
            result['HangFilePath'] = self.hang_file_path
        if self.hang_reason is not None:
            result['HangReason'] = self.hang_reason
        if self.impact_business is not None:
            result['ImpactBusiness'] = self.impact_business
        if self.incident_description is not None:
            result['IncidentDescription'] = self.incident_description
        if self.incident_sub_type is not None:
            result['IncidentSubType'] = self.incident_sub_type
        if self.incident_type is not None:
            result['IncidentType'] = self.incident_type
        if self.liable_man is not None:
            result['LiableMan'] = self.liable_man
        if self.link_man is not None:
            result['LinkMan'] = self.link_man
        if self.original_subject_alarm is not None:
            result['OriginalSubjectAlarm'] = self.original_subject_alarm
        if self.process_limited is not None:
            result['ProcessLimited'] = self.process_limited
        if self.process_man is not None:
            result['ProcessMan'] = self.process_man
        if self.process_man_id is not None:
            result['ProcessManId'] = self.process_man_id
        if self.process_result is not None:
            result['ProcessResult'] = self.process_result
        if self.skill_groups is not None:
            result['SkillGroups'] = self.skill_groups
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.work_order_id is not None:
            result['WorkOrderId'] = self.work_order_id
        result['WorkOrderOperationDtos'] = []
        if self.work_order_operation_dtos is not None:
            for k in self.work_order_operation_dtos:
                result['WorkOrderOperationDtos'].append(k.to_map() if k else None)
        if self.work_order_source is not None:
            result['WorkOrderSource'] = self.work_order_source
        if self.work_order_step is not None:
            result['WorkOrderStep'] = self.work_order_step
        if self.work_order_title is not None:
            result['WorkOrderTitle'] = self.work_order_title
        if self.work_order_type is not None:
            result['WorkOrderType'] = self.work_order_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmHappenTime') is not None:
            self.alarm_happen_time = m.get('AlarmHappenTime')
        if m.get('AlarmRecoverTime') is not None:
            self.alarm_recover_time = m.get('AlarmRecoverTime')
        if m.get('AlarmRelated') is not None:
            self.alarm_related = m.get('AlarmRelated')
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('CircuitId') is not None:
            self.circuit_id = m.get('CircuitId')
        if m.get('CircuitName') is not None:
            self.circuit_name = m.get('CircuitName')
        if m.get('CircuitType') is not None:
            self.circuit_type = m.get('CircuitType')
        if m.get('DeviceAlarmInfo') is not None:
            self.device_alarm_info = m.get('DeviceAlarmInfo')
        if m.get('DeviceIp') is not None:
            self.device_ip = m.get('DeviceIp')
        if m.get('DeviceIpA') is not None:
            self.device_ip_a = m.get('DeviceIpA')
        if m.get('DeviceIpB') is not None:
            self.device_ip_b = m.get('DeviceIpB')
        if m.get('DeviceModelA') is not None:
            self.device_model_a = m.get('DeviceModelA')
        if m.get('DeviceModelB') is not None:
            self.device_model_b = m.get('DeviceModelB')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceNameA') is not None:
            self.device_name_a = m.get('DeviceNameA')
        if m.get('DeviceNameB') is not None:
            self.device_name_b = m.get('DeviceNameB')
        if m.get('DevicePortA') is not None:
            self.device_port_a = m.get('DevicePortA')
        if m.get('DevicePortB') is not None:
            self.device_port_b = m.get('DevicePortB')
        if m.get('DeviceSnA') is not None:
            self.device_sn_a = m.get('DeviceSnA')
        if m.get('DeviceSnB') is not None:
            self.device_sn_b = m.get('DeviceSnB')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('DeviceVendor') is not None:
            self.device_vendor = m.get('DeviceVendor')
        if m.get('DeviceVendorA') is not None:
            self.device_vendor_a = m.get('DeviceVendorA')
        if m.get('DeviceVendorB') is not None:
            self.device_vendor_b = m.get('DeviceVendorB')
        if m.get('EmergencyDegree') is not None:
            self.emergency_degree = m.get('EmergencyDegree')
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('FaultDuration') is not None:
            self.fault_duration = m.get('FaultDuration')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('HangFileName') is not None:
            self.hang_file_name = m.get('HangFileName')
        if m.get('HangFilePath') is not None:
            self.hang_file_path = m.get('HangFilePath')
        if m.get('HangReason') is not None:
            self.hang_reason = m.get('HangReason')
        if m.get('ImpactBusiness') is not None:
            self.impact_business = m.get('ImpactBusiness')
        if m.get('IncidentDescription') is not None:
            self.incident_description = m.get('IncidentDescription')
        if m.get('IncidentSubType') is not None:
            self.incident_sub_type = m.get('IncidentSubType')
        if m.get('IncidentType') is not None:
            self.incident_type = m.get('IncidentType')
        if m.get('LiableMan') is not None:
            self.liable_man = m.get('LiableMan')
        if m.get('LinkMan') is not None:
            self.link_man = m.get('LinkMan')
        if m.get('OriginalSubjectAlarm') is not None:
            self.original_subject_alarm = m.get('OriginalSubjectAlarm')
        if m.get('ProcessLimited') is not None:
            self.process_limited = m.get('ProcessLimited')
        if m.get('ProcessMan') is not None:
            self.process_man = m.get('ProcessMan')
        if m.get('ProcessManId') is not None:
            self.process_man_id = m.get('ProcessManId')
        if m.get('ProcessResult') is not None:
            self.process_result = m.get('ProcessResult')
        if m.get('SkillGroups') is not None:
            self.skill_groups = m.get('SkillGroups')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('WorkOrderId') is not None:
            self.work_order_id = m.get('WorkOrderId')
        self.work_order_operation_dtos = []
        if m.get('WorkOrderOperationDtos') is not None:
            for k in m.get('WorkOrderOperationDtos'):
                temp_model = ListWorkOrdersResponseBodyContentWorkOrderOperationDtos()
                self.work_order_operation_dtos.append(temp_model.from_map(k))
        if m.get('WorkOrderSource') is not None:
            self.work_order_source = m.get('WorkOrderSource')
        if m.get('WorkOrderStep') is not None:
            self.work_order_step = m.get('WorkOrderStep')
        if m.get('WorkOrderTitle') is not None:
            self.work_order_title = m.get('WorkOrderTitle')
        if m.get('WorkOrderType') is not None:
            self.work_order_type = m.get('WorkOrderType')
        return self


class ListWorkOrdersResponseBody(TeaModel):
    def __init__(
        self,
        content: List[ListWorkOrdersResponseBodyContent] = None,
        max_results: int = None,
        next_token: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.content = content
        # 每页数量。
        self.max_results = max_results
        # 当总结果个数大于MaxResults时，用于翻页的token。
        self.next_token = next_token
        # Id of the request
        self.request_id = request_id
        # 总记录数。
        self.total_count = total_count

    def validate(self):
        if self.content:
            for k in self.content:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Content'] = []
        if self.content is not None:
            for k in self.content:
                result['Content'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.content = []
        if m.get('Content') is not None:
            for k in m.get('Content'):
                temp_model = ListWorkOrdersResponseBodyContent()
                self.content.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListWorkOrdersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListWorkOrdersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListWorkOrdersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class LockSpaceModelRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        space_model_id: str = None,
    ):
        # instanceId
        self.instance_id = instance_id
        # 资源id
        self.space_model_id = space_model_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.space_model_id is not None:
            result['SpaceModelId'] = self.space_model_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpaceModelId') is not None:
            self.space_model_id = m.get('SpaceModelId')
        return self


class LockSpaceModelResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class LockSpaceModelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: LockSpaceModelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = LockSpaceModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ReleaseIPRequest(TeaModel):
    def __init__(
        self,
        device_resource_id: str = None,
        device_resource_ids: List[str] = None,
        instance_id: str = None,
        ip_type: str = None,
        setup_project_id: str = None,
    ):
        # deviceResourceId
        self.device_resource_id = device_resource_id
        # deviceResourceIdStr
        self.device_resource_ids = device_resource_ids
        # instanceId
        self.instance_id = instance_id
        # ip地址类型
        self.ip_type = ip_type
        # 建设项目id
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.device_resource_ids is not None:
            result['DeviceResourceIds'] = self.device_resource_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids = m.get('DeviceResourceIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class ReleaseIPShrinkRequest(TeaModel):
    def __init__(
        self,
        device_resource_id: str = None,
        device_resource_ids_shrink: str = None,
        instance_id: str = None,
        ip_type: str = None,
        setup_project_id: str = None,
    ):
        # deviceResourceId
        self.device_resource_id = device_resource_id
        # deviceResourceIdStr
        self.device_resource_ids_shrink = device_resource_ids_shrink
        # instanceId
        self.instance_id = instance_id
        # ip地址类型
        self.ip_type = ip_type
        # 建设项目id
        self.setup_project_id = setup_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_resource_id is not None:
            result['DeviceResourceId'] = self.device_resource_id
        if self.device_resource_ids_shrink is not None:
            result['DeviceResourceIds'] = self.device_resource_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_type is not None:
            result['IpType'] = self.ip_type
        if self.setup_project_id is not None:
            result['SetupProjectId'] = self.setup_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceResourceId') is not None:
            self.device_resource_id = m.get('DeviceResourceId')
        if m.get('DeviceResourceIds') is not None:
            self.device_resource_ids_shrink = m.get('DeviceResourceIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpType') is not None:
            self.ip_type = m.get('IpType')
        if m.get('SetupProjectId') is not None:
            self.setup_project_id = m.get('SetupProjectId')
        return self


class ReleaseIPResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ReleaseIPResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ReleaseIPResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ReleaseIPResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemarkWorkOrderRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        instance_id: str = None,
        operator: str = None,
        remark: str = None,
        work_order_id: str = None,
    ):
        # 幂等校验 token
        self.client_token = client_token
        # 实例ID
        self.instance_id = instance_id
        # 备注人
        self.operator = operator
        # 备注信息
        self.remark = remark
        # 备注工单id
        self.work_order_id = work_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.work_order_id is not None:
            result['WorkOrderId'] = self.work_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('WorkOrderId') is not None:
            self.work_order_id = m.get('WorkOrderId')
        return self


class RemarkWorkOrderResponseBody(TeaModel):
    def __init__(
        self,
        operation_id: str = None,
        request_id: str = None,
    ):
        # 操作id
        self.operation_id = operation_id
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RemarkWorkOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: RemarkWorkOrderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemarkWorkOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RetryTasksRequestRetryTasks(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        item_name: str = None,
        script_id: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # 巡检项名称
        self.item_name = item_name
        # 脚本ID
        self.script_id = script_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.script_id is not None:
            result['ScriptId'] = self.script_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('ScriptId') is not None:
            self.script_id = m.get('ScriptId')
        return self


class RetryTasksRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        retry_tasks: List[RetryTasksRequestRetryTasks] = None,
    ):
        # 实例ID
        self.instance_id = instance_id
        # 重执行任务的数组
        self.retry_tasks = retry_tasks

    def validate(self):
        if self.retry_tasks:
            for k in self.retry_tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['RetryTasks'] = []
        if self.retry_tasks is not None:
            for k in self.retry_tasks:
                result['RetryTasks'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.retry_tasks = []
        if m.get('RetryTasks') is not None:
            for k in m.get('RetryTasks'):
                temp_model = RetryTasksRequestRetryTasks()
                self.retry_tasks.append(temp_model.from_map(k))
        return self


class RetryTasksShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        retry_tasks_shrink: str = None,
    ):
        # 实例ID
        self.instance_id = instance_id
        # 重执行任务的数组
        self.retry_tasks_shrink = retry_tasks_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.retry_tasks_shrink is not None:
            result['RetryTasks'] = self.retry_tasks_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RetryTasks') is not None:
            self.retry_tasks_shrink = m.get('RetryTasks')
        return self


class RetryTasksResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # 请求ID
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RetryTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: RetryTasksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RetryTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateConfigurationSpecificationRequest(TeaModel):
    def __init__(
        self,
        architecture: str = None,
        configuration_specification_id: str = None,
        instance_id: str = None,
        model: str = None,
        related_variate: List[bytes] = None,
        role: str = None,
        specification_content: str = None,
        specification_name: str = None,
        vendor: str = None,
    ):
        # 架构类型
        self.architecture = architecture
        # 配置规范id
        self.configuration_specification_id = configuration_specification_id
        # instanceId
        self.instance_id = instance_id
        # 型号
        self.model = model
        # 相关变量
        self.related_variate = related_variate
        # 角色
        self.role = role
        # 配置规范内容
        self.specification_content = specification_content
        # 配置规范名字
        self.specification_name = specification_name
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.model is not None:
            result['Model'] = self.model
        if self.related_variate is not None:
            result['RelatedVariate'] = self.related_variate
        if self.role is not None:
            result['Role'] = self.role
        if self.specification_content is not None:
            result['SpecificationContent'] = self.specification_content
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('RelatedVariate') is not None:
            self.related_variate = m.get('RelatedVariate')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SpecificationContent') is not None:
            self.specification_content = m.get('SpecificationContent')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class UpdateConfigurationSpecificationShrinkRequest(TeaModel):
    def __init__(
        self,
        architecture: str = None,
        configuration_specification_id: str = None,
        instance_id: str = None,
        model: str = None,
        related_variate_shrink: str = None,
        role: str = None,
        specification_content: str = None,
        specification_name: str = None,
        vendor: str = None,
    ):
        # 架构类型
        self.architecture = architecture
        # 配置规范id
        self.configuration_specification_id = configuration_specification_id
        # instanceId
        self.instance_id = instance_id
        # 型号
        self.model = model
        # 相关变量
        self.related_variate_shrink = related_variate_shrink
        # 角色
        self.role = role
        # 配置规范内容
        self.specification_content = specification_content
        # 配置规范名字
        self.specification_name = specification_name
        # 厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.configuration_specification_id is not None:
            result['ConfigurationSpecificationId'] = self.configuration_specification_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.model is not None:
            result['Model'] = self.model
        if self.related_variate_shrink is not None:
            result['RelatedVariate'] = self.related_variate_shrink
        if self.role is not None:
            result['Role'] = self.role
        if self.specification_content is not None:
            result['SpecificationContent'] = self.specification_content
        if self.specification_name is not None:
            result['SpecificationName'] = self.specification_name
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('ConfigurationSpecificationId') is not None:
            self.configuration_specification_id = m.get('ConfigurationSpecificationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('RelatedVariate') is not None:
            self.related_variate_shrink = m.get('RelatedVariate')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SpecificationContent') is not None:
            self.specification_content = m.get('SpecificationContent')
        if m.get('SpecificationName') is not None:
            self.specification_name = m.get('SpecificationName')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        return self


class UpdateConfigurationSpecificationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateConfigurationSpecificationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateConfigurationSpecificationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateConfigurationSpecificationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateConfigurationVariateRequest(TeaModel):
    def __init__(
        self,
        comment: str = None,
        configuration_variate_id: str = None,
        format_function: str = None,
        instance_id: str = None,
        variate_name: str = None,
    ):
        # 描述变量
        self.comment = comment
        # 资源一级ID
        self.configuration_variate_id = configuration_variate_id
        # python转换函数
        self.format_function = format_function
        # instanceId
        self.instance_id = instance_id
        # 变量名字
        self.variate_name = variate_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.configuration_variate_id is not None:
            result['ConfigurationVariateId'] = self.configuration_variate_id
        if self.format_function is not None:
            result['FormatFunction'] = self.format_function
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.variate_name is not None:
            result['VariateName'] = self.variate_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ConfigurationVariateId') is not None:
            self.configuration_variate_id = m.get('ConfigurationVariateId')
        if m.get('FormatFunction') is not None:
            self.format_function = m.get('FormatFunction')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('VariateName') is not None:
            self.variate_name = m.get('VariateName')
        return self


class UpdateConfigurationVariateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateConfigurationVariateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateConfigurationVariateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateConfigurationVariateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateDedicatedLineRequest(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        contact: str = None,
        dedicated_line_gateway: str = None,
        dedicated_line_id: str = None,
        dedicated_line_ip: str = None,
        dedicated_line_role: str = None,
        description: str = None,
        device_id: str = None,
        device_port: str = None,
        instance_id: str = None,
        isp: str = None,
        phone: str = None,
    ):
        # 宽带（Mbps）
        self.bandwidth = bandwidth
        # 联系人
        self.contact = contact
        # 专线网关
        self.dedicated_line_gateway = dedicated_line_gateway
        # 实例 ID。
        self.dedicated_line_id = dedicated_line_id
        # 专线IP
        self.dedicated_line_ip = dedicated_line_ip
        # 专线角色
        self.dedicated_line_role = dedicated_line_role
        # 备注
        self.description = description
        # 关联设备ID
        self.device_id = device_id
        # 关联设备端口名称
        self.device_port = device_port
        # 实例ID
        self.instance_id = instance_id
        # 运营商
        self.isp = isp
        # 联系电话
        self.phone = phone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.contact is not None:
            result['Contact'] = self.contact
        if self.dedicated_line_gateway is not None:
            result['DedicatedLineGateway'] = self.dedicated_line_gateway
        if self.dedicated_line_id is not None:
            result['DedicatedLineId'] = self.dedicated_line_id
        if self.dedicated_line_ip is not None:
            result['DedicatedLineIp'] = self.dedicated_line_ip
        if self.dedicated_line_role is not None:
            result['DedicatedLineRole'] = self.dedicated_line_role
        if self.description is not None:
            result['Description'] = self.description
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_port is not None:
            result['DevicePort'] = self.device_port
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.phone is not None:
            result['Phone'] = self.phone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('Contact') is not None:
            self.contact = m.get('Contact')
        if m.get('DedicatedLineGateway') is not None:
            self.dedicated_line_gateway = m.get('DedicatedLineGateway')
        if m.get('DedicatedLineId') is not None:
            self.dedicated_line_id = m.get('DedicatedLineId')
        if m.get('DedicatedLineIp') is not None:
            self.dedicated_line_ip = m.get('DedicatedLineIp')
        if m.get('DedicatedLineRole') is not None:
            self.dedicated_line_role = m.get('DedicatedLineRole')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DevicePort') is not None:
            self.device_port = m.get('DevicePort')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        return self


class UpdateDedicatedLineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateDedicatedLineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateDedicatedLineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateDedicatedLineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateDeviceRequest(TeaModel):
    def __init__(
        self,
        device_id: str = None,
        enable_password: str = None,
        ext_attributes: str = None,
        host_name: str = None,
        instance_id: str = None,
        ip: str = None,
        login_password: str = None,
        login_type: str = None,
        login_username: str = None,
        mac: str = None,
        model: str = None,
        physical_space_id: str = None,
        security_domain: str = None,
        service_status: str = None,
        sn: str = None,
        snmp_account_type: str = None,
        snmp_account_version: str = None,
        snmp_auth_passphrase: str = None,
        snmp_auth_protocol: str = None,
        snmp_community: str = None,
        snmp_privacy_passphrase: str = None,
        snmp_privacy_protocol: str = None,
        snmp_security_level: str = None,
        snmp_username: str = None,
        vendor: str = None,
    ):
        # 设备ID
        self.device_id = device_id
        # enable密码
        self.enable_password = enable_password
        # 设备额外属性
        self.ext_attributes = ext_attributes
        # 主机名
        self.host_name = host_name
        # 实例ID
        self.instance_id = instance_id
        # 设备IP
        self.ip = ip
        # 登录密码
        self.login_password = login_password
        # 登录类型
        self.login_type = login_type
        # 登录账号
        self.login_username = login_username
        # 设备MAC地址
        self.mac = mac
        # 设备型号
        self.model = model
        # 物理空间
        self.physical_space_id = physical_space_id
        # 设备安全域
        self.security_domain = security_domain
        # 设备状态
        self.service_status = service_status
        # 设备SN
        self.sn = sn
        # SNMP 账号类型
        self.snmp_account_type = snmp_account_type
        # SNMP 版本号
        self.snmp_account_version = snmp_account_version
        # SNMP Auth Passphrase
        self.snmp_auth_passphrase = snmp_auth_passphrase
        # Auth Protocol
        self.snmp_auth_protocol = snmp_auth_protocol
        # SNMP Community
        self.snmp_community = snmp_community
        # Privacy Passphrase
        self.snmp_privacy_passphrase = snmp_privacy_passphrase
        # Privacy Protocol
        self.snmp_privacy_protocol = snmp_privacy_protocol
        # SNMP 安全级别
        self.snmp_security_level = snmp_security_level
        # SNMP 用户名
        self.snmp_username = snmp_username
        # 设备厂商
        self.vendor = vendor

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.enable_password is not None:
            result['EnablePassword'] = self.enable_password
        if self.ext_attributes is not None:
            result['ExtAttributes'] = self.ext_attributes
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.login_password is not None:
            result['LoginPassword'] = self.login_password
        if self.login_type is not None:
            result['LoginType'] = self.login_type
        if self.login_username is not None:
            result['LoginUsername'] = self.login_username
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.model is not None:
            result['Model'] = self.model
        if self.physical_space_id is not None:
            result['PhysicalSpaceId'] = self.physical_space_id
        if self.security_domain is not None:
            result['SecurityDomain'] = self.security_domain
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.sn is not None:
            result['Sn'] = self.sn
        if self.snmp_account_type is not None:
            result['SnmpAccountType'] = self.snmp_account_type
        if self.snmp_account_version is not None:
            result['SnmpAccountVersion'] = self.snmp_account_version
        if self.snmp_auth_passphrase is not None:
            result['SnmpAuthPassphrase'] = self.snmp_auth_passphrase
        if self.snmp_auth_protocol is not None:
            result['SnmpAuthProtocol'] = self.snmp_auth_protocol
        if self.snmp_community is not None:
            result['SnmpCommunity'] = self.snmp_community
        if self.snmp_privacy_passphrase is not None:
            result['SnmpPrivacyPassphrase'] = self.snmp_privacy_passphrase
        if self.snmp_privacy_protocol is not None:
            result['SnmpPrivacyProtocol'] = self.snmp_privacy_protocol
        if self.snmp_security_level is not None:
            result['SnmpSecurityLevel'] = self.snmp_security_level
        if self.snmp_username is not None:
            result['SnmpUsername'] = self.snmp_username
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        return result

    