# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/008_Tester.ipynb.

# %% auto 0
__all__ = ['Tester', 'mirror_producer', 'mirror_consumer']

# %% ../../nbs/008_Tester.ipynb 1
import asyncio
import inspect
from typing import *

from fastcore.basics import patch
from pydantic import BaseModel, Field

from .app import FastKafka
from .._testing.local_broker import LocalKafkaBroker

# %% ../../nbs/008_Tester.ipynb 4
class Tester(FastKafka):
    def __init__(self, app: Union[FastKafka, List[FastKafka]]):
        self.apps = app if isinstance(app, list) else [app]
        super().__init__(
            bootstrap_servers=self.apps[0]._kafka_config["bootstrap_servers"]
        )
        self.create_mirrors()

    async def startup(self) -> None:
        for app in self.apps:
            app.create_mocks()
            await app.startup()

        self.create_mocks()
        await super().startup()
        await asyncio.sleep(3)

    async def shutdown(self) -> None:
        await super().shutdown()
        for app in self.apps[::-1]:
            await app.shutdown()

    def create_mirrors(self) -> None:
        pass

# %% ../../nbs/008_Tester.ipynb 6
def mirror_producer(topic: str, producer_f: Callable[..., Any]) -> Callable[..., Any]:
    msg_type = inspect.signature(producer_f).return_annotation

    async def skeleton_func(msg: BaseModel) -> None:
        pass

    mirror_func = skeleton_func
    sig = inspect.signature(skeleton_func)

    # adjust name
    mirror_func.__name__ = "on_" + topic

    # adjust arg and return val
    sig = sig.replace(
        parameters=[
            inspect.Parameter(
                name="msg",
                annotation=msg_type,
                kind=inspect.Parameter.POSITIONAL_OR_KEYWORD,
            )
        ]
    )

    mirror_func.__signature__ = sig  # type: ignore

    return mirror_func

# %% ../../nbs/008_Tester.ipynb 8
def mirror_consumer(topic: str, consumer_f: Callable[..., Any]) -> Callable[..., Any]:
    msg_type = inspect.signature(consumer_f).parameters["msg"]

    async def skeleton_func(msg: BaseModel) -> BaseModel:
        return msg

    mirror_func = skeleton_func
    sig = inspect.signature(skeleton_func)

    # adjust name
    mirror_func.__name__ = "to_" + topic

    # adjust arg and return val
    sig = sig.replace(parameters=[msg_type], return_annotation=msg_type.annotation)

    mirror_func.__signature__ = sig  # type: ignore
    return mirror_func

# %% ../../nbs/008_Tester.ipynb 10
@patch  # type: ignore
def create_mirrors(self: Tester):
    for app in self.apps:
        for topic, (consumer_f, _) in app._consumers_store.items():
            mirror_f = mirror_consumer(topic, consumer_f)
            mirror_f = self.produces()(mirror_f)  # type: ignore
            setattr(self, mirror_f.__name__, mirror_f)
        for topic, (producer_f, _, _) in app._producers_store.items():
            mirror_f = mirror_producer(topic, producer_f)
            mirror_f = self.consumes()(mirror_f)  # type: ignore
            setattr(self, mirror_f.__name__, mirror_f)
