#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = ['Click>=7.0', ]

test_requirements = [ ]

setup(
    author="Andreas Liesenfeld",
    author_email='lies0002@ntu.edu.sg',
    python_requires='>=3.6',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    description="A Python package for processing real-world conversational speech data.",
    entry_points={
        'console_scripts': [
            'sktalk=sktalk.cli:main',
        ],
    },
    install_requires=requirements,
    license="MIT license",
    long_description=readme,
    include_package_data=True,
    keywords='sktalk',
    name='sktalk',
    packages=find_packages(include=['sktalk', 'sktalk.*']),
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/liesenf/sktalk',
    version='0.0.400',
    zip_safe=False,
)
