# -*- coding: utf-8 -*-
"""
Created on Thu Sep 19 10:57:23 2019

@author: Jonathan van Leeuwen, Diederick Niehorster
"""
import matplotlib
import matplotlib.pyplot as plt
import matplotlib.patches as patches
import numpy as np

def plot_data_and_fixations(data, fix, fix_as_line=True, res=None):
    """
    Plots the results of the I2MC function
    fix_as_line: if true, fixations are drawn as lines, if
    false as shaded areas
    If the res parameter (screen resolution) is not provided,
    a 1920x1080 pix screen is assumed
    """

    if res is None:
        res = [1920, 1080]
    
    time = data['time']
    Xdat = np.array([])
    Ydat = np.array([])
    klr  = []
    if 'L_X' in data.keys():
        Xdat = data['L_X']
        Ydat = data['L_Y']
        klr.append('g')
    if 'R_X' in data.keys():
        if len(Xdat) == 0:
            Xdat = data['R_X']
            Ydat = data['R_Y']
        else:
            Xdat = np.vstack([Xdat, data['R_X']])
            Ydat = np.vstack([Ydat, data['R_Y']])
        klr.append('r')
    if 'average_X' in data.keys() and not 'L_X' in data.keys() and not 'R_X' in data.keys():
        if len(Xdat) == 0:
            Xdat = data['average_X']
            Ydat = data['average_Y']
        else:
            Xdat = np.vstack([Xdat, data['average_X']])
            Ydat = np.vstack([Ydat, data['average_Y']])
        klr.append('b')   
    
    # Plot settings
    myfontsize = 10
    myLabelSize = 12
    traceLW = 0.5
    
    font = {'size': myfontsize}
    matplotlib.rc('font', **font)
    
    ## plot layout
    f   = plt.figure(figsize=(10, 6), dpi=300)
    ax1 = plt.subplot(2,1,1)
    ax1.set_ylabel('Horizontal position (pixels)', size = myLabelSize)
    ax1.set_xlim([0, time[-1]])
    ax1.set_ylim([0, res[0]])

    ax2 = plt.subplot(2,1,2, sharex=ax1)
    ax2.set_xlabel('Time (ms)')
    ax2.set_ylabel('Vertical position (pixels)', size = myLabelSize)
    ax2.set_ylim([0, res[1]])

    ### Plot X position
    for p in range(Xdat.shape[0]):
        ax1.plot(time,Xdat[p,:],klr[p]+'-', linewidth = traceLW)

    ### Plot Y posiiton
    for p in range(Ydat.shape[0]):
        ax2.plot(time,Ydat[p,:],klr[p]+'-', linewidth = traceLW)
    
    # add fixations
    if fix_as_line:
        fixLW = 2
        for b in range(len(fix['startT'])):
            ax1.plot([fix['startT'][b], fix['endT'][b]], [fix['xpos'][b], fix['xpos'][b]],'k-', linewidth = fixLW)
        for b in range(len(fix['startT'])):
            ax2.plot([fix['startT'][b], fix['endT'][b]], [fix['ypos'][b], fix['ypos'][b]],'k-', linewidth = fixLW)
    else:
        for b in range(len(fix['startT'])):
            ax1.add_patch(patches.Rectangle((fix['startT'][b], 0),
                                            fix['endT'][b] - fix['startT'][b],
                                            res[0], fill=True, color='0.7',
                                            linewidth=0))
            ax2.add_patch(patches.Rectangle((fix['startT'][b], 0),
                                            fix['endT'][b] - fix['startT'][b],
                                            res[1], fill=True, color='0.7',
                                            linewidth=0))

    return f

