from enum import Enum

import strawberry

@strawberry.enum
class Registries(Enum):
    Verra = "Verra"
    GoldStandard = "Gold Standard"
    ClimateActionReserveCAR = "Climate Action Reserve (CAR)"
    AmericanCarbonRegistryACR = "American Carbon Registry (ACR)"
    SwitzerlandNationalRegistry = "Switzerland National Registry"
    SwedenNationalRegistry = "Sweden National Registry"
    SingaporeNationalRegistry = "Singapore National Registry"
    JointCreditingMechanism = "Joint Crediting Mechanism"
    CostaRicaNationalRegistry = "Costa Rica National Registry"
    MexicoNationalRegistry = "Mexico National Registry"
    ChileNationalRegistry = "Chile National Registry"
    GlobalCarbonCouncil = "Global Carbon Council"
    CarbonAssetsTradingSystemCATS = "Carbon Assets Trading System (CATS)"
    GlobalCarbonTrace = "Global CarbonTrace"
    RoyalKingdomOfBhutan = "Royal Kingdom Of Bhutan"
    EcoRegistry = "EcoRegistry"
    CDMRegistry = "CDM Registry"
    Article64MechanismRegistry = "Article 6.4 Mechanism Registry"
    UnfcccArticle62MechanismRegistry = "UNFCCC Article 6.2 Mechanism Registry"
    BioCarbonRegistry = "Biocarbon Registry"
    BioCarbonStandard = "BioCarbon Standard"

    def __str__(self):
        return self.value
    

# OLD
# class ProjectSector(Enum):
#     AgriForestryFishing = "Agriculture, forestry and fishing"
#     MiningQuarrying = "Mining and quarrying"
#     Manufacturing = "Manufacturing"
#     EnergySupply = "Electricity, gas, steam and air conditioning supply"
#     WaterWasteManagement = "Water supply; sewerage, waste management and remediation activities"
#     Construction = "Construction"
#     WholesaleRetailTrade = "Wholesale and retail trade; repair of motor vehicles and motorcycles"
#     TransportStorage = "Transportation and storage"
#     AccommodationFoodServices = "Accommodation and food service activities"
#     InfoComm = "Information and communication"
#     FinanceInsurance = "Financial and insurance activities"
#     RealEstate = "Real estate activities"
#     ProfSciTech = "Professional, scientific and technical activities"
#     AdminSupport = "Administrative and support service activities"
#     PublicAdminDefence = "Public administration and defence; compulsory social security"
#     Education = "Education"
#     HealthSocialWork = "Human health and social work activities"
#     ArtsEntertainment = "Arts, entertainment and recreation"
#     OtherServices = "Other service activities"
#     HouseholdActivities = "Activities of households as employers; undifferentiated goods- and services-producing activities of households for own use"
#     ExtraterritorialOrgs = "Activities of extraterritorial organizations and bodies"

@strawberry.enum
class ProjectSector(Enum):
    AfforestationAndReforestation = "Afforestation and reforestation"
    EnergyIndustries = "Energy industries (renewable - / non-renewable sources)"
    EnergyDemand = "Energy demand"
    AgricultureForestryAndOtherLandUses = "Agriculture, forestry and other land uses (AFOLU)"
    WasteHandlingAndDisposal = "Waste handling and disposal"
    TransportationAndStorage = "Transportation and storage"
    WaterSupplySewerageWasteManagementAndRemediationActivities = "Water supply; sewerage, waste management and remediation activities"
    ElectricityGasSteamAndAirConditioningSupply = "Electricity; gas, steam and air conditioning supply"
    FugitiveEmissionsFromFuels = "Fugitive emissions from fuel (solid, oil and gas)"
    Manufacturing = "Manufacturing"
    LivestockEntericFermentationAndManureManagement = "Livestock, enteric fermentation, and manure management"
    ChemicalIndustries = "Chemical industries"
    EnergyDistribution = "Energy distribution"
    FugitiveEmissionsHalocarbonsSulfurHexafluoride = "Fugitive emissions from production and consumption of halocarbons and sulphur hexafluoride"
    MetalProduction = "Metal production"
    Agriculture = "Agriculture"
    MiningAndQuarrying = "Mining and quarrying"
    Construction = "Construction"
    OtherServices = "Other service activities"
    WholesaleAndRetailTrade = "Wholesale and retail trade; repair of motor vehicles and motorcycles"
    AccommodationAndFoodServices = "Accommodation and food service activities"
    InformationAndCommunication = "Information and communication"
    FinanceAndInsurance = "Financial and insurance activities"
    RealEstateActivities = "Real estate activities"
    ProfessionalScientificAndTechnicalActivities = "Professional, scientific and technical activities"
    AdministrativeAndSupportServiceActivities = "Administrative and support service activities"
    PublicAdministrationAndDefence = "Public administration and defence; compulsory social security"
    Education = "Education"
    HumanHealthAndSocialWorkActivities = "Human health and social work activities"
    ArtsEntertainmentAndRecreation = "Arts, entertainment and recreation"
    HouseholdActivities = "Activities of households as employers; undifferentiated goods- and services-producing activities of households for own use"
    ExtraterritorialOrganizations = "Activities of extraterritorial organizations and bodies"

@strawberry.enum
class ProjectSize(Enum):
    Small = "Small"
    Medium = "Medium"
    Large = "Large"

@strawberry.enum
class SustainableDevelopmentGoals(Enum):
    NoPoverty = "No Poverty"
    ZeroHunger = "Zero Hunger"
    GoodHealthAndWellBeing = "Good Health and Well-Being"
    QualityEducation = "Quality Education"
    GenderEquality = "Gender Equality"
    CleanWaterAndSanitation = "Clean Water and Sanitation"
    AffordableAndCleanEnergy = "Affordable and Clean Energy"
    DecentWorkAndEconomicGrowth = "Decent Work and Economic Growth"
    IndustryInnovationAndInfrastructure = "Industry, Innovation and Infrastructure"
    ReducedInequalities = "Reduced Inequalities"
    SustainableCitiesAndCommunities = "Sustainable Cities and Communities"
    ResponsibleConsumptionAndProduction = "Responsible Consumption and Production"
    ClimateAction = "Climate Action"
    LifeBelowWater = "Life Below Water"
    LifeOnLand = "Life on Land"
    PeaceJusticeAndStrongInstitutions = "Peace, Justice and Strong Institutions"
    PartnershipsForTheGoals = "Partnerships for the Goals"
    PeerToPeerLearningAmongCommunityMembers = "Peer-to-peer learning among community members that does not generate offsets"
    
    def __str__(self):
        return self.value
# old
# class ProjectType(Enum):
#     OzoneDepletingSubstances = "Ozone Depleting Substances"
#     Livestock = "Livestock"
#     SoilEnrichment = "Soil Enrichment"
#     ImprovedForestManagement = "Improved Forest Management"
#     LandfillGasCaptureCombustion = "Landfill Gas Capture/Combustion"
#     Forestry = "Forestry"
#     AvoidedConversion = "Avoided Conversion"
#     CoalMineMethane = "Coal Mine Methane"
#     Conservation = "Conservation"
#     NitrogenManagement = "Nitrogen Management"
#     OrganicWasteComposting = "Organic Waste Composting"
#     OrganicWasteDigestion = "Organic Waste Digestion"
#     Reforestation = "Reforestation"
#     PlasticWasteCollection = "Plastic Waste Collection"
#     PlasticWasteRecycling = "Plastic Waste Recycling"
#     EnergyDemand = "Energy demand"
#     Afforestation = "Afforestation"
#     ReforestationAndRevegetation = "Reforestation and Revegetation"
#     REDD = "REDD+"

@strawberry.enum
class ProjectType(Enum):
    Hydro = "Hydro"
    Solar = "Solar"
    Compost = "Compost"
    EnergyDistribution = "Energy Distribution"
    EEHouseholds = "EE Households"
    AgricultureForestryAndOtherLandUse = "Agriculture Forestry and Other Land Use"
    AfforestationOrReforestation = "Afforestation or Reforestation"
    ForestConservation = "Forest Conservation"
    WasteHandlingAndDisposal = "Waste Handling and Disposal"
    ReducedEmissionsFromDeforestationAndDegradation = "Reduced Emissions from Deforestation & Degradation"
    BiogasElectricity = "Biogas - Electricity"
    GridConnectedElectricityGenerationFromRenewableSources = "Grid-connected Electricity Generation from Renewable Sources"
    EnergyIndustriesRenewableNonRenewableSources = "Energy Industries - renewable/non-renewable sources"
    ForestRestoration = "Forest Restoration"
    OrganicWasteDigestion = "Organic Waste Digestion"
    SolarThermalHeat = "Solar Thermal - Heat"
    Transport = "Transport"
    EnergyDemand = "Energy Demand"
    GHGManagement = "GHG Management"
    AvoidedConversion = "Avoided Conversion"
    ManufacturingIndustries = "Manufacturing Industries"
    LivestockEntericFermentationAndManureManagement = "Livestock, Enteric Fermentation, and Manure Management"
    RenewableEnergy = "Renewable Energy"
    BiomassEnergy = "Biomass Energy"
    EESupplySide = "EE Supply Side"
    LandfillGas = "Landfill Gas"
    EEOwnGeneration = "EE Own Generation"
    CoalBedMineMethane = "Coal Bed/Mine Methane"
    MethaneAvoidance = "Methane Avoidance"
    Wind = "Wind"
    EEIndustry = "EE Industry"
    Agriculture = "Agriculture"
    Fugitive = "Fugitive"
    Cement = "Cement"
    MixedRenewables = "Mixed Renewables"
    N2O = "N2O"
    Geothermal = "Geothermal"
    HFCs = "HFCs"
    EEService = "EE Service"
    HybridRenewables = "Hybrid Renewables"
    Tidal = "Tidal"
    Biogas = "Biogas"
    Waste = "Waste"
    SolarAndWind = "Solar & Wind"
    Construction = "Construction"
    MiningMineralProduction = "Mining/Mineral Production"
    ChemicalIndustry = "Chemical Industry"
    FugitiveEmissionsFromHalocarbonsAndSulphurHexafluoride = "Fugitive Emissions from Production and Consumption of Halocarbons and Sulphur Hexafluoride"
    MetalProduction = "Metal Production"
    ChangeOfFuelOrRawMaterials = "Change of Fuel or Raw Materials"
    ImprovedForestManagement = "Improved Forest Management"
    OzoneDepletingSubstances = "Ozone Depleting Substances"
    Livestock = "Livestock"
    SoilEnrichment = "Soil Enrichment"
    PlasticWasteCollection = "Plastic Waste Collection"
    PlasticWasteRecycling = "Plastic Waste Recycling"
    NitrogenManagement = "Nitrogen Management"
    Conservation = "Conservation"
    CoalMineMethane = "Coal Mine Methane"
    ForestryMX = "Forestry - MX"
    NitricAcidN2OTertiaryCatalyst = "Nitric Acid N2O- Tertiary Catalyst"
    NitricAcidN2OSecondaryCatalyst = "Nitric Acid N2O- Secondary Catalyst"
    AdipicAcid = "Adipic Acid"
    AvoidedGrasslandConversion = "Avoided Grassland Conversion"
    LivestockGasCaptureCombustion = "Livestock Gas Capture/Combustion"
    LandfillMX = "Landfill - MX"
    BiomassOrLiquidBiofuelCogeneration = "Biomass, or Liquid Biofuel - Cogeneration"
    BiomassOrLiquidBiofuelElectricity = "Biomass, or Liquid Biofuel - Electricity"
    BiomassOrLiquidBiofuelHeat = "Biomass, or Liquid Biofuel - Heat"
    PV = "PV (Photovoltaic)"
    ForestCarbon = "Forest Carbon"
    IndustrialProcessEmissions = "Industrial Process Emissions"
    FuelSwitching = "Fuel Switching"
    IndustrialGasSubstitution = "Industrial Gas Substitution"
    LivestockWasteManagement = "Livestock Waste Management"
    AgriculturalLandManagement = "Agricultural Land Management"
    WetlandRestoration = "Wetland Restoration"
    TransportFleetEfficiency = "Transport / Fleet Efficiency"
    EnergyEfficiency = "Energy Efficiency"
    CarbonCaptureStorage = "Carbon Capture & Storage (CCS)"
    WastewaterTreatment = "Wastewater Treatment"
    Other = "Other"

    def __str__(self):
        return self.value

@strawberry.enum
class CoveredByNDC(Enum):
    InsideNDC = "Inside NDC"
    OutsideNDC = "Outside NDC"
    Unknown = "Unknown"

    def __str__(self):
        return self.value

@strawberry.enum
class ProjectStatusValues(Enum):
    Listed = "Listed"
    Validated = "Validated"
    Registered = "Registered"
    Transitioned = "Transitioned"
    Approved = "Approved"
    Authorized = "Authorized"
    Withdrawn = "Withdrawn"
    Deregistered = "Deregistered"
    Completed = "Completed"

    def __str__(self):
        return self.value

@strawberry.enum
class UnitMetric(Enum):
    tCO2e = "tCO2e"
    def __str__(self):
        return self.value

@strawberry.enum
class Methodology(Enum):
    AcrTruckStopElectrification = "ACR - Truck Stop Electrification"
    AcrAdvRefrigerationSys = "ACR - Advanced Refrigeration Systems"
    AcrReclaimedHFCs = "ACR - Certified Reclaimed HFC Refrigerants, Propellants, and Fire Suppressants"
    AcrODSHighGwpFoamDestruction = "ACR - Destruction of Ozone Depleting Substances and High-GWP Foam"
    AcrODSIntlDestruction = "ACR - Destruction of Ozone Depleting Substances from International Sources"
    AcrAdvFoamAgentsTransition = "ACR - Transition to Advanced Formulation Blowing Agents in Foam Manufacturing and Use"
    AcrAfforestReforestDegradedLands = "ACR - Afforestation and Reforestation of Degraded Lands"
    AcrAvoidGrasslandShrublandConversion = "ACR - Avoided Conversion of Grasslands and Shrublands to Crop Production"
    AcrIFMCanadaForestlands = "ACR - Improved Forest Management (IFM) on Canadian Forestlands"
    AcrIFMUSNonFederalForestlands = "ACR - Improved Forest Management (IFM) on Non-Federal U.S. Forestlands"
    AcrIFMSmallNIPForestlands = "ACR - Improved Forest Management (IFM) on Small Non-Industrial Private Forestlands"
    AcrCalifDeltaCoastalWetlandsRestoration = "ACR - Restoration of California Deltaic and Coastal Wetlands"
    AcrPocosinWetlandsRestoration = "ACR - Restoration of Pocosin Wetlands"
    AcrCCSProjects = "ACR - Carbon Capture and Storage Projects"
    AcrLandfillGasProj = "ACR - Landfill Gas Destruction and Beneficial Use Projects"
    AcrComplianceOffsetProtocolDestructionUSDSD = "ACR - Compliance Offset Protocol: Destruction of U.S. Ozone Depleting Substances Banks"
    AcrComplianceOffsetProtocolODSProjects = "ACR - Compliance Offset Protocol: Ozone Depleting Substances Projects"
    AcrSwitchNonRenewableBiomassThermalApps = "ACR - Switch from non-renewable biomass for thermal applications by the user"
    AcrComplianceOffsetProtocolMineMethaneCapture = "ACR - Compliance Offset Protocol: Mine Methane Capture Projects"
    AcrEmissionReductionsIndustrialGasSubstitution = "ACR - Emission reductions through industrial gas substitution"
    AcrComplianceOffsetProtocolCaptureDestroyMethaneManure = "ACR - Compliance Offset Protocol: Capturing and Destroying Methane from Manure Management Systems"
    AcrComplianceOffsetProtocolUSForestProjects = "ACR - Compliance Offset Protocol: U.S. Forest Projects"
    AcrAfforestationReforestationDegradedLand = "ACR - Afforestation and Reforestation of Degraded Land"
    AcrMRVProtocolLandfillGasCombustion = "ACR - Monitoring, Reporting and Verification Protocol for Landfill Gas Combustion"
    AcrFuelSwitchingCoalPetroleumNatGasPowerPlant = "ACR - Fuel switching from coal and/or petroleum fuels to natural gas in existing Power Plant for electricity generation"
    AcrMethaneAvoidanceWastewaterManureSystems = "ACR - Methane avoidance through separation of solids from wastewater or manure treatment systems"
    AcrConversionHighBleedPneumaticControllers = "ACR - Conversion of High-Bleed Pneumatic Controllers in Oil and Natural Gas Systems"
    AcrN2OEmissionReductionsReducedFertilizerAgCrops = "ACR - N2O Emission Reductions through Reduced Use of Fertilizer on Agricultural Crops"
    AcrPluggingOrphanOilGasWellsUSCanada = "ACR - Plugging Orphan Oil and Gas Wells in the U.S. and Canada"
    AcrEmissionReductionsCompostAdditionsGrazedGrasslands = "ACR - Emission Reductions from Compost Additions to Grazed Grasslands"
    AcrUSODSProjectProtocol = "ACR - Climate Action Reserve U.S. Ozone Depleting Substances Project Protocol"
    AcrForestProjectProtocol = "ACR - Climate Action Reserve Forest Project Protocol"
    AcrEmissionReductionsRiceManagementSystems = "ACR - Emission Reductions in Rice Management Systems"
    AcrRestorationDegradedDeltaicWetlandsMississippiDelta = "ACR - Restoration of Degraded Deltaic Wetlands of the Mississippi Delta"
    AcrThermalEnergyProductionWithOrWithoutElectricity = "ACR - Thermal energy production with or without electricity"
    AcrEmissionReductionsEnhancedOilRecovery = "ACR - Emission Reductions from Enhanced Oil Recovery"
    AcrGridConnectedElectricityGenerationRenewableSources = "ACR - Consolidated baseline methodology for grid-connected electricity generation from renewable sources"
    AcrNitrousOxideAbatementProtocol = "ACR - Nitrous Oxide Abatement Protocol"
    AcrCaptureDestroyMethaneCoalTronaMinesNA = "ACR - Capturing and Destroying Methane from Coal and Trona Mines in North America"
    AcrReductionEmissionsRecyclingTransformerOil = "ACR - Reduction in Emissions from the Recycling of Transformer Oil"
    AcrReplaceSF6AlternateCoverGasMagnesiumIndustry = "ACR - Replacement of SF6 with Alternate Cover Gas in the Magnesium Industry"
    AcrEmissionsReductionsAntiIdlingTechnologies = "ACR - Emissions Reductions though Anti-Idling Technologies"
    AcrElectricityGenerationByUser = "ACR - Electricity generation by the user"
    AcrOffsetProjectMethodologyLandfillMethaneCollComb = "ACR - Offset Project Methodology for Landfill Methane Collection and Combustion"
    AcrGrazingLandLivestockManagement = "ACR - Grazing Land and Livestock Management"
    AcrEmissionReductionsWastewaterTreatment = "ACR - Emission reductions through wastewater treatment"
    CarAdipicAcidProduction = "CAR - Adipic Acid Production"
    CarBiochar = "CAR - Biochar"
    CarCanadaGrassland = "CAR - Canada Grassland"
    CarCoalMineMethane = "CAR - Coal Mine Methane"
    CarForest = "CAR - Forest"
    CarGrassland = "CAR - Grassland"
    CarMexicoBoilerEfficiency = "CAR - Mexico Boiler Efficiency"
    CarMexicoForest = "CAR - Mexico Forest"
    CarMexicoHalocarbon = "CAR - Mexico Halocarbon"
    CarMexicoLandfill = "CAR - Mexico Landfill"
    CarMexicoLivestock = "CAR - Mexico Livestock"
    CarMexicoOzoneDepletingSubstances = "CAR - Mexico Ozone Depleting Substances"
    CarNitricAcidProduction = "CAR - Nitric Acid Production"
    CarNitrogenManagement = "CAR - Nitrogen Management"
    CarOrganicWasteComposting = "CAR - Organic Waste Composting"
    CarOrganicWasteDigestion = "CAR - Organic Waste Digestion"
    CarOzoneDepletingSubstances = "CAR - Ozone Depleting Substances"
    CarRiceCultivation = "CAR - Rice Cultivation"
    CarSoilEnrichment = "CAR - Soil Enrichment"
    CarUrbanForestManagement = "CAR - Urban Forest Management"
    CarUrbanTreePlanting = "CAR - Urban Tree Planting"
    CarUsLandfill = "CAR - U.S. Landfill"
    CarUsLivestock = "CAR - U.S. Livestock"
    CarComplianceOffsetProtocolLivestockProjectsNov14 = "ARB Compliance Offset Protocol Livestock Projects, November 14, 2014"
    CarVersion6 = "CAR - Version 6.0"
    CarComplianceOffsetProtocolUSForestProjectsJune25 = "ARB Compliance Offset Protocol U.S. Forest Projects, June 25, 2015"
    CarVersion2_0 = "CAR - Version 2.0"
    CarVersion5_0 = "CAR - Version 5.0"
    CarVersion3_0 = "CAR - Version 3.0"
    CarVersion2_2 = "CAR - Version 2.2"
    CarComplianceOffsetProtocolUSForestProjectsNov14 = "ARB Compliance Offset Protocol U.S. Forest Projects, November 14, 2014"
    CarVersion1_0 = "CAR - Version 1.0"
    CarComplianceOffsetProtocolODSProjectsNov14 = "Compliance Offset Protocol ARB Ozone Depleting Substances Projects, November 14, 2014"
    CarVersion2_1 = "CAR - Version 2.1"
    CarVersion4_0 = "CAR - Version 4.0"
    CarComplianceOffsetProtocolMineMethaneCaptureApr25 = "ARB Compliance Offset Protocol Mine Methane Capture, April 25, 2014"
    CarVersion3_1 = "CAR - Version 3.1"
    CarComplianceOffsetProtocolUSForestProjectsOct20 = "ARB Compliance Offset Protocol U.S. Forest Projects, October 20, 2011"
    CarVersion1_5 = "CAR - Version 1.5"
    CarVersion1_1 = "CAR - Version 1.1"
    CarVersion3_2 = "CAR - Version 3.2"
    CarComplianceOffsetProtocolLivestockProjectsOct20 = "ARB Compliance Offset Protocol Livestock Projects, October 20, 2011"
    CarVersion1_4 = "CAR - Version 1.4"
    CarComplianceOffsetProtocolODSProjectsOct20 = "Compliance Offset Protocol ARB Ozone Depeleting Substances Projects, October 20, 2011"
    CdmAm0001 = "CDM - AM0001"
    CdmAm0002 = "CDM - AM0002"
    CdmAm0006 = "CDM - AM0006" 
    CdmAm0007 = "CDM - AM0007"
    CdmAm0009 = "CDM - AM0009"
    CdmAm0010 = "CDM - AM0010"
    CdmAm0012 = "CDM - AM0012"
    CdmAm0014 = "CDM - AM0014"
    CdmAm0017 = "CDM - AM0017"
    CdmAm0018 = "CDM - AM0018"
    CdmAm0019 = "CDM - AM0019"
    CdmAm0020 = "CDM - AM0020"
    CdmAm0021 = "CDM - AM0021"
    CdmAm0022 = "CDM - AM0022"
    CdmAm0023 = "CDM - AM0023"
    CdmAm0026 = "CDM - AM0026"
    CdmAm0027 = "CDM - AM0027"
    CdmAm0028 = "CDM - AM0028"
    CdmAm0030 = "CDM - AM0030"
    CdmAm0031 = "CDM - AM0031"
    CdmAm0035 = "CDM - AM0035"
    CdmAm0036 = "CDM - AM0036"
    CdmAm0037 = "CDM - AM0037"
    CdmAm0038 = "CDM - AM0038"
    CdmAm0043 = "CDM - AM0043"
    CdmAm0044 = "CDM - AM0044"
    CdmAm0045 = "CDM - AM0045"
    CdmAm0046 = "CDM - AM0046"
    CdmAm0048 = "CDM - AM0048"
    CdmAm0049 = "CDM - AM0049"
    CdmAm0050 = "CDM - AM0050"
    CdmAm0052 = "CDM - AM0052"
    CdmAm0053 = "CDM - AM0053"
    CdmAm0055 = "CDM - AM0055"
    CdmAm0056 = "CDM - AM0056"
    CdmAm0057 = "CDM - AM0057"
    CdmAm0058 = "CDM - AM0058"
    CdmAm0059 = "CDM - AM0059"
    CdmAm0060 = "CDM - AM0060"
    CdmAm0061 = "CDM - AM0061"
    CdmAm0062 = "CDM - AM0062"
    CdmAm0063 = "CDM - AM0063"
    CdmAm0064 = "CDM - AM0064"
    CdmAm0065 = "CDM - AM0065"
    CdmAm0066 = "CDM - AM0066"
    CdmAm0067 = "CDM - AM0067"
    CdmAm0068 = "CDM - AM0068"
    CdmAm0069 = "CDM - AM0069"
    CdmAm0070 = "CDM - AM0070"
    CdmAm0071 = "CDM - AM0071"
    CdmAm0072 = "CDM - AM0072"
    CdmAm0073 = "CDM - AM0073"
    CdmAm0074 = "CDM - AM0074"
    CdmAm0075 = "CDM - AM0075"
    CdmAm0076 = "CDM - AM0076"
    CdmAm0077 = "CDM - AM0077"
    CdmAm0078 = "CDM - AM0078"
    CdmAm0079 = "CDM - AM0079"
    CdmAm0080 = "CDM - AM0080"
    CdmAm0081 = "CDM - AM0081"
    CdmAm0082 = "CDM - AM0082"
    CdmAm0083 = "CDM - AM0083"
    CdmAm0084 = "CDM - AM0084"
    CdmAm0086 = "CDM - AM0086"
    CdmAm0088 = "CDM - AM0088"
    CdmAm0089 = "CDM - AM0089"
    CdmAm0090 = "CDM - AM0090"
    CdmAm0091 = "CDM - AM0091"
    CdmAm0092 = "CDM - AM0092"
    CdmAm0093 = "CDM - AM0093"
    CdmAm0094 = "CDM - AM0094"
    CdmAm0095 = "CDM - AM0095"
    CdmAm0096 = "CDM - AM0096"
    CdmAm0097 = "CDM - AM0097"
    CdmAm0098 = "CDM - AM0098"
    CdmAm0099 = "CDM - AM0099"
    CdmAm0100 = "CDM - AM0100"
    CdmAm0101 = "CDM - AM0101"
    CdmAm0103 = "CDM - AM0103"
    CdmAm0104 = "CDM - AM0104"
    CdmAm0105 = "CDM - AM0105"
    CdmAm0106 = "CDM - AM0106"
    CdmAm0107 = "CDM - AM0107"
    CdmAm0108 = "CDM - AM0108"
    CdmAm0109 = "CDM - AM0109"
    CdmAm0110 = "CDM - AM0110"
    CdmAm0111 = "CDM - AM0111"
    CdmAm0112 = "CDM - AM0112"
    CdmAm0113 = "CDM - AM0113"
    CdmAm0114 = "CDM - AM0114"
    CdmAm0115 = "CDM - AM0115"
    CdmAm0116 = "CDM - AM0116"
    CdmAm0117 = "CDM - AM0117"
    CdmAm0118 = "CDM - AM0118"
    CdmAm0119 = "CDM - AM0119"
    CdmAm0120 = "CDM - AM0120"
    CdmAm0121 = "CDM - AM0121"
    CdmAm0122 = "CDM - AM0122"
    CdmAmsIa = "CDM - AMS-I.A."
    CdmAmsIb = "CDM - AMS-I.B."
    CdmAmsIc = "CDM - AMS-I.C."
    CdmAmsId = "CDM - AMS-I.D."
    CdmAmsIe = "CDM - AMS-I.E."
    CdmAmsIf = "CDM - AMS-I.F."
    CdmAmsIg = "CDM - AMS-I.G."
    CdmAmsIh = "CDM - AMS-I.H."
    CdmAmsIi = "CDM - AMS-I.I."
    CdmAmsIj = "CDM - AMS-I.J."
    CdmAmsIk = "CDM - AMS-I.K."
    CdmAmsIl = "CDM - AMS-I.L."
    CdmAmsIm = "CDM - AMS-I.M."
    CdmAmsIIa = "CDM - AMS-II.A."
    CdmAmsIIb = "CDM - AMS-II.B."
    CdmAmsIIc = "CDM - AMS-II.C."
    CdmAmsIId = "CDM - AMS-II.D."
    CdmAmsIIe = "CDM - AMS-II.E."
    CdmAmsIIf = "CDM - AMS-II.F."
    CdmAmsIIg = "CDM - AMS-II.G."
    CdmAmsIIh = "CDM - AMS-II.H."
    CdmAmsIIi = "CDM - AMS-II.I."
    CdmAmsIIj = "CDM - AMS-II.J."
    CdmAmsIIk = "CDM - AMS-II.K."
    CdmAmsIIl = "CDM - AMS-II.L."
    CdmAmsIIm = "CDM - AMS-II.M."
    CdmAmsIIn = "CDM - AMS-II.N."
    CdmAmsIIo = "CDM - AMS-II.O."
    CdmAmsIIp = "CDM - AMS-II.P."
    CdmAmsIIq = "CDM - AMS-II.Q."
    CdmAmsIIr = "CDM - AMS-II.R."
    CdmAmsIIs = "CDM - AMS-II.S."
    CdmAmsIIt = "CDM - AMS-II.T."
    CdmAmsIIIa = "CDM - AMS-III.A."
    CdmAmsIIIb = "CDM - AMS-III.B."
    CdmAmsIIIc = "CDM - AMS-III.C."
    CdmAmsIIId = "CDM - AMS-III.D."
    CdmAmsIIIE = "CDM - AMS-III.E."
    CdmAmsIIIf = "CDM - AMS-III.F."
    CdmAmsIIIg = "CDM - AMS-III.G."
    CdmAmsIIIh = "CDM - AMS-III.H."
    CdmAmsIIIi = "CDM - AMS-III.I."
    CdmAmsIIIj = "CDM - AMS-III.J."
    CdmAmsIIIk = "CDM - AMS-III.K."
    CdmAmsIIIl = "CDM - AMS-III.L."
    CdmAmsIIIm = "CDM - AMS-III.M."
    CdmAmsIIIn = "CDM - AMS-III.N."
    CdmAmsIIIo = "CDM - AMS-III.O."
    CdmAmsIIIp = "CDM - AMS-III.P."
    CdmAmsIIIq = "CDM - AMS-III.Q."
    CdmAmsIIIr = "CDM - AMS-III.R."
    CdmAmsIIIs = "CDM - AMS-III.S."
    CdmAmsIIIt = "CDM - AMS-III.T."
    CdmAmsIIIu = "CDM - AMS-III.U."
    CdmAmsIIIv = "CDM - AMS-III.V."
    CdmAmsIIIw = "CDM - AMS-III.W."
    CdmAmsIIIx = "CDM - AMS-III.X."
    CdmAmsIIIy = "CDM - AMS-III.Y."
    CdmAmsIIIz = "CDM - AMS-III.Z."
    CdmAmsIIIAa = "CDM - AMS-III.AA."
    CdmAmsIIIAb = "CDM - AMS-III.AB."
    CdmAmsIIIac = "CDM - AMS-III.AC."
    CdmAmsIIIad = "CDM - AMS-III.AD."
    CdmAmsIIIae = "CDM - AMS-III.AE."
    CdmAmsIIIaf = "CDM - AMS-III.AF."
    CdmAmsIIIag = "CDM - AMS-III.AG."
    CdmAmsIIIah = "CDM - AMS-III.AH."
    CdmAmsIIIai = "CDM - AMS-III.AI."
    CdmAmsIIIaj = "CDM - AMS-III.AJ."
    CdmAmsIIIak = "CDM - AMS-III.AK."
    CdmAmsIIIal = "CDM - AMS-III.AL."
    CdmAmsIIIam = "CDM - AMS-III.AM."
    CdmAmsIIIan = "CDM - AMS-III.AN."
    CdmAmsIIIAo = "CDM - AMS-III.AO."
    CdmAmsIIIap = "CDM - AMS-III.AP."
    CdmAmsIIIaq = "CDM - AMS-III.AQ."
    CdmAmsIIIar = "CDM - AMS-III.AR."
    CdmAmsIIIAs = "CDM - AMS-III.AS."
    CdmAmsIIIAt = "CDM - AMS-III.AT."
    CdmAmsIIIau = "CDM - AMS-III.AU."
    CdmAmsIIIav = "CDM - AMS-III.AV."
    CdmAmsIIIaw = "CDM - AMS-III.AW."
    CdmAmsIIIax = "CDM - AMS-III.AX."
    CdmAmsIIIay = "CDM - AMS-III.AY."
    CdmAmsIIIba = "CDM - AMS-III.BA."
    CdmAmsIIIbb = "CDM - AMS-III.BB."
    CdmAmsIIIbc = "CDM - AMS-III.BC."
    CdmAmsIIIbd = "CDM - AMS-III.BD."
    CdmAmsIIIbe = "CDM - AMS-III.BE."
    CdmAmsIIIbf = "CDM - AMS-III.BF."
    CdmAmsIIIbg = "CDM - AMS-III.BG."
    CdmAmsIIIbh = "CDM - AMS-III.BH."
    CdmAmsIIIbi = "CDM - AMS-III.BI."
    CdmAmsIIIbj = "CDM - AMS-III.BJ."
    CdmAmsIIIbk = "CDM - AMS-III.BK."
    CdmAmsIIIbl = "CDM - AMS-III.BL."
    CdmAmsIIIbm = "CDM - AMS-III.BM."
    CdmAmsIIIbn = "CDM - AMS-III.BN."
    CdmAmsIIIbo = "CDM - AMS-III.BO."
    CdmAmsIIIbp = "CDM - AMS-III.BP."
    CdmArAm0014 = "CDM - AR-AM0014"
    CdmArAms0003 = "CDM - AR-AMS0003"
    CdmArAms0007 = "CDM - AR-AMS0007"
    GsMethodologyForMeteredMeasuredEnergyCookingDevices = "GS - METHODOLOGY FOR METERED & MEASURED ENERGY COOKING DEVICES"
    GsMethodologyForEmissionReductionsFromSafeDrinkingWaterSupply = "GS Methodology for emission reductions from safe drinking water supply"
    GsMethodologyForRetrofitEnergyEfficiencyMeasuresInShipping = "GS - METHODOLOGY FOR RETROFIT ENERGY EFFICIENCY MEASURES IN SHIPPING "
    GsSoilOrganicCarbonActivity = "GS - SOIL ORGANIC CARBON ACTIVITY MODULE FOR APPLICATION OF ORGANIC SOIL IMPROVERS FROM PULP AND PAPER MILL SLUDGES"
    GsReducedEmissionsFromCookingAndHeating = "GS - REDUCED EMISSIONS FROM COOKING AND HEATING ‚Äì TECHNOLOGIES AND PRACTICES TO DISPLACE DECENTRALIZED THERMAL ENERGY CONSUMPTION (TPDDTEC)"
    GsCarbonSequestration = "CARBON SEQUESTRATION THROUGH ACCELERATED CARBONATION OF CONCRETE AGGREGATE "
    GsAfforestationReforestationGHGEmissionsReductionSequestration = "Afforestation/Reforestation GHG Emissions Reduction & Sequestration Methodology"
    GsMSMethodologyForEfficientCookstovesV1 = "GS MS Simplified Methodology for Efficient Cookstoves v1.1"
    GsMethaneEmissionReductionAdjustedWaterManagementInRiceCultivation = "Methane Emission Reduction By Adjusted Water Management Practice In Rice Cultivation"
    GsMethodologyForAnimalWasteManagementAndBiogasApplication = "Methodology for animal waste management and biogas application"
    GsBaselineAndMonitoringMethodologyBiodigesterV1 = "GS Baseline and Monitoring Methodology Biodigester v1."
    GsSoilOrganicCarbonFrameworkMethodology = "Soil Organic Carbon Framework Methodology"
    GsRetrofitEnergyEfficiencyMeasuresInShippingV1 = "GS Retrofit Energy Efficiency Measures in Shipping v1."
    GsWaterAccessAndWashMethodologyV1 = "GS Water Access and WASH Methodology v1."
    GsRevisedMethodologyForManureManagementSystemsAndMSWV1 = "GS Revised Methodology for Manure Management Systems and MSW v1."
    SmallholderDairyMethodology = "Smallholder Dairy Methodology: Methodology for GHG Emission Reductions from Smallholder Dairy Production Systems"
    GsMSMicroscaleElectrificationAndEnergizationV1 = "GS MS Microscale Electrification and Energization v1."
    GsAlternativeIgnitionCoalFiresV1 = "GS Alternative Ignition Coal Fires v1."
    GsSSEcologicallySoundFuelSwitchToBiomassV1 = "GS SS Ecologically Sound Fuel Switch to Biomass v1."
    GsAdvancedHullCoatingsV2 = "GS Advanced Hull Coatings v2."
    GsBiodieselFromWasteOilOrFatV1 = "GS Biodiesel from Waste Oil or Fat v1."
    GsADALYSV1 = "GS ADALYS v1."
    GsTPDDTECV1 = "GS TPDDTEC v 1."
    GsTPDDTECV3 = "GS TPDDTEC v3"
    GsTPDDTECV4 = "GS TPDDTEC v4"
    VcsVm0001 = "VCS - VM0001"
    VcsVm0002 = "VCS - VM0002"
    VcsVm0003 = "VCS - VM0003"
    VcsVm0004 = "VCS - VM0004"
    VcsVm0005 = "VCS - VM0005"
    VcsVm0006 = "VCS - VM0006"
    VcsVm0007 = "VCS - VM0007"
    VcsVm0008 = "VCS - VM0008"
    VcsVm0009 = "VCS - VM0009"
    VcsVm0010 = "VCS - VM0010"
    VcsVm0011 = "VCS - VM0011"
    VcsVm0012 = "VCS - VM0012"
    VcsVm0013 = "VCS - VM0013"
    VcsVm0014 = "VCS - VM0014"
    VcsVm0015 = "VCS - VM0015"
    VcsVm0016 = "VCS - VM0016"
    VcsVm0017 = "VCS - VM0017"
    VcsVm0018 = "VCS - VM0018"
    VcsVm0019 = "VCS - VM0019"
    VcsVm0020 = "VCS - VM0020"
    VcsVm0021 = "VCS - VM0021"
    VcsVm0022 = "VCS - VM0022"
    VcsVm0023 = "VCS - VM0023"
    VcsVm0024 = "VCS - VM0024"
    VcsVm0025 = "VCS - VM0025"
    VcsVm0026 = "VCS - VM0026"
    VcsVm0027 = "VCS - VM0027"
    VcsVm0028 = "VCS - VM0028"
    VcsVm0029 = "VCS - VM0029"
    VcsVm0030 = "VCS - VM0030"
    VcsVm0031 = "VCS - VM0031"
    VcsVm0032 = "VCS - VM0032"
    VcsVm0033 = "VCS - VM0033"
    VcsVm0034 = "VCS - VM0034"
    VcsVm0035 = "VCS - VM0035"
    VcsVm0036 = "VCS - VM0036"
    VcsVm0037 = "VCS - VM0037"
    VcsVm0038 = "VCS - VM0038"
    VcsVm0039 = "VCS - VM0039"
    VcsVm0040 = "VCS - VM0040"
    VcsVm0041 = "VCS - VM0041"
    VcsVm0042 = "VCS - VM0042"
    VcsVm0043 = "VCS - VM0043"
    VcsVm0044 = "VCS - VM0044"
    VcsVm0045 = "VCS - VM0045"
    VcsVm0046 = "VCS - VM0046"
    VcsVm0047 = "VCS - VM0047"
    VcsVm0048 = "VCS - VM0048"
    VcsVm0049 = "VCS - VM0049"
    VcsVm0050 = "VCS - VM0050"
    VcsVm0051 = "VCS - VM0051"
    VcsVm0052 = "VCS - VM0052"
    VcsVm0053 = "VCS - VM0053"
    VcsVm0054 = "VCS - VM0054"
    VcsVm0055 = "VCS - VM0055"
    VcsVm0056 = "VCS - VM0056"
    VcsVm0057 = "VCS - VM0057"
    VcsVm0058 = "VCS - VM0058"
    VcsVm0059 = "VCS - VM0059"
    VcsVm0060 = "VCS - VM0060"
    VcsVm0061 = "VCS - VM0061"
    VcsVm0062 = "VCS - VM0062"
    VcsVm0063 = "VCS - VM0063"
    VcsVm0064 = "VCS - VM0064"
    VcsVm0065 = "VCS - VM0065"
    VcsVm0066 = "VCS - VM0066"
    VcsVm0067 = "VCS - VM0067"
    VcsVm0068 = "VCS - VM0068"
    VcsVm0069 = "VCS - VM0069"
    VcsVm0070 = "VCS - VM0070"
    VcsVm0071 = "VCS - VM0071"
    VcsVm0072 = "VCS - VM0072"
    VcsVm0073 = "VCS - VM0073"
    VcsVm0074 = "VCS - VM0074"
    VcsVm0075 = "VCS - VM0075"
    VcsVm0076 = "VCS - VM0076"
    VcsVm0077 = "VCS - VM0077"
    VcsVm0078 = "VCS - VM0078"
    VcsVm0079 = "VCS - VM0079"
    VcsVm0080 = "VCS - VM0080"
    VcsVm0081 = "VCS - VM0081"
    VcsVm0082 = "VCS - VM0082"
    VcsVm0083 = "VCS - VM0083"
    VcsVm0084 = "VCS - VM0084"
    VcsVm0085 = "VCS - VM0085"
    VcsVm0086 = "VCS - VM0086"
    VcsVm0087 = "VCS - VM0087"
    VcsVm0088 = "VCS - VM0088"
    VcsVm0089 = "VCS - VM0089"
    VcsVm0090 = "VCS - VM0090"
    VcsVm0091 = "VCS - VM0091"
    VcsVm0092 = "VCS - VM0092"
    VcsVm0093 = "VCS - VM0093"
    VcsVm0094 = "VCS - VM0094"
    VcsVm0095 = "VCS - VM0095"
    VcsVm0096 = "VCS - VM0096"
    VcsVm0097 = "VCS - VM0097"
    VcsVm0098 = "VCS - VM0098"
    VcsVm0099 = "VCS - VM0099"
    VcsVm0100 = "VCS - VM0100"
    VcsVm0101 = "VCS - VM0101"
    VcsVm0102 = "VCS - VM0102"
    VcsVm0103 = "VCS - VM0103"
    VcsVm0104 = "VCS - VM0104"
    VcsVm0105 = "VCS - VM0105"
    VcsVm0106 = "VCS - VM0106"
    VcsVm0107 = "VCS - VM0107"
    VcsVm0108 = "VCS - VM0108"
    VcsVm0109 = "VCS - VM0109"
    VcsVm0110 = "VCS - VM0110"
    VcsVm0111 = "VCS - VM0111"
    VcsVm0112 = "VCS - VM0112"
    VcsVm0113 = "VCS - VM0113"
    VcsVm0114 = "VCS - VM0114"
    VcsVm0115 = "VCS - VM0115"
    VcsVm0116 = "VCS - VM0116"
    VcsVm0117 = "VCS - VM0117"
    VcsVm0118 = "VCS - VM0118"
    VcsVm0119 = "VCS - VM0119"
    VcsVm0120 = "VCS - VM0120"
    VcsVm0121 = "VCS - VM0121"
    VcsVm0122 = "VCS - VM0122"
    VcsVm0123 = "VCS - VM0123"
    VcsVm0124 = "VCS - VM0124"
    VcsVm0125 = "VCS - VM0125"
    VcsVm0126 = "VCS - VM0126"
    VcsVm0127 = "VCS - VM0127"
    VcsVm0128 = "VCS - VM0128"
    VcsVm0129 = "VCS - VM0129"
    VcsVm0130 = "VCS - VM0130"
    VcsVm0131 = "VCS - VM0131"
    VcsVm0132 = "VCS - VM0132"
    VcsVm0133 = "VCS - VM0133"
    VcsVm0134 = "VCS - VM0134"
    VcsVm0135 = "VCS - VM0135"
    VcsVm0136 = "VCS - VM0136"
    VcsVm0137 = "VCS - VM0137"
    VcsVm0138 = "VCS - VM0138"
    VcsVm0139 = "VCS - VM0139"
    VcsVm0140 = "VCS - VM0140"
    VcsVm0141 = "VCS - VM0141"
    VcsVm0142 = "VCS - VM0142"
    VcsVm0143 = "VCS - VM0143"
    VcsVm0144 = "VCS - VM0144"
    VcsVm0145 = "VCS - VM0145"
    VcsVm0146 = "VCS - VM0146"
    VcsVm0147 = "VCS - VM0147"
    VcsVm0148 = "VCS - VM0148"
    VcsVm0149 = "VCS - VM0149"
    VcsVm0150 = "VCS - VM0150"
    VcsVm0151 = "VCS - VM0151"
    VcsVm0152 = "VCS - VM0152"
    VcsVm0153 = "VCS - VM0153"
    VcsVm0154 = "VCS - VM0154"
    VcsVm0155 = "VCS - VM0155"
    VcsVm0156 = "VCS - VM0156"
    VcsVm0157 = "VCS - VM0157"
    VcsVm0158 = "VCS - VM0158"
    VcsVm0159 = "VCS - VM0159"
    VcsVm0160 = "VCS - VM0160"
    VcsVm0161 = "VCS - VM0161"
    VcsVm0162 = "VCS - VM0162"
    VcsVm0163 = "VCS - VM0163"
    VcsVm0164 = "VCS - VM0164"
    VcsVm0165 = "VCS - VM0165"
    VcsVm0166 = "VCS - VM0166"
    VcsVm0167 = "VCS - VM0167"
    VcsVm0168 = "VCS - VM0168"
    VcsVm0169 = "VCS - VM0169"
    VcsVm0170 = "VCS - VM0170"
    VcsVm0171 = "VCS - VM0171"
    VcsVm0172 = "VCS - VM0172"
    VcsVm0173 = "VCS - VM0173"
    VcsVm0174 = "VCS - VM0174"
    VcsVm0175 = "VCS - VM0175"
    VcsVm0176 = "VCS - VM0176"
    VcsVm0177 = "VCS - VM0177"
    VcsVm0178 = "VCS - VM0178"
    VcsVm0179 = "VCS - VM0179"
    VcsVm0180 = "VCS - VM0180"
    VcsVm0181 = "VCS - VM0181"
    VcsVm0182 = "VCS - VM0182"
    VcsVm0183 = "VCS - VM0183"
    VcsVm0184 = "VCS - VM0184"
    VcsVm0185 = "VCS - VM0185"
    VcsVm0186 = "VCS - VM0186"
    VcsVm0187 = "VCS - VM0187"
    VcsVm0188 = "VCS - VM0188"
    VcsVm0189 = "VCS - VM0189"
    VcsVm0190 = "VCS - VM0190"
    VcsVm0191 = "VCS - VM0191"
    VcsVm0192 = "VCS - VM0192"
    VcsVm0193 = "VCS - VM0193"
    VcsVm0194 = "VCS - VM0194"
    VcsVm0195 = "VCS - VM0195"
    VcsVm0196 = "VCS - VM0196"
    VcsVm0197 = "VCS - VM0197"
    VcsVm0198 = "VCS - VM0198"
    VcsVm0199 = "VCS - VM0199"
    VcsVm0200 = "VCS - VM0200"
    VcsVm0201 = "VCS - VM0201"
    VcsVm0202 = "VCS - VM0202"
    VcsVm0203 = "VCS - VM0203"
    VcsVm0204 = "VCS - VM0204"
    VcsVm0205 = "VCS - VM0205"
    VcsVm0206 = "VCS - VM0206"
    VcsVm0207 = "VCS - VM0207"
    VcsVm0208 = "VCS - VM0208"
    VcsVm0209 = "VCS - VM0209"
    VcsVm0210 = "VCS - VM0210"
    VcsVm0211 = "VCS - VM0211"
    VcsVm0212 = "VCS - VM0212"
    VcsVm0213 = "VCS - VM0213"
    VcsVm0214 = "VCS - VM0214"
    VcsVm0215 = "VCS - VM0215"
    VcsVm0216 = "VCS - VM0216"
    VcsVm0217 = "VCS - VM0217"
    VcsVm0218 = "VCS - VM0218"
    VcsVm0219 = "VCS - VM0219"
    VcsVm0220 = "VCS - VM0220"
    VcsVm0221 = "VCS - VM0221"
    VcsVm0222 = "VCS - VM0222"
    VcsVm0223 = "VCS - VM0223"
    VcsVm0224 = "VCS - VM0224"
    VcsVm0225 = "VCS - VM0225"
    VcsVm0226 = "VCS - VM0226"
    VcsVm0227 = "VCS - VM0227"
    VcsVm0228 = "VCS - VM0228"
    VcsVm0229 = "VCS - VM0229"
    VcsVm0230 = "VCS - VM0230"
    VcsVm0231 = "VCS - VM0231"
    VcsVm0232 = "VCS - VM0232"
    VcsVm0233 = "VCS - VM0233"
    VcsVm0234 = "VCS - VM0234"
    VcsVm0235 = "VCS - VM0235"
    VcsVm0236 = "VCS - VM0236"
    VcsVm0237 = "VCS - VM0237"
    VcsVm0238 = "VCS - VM0238"
    VcsVm0239 = "VCS - VM0239"
    VcsVm0240 = "VCS - VM0240"
    VcsVm0241 = "VCS - VM0241"
    VcsVm0242 = "VCS - VM0242"
    VcsVm0243 = "VCS - VM0243"
    VcsVm0244 = "VCS - VM0244"
    VcsVm0245 = "VCS - VM0245"
    VcsVm0246 = "VCS - VM0246"
    VcsVm0247 = "VCS - VM0247"
    VcsVm0248 = "VCS - VM0248"
    VcsVm0249 = "VCS - VM0249"
    VcsVm0250 = "VCS - VM0250"
    VcsVm0251 = "VCS - VM0251"
    VcsVm0252 = "VCS - VM0252"
    VcsVm0253 = "VCS - VM0253"
    VcsVm0254 = "VCS - VM0254"
    VcsVm0255 = "VCS - VM0255"
    VcsVm0256 = "VCS - VM0256"
    VcsVm0257 = "VCS - VM0257"
    VcsVm0258 = "VCS - VM0258"
    VcsVm0259 = "VCS - VM0259"
    VcsVm0260 = "VCS - VM0260"
    VcsVm0261 = "VCS - VM0261"
    VcsVm0262 = "VCS - VM0262"
    VcsVm0263 = "VCS - VM0263"
    VcsVm0264 = "VCS - VM0264"
    VcsVm0265 = "VCS - VM0265"
    VcsVm0266 = "VCS - VM0266"
    VcsVm0267 = "VCS - VM0267"
    VcsVm0268 = "VCS - VM0268"
    VcsVm0269 = "VCS - VM0269"
    VcsVm0270 = "VCS - VM0270"
    VcsVm0271 = "VCS - VM0271"
    VcsVm0272 = "VCS - VM0272"
    VcsVm0273 = "VCS - VM0273"
    VcsVm0274 = "VCS - VM0274"
    VcsVm0275 = "VCS - VM0275"
    VcsVm0276 = "VCS - VM0276"
    VcsVm0277 = "VCS - VM0277"
    VcsVm0278 = "VCS - VM0278"
    VcsVm0279 = "VCS - VM0279"
    VcsVm0280 = "VCS - VM0280"
    VcsVm0281 = "VCS - VM0281"
    VcsVm0282 = "VCS - VM0282"
    VcsVm0283 = "VCS - VM0283"
    VcsVm0284 = "VCS - VM0284"
    VcsVm0285 = "VCS - VM0285"
    VcsVm0286 = "VCS - VM0286"
    VcsVm0287 = "VCS - VM0287"
    VcsVm0288 = "VCS - VM0288"
    VcsVm0289 = "VCS - VM0289"
    VcsVm0290 = "VCS - VM0290"
    VcsVm0291 = "VCS - VM0291"
    VcsVm0292 = "VCS - VM0292"
    VcsVm0293 = "VCS - VM0293"
    VcsVm0294 = "VCS - VM0294"
    VcsVm0295 = "VCS - VM0295"
    VcsVm0296 = "VCS - VM0296"
    VcsVm0297 = "VCS - VM0297"
    VcsVm0298 = "VCS - VM0298"
    VcsVm0299 = "VCS - VM0299"
    VcsVm0300 = "VCS - VM0300"
    VcsVm0301 = "VCS - VM0301"
    VcsVm0302 = "VCS - VM0302"
    VcsVm0303 = "VCS - VM0303"
    VcsVm0304 = "VCS - VM0304"
    VcsVm0305 = "VCS - VM0305"
    VcsVm0306 = "VCS - VM0306"
    VcsVm0307 = "VCS - VM0307"
    VcsVm0308 = "VCS - VM0308"
    VcsVm0309 = "VCS - VM0309"
    VcsVm0310 = "VCS - VM0310"
    VcsVm0311 = "VCS - VM0311"
    VcsVm0312 = "VCS - VM0312"
    VcsVm0313 = "VCS - VM0313"
    VcsVm0314 = "VCS - VM0314"
    VcsVm0315 = "VCS - VM0315"
    VcsVm0316 = "VCS - VM0316"
    VcsVm0317 = "VCS - VM0317"
    VcsVm0318 = "VCS - VM0318"
    VcsVm0319 = "VCS - VM0319"
    VcsVm0320 = "VCS - VM0320"
    VcsVm0321 = "VCS - VM0321"
    VcsVm0322 = "VCS - VM0322"
    VcsVm0323 = "VCS - VM0323"
    VcsVm0324 = "VCS - VM0324"
    VcsVm0325 = "VCS - VM0325"
    VcsVm0326 = "VCS - VM0326"
    VcsVm0327 = "VCS - VM0327"
    VcsVm0328 = "VCS - VM0328"
    VcsVm0329 = "VCS - VM0329"
    VcsVm0330 = "VCS - VM0330"
    VcsVm0331 = "VCS - VM0331"
    VcsVm0332 = "VCS - VM0332"
    VcsVm0333 = "VCS - VM0333"
    VcsVm0334 = "VCS - VM0334"
    VcsVm0335 = "VCS - VM0335"
    VcsVm0336 = "VCS - VM0336"
    VcsVm0337 = "VCS - VM0337"
    VcsVm0338 = "VCS - VM0338"
    VcsVm0339 = "VCS - VM0339"
    VcsVm0340 = "VCS - VM0340"
    VcsVm0341 = "VCS - VM0341"
    VcsVm0342 = "VCS - VM0342"
    VcsVm0343 = "VCS - VM0343"
    VcsVmR000 = "VCS - VMR000"
    VcsVmR006 = "VCS - VMR006"
    IdPm044 = "ID_PM044"
    IdPm043 = "ID_PM043"
    IdPm042 = "ID_PM042"
    IdPm041 = "ID_PM041"
    IdPm040 = "ID_PM040"
    IdPm039 = "ID_PM039"
    IdAm028 = "ID_AM028"
    IdAm027 = "ID_AM027"
    IdAm026 = "ID_AM026"
    IdAm025 = "ID_AM025"
    IdAm024 = "ID_AM024"
    IdAm023 = "ID_AM023"
    IdAm022 = "ID_AM022"
    IdAm021 = "ID_AM021"
    IdAm020 = "ID_AM020"
    IdAm006 = "ID_AM006"
    VnPm028 = "VN_PM028"
    IdAm019 = "ID_AM019"
    VnPm027 = "VN_PM027"
    IdAm018 = "ID_AM018"
    IdAm007 = "ID_AM007"
    ThPm026 = "TH_PM026"
    VnPm026 = "VN_PM026"
    VnPm025 = "VN_PM025"
    ThPm025 = "TH_PM025"
    IdAm009 = "ID_AM009"
    VnPm024 = "VN_PM024"
    IdAm017 = "ID_AM017"
    ThPm024 = "TH_PM024"
    IdAm016 = "ID_AM016"
    VnPm023 = "VN_PM023"
    ThPm023 = "TH_PM023"
    IdAm015 = "ID_AM015"
    ThPm022 = "TH_PM022"
    VnAm015 = "VN_AM015"
    VnAm009 = "VN_AM009"
    IdAm014 = "ID_AM014"
    ThPm021 = "TH_PM021"
    ThAm017 = "TH_AM017"
    IdAm013 = "ID_AM013"
    VnAm014 = "VN_AM014"
    VnAm013 = "VN_AM013"
    ThAm016 = "TH_AM016"
    VnAm012 = "VN_AM012"
    ThAm015 = "TH_AM015"
    IdAm011 = "ID_AM011"
    ThAm001 = "TH_AM001"
    VnAm011 = "VN_AM011"
    IdAm012 = "ID_AM012"
    VnAm010 = "VN_AM010"
    ThAm014 = "TH_AM014"
    IdAm008 = "ID_AM008"
    VnAm006 = "VN_AM006"
    ThAm013 = "TH_AM013"
    ThAm012 = "TH_AM012"
    VnAm004 = "VN_AM004"
    IdAm005 = "ID_AM005"
    IdAm004 = "ID_AM004"
    ThAm011 = "TH_AM011"
    VnAm003 = "VN_AM003"
    IdAm003 = "ID_AM003"
    VnAm002 = "VN_AM002"
    ThAm010 = "TH_AM010"
    IdAm002 = "ID_AM002"
    ThAm009 = "TH_AM009"
    IdAm010 = "ID_AM010"
    VnAm008 = "VN_AM008"
    ThAm008 = "TH_AM008"
    ThAm005 = "TH_AM005"
    VnAm007 = "VN_AM007"
    ThAm007 = "TH_AM007"
    VnAm001 = "VN_AM001"
    MmPm007 = "MM_PM007"
    ThAm006 = "TH_AM006"
    MmPm006 = "MM_PM006"
    VnAm005 = "VN_AM005"
    KhAm004 = "KH_AM004"
    ThAm002 = "TH_AM002"
    KhAm005 = "KH_AM005"
    BdPm005 = "BD_PM005"
    MmAm005 = "MM_AM005"
    ThAm004 = "TH_AM004"
    LaAm004 = "LA_AM004"
    BdAm001 = "BD_AM001"
    MnAm003 = "MN_AM003"
    MmAm004 = "MM_AM004"
    KeAm003 = "KE_AM003"
    LaAm003 = "LA_AM003"
    MmAm003 = "MM_AM003"
    CrAm003 = "CR_AM003"
    KhAm003 = "KH_AM003"
    PhPm003 = "PH_PM003"
    ThAm003 = "TH_AM003"
    ClAm001 = "CL_AM001"
    EtAm003 = "ET_AM003"
    BdAm003 = "BD_AM003"
    BdAm002 = "BD_AM002"
    EtAm002 = "ET_AM002"
    KeAm002 = "KE_AM002"
    CrAm002 = "CR_AM002"
    LaAm002 = "LA_AM002"
    KhAm002 = "KH_AM002"
    MvAm002 = "MV_AM002"
    MmAm002 = "MM_AM002"
    PhAm002 = "PH_AM002"
    MnAm002 = "MN_AM002"
    ClAm002 = "CL_AM002"
    PwAm001 = "PW_AM001"
    PhAm001 = "PH_AM001"
    KeAm001 = "KE_AM001"
    KhAm001 = "KH_AM001"
    SaAm001 = "SA_AM001"
    MnAm001 = "MN_AM001"
    MmAm001 = "MM_AM001"
    CrAm001 = "CR_AM001"
    IdAm001 = "ID_AM001"
    MxAm001 = "MX_AM001"
    EtAm001 = "ET_AM001"
    LaAm001 = "LA_AM001"
    MvAm001 = "MV_AM001"

    def __str__(self):
        return self.value


@strawberry.enum
class ValidationBody(Enum):
    FourKEarthSciencePrivateLimited = "4K Earth Science Private Limited"
    AENORInternationalSAU = "AENOR International S.A.U."
    AgriWasteTechnologyInc = "Agri-Waste Technology, Inc."
    AsterGlobalEnvironmentalSolutionsInc = "Aster Global Environmental Solutions, Inc."
    CarbonCheckIndiaPrivateLtd = "Carbon Check (India) Private Ltd."
    ChinaBuildingMaterialTestAndCertificationGroupCoLTDCTC = "China Building Material Test & Certification Group Co. LTD. (CTC)"
    ChinaClassificationSocietyCertificationCoLtdCCSC = "China Classification Society Certification Co. Ltd. (CCSC)"
    ChinaEnvironmentalUnitedCertificationCenterCoLtdCEC = "China Environmental United Certification Center Co., Ltd. (CEC)"
    ChinaQualityCertificationCenterCQC = "China Quality Certification Center (CQC)"
    ColombianInstituteForTechnicalStandardsAndCertificationICONTEC = "Colombian Institute for Technical Standards and Certification (ICONTEC)"
    EarthoodServicesPrivateLimited = "Earthood Services Private Limited"
    EnviroAccesInc = "Enviro-Accès Inc."
    EPICSustainabilityServicesPvtLtd = "EPIC Sustainability Services Pvt. Ltd."
    ERMCertificationAndVerificationServicesLtd = "ERM Certification and Verification Services Ltd."
    FirstEnvironmentInc = "First Environment, Inc."
    GHDServicesInc = "GHD Services, Inc."
    KBSCertificationServicesPvtLtd = "KBS Certification Services Pvt. Ltd."
    LGAITechnologicalCenterSA = "LGAI Technological Center, S.A. (Applus+)"
    ReCarbonLtd = "Re Carbon Ltd."
    RINAServicesSpA = "RINA Services S.p.A"
    RubyCanyonEnvironmentalInc = "Ruby Canyon Environmental, Inc"
    SAndACarbonLLC = "S&A Carbon, LLC"
    SCSGlobalServices = "SCS Global Services"
    ShenzhenCTIInternationalCertificationCoLtdCTI = "Shenzhen CTI International Certification Co., Ltd (CTI)"
    TUVNordCertGmbH = "TÜV Nord Cert GmbH"
    TUVSUDSouthAsiaPrivateLimited = "TÜV SÜD South Asia Private Limited"
    Other = "Other"
    TUVSUDAmericaIncRubyCanyon = "TUV SUD America, Inc.-Ruby Canyon"
    SCSEngineers = "SCS Engineers"
    AsociacionDeNormalizacionYCertificacionSADeCV = "Asociacion de Normalizacion y Certificacion, S.A. de C.V."
    GREENCERTIFICACIONESEINSPECCIONESSC = "GREEN CERTIFICACIONES E INSPECCIONES S.C."
    FirstEnvironmentOfCaliforniaInc = "First Environment of California, Inc."
    NSFCertificationLLC = "NSF Certification LLC"
    LRQAAmericasSustainabilityInc = "LRQA Americas Sustainability, Inc. (Formerly RMA)"
    SESInc = "SES, Inc."
    THEEARTHLABSADeCV = "THEEARTHLAB S.A de C.V"
    EnvironmentalServicesInc = "Environmental Services, Inc."
    DNV = "DNV"
    DNVUSAInc = "Det Norske Veritas (U.S.A.), Inc."
    GHDLimited = "GHD Limited"
    FuturepastInc = "Futurepast: Inc."
    NOVACERTLLC = "NOVA CERT LLC"

    def __str__(self):
        return self.value
    
@strawberry.enum
class Countries(Enum):
    Afghanistan = "Afghanistan"
    Albania = "Albania"
    Algeria = "Algeria"
    Andorra = "Andorra"
    Angola = "Angola"
    AntiguaAndBarduba = "Antigua and Barduba"
    Argentina = "Argentina"
    Australia = "Australia"
    Austria = "Austria"
    Azerbaijan = "Azerbaijan"
    Bahamas = "Bahamas"
    Bahrain = "Bahrain"
    Bangladesh = "Bangladesh"
    Barbados = "Barbados"
    Belarus = "Belarus"
    Belgium = "Belgium"
    Belize = "Belize"
    Benin = "Benin"
    Bhutan = "Bhutan"
    Bolivia = "Bolivia"
    BosniaAndHerzegovina = "Bosnia and Herzegovina"
    Botswana = "Botswana"
    Brazil = "Brazil"
    BruneiDarussalam = "Brunei Darussalam"
    Bulgaria = "Bulgaria"
    BurkinaFaso = "Burkina Faso"
    Burundi = "Burundi"
    CaboVerde = "Cabo Verde"
    Cambodia = "Cambodia"
    Cameroon = "Cameroon"
    Canada = "Canada"
    CentralAfricanRepublic = "Central African Republic"
    Chad = "Chad"
    Chile = "Chile"
    China = "China"
    Colombia = "Colombia"
    Comoros = "Comoros"
    Congo = "Congo"
    CostaRica = "Costa Rica"
    CoteDIvoire = "Cote d'Ivoire"
    Croatia = "Croatia"
    Cuba = "Cuba"
    Cyprus = "Cyprus"
    CzechRepublic = "Czech Republic"
    DemocraticPeoplesRepublicOfKorea = "Democratic People's Republic of Korea"
    DemocraticRepublicOfCongo = "Democratic Republic of Congo"
    Denmark = "Denmark"
    Djibouti = "Djibouti"
    Dominica = "Dominica"
    DomincanRepublic = "Domincan Republic"
    Egypt = "Egypt"
    ElSalvador = "El Salvador"
    EquatorialNewGuinea = "Equatorial New Guinea"
    Eritrea = "Eritrea"
    Estonia = "Estonia"
    Ethiopia = "Ethiopia"
    EuropeanUnion = "European Union"
    Fiji = "Fiji"
    Finland = "Finland"
    France = "France"
    Gabon = "Gabon"
    Georgia = "Georgia"
    Germany = "Germany"
    Ghana = "Ghana"
    Greece = "Greece"
    Grenada = "Grenada"
    Guatemala = "Guatemala"
    Guinea = "Guinea"
    GuineaBissau = "Guinea Bissau"
    Guyana = "Guyana"
    Haiti = "Haiti"
    Honduras = "Honduras"
    Hungary = "Hungary"
    Iceland = "Iceland"
    India = "India"
    Indonesia = "Indonesia"
    Iran = "Iran"
    Ireland = "Ireland"
    Israel = "Israel"
    Italy = "Italy"
    Jamaica = "Jamaica"
    Japan = "Japan"
    Jordan = "Jordan"
    Kenya = "Kenya"
    Kiribati = "Kiribati"
    Kuwait = "Kuwait"
    LaoPeoplesDemocraticRepublic = "Lao People's Democratic Republic"
    Latvia = "Latvia"
    Lebanon = "Lebanon"
    Lesotho = "Lesotho"
    Liberia = "Liberia"
    Libya = "Libya"
    Liechtenstein = "Liechtenstein"
    Lithuania = "Lithuania"
    Luxembourg = "Luxembourg"
    Madagascar = "Madagascar"
    Malaysia = "Malaysia"
    Maldives = "Maldives"
    Mali = "Mali"
    Malta = "Malta"
    MarshallIslands = "Marshall Islands"
    Mauritius = "Mauritius"
    Mauritania = "Mauritania"
    Mexico = "Mexico"
    Micronesia = "Micronesia"
    Monaco = "Monaco"
    Mongolia = "Mongolia"
    Montenegro = "Montenegro"
    Morocco = "Morocco"
    Mozambique = "Mozambique"
    Myanmar = "Myanmar"
    Namibia = "Namibia"
    Nauru = "Nauru"
    Nepal = "Nepal"
    Netherlands = "Netherlands"
    NewZealand = "New Zealand"
    Niger = "Niger"
    Norway = "Norway"
    Oman = "Oman"
    Pakistan = "Pakistan"
    Palau = "Palau"
    Panama = "Panama"
    PapuaNewGuinea = "Papua New Guinea"
    Paraguay = "Paraguay"
    Peru = "Peru"
    Philippines = "Philippines"
    Poland = "Poland"
    Portugal = "Portugal"
    Qatar = "Qatar"
    RepublicOfKorea = "Republic of Korea"
    Romania = "Romania"
    RussianFederation = "Russian Federation"
    Rwanda = "Rwanda"
    SaintKittsAndNevis = "Saint Kitts and Nevis"
    SaintLucia = "Saint Lucia"
    SaintVincentAndTheGrenadines = "Saint Vincent and the Grenadines"
    Samoa = "Samoa"
    SanMarino = "San Marino"
    SaoTomeAndPrincipe = "Sao Tome and Principe"
    SaudiArabia = "Saudi Arabia"
    Senegal = "Senegal"
    Serbia = "Serbia"
    Singapore = "Singapore"
    Slovakia = "Slovakia"
    Slovenia = "Slovenia"
    SolomonIslands = "Solomon Islands"
    Somalia = "Somalia"
    SouthAfrica = "South Africa"
    SouthSudan = "South Sudan"
    Spain = "Spain"
    SriLanka = "Sri Lanka"
    StateOfPalestine = "State of Palestine"
    Sudan = "Sudan"
    Suriname = "Suriname"
    Swaziland = "Swaziland"
    Sweden = "Sweden"
    Switzerland = "Switzerland"
    Tajikistan = "Tajikistan"
    Thailand = "Thailand"
    TheFormerYugoslavRepublicOfMacedonia = "The Former Yugoslav Republic of Macedonia"
    TimorLeste = "Timor-Leste"
    Tonga = "Tonga"
    TrinidadAndTobago = "Trinidad and Tobago"
    Tunisia = "Tunisia"
    Turkey = "Turkey"
    Tuvalu = "Tuvalu"
    Uganda = "Uganda"
    Ukraine = "Ukraine"
    UnitedArabEmirates = "United Arab Emirates"
    UnitedKingdom = "United Kingdom"
    UnitedRepublicOfTanzania = "United Republic of Tanzania"
    UnitedStatesOfAmerica = "United States of America"
    Uruguay = "Uruguay"
    Vanuatu = "Vanuatu"
    Venezuela = "Venezuela"
    VietNam = "Viet Nam"
    Zimbabwe = "Zimbabwe"
    Nicaragua = "Nicaragua"
    
    def __str__(self):
        return self.value

@strawberry.enum
class RatingType(Enum):
    CDP = "CDP"
    CCQI = "CCQI"
    MAAP = "MAAP"
    SylveraCarbonRating = "Sylvera Carbon Rating"
    BeZeroRating = "BeZero Rating"

    def __str__(self):
        return self.value

@strawberry.enum
class UnitType(Enum):
    ReductionNature = "Reduction - nature"
    ReductionTechnical = "Reduction - technical"
    RemovalNature = "Removal - nature"
    RemovalTechnical = "Removal - technical"
    Avoidance = "Avoidance"

    def __str__(self):
        return self.value

@strawberry.enum
class UnitStatus(Enum):
    Issued = "Issued"
    Assigned = "Assigned"
    Held = "Held"
    Retired = "Retired"
    Cancelled = "Cancelled"
    Expired = "Expired"
    Buffer = "Buffer"
    Exported = "Exported"
    PendingExport = "Pending Export"

    def __str__(self):
        return self.value

@strawberry.enum
class CorrespondingAdjustmentDeclaration(Enum):
    Committed = "Committed"
    NotRequired = "Not Required"
    Unknown = "Unknown"

    def __str__(self):
        return self.value

@strawberry.enum
class CorrespondingAdjustmentStatus(Enum):
    NotStarted = "Not Started"
    Pending = "Pending"
    Completed = "Completed"

    def __str__(self):
        return self.value

@strawberry.enum
class LabelType(Enum):
    Endorsement = "Endorsement"
    LetterOfQualification = "Letter of Qualification"
    Certification = "Certification"
    LetterOfAuthorization = "Letter of Authorization"
    LetterOfApproval = "Letter of Approval"

