Write-Host;
Write-Host Preparing environment to run MAFFT on Windows.
Write-Host This may take a while, if real-time scanning by anti-virus software is on.

Set-Item Env:Path "/usr/bin;$Env:Path"
Set-Item Env:MAFFT_BINARIES "/usr/lib/mafft"
Set-Item Env:TMPDIR "$Env:TMP"
Set-Item Env:MAFFT_TMPDIR "$Env:TMP"
Set-Item Env:mafft_working_dir "$PWD"

#Set-Item Env:TMPDIR "/tmp"
#Set-Item Env:MAFFT_TMPDIR "/tmp"
# If you do not have write permission for standard temporary folder
# (typically C:\Users\username\AppData\Local\Temp\), then
# uncomment (remove #) the above two lines to use an alternative 
# temporary folder.

#$ROOTDIR=$PSScriptRoot # not supported by powershell versions <= 2
$ROOTDIR=Split-Path -Parent $MyInvocation.MyCommand.Path
$proc = Start-Process -Wait -NoNewWindow -PassThru -FilePath "$ROOTDIR\usr\bin\bash.exe" -ArgumentList "'/usr/bin/mafft' $args"
exit $proc.ExitCode

# SIG # Begin signature block
# MIIcVQYJKoZIhvcNAQcCoIIcRjCCHEICAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUqI6m13VqWCFoXSfDfv8r86zz
# q4KgggmVMIIElDCCA3ygAwIBAgIOSBtqBybS6D8mAtSCWs0wDQYJKoZIhvcNAQEL
# BQAwTDEgMB4GA1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjMxEzARBgNVBAoT
# Ckdsb2JhbFNpZ24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMTYwNjE1MDAwMDAw
# WhcNMjQwNjE1MDAwMDAwWjBaMQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFs
# U2lnbiBudi1zYTEwMC4GA1UEAxMnR2xvYmFsU2lnbiBDb2RlU2lnbmluZyBDQSAt
# IFNIQTI1NiAtIEczMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjYVV
# I6kfU6/J7TbCKbVu2PlC9SGLh/BDoS/AP5fjGEfUlk6Iq8Zj6bZJFYXx2Zt7G/3Y
# SsxtToZAF817ukcotdYUQAyG7h5LM/MsVe4hjNq2wf6wTjquUZ+lFOMQ5pPK+vld
# sZCH7/g1LfyiXCbuexWLH9nDoZc1QbMw/XITrZGXOs5ynQYKdTwfmOPLGC+MnwhK
# kQrZ2TXZg5J2Yl7fg67k1gFOzPM8cGFYNx8U42qgr2v02dJsLBkwXaBvUt/RnMng
# Ddl1EWWW2UO0p5A5rkccVMuxlW4l3o7xEhzw127nFE2zGmXWhEpX7gSvYjjFEJtD
# jlK4PrauniyX/4507wIDAQABo4IBZDCCAWAwDgYDVR0PAQH/BAQDAgEGMB0GA1Ud
# JQQWMBQGCCsGAQUFBwMDBggrBgEFBQcDCTASBgNVHRMBAf8ECDAGAQH/AgEAMB0G
# A1UdDgQWBBQPOueslJF0LZYCc4OtnC5JPxmqVDAfBgNVHSMEGDAWgBSP8Et/qC5F
# JK5NUPpjmove4t0bvDA+BggrBgEFBQcBAQQyMDAwLgYIKwYBBQUHMAGGImh0dHA6
# Ly9vY3NwMi5nbG9iYWxzaWduLmNvbS9yb290cjMwNgYDVR0fBC8wLTAroCmgJ4Yl
# aHR0cDovL2NybC5nbG9iYWxzaWduLmNvbS9yb290LXIzLmNybDBjBgNVHSAEXDBa
# MAsGCSsGAQQBoDIBMjAIBgZngQwBBAEwQQYJKwYBBAGgMgFfMDQwMgYIKwYBBQUH
# AgEWJmh0dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRvcnkvMA0GCSqG
# SIb3DQEBCwUAA4IBAQAVhCgM7aHDGYLbYydB18xjfda8zzabz9JdTAKLWBoWCHqx
# mJl/2DOKXJ5iCprqkMLFYwQL6IdYBgAHglnDqJQy2eAUTaDVI+DH3brwaeJKRWUt
# TUmQeGYyDrBowLCIsI7tXAb4XBBIPyNzujtThFKAzfCzFcgRCosFeEZZCNS+t/9L
# 9ZxqTJx2ohGFRYzUN+5Q3eEzNKmhHzoL8VZEim+zM9CxjtEMYAfuMsLwJG+/r/uB
# AXZnxKPo4KvcM1Uo42dHPOtqpN+U6fSmwIHRUphRptYCtzzqSu/QumXSN4NTS35n
# fIxA9gccsK8EBtz4bEaIcpzrTp3DsLlUo7lOl8oUMIIE+TCCA+GgAwIBAgIMFc8a
# jh5+hrY2+89QMA0GCSqGSIb3DQEBCwUAMFoxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
# ExBHbG9iYWxTaWduIG52LXNhMTAwLgYDVQQDEydHbG9iYWxTaWduIENvZGVTaWdu
# aW5nIENBIC0gU0hBMjU2IC0gRzMwHhcNMTgwNjEyMDcyOTM2WhcNMTkwNzE2MDU0
# MDA3WjBzMQswCQYDVQQGEwJKUDEOMAwGA1UECBMFT3Nha2ExDjAMBgNVBAcTBVN1
# aXRhMRkwFwYDVQQKExBPc2FrYSBVbml2ZXJzaXR5MQ4wDAYDVQQLEwVJRlJlQzEZ
# MBcGA1UEAxMQT3Nha2EgVW5pdmVyc2l0eTCCASIwDQYJKoZIhvcNAQEBBQADggEP
# ADCCAQoCggEBALewrK03sLqADU9LkvAwx8r28L2zo+qUROEz9oNZW6xYPylSzEYp
# 7RRAYbwQA6rlIHtW8A8/+SjA4fNwcy9qGBiu1OZJmeX4sLZzr48rUFRKyZqfraIo
# ILT8GVNZBMW39K78ZIP+1eTXjcBXyX2Ri2BIEH0fgtYO/q9Hz3NLZkWv2InxZvkk
# Xh8khFAPwDSI6IEy5K972kyfp5liilDzBVBQmYve3O8lMNTpg6PseWxruBkr0kQs
# FXzHLJ+tNVQGRHPF81xMGD8YPhI1IySUgDZXqU98u+EB5uBfXNyMgv9PuTy/8zx/
# mlAMbVMvwWBL9y+fcZIfYHuKI/swraWHt7kCAwEAAaOCAaQwggGgMA4GA1UdDwEB
# /wQEAwIHgDCBlAYIKwYBBQUHAQEEgYcwgYQwSAYIKwYBBQUHMAKGPGh0dHA6Ly9z
# ZWN1cmUuZ2xvYmFsc2lnbi5jb20vY2FjZXJ0L2dzY29kZXNpZ25zaGEyZzNvY3Nw
# LmNydDA4BggrBgEFBQcwAYYsaHR0cDovL29jc3AyLmdsb2JhbHNpZ24uY29tL2dz
# Y29kZXNpZ25zaGEyZzMwVgYDVR0gBE8wTTBBBgkrBgEEAaAyATIwNDAyBggrBgEF
# BQcCARYmaHR0cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9yeS8wCAYG
# Z4EMAQQBMAkGA1UdEwQCMAAwPwYDVR0fBDgwNjA0oDKgMIYuaHR0cDovL2NybC5n
# bG9iYWxzaWduLmNvbS9nc2NvZGVzaWduc2hhMmczLmNybDATBgNVHSUEDDAKBggr
# BgEFBQcDAzAdBgNVHQ4EFgQUz880T9hEerWAjdohhwXpJTk1A2swHwYDVR0jBBgw
# FoAUDzrnrJSRdC2WAnODrZwuST8ZqlQwDQYJKoZIhvcNAQELBQADggEBAE5mwpcK
# Xp/0Ira6wn74jx3CK70qtlC0q++Dfmc8TJvkfzWZQgnbAeLFwsDVcGzDAQ+LUl/Y
# TzgBWR4loyv2L4NWG02z9jpwoKnKYvw4+3y2oqSWqUprUqSO0cl1WO7YRfgFLQ8Q
# udFWHvdrsFcCowDKlHAvN0q5nfLR7imclVhHwTAn0ydXpvDYcsqZSu4WSSTi0VBk
# Li32Ch7xANr6kTKoP3kSc4qo/GWDpRuQ7kTym2B17p9kdylwsAYTtlYAL3cqd5a8
# Z8jFHECC2n4yNN7H/ZkyG/g/wpbeM9Gh1plPed+8CtzFB3tdYXghRezmCOILLlb5
# T4SfajNQvchmuGAxghIqMIISJgIBATBqMFoxCzAJBgNVBAYTAkJFMRkwFwYDVQQK
# ExBHbG9iYWxTaWduIG52LXNhMTAwLgYDVQQDEydHbG9iYWxTaWduIENvZGVTaWdu
# aW5nIENBIC0gU0hBMjU2IC0gRzMCDBXPGo4efoa2NvvPUDAJBgUrDgMCGgUAoHAw
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFBRU4nWu
# yEz++xp0jM+X0oCnjMBWMA0GCSqGSIb3DQEBAQUABIIBABMR+aFvaFANzFRPfG38
# R/AplM4WYdMxh/3uDWNMV1mcVYVBMK3+zB0RXzSPIf1m9VoVDYHmjMnn9WEZukJC
# PH3v97H1KZdWj5QiuTB2+8EEzhQq3YojeUgQ7t11sC86IOIo93bXfbhWrt2C3ZJH
# NeEgdRLx6VBgG6BgwS8xbdRyrr5j+6p1rrMPlsMTdc4UsqU/AFbiBFKAD42OJ55x
# HFgOMnm7MVYIAn2zY7yopqHoNYMd9HdPs7YsRSsNp6lBZxfTyHxg5WfTML9xlw1j
# M/Dd8K5jdjUjKyeSHLvWnSsK52umbrhfr9fB5r3gVnAihEdJA7c9SSqftdc46mD5
# 0KyhghAjMIIQHwYKKwYBBAGCNwMDATGCEA8wghALBgkqhkiG9w0BBwKggg/8MIIP
# +AIBAzEPMA0GCWCGSAFlAwQCAQUAMIHmBgsqhkiG9w0BCRABBKCB1gSB0zCB0AIB
# AQYJKwYBBAGgMgIDMDEwDQYJYIZIAWUDBAIBBQAEIBzVNuZO6bYKQYkG2U2bXfv6
# xRgjuqIqX83afNZJ3kMYAg4BZYmsk78AAAAAALHeJhgTMjAxOTA1MjEwODQyMzAu
# NjU0WjADAgEBoGOkYTBfMQswCQYDVQQGEwJKUDEcMBoGA1UEChMTR01PIEdsb2Jh
# bFNpZ24gSy5LLjEyMDAGA1UEAxMpR2xvYmFsU2lnbiBUU0EgZm9yIEFkdmFuY2Vk
# IC0gRzMgLSAwMDMtMDKgggxqMIIE6jCCA9KgAwIBAgIMUGf6Rs5s/pUVpp6yMA0G
# CSqGSIb3DQEBCwUAMFsxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
# IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNI
# QTI1NiAtIEcyMB4XDTE4MDYxNDEwMDAwMFoXDTI5MDMxODEwMDAwMFowXzELMAkG
# A1UEBhMCSlAxHDAaBgNVBAoTE0dNTyBHbG9iYWxTaWduIEsuSy4xMjAwBgNVBAMT
# KUdsb2JhbFNpZ24gVFNBIGZvciBBZHZhbmNlZCAtIEczIC0gMDAzLTAyMIIBIjAN
# BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyPnKCDjJ248NqgMvZFZv5OK9o365
# HS6YQtac8NSD3Dz+MstX8Zkx3I45s0JISWN/SzDV1ESFJ0GSOfpQNVM3wvuGI43T
# 6SGOtZYeCFioA85bseoZslrJnGe7gLcxG9qGx7t4KTQfE4xqFZHLsgx/jfkLvIa8
# FcfxUNSAvs2RmmiQfPzmXQ3h6K7JL7ghe2TI26IHA/mN9ItnV43C8EHY34VEHkZ2
# SJOy3B1IlsIKRixt4QDIGmVJep8L6sKvMnD8HrfV+NeAnwqPQmalyXQoZEsq+ls4
# aIEtFAUgzhVhDxuXJTgWOU59bSAvrxxGwd9AlnwZvzlFuW5cHel2F3dHEwIDAQAB
# o4IBqDCCAaQwDgYDVR0PAQH/BAQDAgeAMEwGA1UdIARFMEMwQQYJKwYBBAGgMgEe
# MDQwMgYIKwYBBQUHAgEWJmh0dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9z
# aXRvcnkvMAkGA1UdEwQCMAAwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwRgYDVR0f
# BD8wPTA7oDmgN4Y1aHR0cDovL2NybC5nbG9iYWxzaWduLmNvbS9ncy9nc3RpbWVz
# dGFtcGluZ3NoYTJnMi5jcmwwgZgGCCsGAQUFBwEBBIGLMIGIMEgGCCsGAQUFBzAC
# hjxodHRwOi8vc2VjdXJlLmdsb2JhbHNpZ24uY29tL2NhY2VydC9nc3RpbWVzdGFt
# cGluZ3NoYTJnMi5jcnQwPAYIKwYBBQUHMAGGMGh0dHA6Ly9vY3NwMi5nbG9iYWxz
# aWduLmNvbS9nc3RpbWVzdGFtcGluZ3NoYTJnMjAdBgNVHQ4EFgQUXS7r1FaeHBn5
# WJwbtS/oyNt5HucwHwYDVR0jBBgwFoAUkiGnSpVdZLCbtB7mADdH5p1BK0wwDQYJ
# KoZIhvcNAQELBQADggEBACu34JGiT64w8FccYtF0BAJBjFxugoVSZC3JmEa6lp+j
# Q+EyzKAnguXZB6DOfm5vfFv4QdM2DnVWh4FdRBLj/Pf7ooZlINqgel5vcQsAkqmj
# ILQiohGOyA2cewUT5Fre6cPacgzJgZwXnnwFpG2wnMqkLnYmlmS8ZLJtIo/CsKnI
# kfKDNv8YUiwmrhuKM+bSoHXZMT2jQorYSassv9qGn3z5Gvey8tWTT7S8CR9LgCje
# sC/dsblwzY6w1lE/UdnffQ30iYc8IGFPfnfcXhl/0XAWBkDxHwdJLPIHoOPHJGBw
# h9cpuYf0KakLookYrSslTm/7m4uLrvmYlh1ajtzePrAwggQVMIIC/aADAgECAgsE
# AAAAAAExicZQBDANBgkqhkiG9w0BAQsFADBMMSAwHgYDVQQLExdHbG9iYWxTaWdu
# IFJvb3QgQ0EgLSBSMzETMBEGA1UEChMKR2xvYmFsU2lnbjETMBEGA1UEAxMKR2xv
# YmFsU2lnbjAeFw0xMTA4MDIxMDAwMDBaFw0yOTAzMjkxMDAwMDBaMFsxCzAJBgNV
# BAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhHbG9i
# YWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyMIIBIjANBgkqhkiG
# 9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqpuOw6sRUSUBtpaU4k/YwQj2RiPZRcWVl1ur
# Gr/SbFfJMwYfoA/GPH5TSHq/nYeer+7DjEfhQuzj46FKbAwXxKbBuc1b8R5EiY7+
# C94hWBPuTcjFZwscsrPxNHaRossHbTfFoEcmAhWkkJGpeZ7X61edK3wi2BTX8Qce
# eCI2a3d5r6/5f45O4bUIMf3q7UtxYowj8QM5j0R5tnYDV56tLwhG3NKMvPSOdM7I
# aGlRdhGLD10kWxlUPSbMQI2CJxtZIH1Z9pOAjvgqOP1roEBlH1d2zFuOBE8sqNuE
# UBNPxtyLufjdaUyI65x7MCb8eli7WbwUcpKBV7d2ydiACoBuCQIDAQABo4HoMIHl
# MA4GA1UdDwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBSS
# IadKlV1ksJu0HuYAN0fmnUErTDBHBgNVHSAEQDA+MDwGBFUdIAAwNDAyBggrBgEF
# BQcCARYmaHR0cHM6Ly93d3cuZ2xvYmFsc2lnbi5jb20vcmVwb3NpdG9yeS8wNgYD
# VR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5nbG9iYWxzaWduLm5ldC9yb290LXIz
# LmNybDAfBgNVHSMEGDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG9w0B
# AQsFAAOCAQEABFaCSnzQzsm/NmbRvjWek2yX6AbOMRhZ+WxBX4AuwEIluBjH/NSx
# N8RooM8oagN0S2OXhXdhO9cv4/W9M6KSfREfnops7yyw9GKNNnPRFjbxvF7stICY
# ePzSdnno4SGU4B/EouGqZ9uznHPlQCLPOc7b5neVp7uyy/YZhp2fyNSYBbJxb051
# rvE9ZGo7Xk5GpipdCJLxo/MddL9iDSOMXCo4ldLA1c3PiNofKLW6gWlkKrWmotVz
# r9xG2wSukdduxZi61EfEVnSAR3hYjL7vK/3sbL/RlPe/UOB74JD9IBh4GCJdCC6M
# HKCX8x2ZfaOdkdMGRE4EbnocIOM28LZQuTCCA18wggJHoAMCAQICCwQAAAAAASFY
# UwiiMA0GCSqGSIb3DQEBCwUAMEwxIDAeBgNVBAsTF0dsb2JhbFNpZ24gUm9vdCBD
# QSAtIFIzMRMwEQYDVQQKEwpHbG9iYWxTaWduMRMwEQYDVQQDEwpHbG9iYWxTaWdu
# MB4XDTA5MDMxODEwMDAwMFoXDTI5MDMxODEwMDAwMFowTDEgMB4GA1UECxMXR2xv
# YmFsU2lnbiBSb290IENBIC0gUjMxEzARBgNVBAoTCkdsb2JhbFNpZ24xEzARBgNV
# BAMTCkdsb2JhbFNpZ24wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDM
# JXaQeQZ4Ihb1wIO2hMoonv0FdhHFrYhy/EYCQ8eyip0EXyTLLkvhYIJG4VKrDIFH
# cGzdZNHr9SyjD4I9DCuul9e2FIYQebs7E4B3jAjhSdJqYi8fXvqWaN+JJ5U4nwbX
# PsnLJlkNc96wyOkmDoMVxu9bi9IEYMpJpij2aTv2y8gokeWdimFXN6x0FNx04Dru
# ci8unPvQu7/1PQDhBjPogiuuU6Y6FnOM3UEOIDrAtKeh6bJPkC4yYOlXy7kEkmho
# 5TgmYHWyn3f/kRTvriBJ/K1AFUjRAjFhGV64l++td7dkmnq/X8ET75ti+w1s4FRp
# FqkD2m7pg5NxdsZphYIXAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMB
# Af8EBTADAQH/MB0GA1UdDgQWBBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG
# 9w0BAQsFAAOCAQEAS0DbwFCq/sgM7/eWVEVJu5YACUGssxOGhigHM8pr5nS5ugAt
# rqQK0/Xx8Q+Kv3NnSoPHRHt44K9ubG8DKY4zOUXDjuS5V2yq/BKW7FPGLeQkbLmU
# Y/vcU2hnVj6DuM81IcPJaP7O2sJTqsyQiunwXUaMld16WCgaLx3ezQA3QY/tRG3X
# UyiXfvNnBB4V14qWtNPeTCekTBtzc3b0F5nCH3oO4y0IrQocLP88q1UOD5F+NuvD
# V0m+4S4tfGCLw0FREyOdzvcya5QBqJnnLDMfOjsl0oZAzjsshnjJYS8Uuu7bVW/f
# hO4FCU29KNhyztNiUGUe65KXgzHZs7XKR1g/XzGCAokwggKFAgEBMGswWzELMAkG
# A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExMTAvBgNVBAMTKEds
# b2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0gU0hBMjU2IC0gRzICDFBn+kbObP6V
# FaaesjANBglghkgBZQMEAgEFAKCB8DAaBgkqhkiG9w0BCQMxDQYLKoZIhvcNAQkQ
# AQQwLwYJKoZIhvcNAQkEMSIEIPIVPJdBTy7cKZA+XrSqloyPlzW3UATmJ02NxLxE
# HU5zMIGgBgsqhkiG9w0BCRACDDGBkDCBjTCBijCBhwQUe190nJDud78pQ3Xomb4K
# ZtCFB0wwbzBfpF0wWzELMAkGA1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24g
# bnYtc2ExMTAvBgNVBAMTKEdsb2JhbFNpZ24gVGltZXN0YW1waW5nIENBIC0gU0hB
# MjU2IC0gRzICDFBn+kbObP6VFaaesjANBgkqhkiG9w0BAQEFAASCAQCiGLQOdvUl
# LoRipx/QB0JGJ3xYrRQ5O+HaX4B3GyCa4QLjRWrgmvp/5Es68txxwHLtBZLwOYck
# E8NfCtziQAe2xhRXBN1TkcY8488L7RDfnTOpTbpT6ZghgzLyonBcp1NpCUrL9/Ft
# qSNNhDg2w9kPgPWrrhDCqtzsMKVF6+ZR1GCT1SSxJpD7VUv0g5bBfmB1PHbl6oNS
# 4XQELjp32JQeKYu/GuqH2kDfYRbHUjZqhuMFmZChvMUuRJ9mhGL3SbsIMeN6yRRu
# I+Eu7jO2gYeVYz7SPqoiiG3XNU8haUMVIjRIX/10d5nV1m1uuhfGucnxPpSe3D2e
# pjzY5hjHLZ6r
# SIG # End signature block
