import binascii

tgt = 10000
tpl = """{"notes": "generated by generator.py", "seed": "{{SEED}}", "tv-size": null, "tv-count": null, "tv_size": 16, "tv_count": 625000, "file_name": "REFDATA_ctr_seed_{{SEED}}_10MiB__AES_r10_b16.bin", "stream": {"type": "block", "init_frequency": "only_once", "algorithm": "AES", "round": 10, "block_size": 16, "plaintext": {"type": "counter"}, "key_size": 16, "key": {"type": "pcg32_stream"}, "iv_size": 16, "iv": {"type": "false_stream"}}}"""


for i in range(tgt):
    seed = binascii.hexlify(i.to_bytes(8, 'big')).decode('ascii')
    dt = tpl.replace('{{SEED}}', seed)
    fname = "REFDATA_ctr_seed_{{SEED}}_10MiB__AES_r10_b16.bin.json".replace('{{SEED}}', seed)
    print(fname)
    with open(fname, 'w') as fh:
        fh.write(dt)



