# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr 
from luminesce.models.data_type import DataType
from luminesce.models.query_designer_binary_operator import QueryDesignerBinaryOperator

class OnClauseTermDesign(BaseModel):
    """
    A single on clause term (a pair of columns to join or a column to filter on)  # noqa: E501
    """
    left_table_field:  Optional[StrictStr] = Field(None,alias="leftTableField", description="Name of field in the left table to join to (complex expressions are not supported at this time)") 
    right_table_field:  Optional[StrictStr] = Field(None,alias="rightTableField", description="Name of field in the left table to join to (complex expressions are not supported at this time)") 
    operator: QueryDesignerBinaryOperator = Field(...)
    filter_value:  Optional[StrictStr] = Field(None,alias="filterValue", description="The value to compare against (always as a string, but will be formatted to the correct type)") 
    filter_value_data_type: Optional[DataType] = Field(None, alias="filterValueDataType")
    __properties = ["leftTableField", "rightTableField", "operator", "filterValue", "filterValueDataType"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OnClauseTermDesign:
        """Create an instance of OnClauseTermDesign from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if left_table_field (nullable) is None
        # and __fields_set__ contains the field
        if self.left_table_field is None and "left_table_field" in self.__fields_set__:
            _dict['leftTableField'] = None

        # set to None if right_table_field (nullable) is None
        # and __fields_set__ contains the field
        if self.right_table_field is None and "right_table_field" in self.__fields_set__:
            _dict['rightTableField'] = None

        # set to None if filter_value (nullable) is None
        # and __fields_set__ contains the field
        if self.filter_value is None and "filter_value" in self.__fields_set__:
            _dict['filterValue'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OnClauseTermDesign:
        """Create an instance of OnClauseTermDesign from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OnClauseTermDesign.parse_obj(obj)

        _obj = OnClauseTermDesign.parse_obj({
            "left_table_field": obj.get("leftTableField"),
            "right_table_field": obj.get("rightTableField"),
            "operator": obj.get("operator"),
            "filter_value": obj.get("filterValue"),
            "filter_value_data_type": obj.get("filterValueDataType")
        })
        return _obj
