# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictBool, StrictStr, conlist 

class ErrorHighlightRequest(BaseModel):
    """
    Request for Error highlighting  # noqa: E501
    """
    lines: conlist(StrictStr) = Field(..., description="The lines of text the user currently has in the editor")
    ensure_some_text_is_selected: Optional[StrictBool] = Field(None, alias="ensureSomeTextIsSelected", description="If an editor requires some selection of non-whitespace this can be set to true to force at least one visible character to be selected.")
    __properties = ["lines", "ensureSomeTextIsSelected"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ErrorHighlightRequest:
        """Create an instance of ErrorHighlightRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ErrorHighlightRequest:
        """Create an instance of ErrorHighlightRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ErrorHighlightRequest.parse_obj(obj)

        _obj = ErrorHighlightRequest.parse_obj({
            "lines": obj.get("lines"),
            "ensure_some_text_is_selected": obj.get("ensureSomeTextIsSelected")
        })
        return _obj
