# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: onos/e2sub/endpoint/endpoint.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import AsyncIterator, List, Optional

import betterproto
import grpclib


class EventType(betterproto.Enum):
    """Type of change"""

    NONE = 0
    ADDED = 1
    REMOVED = 3


@dataclass(eq=False, repr=False)
class TerminationEndpoint(betterproto.Message):
    """
    Termination is a record identifying the IP address and TCP port coordinates
    where the E2 termination service is available.
    """

    id: str = betterproto.string_field(1)
    revision: int = betterproto.uint64_field(2)
    ip: str = betterproto.string_field(3)
    port: int = betterproto.uint32_field(4)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class Event(betterproto.Message):
    """Event is an end-point event"""

    type: "EventType" = betterproto.enum_field(1)
    endpoint: "TerminationEndpoint" = betterproto.message_field(2)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class AddTerminationRequest(betterproto.Message):
    """
    AddTerminationRequest is a request for adding a new termination point
    """

    endpoint: "TerminationEndpoint" = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class AddTerminationResponse(betterproto.Message):
    """
    AddTerminationResponse is a response to adding a new termination point
    """

    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GetTerminationRequest(betterproto.Message):
    """
    GetTerminationRequest is a request for getting existing termination point
    """

    id: str = betterproto.string_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class GetTerminationResponse(betterproto.Message):
    """
    GetTerminationResponse is a response with invormation about a requested
    termination point
    """

    endpoint: "TerminationEndpoint" = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class RemoveTerminationRequest(betterproto.Message):
    """RemoveTerminationRequest is a request for removing termination point"""

    id: str = betterproto.string_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class RemoveTerminationResponse(betterproto.Message):
    """
    RemoveTerminationResponse is a response to removing a termination point
    """

    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ListTerminationsRequest(betterproto.Message):
    """
    ListTerminationsRequest is a request to list all available E2 terminations
    """

    pass

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class ListTerminationsResponse(betterproto.Message):
    """
    ListTerminationsResponse is a response to list all available E2
    terminations
    """

    endpoints: List["TerminationEndpoint"] = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class WatchTerminationsRequest(betterproto.Message):
    """
    WatchTerminationsRequest is a request to receive a stream of all E2
    termination changes.
    """

    noreplay: bool = betterproto.bool_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


@dataclass(eq=False, repr=False)
class WatchTerminationsResponse(betterproto.Message):
    """
    WatchTerminationsResponse is a response indicating a change in the
    available E2 termination end-points.
    """

    event: "Event" = betterproto.message_field(1)

    def __post_init__(self) -> None:
        super().__post_init__()


class E2RegistryServiceStub(betterproto.ServiceStub):
    """
    E2RegistryService manages subscription and subscription delete requests
    """

    async def add_termination(
        self, *, endpoint: "TerminationEndpoint" = None
    ) -> "AddTerminationResponse":
        """AddTermination registers new E2 termination end-point."""

        request = AddTerminationRequest()
        if endpoint is not None:
            request.endpoint = endpoint

        return await self._unary_unary(
            "/onos.e2sub.endpoint.E2RegistryService/AddTermination",
            request,
            AddTerminationResponse,
        )

    async def get_termination(self, *, id: str = "") -> "GetTerminationResponse":
        """GetTermination retrieves information about a specific end-point"""

        request = GetTerminationRequest()
        request.id = id

        return await self._unary_unary(
            "/onos.e2sub.endpoint.E2RegistryService/GetTermination",
            request,
            GetTerminationResponse,
        )

    async def remove_termination(self, *, id: str = "") -> "RemoveTerminationResponse":
        """
        RemoveTermination removes the specified E2 termination end-point.
        """

        request = RemoveTerminationRequest()
        request.id = id

        return await self._unary_unary(
            "/onos.e2sub.endpoint.E2RegistryService/RemoveTermination",
            request,
            RemoveTerminationResponse,
        )

    async def list_terminations(self) -> "ListTerminationsResponse":
        """
        ListTerminations returns the list of currently registered E2
        terminations.
        """

        request = ListTerminationsRequest()

        return await self._unary_unary(
            "/onos.e2sub.endpoint.E2RegistryService/ListTerminations",
            request,
            ListTerminationsResponse,
        )

    async def watch_terminations(
        self, *, noreplay: bool = False
    ) -> AsyncIterator["WatchTerminationsResponse"]:
        """
        WatchTerminations returns a stream of changes in the set of available
        E2 terminations.
        """

        request = WatchTerminationsRequest()
        request.noreplay = noreplay

        async for response in self._unary_stream(
            "/onos.e2sub.endpoint.E2RegistryService/WatchTerminations",
            request,
            WatchTerminationsResponse,
        ):
            yield response
