"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createLibraryReadme = exports.createModuleDefinitionFromCfnNamespace = void 0;
const fs = require("fs-extra");
function createModuleDefinitionFromCfnNamespace(namespace) {
    const [moduleFamily, moduleBaseName] = (namespace === 'AWS::Serverless' ? 'AWS::SAM' : namespace).split('::');
    const moduleName = `${moduleFamily}-${moduleBaseName.replace(/V\d+$/, '')}`.toLocaleLowerCase();
    const lowcaseModuleName = moduleBaseName.toLocaleLowerCase();
    const packageName = `@aws-cdk/${moduleName}`;
    // dotnet names
    const dotnetPackage = `Amazon.CDK.${moduleFamily}.${moduleBaseName}`;
    // java names
    const javaGroupId = 'software.amazon.awscdk';
    const javaPackage = moduleFamily === 'AWS'
        ? `services.${lowcaseModuleName}`
        : `${moduleFamily.toLocaleLowerCase()}.${lowcaseModuleName}`;
    const javaArtifactId = moduleFamily === 'AWS'
        ? lowcaseModuleName
        : `${moduleFamily.toLocaleLowerCase()}-${lowcaseModuleName}`;
    // python names
    const pythonDistName = `aws-cdk.${moduleName}`;
    const pythonModuleName = pythonDistName.replace(/-/g, '_');
    return {
        namespace,
        moduleName,
        moduleFamily,
        moduleBaseName,
        packageName,
        dotnetPackage,
        javaGroupId,
        javaPackage,
        javaArtifactId,
        pythonDistName,
        pythonModuleName,
    };
}
exports.createModuleDefinitionFromCfnNamespace = createModuleDefinitionFromCfnNamespace;
async function createLibraryReadme(namespace, readmePath) {
    const module = createModuleDefinitionFromCfnNamespace(namespace);
    await fs.writeFile(readmePath, [
        `# ${namespace} Construct Library`,
        '<!--BEGIN STABILITY BANNER-->',
        '',
        '---',
        '',
        '![cfn-resources: Stable](https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge)',
        '',
        '> All classes with the `Cfn` prefix in this module ([CFN Resources]) are always stable and safe to use.',
        '>',
        '> [CFN Resources]: https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib',
        '',
        '---',
        '',
        '<!--END STABILITY BANNER-->',
        '',
        'This module is part of the [AWS Cloud Development Kit](https://github.com/aws/aws-cdk) project.',
        '',
        '```ts',
        `import ${module.moduleName.toLocaleLowerCase()} = require('${module.packageName}');`,
        '```',
        '',
    ].join('\n'), 'utf8');
}
exports.createLibraryReadme = createLibraryReadme;
//# sourceMappingURL=data:application/json;base64,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