"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.expect = void 0;
const cdk = require("monocdk");
const api = require("monocdk/cx-api");
const inspector_1 = require("./inspector");
const synth_utils_1 = require("./synth-utils");
function expect(stack, skipValidation = false) {
    // if this is already a synthesized stack, then just inspect it.
    const artifact = stack instanceof api.CloudFormationStackArtifact ? stack
        : cdk.Stack.isStack(stack) ? synth_utils_1.SynthUtils._synthesizeWithNested(stack, { skipValidation })
            : stack; // This is a template already
    return new inspector_1.StackInspector(artifact);
}
exports.expect = expect;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhwZWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZXhwZWN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLCtCQUErQjtBQUMvQixzQ0FBc0M7QUFDdEMsMkNBQTZDO0FBQzdDLCtDQUEyQztBQUUzQyxTQUFnQixNQUFNLENBQUMsS0FBd0UsRUFBRSxjQUFjLEdBQUcsS0FBSztJQUNySCxnRUFBZ0U7SUFDaEUsTUFBTSxRQUFRLEdBQUcsS0FBSyxZQUFZLEdBQUcsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLENBQUMsS0FBSztRQUN2RSxDQUFDLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLHdCQUFVLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFFLEVBQUUsY0FBYyxFQUFFLENBQUM7WUFDdEYsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLDZCQUE2QjtJQUMxQyxPQUFPLElBQUksMEJBQWMsQ0FBQyxRQUFRLENBQUMsQ0FBQztBQUN0QyxDQUFDO0FBTkQsd0JBTUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgKiBhcyBhcGkgZnJvbSAnbW9ub2Nkay9jeC1hcGknO1xuaW1wb3J0IHsgU3RhY2tJbnNwZWN0b3IgfSBmcm9tICcuL2luc3BlY3Rvcic7XG5pbXBvcnQgeyBTeW50aFV0aWxzIH0gZnJvbSAnLi9zeW50aC11dGlscyc7XG5cbmV4cG9ydCBmdW5jdGlvbiBleHBlY3Qoc3RhY2s6IGFwaS5DbG91ZEZvcm1hdGlvblN0YWNrQXJ0aWZhY3QgfCBjZGsuU3RhY2sgfCBSZWNvcmQ8c3RyaW5nLCBhbnk+LCBza2lwVmFsaWRhdGlvbiA9IGZhbHNlKTogU3RhY2tJbnNwZWN0b3Ige1xuICAvLyBpZiB0aGlzIGlzIGFscmVhZHkgYSBzeW50aGVzaXplZCBzdGFjaywgdGhlbiBqdXN0IGluc3BlY3QgaXQuXG4gIGNvbnN0IGFydGlmYWN0ID0gc3RhY2sgaW5zdGFuY2VvZiBhcGkuQ2xvdWRGb3JtYXRpb25TdGFja0FydGlmYWN0ID8gc3RhY2tcbiAgICA6IGNkay5TdGFjay5pc1N0YWNrKHN0YWNrKSA/IFN5bnRoVXRpbHMuX3N5bnRoZXNpemVXaXRoTmVzdGVkKHN0YWNrLCB7IHNraXBWYWxpZGF0aW9uIH0pXG4gICAgICA6IHN0YWNrOyAvLyBUaGlzIGlzIGEgdGVtcGxhdGUgYWxyZWFkeVxuICByZXR1cm4gbmV3IFN0YWNrSW5zcGVjdG9yKGFydGlmYWN0KTtcbn1cbiJdfQ==