"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lib_1 = require("./lib");
const have_output_1 = require("./lib/assertions/have-output");
const have_resource_1 = require("./lib/assertions/have-resource");
const match_template_1 = require("./lib/assertions/match-template");
const expect_1 = require("./lib/expect");
expect.extend({
    toMatchTemplate(actual, template, matchStyle) {
        const assertion = match_template_1.matchTemplate(template, matchStyle);
        const inspector = expect_1.expect(actual);
        const pass = assertion.assertUsing(inspector);
        if (pass) {
            return {
                pass,
                message: () => 'Not ' + assertion.description,
            };
        }
        else {
            return {
                pass,
                message: () => assertion.description,
            };
        }
    },
    toHaveResource(actual, resourceType, properties, comparison) {
        const assertion = new have_resource_1.HaveResourceAssertion(resourceType, properties, comparison, false);
        return applyAssertion(assertion, actual);
    },
    toHaveResourceLike(actual, resourceType, properties, comparison) {
        const assertion = new have_resource_1.HaveResourceAssertion(resourceType, properties, comparison, true);
        return applyAssertion(assertion, actual);
    },
    toHaveOutput(actual, props) {
        return applyAssertion(have_output_1.haveOutput(props), actual);
    },
    toCountResources(actual, resourceType, count = 1) {
        return applyAssertion(lib_1.countResources(resourceType, count), actual);
    },
});
function applyAssertion(assertion, actual) {
    const inspector = expect_1.expect(actual);
    const pass = assertion.assertUsing(inspector);
    if (pass) {
        return {
            pass,
            message: () => 'Not ' + assertion.generateErrorMessage(),
        };
    }
    else {
        return {
            pass,
            message: () => assertion.generateErrorMessage(),
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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