"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlywayConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("monocdk");
const awsLambda = require("monocdk/aws-lambda");
const s3 = require("monocdk/aws-s3");
// eslint-disable-next-line @typescript-eslint/no-require-imports
const pjson = require('../package.json');
/**
 * @stability stable
 */
class FlywayConstruct extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, params) {
        super(scope, id);
        /**
         * @stability stable
         */
        this.objectCodeKey = pjson.version;
        this.flywayLambdaMigration = new awsLambda.Function(this, id, {
            vpc: params.vpc,
            vpcSubnets: params.subnet,
            securityGroups: params.securityGroups,
            memorySize: params.memorySize || 512,
            timeout: params.timeout || cdk.Duration.seconds(30),
            handler: FlywayConstruct.HANDLER,
            runtime: awsLambda.Runtime.JAVA_11,
            environment: {
                //add PREFIX: params.bucketFolderPrefix || ''
                ARN: params.migrationDBSecretManager.secretArn,
                BUCKET_NAME: params.bucketMigrationSQL.bucketName,
            },
            code: awsLambda.S3Code.fromBucket(s3.Bucket.fromBucketArn(this, FlywayConstruct.ID_LAMBDA_CODE, FlywayConstruct.BUCKET_CODE_ARN), 'flywayjar.' + this.objectCodeKey + '.zip'),
        });
        params.migrationDBSecretManager.grantRead(this.flywayLambdaMigration);
        params.bucketMigrationSQL.grantRead(this.flywayLambdaMigration);
    }
}
exports.FlywayConstruct = FlywayConstruct;
_a = JSII_RTTI_SYMBOL_1;
FlywayConstruct[_a] = { fqn: "flywaymigrationconstructmonocdk.FlywayConstruct", version: "0.0.3" };
/**
 * @stability stable
 */
FlywayConstruct.HANDLER = 'tech.necko.flywayjar.Main::handleRequest';
/**
 * @stability stable
 */
FlywayConstruct.ID_LAMBDA_CODE = 'bucketMigration';
/**
 * @stability stable
 */
FlywayConstruct.BUCKET_CODE_ARN = 'arn:aws:s3:::flywaymigrationconstruct-monocdk';
//# sourceMappingURL=data:application/json;base64,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